/*
 * startup.h
 *
 *  Created on: 17.11.2017
 *      Author: joerg_000
 */
#include <stdio.h>
// for va_* functions
#include <stdarg.h>

#ifndef STARTUP_H_
#define STARTUP_H_

#define uint8 unsigned char

//register
//unsigned long *TIM6_ARR = (unsigned long *)	0x4000102C;
//unsigned long *TIM7_ = (unsigned long *)	0x40001400;
//unsigned long *TIM7_ARR = (unsigned long *)	0x4000142C;
//unsigned long *TIM2_ARR = (unsigned long *)	0x4000002C;
//unsigned long *TIM3_ARR = (unsigned long *)	0x4000042C;
//unsigned long *TIM6_CNT = (unsigned long *)	0x40001024;
//unsigned long *TIM7_CNT = (unsigned long *)	0x40001424;
//unsigned long *TIM2_CNT = (unsigned long *)	0x40000024;
//unsigned long *TIM3_CNT = (unsigned long *)	0x40000424;
//unsigned long *SysTickRR = (unsigned long *)	0xE000E014;
//unsigned long *SysTickCVR = (unsigned long *)	0xE000E018;
////unsigned long *GPIOA = (unsigned long *)	0x40020000;
//unsigned long *GPIOA_IDR = (unsigned long *)	0x40020010;
//unsigned long *GPIOB_IDR = (unsigned long *)	0x40020410;
//unsigned long *GPIOC_IDR = (unsigned long *)	0x40020810;
//unsigned long *GPIOA_ODR = (unsigned long *)	0x40020014;
//unsigned long *GPIOB_ODR = (unsigned long *)	0x40020414;
//unsigned long *GPIOC_ODR = (unsigned long *)	0x40020814;
//unsigned long *GPIOA_MODER = (unsigned long *)	0x40020000;
//unsigned long *GPIOB_MODER = (unsigned long *)	0x40020400;
//unsigned long *GPIOC_MODER = (unsigned long *)	0x40020800;
//unsigned long *GPIOA_OTYPER = (unsigned long *)	0x40020004;
//unsigned long *GPIOB_OTYPER = (unsigned long *)	0x40020404;
//unsigned long *GPIOC_OTYPER = (unsigned long *)	0x40020804;
//unsigned long *GPIOA_PUPDR = (unsigned long *)	0x4002000C;
//unsigned long *GPIOB_PUPDR = (unsigned long *)	0x4002040C;
//unsigned long *GPIOC_PUPDR = (unsigned long *)	0x4002080C;
//
#define TIM6_ARR TIM6->ARR
#define TIM7_ARR TIM7->ARR
#define TIM2_ARR TIM2->ARR
#define TIM3_ARR TIM3->ARR
#define TIM6_CNT TIM6->CNT
#define TIM7_CNT TIM7->CNT
#define TIM2_CNT TIM2->CNT
#define TIM3_CNT TIM3->CNT
#define SysTick_ARR SysTick->LOAD
#define SysTickRR SysTick->LOAD
#define SysTick_CNT	SysTick->VAL
#define SysTickCVR SysTick->VAL
#define GPIOA_IDR GPIOA->IDR
#define GPIOB_IDR GPIOB->IDR
#define GPIOC_IDR GPIOC->IDR
#define GPIOA_ODR GPIOA->ODR
#define GPIOB_ODR GPIOB->ODR
#define GPIOC_ODR GPIOC->ODR
#define GPIOA_MODER GPIOA->MODER
#define GPIOB_MODER GPIOB->MODER
#define GPIOC_MODER GPIOC->MODER
#define GPIOA_OTYPER GPIOA->OTYPER
#define GPIOB_OTYPER GPIOB->OTYPER
#define GPIOC_OTYPER GPIOC->OTYPER
#define GPIOA_PUPDR GPIOA->PUPDR
#define GPIOB_PUPDR GPIOA->PUPDR
#define GPIOC_PUPDR GPIOA->PUPDR



//Priorittenregister
#define PRI6 NVIC->IP[6]

#define	PRI7 NVIC->IP[7]
#define	PRI8 NVIC->IP[8]
#define	PRI9 NVIC->IP[9]
#define	PRI10  NVIC->IP[10]
#define	PRI23  NVIC->IP[23]
#define	PRI28  NVIC->IP[28]
#define	PRI29  NVIC->IP[29]
#define	PRI40  NVIC->IP[40]
#define	PRI43  NVIC->IP[43]
#define	PRI44  NVIC->IP[44]
//unsigned char *PRI_SysTickP = (unsigned char *) 0xE000ED20;
#define	PRI_SysTick   NVIC->IP[2339]





//Bitdefines
#define		EA		255
#define		ea		255
#define 	A0 		0
#define 	PA0		0
#define 	A1		1
#define		PA1		1
#define 	D1		2
#define		PA2		2
#define		D0		3
#define		PA3		3
#define		A2		4
#define		PA4		4
#define		D13		5
#define		PA5		5
#define		LED		5
#define		D12		6
#define		PA6		6
#define		D11		7
#define		PA7		7
#define		D7		8
#define		PA8		8
#define		D8		9
#define		PA9		9
#define		D2		10
#define		PA10	10
#define		PA11	11
#define		PA12	12
#define		PA13	13
#define		PA14	14
#define		PA15	15
#define		A3		16
#define		PB0		16
#define		PB1		17

//.word	0x00000002,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB2		18
//.word	0x00000004,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D3		19
#define		PB3		19
//.word	0x00000008,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D5		20
#define		PB4		20
//.word	0x00000010,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D4		21
#define		PB5		21
//.word	0x00000020,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D10		22
#define		PB6		22
//.word	0x00000040,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB7		23
//.word	0x00000080,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D15		24
#define		PB8		24
//.word	0x00000100,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D14		25
#define		PB9		25
//.word	0x00000200,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		D6		26
#define		PB10	26
//.word	0x00000400,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB11	27
//.word	0x00000800,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB12	28
//.word	0x00001000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB13	29
//.word	0x00002000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB14	30
//.word	0x00004000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
#define		PB15	31
//.word	0x00008000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR

#define		A5		32
#define		PC0		32
//.word	0x00000001,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		A4		33
#define		PC1		33
//.word	0x00000002,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC2		34
//.word	0x00000004,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC3		35
//.word	0x00000008,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC4		36
//.word	0x00000010,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC5		37
//.word	0x00000020,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC6		38
//.word	0x00000040,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		D9		39
#define		PC7		39
//.word	0x00000080,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC8		40
//.word	0x00000100,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC9		41
//.word	0x00000200,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC10	42
//.word	0x00000400,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC11	43
//.word	0x00000800,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC12	44
//.word	0x00001000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC13	45
#define		USER	29
#define     Taste	29
//.word	0x00002000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC14	46
//.word	0x00004000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
#define		PC15	47
//.word	0x00008000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR

#define		MR0		48
#define		ex0		48
#define		EX0		48
//.word 	0x00000001<<ex0_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR1		49
#define		ex1		49
#define		EX1		49
//.word 	0x00000001<<ex1_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR2		50
#define		ex2		50
#define		EX2		50
//.word 	0x00000001<<ex2_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR3		51
#define		ex3		51
#define		EX3		51
//.word 	0x00000001<<ex3_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR4		52
#define		ex4		52
#define		EX4		52
//.word 	0x00000001<<ex4_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR5		53
#define		ex5		53
#define		EX5		53
//.word 	0x00000001<<ex5_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR6		54
#define		ex6		54
#define		EX6		54
//.word 	0x00000001<<ex6_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR7		55
#define		ex7		55
#define		EX7		55
//.word 	0x00000001<<ex7_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR8		56
#define		ex8		56
#define		EX8		56
//.word 	0x00000001<<ex8_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR9		57
#define		ex9		57
#define		EX9		57
//.word 	0x00000001<<ex9_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR10	58
#define		ex10	58
#define		EX10	58
//.word 	0x00000001<<ex10_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR11	59
#define		ex11	59
#define		EX11	59
//.word 	0x00000001<<ex11_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR12	60
#define		ex12	60
#define		EX12	60
//.word 	0x00000001<<ex12_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR13	61
#define		ex13	61
#define		EX13	61
//.word 	0x00000001<<ex13_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR14	62
#define		ex14	62
#define		EX14	62
//.word 	0x00000001<<ex14_nr,exti+EXTI_IMR,exti+EXTI_IMR
#define		MR15	63
#define		ex15	63
#define		EX15	63
//.word 	0x00000001<<ex15_nr,exti+EXTI_IMR,exti+EXTI_IMR

#define		pr0		64
#define		PR0		64
//.word 	0x00000001<<ex0_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr1		65
#define		PR1		65
//.word 	0x00000001<<ex1_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr2		66
#define		PR2		66
//.word 	0x00000001<<ex2_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr3		67
#define		PR3		67
//.word 	0x00000001<<ex3_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr4		68
#define		PR4		68
//.word 	0x00000001<<ex4_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr5		69
#define		PR5		69
//.word 	0x00000001<<ex5_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr6		70
#define		PR6		70
//.word 	0x00000001<<ex6_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr7		71
#define		PR7		71
//.word 	0x00000001<<ex7_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr8		72
#define		PR8		72
//.word 	0x00000001<<ex8_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr9		73
#define		PR9		73
//.word 	0x00000001<<ex9_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr10	74
#define		PR10	74
//.word 	0x00000001<<ex10_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr11	75
#define		PR11	75
//.word 	0x00000001<<ex11_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr12	76
#define		PR12	76
//.word 	0x00000001<<ex12_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr13	77
#define		PR13	77
//.word 	0x00000001<<ex13_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr14	78
#define		PR14	78
//.word 	0x00000001<<ex14_nr,exti+EXTI_PR,exti+EXTI_PR
#define		pr15	79
#define		PR15	79
//.word 	0x00000001<<ex15_nr,exti+EXTI_PR,exti+EXTI_PR



#define		CEN2	80
#define		cen2	80	//Tim2 enable
//.word	0x00000001,TIM2+TIMx_CR1,TIM2+TIMx_CR1
#define		CEN3	81
#define		cen3	81	//Tim3 enable
//.word	0x00000001,TIM3+TIMx_CR1,TIM3+TIMx_CR1
#define		CEN6	82
#define		cen6	82	//Tim6 enable
//.word	0x00000001,TIM6+TIMx_CR1,TIM6+TIMx_CR1
#define		CEN7	83
#define		cen7	83	//Tim6 enable
//.word	0x00000001,TIM7+TIMx_CR1,TIM7+TIMx_CR1

#define		UIE6	84
#define		uie6	84	//Tim6 Interrupt enable
//.word	0x00000001,TIM6+TIMx_DIER,TIM6+TIMx_DIER
#define		UIF6	85
#define		uif6	85  //Tim6 interrupt flag
//.word	0x00000001,TIM6+TIMx_SR,TIM6+TIMx_SR
#define		UIE7	86
#define		uie7	86	//Tim7 Interrupt enable
//.word	0x00000001,TIM7+TIMx_DIER,TIM7+TIMx_DIER
#define		UIF7	87
#define		uif7	87  //Tim7 interrupt flag
//.word	0x00000001,TIM7+TIMx_SR,TIM7+TIMx_SR
#define		UIE2	88
#define		uie2	88	//Tim6 Interrupt enable
//.word	0x00000001,TIM2+TIMx_DIER,TIM2+TIMx_DIER
#define		UIF2	89
#define		uif2	89  //Tim6 interrupt flag
//.word	0x00000001,TIM2+TIMx_SR,TIM2+TIMx_SR
#define		UIE3	90
#define		uie3	90	//Tim7 Interrupt enable
//.word	0x00000001,TIM3+TIMx_DIER,TIM3+TIMx_DIER
#define		UIF3	91
#define		uif3	91  //Tim7 interrupt flag
//.word	0x00000001,TIM3+TIMx_SR,TIM3+TIMx_SR
#define		TIM2_SMS_0	92
#define		tim2_sms_0	92
//.word	0x00000001,TIM2+TIMx_SMCR,TIM2+TIMx_SMCR
#define		TIM2_SMS_1	93
#define		tim2_sms_1	93
//.word	0x00000010,TIM2+TIMx_SMCR,TIM2+TIMx_SMCR
#define		TIM2_SMS_2	94
#define		tim2_sms_2	94
//.word	0x00000100,TIM2+TIMx_SMCR,TIM2+TIMx_SMCR
#define		TIM3_SMS_0	95
#define		tim3_sms_0	95
//.word	0x00000001,TIM3+TIMx_SMCR,TIM3+TIMx_SMCR
#define		TIM3_SMS_1	96
#define		tim3_sms_1	96
//.word	0x00000010,TIM3+TIMx_SMCR,TIM3+TIMx_SMCR
#define		TIM3_SMS_2	97
#define		tim3_sms_2	97
//.word	0x00000100,TIM3+TIMx_SMCR,TIM3+TIMx_SMCR

#define		RXNEIE	98
#define		rxneie	98
//.word	0x00000020,USART2+USART2_CR1,USART2+USART2_CR1
#define		EPort0	99
//.word 	0x0000001,EPort,EPort
#define		EPort1	100
//.word 	0x0000002,EPort,EPort
#define		EPort2	101
//.word 	0x0000004,EPort,EPort
#define		EPort3	102
//.word 	0x0000008,EPort,EPort
#define		EPort4	103
//.word 	0x0000010,EPort,EPort
#define		EPort5	104
//.word 	0x0000020,EPort,EPort
#define		EPort6	105
//.word 	0x0000040,EPort,EPort
#define		EPort7	106
//.word 	0x0000080,EPort,EPort
#define		EPort8	107
//.word 	0x0000100,EPort,EPort
#define		EPort9	108
//.word 	0x0000200,EPort,EPort
#define		EPort10	109
//.word 	0x0000400,EPort,EPort
#define		EPort11	110
//.word 	0x0000800,EPort,EPort
#define		EPort12	111
//.word 	0x0001000,EPort,EPort
#define		EPort13	112
//.word 	0x0002000,EPort,EPort
#define		EPort14	113
//.word 	0x0004000,EPort,EPort
#define		EPort15	114
//.word 	0x0008000,EPort,EPort
//Systicktimer
#define		SysTickIntEnable	115
//.word   0x0000002,SysTickCSR,SysTickCSR
#define		SysTickTimerEnable	116
//.word   0x0000001,SysTickCSR,SysTickCSR
#define		SysTickTimerCOUNTFLAG	117
//.word   1<<16,SysTickCSR,SysTickCSR
#define		SysTickTimerClockSource	118
//.word   1<<2,SysTickCSR,SysTickCSR
#define		RTSR0	119
#define		rtsr0	119
//.word   1<<0,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR1	120
#define		rtsr1	120
//.word   1<<1,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR2	121
#define		rtsr2	121
//.word   1<<2,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR3	122
#define		rtsr3	122
//.word   1<<3,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR4	123
#define		rtsr4	123
//.word   1<<4,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR5	124
#define		rtsr5	124
//.word   1<<5,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR6	125
#define		rtsr6	125
//.word   1<<6,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR7	126
#define		rtsr7	126
//.word   1<<7,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR8	127
#define		rtsr8	127
//.word   1<<8,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR9	128
#define		rtsr9	128
//.word   1<<9,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR10	129
#define		rtsr10	129
//.word   1<<10,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR11	130
#define		rtsr11	130
//.word   1<<11,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR12	131
#define		rtsr12	131
//.word   1<<12,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR13	132
#define		rtsr13	132
//.word   1<<13,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR14	133
#define		rtsr14	133
//.word   1<<14,exti+exti_RTSR,exti+exti_RTSR
#define		RTSR15	134
#define		rtsr15	134
//.word   1<<15,exti+exti_RTSR,exti+exti_RTSR

#define		FTSR0	135
#define		ftsr0	135
//.word   1<<0,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR1	136
#define		ftsr1	136
//.word   1<<1,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR2	137
#define		ftsr2	137
//.word   1<<2,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR3	138
#define		ftsr3	138
//.word   1<<3,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR4	139
#define		ftsr4	139
//.word   1<<4,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR5	140
#define		ftsr5	140
//.word   1<<5,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR6	141
#define		ftsr6	141
//.word   1<<6,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR7	142
#define		ftsr7	142
//.word   1<<7,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR8	143
#define		ftsr8	143
//.word   1<<8,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR9	144
#define		ftsr9	144
//.word   1<<9,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR10	145
#define		ftsr10	145
//.word   1<<10,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR11	146
#define		ftsr11	146
//.word   1<<11,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR12	147
#define		ftsr12	147
//.word   1<<12,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR13	148
#define		ftsr13	148
//.word   1<<13,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR14	149
#define		ftsr14	149
//.word   1<<14,exti+exti_FTSR,exti+exti_FTSR
#define		FTSR15	150
#define		ftsr15	150
//.word   1<<15,exti+exti_FTSR,exti+exti_FTSR


//vektorLocationTabelle:
#define 	ex0Vector      0x58
#define 	ex1Vector      0x5c
#define 	ex2Vector      0x60
#define 	ex3Vector      0x64
#define 	ex4Vector      0x68
#define 	ex5Vector      0x9c
#define 	ex6Vector      0x9c
#define 	ex7Vector      0x9c
#define 	ex8Vector      0x9c
#define 	ex9Vector      0x9c
#define 	ex10Vector      0xe0
#define 	ex11Vector      0xe0
#define 	ex12Vector      0xe0
#define 	ex13Vector      0xe0
#define 	ex14Vector      0xe0
#define 	ex15Vector      0xe0
#define 	uie6Vector      0xec
#define 	uie7Vector      0xf0
#define 	uie2Vector      0xb0
#define 	uie3Vector      0xb4
#define 	usart2IntVector      0xD8
#define		SysTickVector      0x3c



void startup(void) asm("startup");
//Bitbefehle
void writeBit(uint8 IOBit,uint8	Wert) asm("writeBit");
uint8 readBit(uint8 IOBit) asm("readBit");
void cplBit(uint8 IOBit) asm("cplBit");


void setDirection(uint8 IOBit,uint8 Direction) asm("setDirection");
#define Eingang		0
#define Ausgang		1
#define Alternate	2
#define	Analog		3

void PullUpDown(uint8 IOBit, uint8 UpDown) asm("PullUpDown");
//Pullup/-down
#define	KeinPull 0
#define	Pullup   1
#define	Pulldown 2


void Ausgangstyp(uint8 IOBit, uint8 Typ) asm("Ausgangstyp");	//Bit in R0, Typ in R1
//OutputType
#define PushPull	0
#define OpenDrain	1


void writeRegister(unsigned long Register, unsigned int Data) asm("writeRegister");
unsigned int readRegister(unsigned long Register) asm("readRegister");

void writeByteRegister(unsigned long *Register, uint8 Data) asm("writeByteRegister");
uint8 readByteRegister(unsigned long *Register) asm("readByteRegister");


void writeArduinoPort(uint8 Data, uint8 DHoderDL) asm("writeArduinoPort"); 		// DL oder DH 	kopiert  Data auf D7..D0 oder D15 .. D8
#define	DL 0
#define	DH 1

//USART2 sendByte
void USART2_sendbyte(uint8 b ) asm("USART2_sendbyte");

void USART2_sendBytes(uint8* Buffer) asm("USART2_sendBytes");	//R0 Zeiger auf Buffer, Letztes Zeichen: 0 als Startbyte wird immer eine 1 weggeschickt

typedef void (*funcptr)();

void setIntVector(funcptr isr,int Vector)  asm("setIntVector"); //Startadresse der ISR, Interruptvector

void I2C_init(void) asm("I2Cinit");	//I2C1 init

void I2C1_sendBytes(uint8* Datapointer,uint8 anz, uint8 Zieladresse);	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse

unsigned int Ain0() asm("Ain0");
unsigned int Ain1() asm("Ain1");
unsigned int Ain2() asm("Ain2");
unsigned int Ain3() asm("Ain3");
unsigned int Ain4() asm("Ain4");
unsigned int Ain5() asm("Ain5");

void wait_ms(unsigned long ms) asm("wait_ms");

//Grove-LCD RGB Backlight


/*This function is used to turn on the display on the LCD.  It sends the
hexadecimal code for the display on setting to the device in order to
turn on the display*/

void Grove_LCD_RGB_Backlight_displayOn() asm("Grove_LCD_RGB_Backlight_displayOn");


/*This function is used to clear display on the LCD.  It sends the
hexadecimal code for the clear instruction to the device in order to
clear the display*/
void Grove_LCD_RGB_Backlightclear() asm("Grove_LCD_RGB_Backlightclear");


/*This function is used to set the backlight color of the dispaly.
It writes the provided r, g, and b values to the registers for the red
value, the green value, and the blue value respectively.*/
void Grove_LCD_RGB_BacklightsetRGB(uint8 r, uint8 g, uint8 b) asm("Grove_LCD_RGB_BacklightsetRGB");

/*This function is used to write to the LCD screen.  It takes in a string of
characters and writes them to the 0x40 register of the display.*/
void Grove_LCD_RGB_Backlightprint(char * text)	 asm("Grove_LCD_RGB_Backlightprint");

/*This function sets where on the screen the text will be written next.  It
takes in two values which indicate the row and column on the display that
the cursor should be moved to*/
void Grove_LCD_RGB_Backlightlocate(uint8 x, uint8 y) asm("Grove_LCD_RGB_Backlightlocate");


void Grove_LCD_RGB_Backlightinit() asm("Grove_LCD_RGB_Backlightinit");

/*This function is used to write to the LCD screen.  It takes in a number writes it to the 0x40 register of the display.*/
void Grove_LCD_RGB_Backlightdezaus(unsigned int zahl) asm("Grove_LCD_RGB_Backlightdezaus");

extern unsigned int EPort;

// Multi Function Shield
// SerialData,D8
// SerialClock,D7
// LatchClock,D4

void MFS_serial_init() asm("MFS_serial_init");
void MFS_sendWord(unsigned int) asm("MFS_sendWord");	//Daten in EPort

//LCD_Keyboard_Shield
//	RS,PA9
//	E,PC7
//	DB4,D4
//	DB5,D5
//	DB6,D6
//	DB7,D7

void LCD_Keypad_init() asm("LCD_Keypad_init");
/*This function is used to write to the LCD screen.  It takes in a string of
characters and writes them to the 0x40 register of the display.*/
void LCD_Keypad_Text(char * text) asm("LCD_Keypad_Text");
void LCD_Keypad_Clear() asm("LCD_Keypad_Clear");
void LCD_Keypad_Cursor(uint8 pos) asm("LCD_Keypad_Cursor"); //1. Zeile 0... 2. Zeile 0x40 ...
void LCD_Keypad_Dezaus(unsigned int zahl) asm("LCD_Keypad_Dezaus");

//Schrittmotorshield
// SM_EN12,D11
// SM_EN34,D3
// SM_SerialData,D8
// SM_SerialClock,D4
// SM_LatchClock,D12
// SM_OutputEnable,D7

void SM_init() asm("SM_init");
void SM_sendByte(uint8 data) asm("SM_sendByte");

//LED&KEY
void LuK_init(uint8 StrobePort, uint8 CLKPort, uint8 DIOPort) asm("LuK_init");
void LuK_sendCommand(uint8 command) asm("Luk_sendCommand");
void LuK_sendByte(uint8 Displayadresse, uint8 Databyte) asm("LuK_sendByte");	//R0 Displayadresse, R1 Data
uint8	LuK_readByte(void) asm("LuK_readByte");	//Return Tasten
void LuK_setLEDs(uint8 LEDs, uint8 Maske) asm("LuK_setLEDs");

//LCD mit I2C-Schnittstelle
//verwendet i2c-Adresse 0x27 (siehe regs.asm)
//verwendet soft_i2cNr 0
void LCD_i2c_init_display(uint8 SCL, uint8 SDA) asm("LCD_i2c_init_display");
void LCD_i2c_cursorpos(uint8 pos) asm("LCD_i2c_cursorpos");
void LCD_i2c_clear() asm("LCD_i2c_clear");
void LCD_i2c_textaus(char *Text) asm("LCD_i2c_textout");	//R0 Pointer auf string, nullterminiert
void LCD_i2c_dezaus(unsigned int zahl) asm("LCD_i2c_dezaus");
void LCD_i2c_hexaus(unsigned int zahl) asm("LCD_i2c_hexaus");
void LCD_i2c_binaus(unsigned int zahl) asm("LCD_i2c_binaus");
void LCD_i2c_bin16aus(unsigned int zahl) asm("LCD_i2c_bin16aus");
void LCD_i2c_textzeile1(char *Text) asm("LCD_i2c_textzeile1");
void LCD_i2c_textzeile2(char *Text) asm("LCD_i2c_textzeile2");
void LCD_i2c_asciaus(char z) asm("LCD_i2c_asciaus");

//return unsigned char (1 nicht ok)
uint8 soft_write_i2c(uint8 geraeteadresse, uint8 wortadresse, uint8 *daten, unsigned int i2cNR_anzahl) asm("soft_send_i2c");
void soft_init(uint8 scl, uint8 sda, uint8 i2cNr) asm("soft_init");
uint8 soft_read_i2c(unsigned char geraeteadresse, unsigned char wordadress, unsigned char *daten, unsigned int i2cNr_anzahl) asm("soft_read_i2c");

void writePort(unsigned int Wert, unsigned int Port, unsigned int Maske) asm("writePort"); //R0 Wert, R1 Port, R2 Maske
unsigned int readPort(unsigned int Port, unsigned int Maske) asm ("readPort"); //R0 Port/Wert, R1 Maske

void initSysTick(unsigned int Reload) asm("initSysTick"); //R0 Reloadwert

int LCD_i2c_printf(const char *format, ...)
{
	char buf[16];
	va_list args;
	va_start(args, format);
	vsprintf(buf,format,args);
	va_end(args);
	LCD_i2c_textaus(buf);
	return 0;
}

void HC05init(void) asm("HC05init");
int gibHC05Anz(void) asm("gibHC05Anz");
char gibHC05data(void) asm("gibHC05data");
void HC05send(char z) asm("HC05send");

#endif
