.syntax unified
.equ L152,1
.include "../Core/src/regs.s"
.global mainasm
mainasm:


.equ Einerstelle,Bit12
.equ Zehnerstelle,Bit13
.equ Taster,Bit1

main:

	mov 	R5,#0 			//Zähler für Einer in R5 mit 0 beginnen
	mov		R7,#0			//Zähler für Zehner
	ldr 	R4,=GPIOA		//R4 verweist auf GPIOA
	ldr 	R6,=seg7		//R6 verweist auf die Tabelle seg7
	bl		MFS_serial_init	//Initialisierung der Schnittstelle
schleife:	//Endlosschleife
	ldr 	R0,[R4,IDR]		//GPIOA.IDR einlesen (Bit1=Taster PA1)
	tst 	R0,Taster		//Taster prüfen
	beq		gedrueckt		//0 dann gedrückt

	ldrb 	R0,[R6,R5]		//R0=seg7[R5]
	add		R0,Einerstelle	//Einerstelle hinzufügen
	bl		MFS_sendWord
	mov		R0,#5
	bl		wait_ms

	ldrb 	R0,[R6,R7]		//R0=seg7[R7]
	add		R0,Zehnerstelle	//Einerstelle hinzufügen
	bl		MFS_sendWord
	mov		R0,#5
	bl		wait_ms


	b		schleife
gedrueckt:					//wenn PA1-Taste gedrückt
	add		R5,#1			//um 1 hochzählen
nochgedrueckt:				//warten solange Taste-PA1 noch gedrückt
	ldr 	R0,[R4,IDR]		//GPIOA.IDR einlesen
	tst 	R0,Taster		//Bit1 prüfen
	beq		nochgedrueckt	//bei noch gedrückt erneut Taste abfragen
	cmp 	R5,#10			//R5==10?
	bne 	schleife		//nein, dann von vorne
	mov 	R5,#0			//ja, dann R1 wieder bei 0 beginnen
	add		R7,#1
	cmp		R7,#10
	bne		schleife
	mov		R7,#0
	b		schleife

seg7:
.byte 0b00000011,0b10011111,0b00100101,0b00001101,0b10011001,0b01001001,0b01000001,0b00011111,0b00000001,0b00001001



.end
