.syntax unified

.equ L152,1
.include "../Core/src/regs.s"

.global mainasm

mainasm:



main:
ldr R0,=rcc
ldr R1,[R0,RCC_AHBENR]
orr R1,Bit2+Bit1+Bit0
str R1,[R0,RCC_AHBENR]

ldr R0,=GPIOB
ldr R1,[R0,PUPDR]
mov R2,#0b10101010101010 //alle Pulldown
orr R1,R2
str R1,[R0,PUPDR]

//GPIOC 7..0 als Ausgänge
ldr R1,=GPIOC
ldr R2,[R1,MODER]
mov R3,0b0101010101010101
orr R2,R3
str R2,[R1,MODER]

//**********************************************************
// Timer TIM6 initialisieren
//*********************************************************
//TIM2, TIM6 und TIM7 mit Takt versorgen
ldr 	R0,=rcc
ldr 	R1,[R0,RCC_APB1ENR]
orr 	R1,0b110001   			//0bTIM7,TIM6,000,TIM2
str 	R1,[R0,RCC_APB1ENR]

ldr 	R3,=TIM2	//Timerauswahl TIM2, TIM6, TIM7

mov 	R1,#31999	//Prescalerwert 31999 = 1 ms
str 	R1,[R3,PSC]

mov		R1,#499		//Autoreloadwert 500ms
str		R1,[R3,ARR]

mov		R1,#0
str 	R1,[R3,CNT] //Zähler bei 0 starten
str 	R1,[R3,SR]	//Update Interrupt flag UIF zurücksetzen

mov 	R1,#1
str 	R1,[R3,CR1] //Timer starten (CEN=1)
//Timerinitialisierung fertig

//**********************************************************
// Initialisierung Timerinterrupt (Timerauswahl in R3
//**********************************************************
//1. NVIC alle Interrupts einschalten
//NVIC config enable Interrupt
ldr r4,=nvic

ldr r1,=0xFFFFFFFF

str r1,[r4,isrEnableReg0]
str r1,[r4,isrEnableReg1]

//2. Timerinterrupt freigeben
mov	R1,#1
str R1,[R3,DIER]
//3. ISR in Vektortabelle eintragen Datei: startup_stm32l152retx.s
/*
 .word isrTIM2	//TIM2_IRQHandler
  .word TIM3_IRQHandler
  .word TIM4_IRQHandler
...
  .word isrTIM6	//TIM6_IRQHandler
  .word isrTIM7	//TIM7_IRQHandler
*/
//Initialisierung des Timerinterrupts fertig

ldr 	R0,=GPIOB
ldr		R1,=GPIOC

schleife:				//Sprungmarke
ldrb	R2,[R0,IDR]
tst		R2,Bit0
bne		setzen
ruecksetzen:
mov		R2,Bit0
strb	R2,[R1,BRR]
b		schleife
setzen:
mov		R2,Bit0
strb	R2,[R1,BSR]
b		schleife		//branch = Sprung = Fortsetzen bei Sprungmarke (label) schleife:


//4. ISR schreiben (Timerauswahl in R3)
.global isrTIM2		//selbe ISR für alle 3 Timer
.global isrTIM6
.global isrTIM7
isrTIM2:
isrTIM6:
isrTIM7:
mov 	R2,#0		//5. UIF zurücksetzen
str 	R2,[R3,SR]

ldrb 	R2,[R1,ODR]	//Bit1 im ODR umschalten (blinken)
eor 	R2,Bit1
strb 	R2,[R1,ODR]
bx		lr

.end
