<?php
/*
 * Copyright (c) Codiad, Thomas Perschke, distributed
 * as-is and without warranty under the MIT License. 
 * See http://opensource.org/licenses/MIT for more information.
 * This information must remain intact.
 */

    function getWorkspacePath($path, $error='Invalid path: '){
		
		//Security check
		if (!Common::checkPath($path)) {
			$error .= $path;
			die($error);
		}
        if (strpos($path, "/") === 0) {
            //Unix absolute path
            return $path;
        }
        if (strpos($path, ":/") !== false) {
            //Windows absolute path
            return $path;
        }
        if (strpos($path, ":\\") !== false) {
            //Windows absolute path
            return $path;
        }
		
        return WORKSPACE . "/" . $path;
    }

	function getStudentsList(){
		
		$students=[];
		
		if(isset($_GET['path'])){
			
			//TODO: Common::checkPath($path) return false...
			$source = getWorkspacePath($_GET['path']);
			
			//$source = WORKSPACE . "/" . $_GET['path'];

			if(file_exists($source)){
			
				$source_info=pathinfo($source);

				if(isset($source_info['extension'])&&!empty($source_info['extension'])){
					
					
					if($source_info['extension']=='csv'){
						
						if (($handle = fopen($source, "r")) !== FALSE) {
							while (($data = fgetcsv($handle, 1024, "\t")) !== FALSE) {
								if(isset($data[0]) && substr($data[0], 0, 8)!= "Langname") {
									$students[] = $data;
								}
							}
							fclose($handle);
						}
					}
				}
			}
		}
		
		return $students;
	}
	
?>