/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.Format;
import edu.davidson.display.SContour_this_mouseAdapter;
import edu.davidson.display.SContour_this_mouseMotionAdapter;
import edu.davidson.display.SGraph;
import edu.davidson.graph.DataSet;
import edu.davidson.graph.IsoCurve;
import edu.davidson.graph.TextLine;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class SContour
extends SGraph {
    static int MINCELLS = 25;
    static final int NLEVELS = 12;
    protected int nx = 0;
    protected int ny = 0;
    protected Vector[] curves = null;
    protected boolean autoLevels = true;
    protected boolean logLevels = false;
    protected boolean gridLimits = true;
    protected double[] levels;
    protected TextLine[] labels;
    protected Font labelfont;
    protected Color labelcolor;
    protected int labelStyle = 2;
    protected int labelPrecision = 2;
    protected int labelSignificant = 3;
    protected int labelLevels = 1;
    protected boolean drawlabels = true;
    protected boolean autoLabels = true;
    protected Color contourColor = null;
    protected Color labelledColor = null;
    protected double[] grid = null;
    protected double xmin = -1.0;
    protected double xmax = 1.0;
    protected double ymin = -1.0;
    protected double ymax = 1.0;
    protected double zmin = 0.0;
    protected double zmax = 0.0;
    public boolean noContours = false;
    boolean isDrag = false;
    Format format = new Format("%-+8.5g");

    public SContour() {
        this.levels = new double[12];
        this.labels = new TextLine[12];
        this.labelfont = new Font("Helvetica", 0, 12);
        this.labelcolor = Color.blue;
        this.setDataBackground(new Color(0.933f, 0.914f, 0.749f));
        this.setContourColor(new Color(0.18f, 0.545f, 0.341f));
        this.setLabelledContourColor(new Color(0.5f, 0.0f, 0.0f));
        this.setLabelPrecision(2);
        this.setLabelSignificance(2);
        this.square = false;
        this.setFont(new Font("TimesRoman", 0, 15));
        this.deleteAllSeries();
        this.detachAxes();
        this.detachDataSets();
        this.xaxis = this.createAxis(5);
        this.xaxis.setTitleText("X_axis");
        this.xaxis.setTitleColor(Color.magenta);
        this.xaxis.setTitleFont(new Font("TimesRoman", 2, 15));
        this.xaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.yaxis = this.createAxis(2);
        this.yaxis.setTitleText("Y_axis");
        this.yaxis.setTitleColor(Color.magenta);
        this.yaxis.setTitleFont(new Font("TimesRoman", 2, 15));
        this.yaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.borderLeft = 0;
        this.borderTop = 0;
        this.borderRight = 0;
        this.borderBottom = 0;
        this.setShowAxis(true);
        this.createSampleData();
        this.xaxis.setManualRange(true);
        this.yaxis.setManualRange(true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setRange(double d, double d2, double d3, double d4) {
        if (d >= d2 || d3 >= d4) {
            return;
        }
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.detachCurves();
        this.curves = null;
        if (this.gridLimits) {
            if (this.xaxis != null) {
                this.xaxis.setManualRange(true, d, d2);
            }
            if (this.yaxis != null) {
                this.yaxis.setManualRange(true, d3, d4);
            }
        }
    }

    public void setNoContours(boolean bl) {
        if (bl == this.noContours) {
            return;
        }
        this.noContours = bl;
        if (bl) {
            this.detachCurves();
        } else {
            this.attachCurves();
        }
    }

    public double[] getRange() {
        double[] dArray = new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
        return dArray;
    }

    public int[] getDim() {
        int[] nArray = new int[]{this.nx, this.ny};
        return nArray;
    }

    public double[] getGrid() {
        return this.grid;
    }

    public void setLevels(double d, double d2, int n) {
        int n2;
        if ((n = Math.min(n, 1000)) <= 0) {
            this.autoLevels = true;
            this.setNLevels(12);
            return;
        }
        if (d2 <= 0.0) {
            this.autoLevels = true;
            this.setNLevels(n);
            return;
        }
        this.detachCurves();
        this.curves = null;
        this.autoLevels = false;
        this.levels = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.levels[n2] = d;
            d += d2;
        }
        this.labels = new TextLine[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.labels[n2] = new TextLine(String.valueOf((float)this.levels[n2]));
        }
    }

    public void setLevels(double[] dArray) {
        if (dArray == null || dArray.length <= 0) {
            this.autoLevels = true;
            this.setNLevels(12);
            return;
        }
        int n = dArray.length;
        this.detachCurves();
        this.curves = null;
        this.autoLevels = false;
        this.levels = new double[n];
        System.arraycopy(dArray, 0, this.levels, 0, n);
        this.labels = new TextLine[n];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new TextLine(String.valueOf((float)dArray[i]));
        }
    }

    public void setLabels(TextLine[] textLineArray, int n) {
        if (textLineArray == null || n <= 0) {
            return;
        }
        this.autoLabels = false;
        this.labels = new TextLine[n];
        System.arraycopy(textLineArray, 0, this.labels, 0, n);
    }

    public void setLabelFont(Font font) {
        this.labelfont = font;
    }

    public void setLabelColor(Color color) {
        this.labelcolor = color;
    }

    public void setGrid(double[] dArray, int n, int n2) {
        this.grid = dArray;
        this.nx = n;
        this.ny = n2;
        MINCELLS = (n + n2) / 4;
        this.zrange();
        this.calcLevels();
    }

    public void setGrid(double[][] dArray) {
        if (dArray == null || dArray.length < 2 || dArray[0].length < 2) {
            return;
        }
        this.setGrid(dArray, this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void setGrid(double[][] dArray, double d, double d2, double d3, double d4) {
        if (dArray == null || dArray.length < 2 || dArray[0].length < 2) {
            return;
        }
        int n = 0;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = new double[n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[n] = dArray[j][i];
                ++n;
            }
        }
        this.setRange(d, d2, d3, d4);
        this.setGrid(dArray2, n2, n3);
        this.calcLabels();
        this.detachCurves();
        this.curves = null;
    }

    public void deleteContours() {
        if (this.curves == null) {
            return;
        }
        this.detachCurves();
        this.curves = null;
    }

    public void detachContours() {
        if (this.curves == null) {
            return;
        }
        this.detachCurves();
    }

    public void attachContours() {
        if (this.curves == null) {
            return;
        }
        this.attachCurves();
    }

    public void setContourColor(Color color) {
        this.contourColor = color;
    }

    public void setLabelledContourColor(Color color) {
        this.labelledColor = color;
    }

    public double[] getLevels() {
        return this.levels;
    }

    public void setLimitsToGrid(boolean bl) {
        this.gridLimits = bl;
    }

    public void setLabelLevels(int n) {
        this.labelLevels = n <= 0 ? 0 : n;
    }

    public void setLogLevels(boolean bl) {
        this.logLevels = bl;
        if (this.zmin <= 0.0 || this.zmax <= 0.0) {
            this.logLevels = false;
        }
    }

    public void setNLevels(int n) {
        if (n <= 0) {
            return;
        }
        this.levels = new double[n];
        this.calcLevels();
        this.detachCurves();
        this.curves = null;
    }

    public void setAutoLevels(boolean bl) {
        this.autoLevels = bl;
    }

    public void setDrawLabels(boolean bl) {
        if (this.drawlabels == bl) {
            return;
        }
        this.drawlabels = bl;
    }

    public boolean getDrawLabels() {
        return this.drawlabels;
    }

    public void setLabelStyle(int n) {
        this.labelStyle = n;
        this.calcLabels();
    }

    public int getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
        this.calcLabels();
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public void setLabelSignificance(int n) {
        this.labelSignificant = n;
        this.calcLabels();
    }

    public int getLabelSignificance() {
        return this.labelSignificant;
    }

    private void calcLevels() {
        if (!this.autoLevels) {
            return;
        }
        if (this.levels == null) {
            this.levels = new double[12];
        }
        this.labels = new TextLine[this.levels.length];
        if (this.logLevels) {
            double d = Math.log(this.zmax - this.zmin) / (double)(this.levels.length + 1);
            try {
                for (int i = 0; i < this.levels.length; ++i) {
                    this.levels[i] = this.zmin + Math.pow(Math.E, (double)(i + 1) * d);
                }
            }
            catch (Exception exception) {
                System.out.println("Error calculateing Log levels!");
                System.out.println("... calculating linear levels instead");
                this.logLevels = false;
                this.calcLevels();
            }
        } else {
            double d = (this.zmax - this.zmin) / (double)(this.levels.length + 1);
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = this.zmin + (double)(i + 1) * d;
            }
        }
    }

    private void calcLabels() {
        if (!this.autoLabels) {
            return;
        }
        if (this.levels == null || this.levels.length <= 0) {
            return;
        }
        this.labels = new TextLine[this.levels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new TextLine();
            this.labels[i].parseDouble(this.levels[i], this.labelSignificant, this.labelPrecision, this.labelStyle);
        }
    }

    private void zrange() {
        this.zmin = this.grid[0];
        this.zmax = this.grid[1];
        for (int i = 0; i < this.grid.length; ++i) {
            this.zmin = Math.min(this.zmin, this.grid[i]);
            this.zmax = Math.max(this.zmax, this.grid[i]);
        }
        if (this.zmin == this.zmax) {
            // empty if block
        }
        if (this.zmin <= 0.0 || this.zmax <= 0.0) {
            this.logLevels = false;
        }
    }

    public void paintFirst(Graphics graphics, Rectangle rectangle) {
        Object object = this.delayLock;
        synchronized (object) {
            if (this.curves == null && !this.noContours) {
                this.calculateCurves();
                this.calcLabels();
            }
        }
        this.setContourColors();
        if (this.gridLimits) {
            if (this.xaxis != null) {
                if (this.xaxis.minimum != this.xmin) {
                    this.xaxis.minimum = this.xmin;
                }
                if (this.xaxis.maximum != this.xmax) {
                    this.xaxis.maximum = this.xmax;
                }
            }
            if (this.yaxis != null) {
                if (this.yaxis.minimum != this.ymin) {
                    this.yaxis.minimum = this.ymin;
                }
                if (this.yaxis.maximum != this.ymax) {
                    this.yaxis.maximum = this.ymax;
                }
            }
        } else if (this.dataset.isEmpty()) {
            if (this.xaxis != null) {
                this.xaxis.minimum = this.xmin;
                this.xaxis.maximum = this.xmax;
            }
            if (this.yaxis != null) {
                this.yaxis.minimum = this.ymin;
                this.yaxis.maximum = this.ymax;
            }
        }
    }

    private void setContourColors() {
        int n;
        if (this.curves == null || this.contourColor == null && this.labelledColor == null) {
            return;
        }
        for (n = 0; n < this.curves.length; ++n) {
            this.setContourColors(this.curves[n], null);
        }
        if (this.contourColor != null) {
            for (n = 0; n < this.curves.length; ++n) {
                this.setContourColors(this.curves[n], this.contourColor);
            }
        }
        if (this.labelledColor != null) {
            for (n = 0; n < this.curves.length; ++n) {
                if (n % this.labelLevels != 0) continue;
                this.setContourColors(this.curves[n], this.labelledColor);
            }
        }
    }

    private void setContourColors(Vector vector, Color color) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            DataSet dataSet = (DataSet)vector.elementAt(i);
            if (dataSet == null) continue;
            dataSet.linecolor = color;
        }
    }

    private void attachCurves() {
        if (this.curves == null) {
            return;
        }
        for (int i = 0; i < this.curves.length; ++i) {
            this.attachCurves(this.curves[i]);
        }
    }

    private void attachCurves(Vector vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.attachDataSet((DataSet)vector.elementAt(i));
            if (this.xaxis != null) {
                this.xaxis.attachDataSet((DataSet)vector.elementAt(i));
            }
            if (this.yaxis == null) continue;
            this.yaxis.attachDataSet((DataSet)vector.elementAt(i));
        }
    }

    private void detachCurves() {
        if (this.curves == null) {
            return;
        }
        for (int i = 0; i < this.curves.length; ++i) {
            this.detachCurves(this.curves[i]);
        }
    }

    private void detachCurves(Vector vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.detachDataSet((DataSet)vector.elementAt(i));
            if (this.xaxis != null) {
                this.xaxis.detachDataSet((DataSet)vector.elementAt(i));
            }
            if (this.yaxis == null) continue;
            this.yaxis.detachDataSet((DataSet)vector.elementAt(i));
        }
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        double[] dArray = new double[2];
        Color color = graphics.getColor();
        Rectangle rectangle2 = new Rectangle();
        if (this.xaxis == null || this.yaxis == null || this.labels == null || this.labelLevels == 0 || !this.drawlabels || this.curves == null) {
            super.paintLast(graphics, rectangle);
            return;
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (this.labels[i] == null || this.labels[i].isNull() || i % this.labelLevels != 0) continue;
            this.labels[i].setFont(this.labelfont);
            this.labels[i].setColor(this.labelcolor);
            Vector vector = this.curves[i];
            for (int j = 0; j < vector.size(); ++j) {
                DataSet dataSet = (DataSet)vector.elementAt(j);
                int n = dataSet.dataPoints();
                int n2 = (int)(Math.random() * (double)MINCELLS);
                while (n > MINCELLS) {
                    dArray = dataSet.getPoint(n2);
                    int n3 = this.xaxis.getInteger(dArray[0]);
                    int n4 = this.yaxis.getInteger(dArray[1]);
                    rectangle2.width = this.labels[i].getWidth(graphics);
                    rectangle2.height = this.labels[i].getAscent(graphics);
                    rectangle2.x = n3 - rectangle2.width / 2;
                    rectangle2.y = n4 - rectangle2.height / 2;
                    graphics.setColor(this.DataBackground);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics.setColor(color);
                    this.labels[i].draw(graphics, rectangle2.x, rectangle2.y + rectangle2.height, 1);
                    n -= MINCELLS;
                    n2 += MINCELLS;
                }
            }
        }
        super.paintLast(graphics, rectangle);
    }

    protected synchronized void calculateCurves() {
        double d = (this.xmax - this.xmin) / (double)(this.nx - 1);
        double d2 = (this.ymax - this.ymin) / (double)(this.ny - 1);
        IsoCurve isoCurve = new IsoCurve(this.grid, this.nx, this.ny);
        Object object = this.delayLock;
        synchronized (object) {
            if (this.curves != null) {
                this.detachCurves();
                this.curves = null;
            }
            if (this.zmin == this.zmax) {
                return;
            }
            int n = this.levels.length;
            Vector[] vectorArray = new Vector[n];
            for (int i = 0; i < n; ++i) {
                isoCurve.setValue(this.levels[i]);
                vectorArray[i] = new Vector();
                double[] dArray = isoCurve.getCurve();
                while (isoCurve != null && dArray != null) {
                    for (int j = 0; j < dArray.length; ++j) {
                        dArray[j] = this.xmin + dArray[j] * d;
                        dArray[++j] = this.ymin + dArray[j] * d2;
                    }
                    try {
                        vectorArray[i].addElement(new DataSet(dArray, dArray.length / 2));
                    }
                    catch (Exception exception) {
                        System.out.println("Error loading contour into DataSet!");
                        System.out.println("...Contour Level ".concat(String.valueOf(String.valueOf(this.levels[i]))));
                        return;
                    }
                    dArray = isoCurve.getCurve();
                }
                this.calcLabels();
                if (vectorArray == null || vectorArray[i] == null) continue;
                this.attachCurves(vectorArray[i]);
            }
            this.curves = vectorArray;
        }
    }

    public void calculateCurve(double d) {
        double[] dArray;
        double d2 = (this.xmax - this.xmin) / (double)(this.nx - 1);
        double d3 = (this.ymax - this.ymin) / (double)(this.ny - 1);
        IsoCurve isoCurve = new IsoCurve(this.grid, this.nx, this.ny);
        if (this.zmin == this.zmax) {
            return;
        }
        isoCurve.setValue(d);
        Vector<DataSet> vector = new Vector<DataSet>();
        while (isoCurve != null && (dArray = isoCurve.getCurve()) != null) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.xmin + dArray[i] * d2;
                dArray[++i] = this.ymin + dArray[i] * d3;
            }
            try {
                vector.addElement(new DataSet(dArray, dArray.length / 2));
            }
            catch (Exception exception) {
                System.out.println("Error loading contour into DataSet!");
                System.out.println("...Contour Level ".concat(String.valueOf(String.valueOf(d))));
                return;
            }
        }
        if (vector != null) {
            this.attachCurves(vector);
        }
    }

    public void deleteAllSeries() {
        this.deleteContours();
        super.deleteAllSeries();
        this.calcLevels();
        this.repaint();
    }

    public void createSampleData() {
        int n = 50;
        int n2 = 50;
        double d = -1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = -1.0;
        double[] dArray = new double[n * n2];
        double d5 = 0.25;
        double d6 = 0.5625;
        double d7 = 0.0625;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            double d8 = 2.0 * (double)i / (double)(n2 - 1) - 1.0;
            for (int j = 0; j < n; ++j) {
                double d9 = 2.0 * (double)j / (double)(n - 1) - 1.0;
                double d10 = (d9 - 0.5) * (d9 - 0.5) + (d8 + 0.5) * (d8 + 0.5);
                dArray[n3] = Math.exp(-d10 / d5);
                d10 = (d9 + 0.3) * (d9 + 0.3) + (d8 - 0.75) * (d8 - 0.75);
                int n4 = n3;
                dArray[n4] = dArray[n4] + Math.exp(-d10 / d6);
                d10 = (d9 + 0.7) * (d9 + 0.7) + (d8 + 0.6) * (d8 + 0.6);
                dArray[n3] = d9 * d9 + d9 * d8;
                ++n3;
            }
        }
        this.setRange(d, d2, d4, d3);
        this.setGrid(dArray, n, n2);
        this.setLabelLevels(3);
        this.setNLevels(20);
    }

    void paintCoordinates(double d, double d2) {
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        String string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append(" y=").append(this.format.form(d2))));
        graphics.setColor(Color.yellow);
        int n = 20 + fontMetrics.stringWidth(string);
        graphics.fillRect(0, this.getBounds().height - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, 8, this.getBounds().height - 2);
        graphics.dispose();
    }

    public void jbInit() throws Exception {
        this.addMouseMotionListener(new SContour_this_mouseMotionAdapter(this));
        this.addMouseListener(new SContour_this_mouseAdapter(this));
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        this.isDrag = true;
        double d = this.xFromPix(mouseEvent.getX());
        double d2 = this.yFromPix(mouseEvent.getY());
        this.paintCoordinates(d, d2);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.isDrag = false;
        this.repaint();
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        double d = this.xFromPix(mouseEvent.getX());
        double d2 = this.yFromPix(mouseEvent.getY());
        if (this.isDrag) {
            this.paintCoordinates(d, d2);
        }
    }

    static {
        NLEVELS = 12;
    }
}

