/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.numerics;

import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SODE;

public class SRK4
extends SODE {
    double h = 0.01;
    int numEqu = 0;
    double[] dydx;
    double[] xTemp;
    double[] k1;
    double[] k2;
    double[] k3;
    double[] k4;
    SDifferentiable equations;
    double tol = this.h * 1.0E-6;

    public int step(double d, double[] dArray) {
        if (d == 0.0) {
            return 0;
        }
        if (dArray.length < this.numEqu) {
            this.numEqu = dArray.length;
            this.xTemp = new double[this.numEqu];
            this.k1 = new double[this.numEqu];
            this.k2 = new double[this.numEqu];
            this.k3 = new double[this.numEqu];
            this.k4 = new double[this.numEqu];
            this.dydx = new double[this.numEqu];
            System.out.println("Warning:  Temporary arrays reset.");
        }
        int n = (int)Math.abs(d / this.h);
        for (int i = 0; i < n; ++i) {
            this.stepRK4(this.h, dArray);
        }
        if (d - (double)n * this.h > this.tol) {
            this.stepRK4(d - (double)n * this.h, dArray);
            ++n;
        }
        return n;
    }

    public double stepODE(double d, double[] dArray) {
        if (dArray.length < this.numEqu) {
            System.out.println("Error:  The temporary arrays are not large enough.");
            return 0.0;
        }
        this.stepRK4(d, dArray);
        return d;
    }

    private void stepRK4(double d, double[] dArray) {
        int n;
        double d2 = d;
        double d3 = 0.5 * d;
        double d4 = d / 6.0;
        this.dydx = this.equations.rate(dArray);
        for (n = 0; n < this.numEqu; ++n) {
            this.k1[n] = this.dydx[n];
            this.xTemp[n] = dArray[n] + d3 * this.k1[n];
        }
        this.dydx = this.equations.rate(this.xTemp);
        for (n = 0; n < this.numEqu; ++n) {
            this.k2[n] = this.dydx[n];
        }
        for (n = 0; n < this.numEqu; ++n) {
            this.xTemp[n] = dArray[n] + d3 * this.k2[n];
        }
        this.dydx = this.equations.rate(this.xTemp);
        for (n = 0; n < this.numEqu; ++n) {
            this.k3[n] = this.dydx[n];
        }
        for (n = 0; n < this.numEqu; ++n) {
            this.xTemp[n] = dArray[n] + d2 * this.k3[n];
        }
        this.dydx = this.equations.rate(this.xTemp);
        for (n = 0; n < this.numEqu; ++n) {
            this.k4[n] = this.dydx[n];
        }
        for (n = 0; n < this.numEqu; ++n) {
            dArray[n] = dArray[n] + d4 * (this.k1[n] + (double)2 * this.k2[n] + (double)2 * this.k3[n] + this.k4[n]);
        }
    }

    public final void setDifferentials(SDifferentiable sDifferentiable) {
        this.equations = sDifferentiable;
        this.numEqu = this.equations.getNumEqu();
        this.xTemp = new double[this.numEqu];
        this.k1 = new double[this.numEqu];
        this.k2 = new double[this.numEqu];
        this.k3 = new double[this.numEqu];
        this.k4 = new double[this.numEqu];
        this.dydx = new double[this.numEqu];
    }

    public final void setNumberOfEquations(int n) {
        this.numEqu = n;
        this.xTemp = new double[this.numEqu];
        this.k1 = new double[this.numEqu];
        this.k2 = new double[this.numEqu];
        this.k3 = new double[this.numEqu];
        this.k4 = new double[this.numEqu];
        this.dydx = new double[this.numEqu];
    }

    public final SDifferentiable getDiffernetials() {
        return this.equations;
    }

    public double getH() {
        return this.h;
    }

    public void setH(double d) {
        this.h = d;
        this.tol = d * 1.0E-6;
    }

    public void setTol(double d) {
    }

    public double getTol() {
        return this.tol;
    }
}

