/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Arrow;
import animator4.ArrowStatic;
import animator4.CalcThing;
import animator4.CaptionThing;
import animator4.Charge;
import animator4.ConnectorLine;
import animator4.ConnectorSpring;
import animator4.MouseDataSource;
import animator4.Protractor;
import animator4.TextThing;
import animator4.Thing;
import edu.davidson.display.Format;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.graphics.SFrame;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.StringTokenizer;

public class Animator
extends SApplet {
    String label_time = "Time";
    String label_collision = "collision";
    private String button_start = "Play";
    private String button_stop = "Pause";
    private String button_reset = "Reset";
    private String button_forward = ">>";
    private String button_back = "<<";
    private String message = null;
    int fps = 10;
    int ppu = 10;
    double gridUnit = 1.0;
    boolean showControls;
    double dt;
    EtchedBorder controlPanel = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    Button playBtn = new Button();
    Button pauseBtn = new Button();
    FlowLayout flowLayout2 = new FlowLayout();
    Button stepBackBtn = new Button();
    Button stepForwardBtn = new Button();
    Button resetBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    AnimatorCanvas animatorCanvas = new AnimatorCanvas(this);

    protected void setResources() {
        this.label_time = this.localProperties.getProperty("label.time", this.label_time);
        this.label_collision = this.localProperties.getProperty("label.collision", this.label_collision);
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_forward = this.localProperties.getProperty("button.forward", this.button_forward);
        this.button_back = this.localProperties.getProperty("button.back", this.button_back);
    }

    public void init() {
        this.initResources(null);
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ppu = Integer.parseInt(this.getParameter("PixPerUnit", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dt = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.gridUnit = Double.valueOf(this.getParameter("GridUnit", "1.0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.controlPanel.setVisible(this.showControls);
        this.animatorCanvas.pixPerUnit = this.ppu;
        this.animatorCanvas.gridUnit = this.gridUnit;
        this.clock.addClockListener((SStepable)this.animatorCanvas);
        this.clock.setDt(this.dt);
        this.clock.setFPS((double)this.fps);
    }

    private void jbInit() throws Exception {
        this.controlPanel.setLayout(this.flowLayout2);
        this.etchedBorder2.setLayout(this.borderLayout1);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.playBtn.setLabel(this.button_start);
        this.playBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Animator.this.playBtn_actionPerformed(actionEvent);
            }
        });
        this.pauseBtn.setLabel(this.button_stop);
        this.pauseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Animator.this.pauseBtn_actionPerformed(actionEvent);
            }
        });
        this.stepBackBtn.setLabel(this.button_back);
        this.stepBackBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Animator.this.stepBackBtn_actionPerformed(actionEvent);
            }
        });
        this.stepForwardBtn.setLabel(this.button_forward);
        this.stepForwardBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Animator.this.stepForwardBtn_actionPerformed(actionEvent);
            }
        });
        this.resetBtn.setLabel(this.button_reset);
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Animator.this.resetBtn_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.stepBackBtn, null);
        this.controlPanel.add((Component)this.playBtn, null);
        this.controlPanel.add((Component)this.stepForwardBtn, null);
        this.controlPanel.add((Component)this.pauseBtn, null);
        this.controlPanel.add((Component)this.resetBtn, null);
        ((Container)((Object)this)).add((Component)this.etchedBorder2, "Center");
        this.etchedBorder2.add((Component)this.animatorCanvas, "Center");
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.animatorCanvas.clearTrails();
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    protected void stoppingClock() {
        this.animatorCanvas.setMessage(this.message);
    }

    protected void cyclingClock() {
        this.setAnimationTime(this.clock.getMinTime());
        this.clearAllData();
    }

    public void setAutoRefresh(boolean bl) {
        if (this.destroyed) {
            this.animatorCanvas.autoRefresh = false;
            this.autoRefresh = false;
            return;
        }
        this.autoRefresh = bl;
        this.animatorCanvas.autoRefresh = bl;
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        if (bl) {
            this.animatorCanvas.repaint();
        }
    }

    public int setCaption(String string) {
        return this.animatorCanvas.setCaption(string);
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.noDrag = !bl;
        return true;
    }

    public boolean setResizable(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setResizable(bl);
        return true;
    }

    public boolean setVisibility(int n, boolean bl) {
        if (n == this.getClockID()) {
            this.animatorCanvas.timeDisplay = bl;
            if (this.animatorCanvas.autoRefresh) {
                this.animatorCanvas.repaint();
            }
            return true;
        }
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setDefault() {
        this.pause();
        this.deleteDataConnections();
        this.animatorCanvas.setMessage(null);
        this.message = null;
        this.animatorCanvas.timeDisplay = true;
        this.clock.setTime(0.0);
        this.animatorCanvas.setTime();
        this.animatorCanvas.pixPerUnit = this.ppu;
        this.animatorCanvas.gridUnit = this.gridUnit;
        this.clock.setDt(this.dt);
        this.clock.setFPS((double)this.fps);
        this.clock.setContinuous();
        this.animatorCanvas.setDefault();
    }

    public boolean setMass(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setMass(d);
        return true;
    }

    public void setCollisionMessage(String string) {
        this.label_collision = string;
    }

    public void setMessage(String string) {
        this.animatorCanvas.setMessage(string);
        this.message = string;
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.animatorCanvas.getThing(n);
        Thing thing2 = this.animatorCanvas.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        if (thing.myMaster == thing2) {
            thing.myMaster = null;
        }
        thing.mySlaves.addElement(thing2);
        thing2.myMaster = thing;
        thing2.setVarsFromMaster();
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setShapeRGB(int n, int n2, int n3) {
        this.animatorCanvas.defaultColor = new Color(n, n2, n3);
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        if (n == this.animatorCanvas.hashCode()) {
            this.animatorCanvas.setBackground(new Color(n2, n3, n4));
            return true;
        }
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.color = new Color(n2, n3, n4);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setOneShot(double d, double d2, String string) {
        this.clock.setOneShot(d, d2);
        this.animatorCanvas.setMessage(null);
        this.setAnimationTime(d);
        this.message = string;
    }

    public boolean setOnScreenSize(int n, int n2) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setSize(n2);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setTimeCycle(double d) {
        this.setTimeInterval(0.0, d);
    }

    public void setTimeInterval(double d, double d2) {
        this.clock.setCycle(d, d2);
        this.setAnimationTime(d);
        this.message = null;
        this.animatorCanvas.setMessage(null);
    }

    public void setTimeContinuous() {
        this.clock.setContinuous();
        this.message = null;
        this.animatorCanvas.setMessage(null);
    }

    public void setTimeOneShot(double d, String string) {
        this.setOneShot(0.0, d, string);
    }

    public boolean setFootPrints(int n, int n2) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.footPrints = n2;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setGhost(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.ghost = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setLabel(int n, String string) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setLabel(string);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setTolerance(double d) {
        this.animatorCanvas.dynamics.setTolerance(d);
    }

    public boolean setTrail(int n, int n2) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setTrailSize(n2);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setTrail(int n, int n2, int n3) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setTrailSize(n2, n3);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setTrajectory(int n, String string, String string2) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        return thing.setTrajectory(string, string2);
    }

    public boolean setForce(int n, String string, String string2, double d, double d2, double d3, double d4) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        if (thing.setForce(string, string2, d, d2, d3, d4)) {
            this.animatorCanvas.dynamics.addRateEquation(thing);
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setPaintBeforeGrid(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.paintBeforeGrid = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setTimeDisplay(boolean bl) {
        this.animatorCanvas.timeDisplay = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
    }

    public void setShowTime(boolean bl) {
        this.setTimeDisplay(bl);
    }

    public void setTimeVisibility(boolean bl) {
        this.setTimeDisplay(bl);
    }

    public boolean setShowConstraintPath(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showConstraintPath = bl;
        return true;
    }

    public boolean setShowCoordinates(int n, boolean bl) {
        if (n == this.animatorCanvas.hashCode()) {
            this.animatorCanvas.coordDisplay = bl;
            return true;
        }
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showCoordinates = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setShowVComponents(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showVComponents = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setShowFComponents(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showFComponents = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setShowAComponents(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showAComponents = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setShowVVector(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showVVector = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setShowAVector(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showAVector = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setShowFVector(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.showFVector = bl;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setSticky(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setSticky(bl);
        return true;
    }

    public boolean setBouncy(int n, boolean bl) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setBouncy(bl);
        return true;
    }

    public boolean setConstrainR(int n, double d, double d2, double d3) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        return thing.setConstrainR(d, d2, d3);
    }

    public boolean setConstrainX(int n, double d, double d2, double d3) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        return thing.setConstrainX(d, d2, d3);
    }

    public boolean setConstrainY(int n, double d, double d2, double d3) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        return thing.setConstrainY(d, d2, d3);
    }

    public boolean setCoordinateOffset(int n, int n2, int n3) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.xCoordOff = n2;
        thing.yCoordOff = n3;
        if (thing instanceof CaptionThing) {
            thing.xDisplayOff = n2;
            thing.yDisplayOff = n3;
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setDampOnMousePressed(boolean bl) {
        this.animatorCanvas.dampOnMousePressed = bl;
    }

    public boolean setFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null || font == null) {
            return false;
        }
        thing.font = font;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setObjectFont(int n, String string, int n2, int n3) {
        return this.setFont(n, string, n2, n3);
    }

    public boolean setFormat(int n, String string) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null && (n == 0 || n == this.animatorCanvas.hashCode())) {
            return this.animatorCanvas.setFormat(string);
        }
        boolean bl = thing.setFormat(string);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return bl;
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.xDisplayOff = n2;
        thing.yDisplayOff = n3;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public void setGridUnit(double d) {
        this.animatorCanvas.gridUnit = d;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
    }

    public int setSketchMode(boolean bl) {
        return this.animatorCanvas.setSketchMode(bl);
    }

    public void setPixPerUnit(int n) {
        this.animatorCanvas.pixPerUnit = n;
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
    }

    public void shiftPixOrigin(int n, int n2) {
        this.animatorCanvas.xOffset = -n;
        this.animatorCanvas.yOffset = -n2;
    }

    public void reset() {
        this.clearAllData();
        this.setAnimationTime(0.0);
    }

    public void setAnimationTime(double d) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.stopClock();
        }
        this.clock.setTime(d);
        this.animatorCanvas.setTime();
        if (bl) {
            this.startClock();
        } else if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
    }

    public void stepTimeForward() {
        this.animatorCanvas.setMessage(null);
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        boolean bl = this.clock.getDt() < 0.0;
        this.clock.setDt(Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (this.clock.isCycle() && this.clock.getTime() <= this.clock.getMinTime()) {
            this.animatorCanvas.clearTrails();
        }
        if (bl) {
            this.clock.setDt(-Math.abs(this.clock.getDt()));
        }
    }

    public void stepForward() {
        this.stepTimeForward();
    }

    public void stepTimeBack() {
        this.animatorCanvas.setMessage(null);
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        boolean bl = this.clock.getDt() < 0.0;
        this.clock.setDt(-Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (this.clock.isCycle() && this.clock.getTime() <= this.clock.getMinTime()) {
            this.animatorCanvas.clearTrails();
        }
        if (!bl) {
            this.clock.setDt(Math.abs(this.clock.getDt()));
        }
    }

    public void stepBack() {
        this.stepTimeBack();
    }

    public synchronized int addObject(String string, String string2) {
        if (this.destroyed) {
            return 0;
        }
        Object var3_3 = null;
        double d = 0.0;
        double d2 = 0.0;
        String string3 = "0";
        String string4 = "0";
        int n = 20;
        int n2 = 20;
        int n3 = 1;
        int n4 = 5;
        double d3 = 1.0;
        int n5 = 0;
        if (string2 == null) {
            string2 = " ";
        }
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string5 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("mouse")) {
            MouseDataSource mouseDataSource = this.animatorCanvas.addMouseThing();
            if (SUtil.parameterExist((String)string2, (String)"drag")) {
                mouseDataSource.setTrackDrag(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"move")) {
                mouseDataSource.setTrackMove(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"click")) {
                mouseDataSource.setTrackClick(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"release")) {
                mouseDataSource.setTrackRelease(true);
            }
            return mouseDataSource.getID();
        }
        if (string.equals("box")) {
            n3 = 1;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            n5 = this.animatorCanvas.addBox(n, n2, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            if (n3 != 1) {
                this.animatorCanvas.getThing(n5).setSize(n3);
            }
            return n5;
        }
        if (string.equals("rectangle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.animatorCanvas.addRectangle(n, n2, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("circle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.animatorCanvas.addCircle(2 * n4 + 1, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("doppler")) {
            int n6 = 10;
            double d4 = 1.0;
            double d5 = 1.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                n6 = (int)SUtil.getParam((String)string2, (String)"n=");
            }
            if (SUtil.parameterExist((String)string2, (String)"period=")) {
                d4 = SUtil.getParam((String)string2, (String)"period=");
            }
            if (SUtil.parameterExist((String)string2, (String)"c=")) {
                d5 = SUtil.getParam((String)string2, (String)"c=");
            }
            n6 = Math.max(1, n6);
            d4 = Math.max(this.dt, d4);
            if (d5 <= 0.0) {
                d5 = 1.0;
            }
            n5 = this.animatorCanvas.addDoppler(2 * n4 + 1, string3, string4, n6, d4, d5);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("charge")) {
            double d6 = 1.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            if (SUtil.parameterExist((String)string2, (String)"q=")) {
                d6 = SUtil.getParam((String)string2, (String)"q=");
            }
            n5 = this.animatorCanvas.addCharge(2 * n4 + 1, string3, string4, d6);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("shell")) {
            n3 = 1;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            n5 = this.animatorCanvas.addShell(2 * n4 + 1, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            if (n3 != 1) {
                this.animatorCanvas.getThing(n5).setSize(n3);
            }
            return n5;
        }
        if (string.equals("exshell")) {
            String string6 = "10";
            n3 = 2;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"r=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.animatorCanvas.addExShell(n3, string6, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("image")) {
            String string7 = " ";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"gif=")) {
                string7 = SUtil.getParamStr((String)string2, (String)"gif=");
            }
            if (SUtil.parameterExist((String)string2, (String)"file=")) {
                string7 = SUtil.getParamStr((String)string2, (String)"file=");
            }
            if (string7 == null) {
                return 0;
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.addImage(string7, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("protractor")) {
            Protractor protractor;
            n3 = 40;
            double d7 = 0.0;
            double d8 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta=")) {
                d7 = SUtil.getParam((String)string2, (String)"theta=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta0=")) {
                d8 = SUtil.getParam((String)string2, (String)"theta0=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            n5 = this.animatorCanvas.addProtractor(n3, d7, d8, string3, string4);
            if (SUtil.parameterExist((String)string2, (String)"fixedbase")) {
                protractor = (Protractor)this.animatorCanvas.getThing(n5);
                protractor.fixedBase = true;
            }
            if (SUtil.parameterExist((String)string2, (String)"fixedlength")) {
                protractor = (Protractor)this.animatorCanvas.getThing(n5);
                protractor.fixedlength = true;
            }
            return n5;
        }
        if (string.equals("arrow")) {
            Arrow arrow;
            String string8 = "1";
            String string9 = "1";
            n3 = 4;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                string8 = SUtil.getParamStr((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                string9 = SUtil.getParamStr((String)string2, (String)"v=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.animatorCanvas.addArrow(n3, string8, string9, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            if (SUtil.parameterExist((String)string2, (String)"thickness=")) {
                arrow = (Arrow)this.animatorCanvas.getThing(n5);
                arrow.thickness = Math.max((int)SUtil.getParam((String)string2, (String)"thickness="), 1);
            }
            if (SUtil.parameterExist((String)string2, (String)"filled")) {
                arrow = (Arrow)this.animatorCanvas.getThing(n5);
                arrow.setFilled(true);
            }
            return n5;
        }
        if (string.equals("arrow2")) {
            ArrowStatic arrowStatic;
            double d9 = 1.0;
            double d10 = 1.0;
            n3 = 5;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d9 = SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d10 = SUtil.getParam((String)string2, (String)"v=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.animatorCanvas.addArrowStatic(n3, d9, d10, string3, string4);
            if (SUtil.parameterExist((String)string2, (String)"thickness=")) {
                arrowStatic = (ArrowStatic)this.animatorCanvas.getThing(n5);
                arrowStatic.thickness = Math.max((int)SUtil.getParam((String)string2, (String)"thickness="), 1);
            }
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            if (SUtil.parameterExist((String)string2, (String)"filled")) {
                arrowStatic = (ArrowStatic)this.animatorCanvas.getThing(n5);
                arrowStatic.setFilled(true);
            }
            if (SUtil.parameterExist((String)string2, (String)"fixedlength")) {
                arrowStatic = (ArrowStatic)this.animatorCanvas.getThing(n5);
                arrowStatic.setFixedLength(true);
            }
            return n5;
        }
        if (string.equals("piston")) {
            String string10 = "1";
            String string11 = "1";
            n3 = 4;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                string10 = SUtil.getParamStr((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                string11 = SUtil.getParamStr((String)string2, (String)"v=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.animatorCanvas.addPiston(n3, string10, string11, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("line")) {
            String string12 = "1";
            String string13 = "1";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                string12 = SUtil.getParamStr((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                string13 = SUtil.getParamStr((String)string2, (String)"v=");
            }
            n5 = this.animatorCanvas.addArrow(0, string12, string13, string3, string4);
            if (SUtil.parameterExist((String)string2, (String)"thickness=")) {
                Arrow arrow = (Arrow)this.animatorCanvas.getThing(n5);
                arrow.thickness = Math.max((int)SUtil.getParam((String)string2, (String)"thickness="), 1);
            }
            return n5;
        }
        if (string.equals("calculation")) {
            String string14 = "";
            Object var19_38 = null;
            double d11 = 1.0E-12;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string14 = SUtil.getParamStr((String)string5, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string14 = SUtil.getParamStr((String)string5, (String)"text=");
            }
            n5 = this.animatorCanvas.addCalcThing(string14, string3, string4);
            if (SUtil.parameterExist((String)string2, (String)"chop=")) {
                d11 = SUtil.getParam((String)string2, (String)"chop=");
                CalcThing calcThing = (CalcThing)this.animatorCanvas.getThing(n5);
                calcThing.setChop(d11);
            }
            return n5;
        }
        if (string.equals("text")) {
            String string15 = "";
            String string16 = null;
            double d12 = 1.0E-12;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string15 = SUtil.getParamStr((String)string5, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string15 = SUtil.getParamStr((String)string5, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string16 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            n5 = this.animatorCanvas.addText(string15, string16, string3, string4);
            if (SUtil.parameterExist((String)string2, (String)"chop=")) {
                d12 = SUtil.getParam((String)string2, (String)"chop=");
                TextThing textThing = (TextThing)this.animatorCanvas.getThing(n5);
                textThing.setChop(d12);
            }
            return n5;
        }
        if (string.equals("caption")) {
            String string17 = "";
            String string18 = null;
            double d13 = 1.0E-12;
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string17 = SUtil.getParamStr((String)string5, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string17 = SUtil.getParamStr((String)string5, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string18 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            n5 = this.animatorCanvas.addCaption(string17, string18, "0", "0");
            if (SUtil.parameterExist((String)string2, (String)"chop=")) {
                d13 = SUtil.getParam((String)string2, (String)"chop=");
                CaptionThing captionThing = (CaptionThing)this.animatorCanvas.getThing(n5);
                captionThing.setChop(d13);
            }
            return n5;
        }
        if (string.equals("connectorline")) {
            int n7 = 0;
            int n8 = 0;
            if (SUtil.parameterExist((String)string2, (String)"id1=")) {
                n7 = (int)SUtil.getParam((String)string2, (String)"id1=");
            }
            if (SUtil.parameterExist((String)string2, (String)"id2=")) {
                n8 = (int)SUtil.getParam((String)string2, (String)"id2=");
            }
            return this.addConnectorLine(n7, n8);
        }
        if (string.equals("connectorspring")) {
            int n9 = 0;
            int n10 = 0;
            if (SUtil.parameterExist((String)string2, (String)"id1=")) {
                n9 = (int)SUtil.getParam((String)string2, (String)"id1=");
            }
            if (SUtil.parameterExist((String)string2, (String)"id2=")) {
                n10 = (int)SUtil.getParam((String)string2, (String)"id2=");
            }
            return this.addConnectorSpring(n9, n10);
        }
        if (string.equals("cursor")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            return this.animatorCanvas.addCursor(2 * n4 + 1, string3, string4);
        }
        if (string.equals("interaction")) {
            int n11 = 0;
            int n12 = 0;
            String string19 = "0";
            String string20 = "r";
            if (SUtil.parameterExist((String)string2, (String)"id1=")) {
                n11 = (int)SUtil.getParam((String)string2, (String)"id1=");
            }
            if (SUtil.parameterExist((String)string2, (String)"id2=")) {
                n12 = (int)SUtil.getParam((String)string2, (String)"id2=");
            }
            if (SUtil.parameterExist((String)string2, (String)"force=")) {
                string19 = SUtil.getParamStr((String)string2, (String)"force=");
            }
            if (SUtil.parameterExist((String)string2, (String)"mode=")) {
                string20 = SUtil.getParamStr((String)string2, (String)"mode=");
            }
            if (!this.animatorCanvas.addInteraction(n11, n12, string19, string20)) {
                System.out.println("Error in add interaction. force=" + string19);
            }
            return 0;
        }
        if (string.equals("curve")) {
            int n13 = 100;
            double d14 = -1.0;
            double d15 = 1.0;
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                n13 = (int)SUtil.getParam((String)string2, (String)"n=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"start=")) {
                d14 = SUtil.getParam((String)string2, (String)"start=");
            }
            if (SUtil.parameterExist((String)string2, (String)"stop=")) {
                d15 = SUtil.getParam((String)string2, (String)"stop=");
            }
            return this.animatorCanvas.addParametricCurve(n13, d14, d15, string3, string4);
        }
        if (string.equals("polyshape")) {
            int n14 = 0;
            String string21 = " ";
            String string22 = " ";
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                n14 = (int)SUtil.getParam((String)string2, (String)"n=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                string21 = SUtil.getParamStr((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                string22 = SUtil.getParamStr((String)string2, (String)"v=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.addPolyShape(n14, string21, string22, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (string.equals("relshape")) {
            int n15 = 0;
            String string23 = " ";
            String string24 = " ";
            if (SUtil.parameterExist((String)string2, (String)"n=")) {
                n15 = (int)SUtil.getParam((String)string2, (String)"n=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                string3 = SUtil.getParamStr((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                string23 = SUtil.getParamStr((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                string24 = SUtil.getParamStr((String)string2, (String)"v=");
            }
            if (SUtil.parameterExist((String)string2, (String)"m=")) {
                d3 = SUtil.getParam((String)string2, (String)"m=");
            }
            n5 = this.addRelPolyShape(n15, string23, string24, string3, string4);
            if (d3 != 1.0) {
                this.setMass(n5, d3);
            }
            return n5;
        }
        if (var3_3 == null) {
            System.out.println("Object not created. name:" + string + "parameter list:" + string2);
            return 0;
        }
        return 0;
    }

    public int addCircle(int n, String string, String string2) {
        return this.animatorCanvas.addCircle(n, string, string2);
    }

    public int addShell(int n, String string, String string2) {
        return this.animatorCanvas.addShell(n, string, string2);
    }

    public int addExShell(int n, String string, String string2, String string3) {
        return this.animatorCanvas.addExShell(n, string, string2, string3);
    }

    public int addPiston(int n, String string, String string2, String string3, String string4) {
        return this.animatorCanvas.addPiston(n, string, string2, string3, string4);
    }

    public int addSpring(String string, String string2, String string3, String string4) {
        return this.animatorCanvas.addSpring(4, string, string2, string3, string4);
    }

    public int addArrow(String string, String string2, String string3, String string4) {
        return this.animatorCanvas.addArrow(4, string, string2, string3, string4);
    }

    public boolean addInteraction(int n, int n2, String string, String string2) {
        return this.animatorCanvas.addInteraction(n, n2, string, string2);
    }

    public int addCalculation(String string, String string2, String string3, String string4) {
        return this.animatorCanvas.addText(string, string2, string3, string4);
    }

    public int addCaption(String string, String string2) {
        return this.animatorCanvas.addCaption(string, string2, "0", "0");
    }

    public int addCursor(int n, String string, String string2) {
        return this.animatorCanvas.addCursor(n, string, string2);
    }

    public int addText(String string, String string2, String string3) {
        return this.animatorCanvas.addText(string, null, string2, string3);
    }

    public int addLine(String string, String string2, String string3, String string4) {
        return this.animatorCanvas.addArrow(0, string, string2, string3, string4);
    }

    public synchronized int addConnectorLine(int n, int n2) {
        Thing thing = this.animatorCanvas.getThing(n);
        Thing thing2 = this.animatorCanvas.getThing(n2);
        ConnectorLine connectorLine = new ConnectorLine(this.animatorCanvas, thing, thing2);
        this.animatorCanvas.things.addElement(connectorLine);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return connectorLine.hashCode();
    }

    public synchronized int addConnectorSpring(int n, int n2) {
        Thing thing = this.animatorCanvas.getThing(n);
        Thing thing2 = this.animatorCanvas.getThing(n2);
        ConnectorSpring connectorSpring = new ConnectorSpring(this.animatorCanvas, thing, thing2);
        this.animatorCanvas.things.addElement(connectorSpring);
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return connectorSpring.hashCode();
    }

    public synchronized boolean swapZOrder(int n, int n2) {
        return this.animatorCanvas.swapZOrder(n, n2);
    }

    public synchronized void deleteObject(int n) {
        this.animatorCanvas.deleteObject(n);
    }

    public int addBox(int n, int n2, String string, String string2) {
        return this.animatorCanvas.addBox(n, n2, string, string2);
    }

    public int addRectangle(int n, int n2, String string, String string2) {
        return this.animatorCanvas.addRectangle(n, n2, string, string2);
    }

    public int addParametricCurve(int n, double d, double d2, String string, String string2) {
        return this.animatorCanvas.addParametricCurve(n, d, d2, string, string2);
    }

    public int addPolyShape(int n, String string, String string2, String string3, String string4) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ; / \\ ( { [ ) } ] \t \n \r");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() != n || stringTokenizer.countTokens() != n) {
            return 0;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Format.atoi((String)stringTokenizer.nextToken());
            nArray2[n2] = Format.atoi((String)stringTokenizer2.nextToken());
            ++n2;
        }
        return this.animatorCanvas.addPolyShape(n, nArray, nArray2, string3, string4);
    }

    public int addRelPolyShape(int n, String string, String string2, String string3, String string4) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ; / \\ ( { [ ) } ] \t \n \r");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() != n || stringTokenizer.countTokens() != n) {
            return 0;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Format.atoi((String)stringTokenizer.nextToken());
            nArray2[n2] = Format.atoi((String)stringTokenizer2.nextToken());
            ++n2;
        }
        int n3 = 1;
        while (n3 < n) {
            nArray[n3] = nArray[n3 - 1] + nArray[n3];
            nArray2[n3] = nArray2[n3 - 1] + nArray2[n3];
            ++n3;
        }
        return this.animatorCanvas.addPolyShape(n, nArray, nArray2, string3, string4);
    }

    public int addImage(String string, String string2, String string3) {
        Image image;
        int n = 0;
        try {
            image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getCodeBase(), string);
            n = this.animatorCanvas.addImage(image, string2, string3);
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n == 0) {
            try {
                image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getDocumentBase(), string);
                n = this.animatorCanvas.addImage(image, string2, string3);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        if (n == 0) {
            try {
                URL uRL = new URL(string);
                image = ((Applet)((Object)this)).getImage(uRL);
                n = this.animatorCanvas.addImage(image, string2, string3);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        if (n == 0) {
            System.out.println("Failed to load image file.");
        }
        return n;
    }

    public int addImageFromDocumentBase(String string, String string2, String string3) {
        int n = 0;
        try {
            n = this.animatorCanvas.addImage(((Applet)((Object)this)).getImage(((Applet)((Object)this)).getDocumentBase(), string), string2, string3);
        }
        catch (Exception exception) {
            n = 0;
            System.out.println("Failed to load image file from Document Base");
        }
        return n;
    }

    public int addImageFromCodeBase(String string, String string2, String string3) {
        int n = 0;
        try {
            n = this.animatorCanvas.addImage(((Applet)((Object)this)).getImage(((Applet)((Object)this)).getCodeBase(), string), string2, string3);
        }
        catch (Exception exception) {
            n = 0;
            System.out.println("Failed to load image file from Code base!");
        }
        return n;
    }

    public AnimatorCanvas getPhysletCanvas() {
        return this.animatorCanvas;
    }

    public int getEnsembleID() {
        return this.animatorCanvas.hashCode();
    }

    public int getCollisionID() {
        return this.animatorCanvas.getCollisionThing().hashCode();
    }

    public void reverse() {
        this.clock.setDt(-this.clock.getDt());
    }

    public void forward() {
        this.animatorCanvas.setMessage(null);
        this.clock.startClock();
    }

    public void pause() {
        this.animatorCanvas.setMessage(null);
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
    }

    public double getAnimationTime() {
        return this.animatorCanvas.time;
    }

    public double getX(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getX();
    }

    public boolean setX(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setX(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        if (thing == this.animatorCanvas.dragThing) {
            this.animatorCanvas.this_mouseReleased(null);
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setXPos(int n, double d) {
        return this.setX(n, d);
    }

    public double getXPos(int n) {
        return this.getX(n);
    }

    public double getYPos(int n) {
        return this.getY(n);
    }

    public boolean setXY(int n, double d, double d2) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setXY(d, d2);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        if (thing == this.animatorCanvas.dragThing) {
            this.animatorCanvas.this_mouseReleased(null);
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public double getH(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getH();
    }

    public boolean setH(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setH(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        if (thing == this.animatorCanvas.dragThing) {
            this.animatorCanvas.this_mouseReleased(null);
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public double getW(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getW();
    }

    public boolean setW(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setW(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        if (thing == this.animatorCanvas.dragThing) {
            this.animatorCanvas.this_mouseReleased(null);
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public double getY(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getY();
    }

    public boolean setY(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setY(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        if (thing == this.animatorCanvas.dragThing) {
            this.animatorCanvas.this_mouseReleased(null);
        }
        if (this.animatorCanvas.autoRefresh) {
            this.animatorCanvas.repaint();
        }
        return true;
    }

    public boolean setYPos(int n, double d) {
        return this.setY(n, d);
    }

    public double getVX(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getVX();
    }

    public boolean setVX(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVX(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        return true;
    }

    public double getVY(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getVY();
    }

    public boolean setVY(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVY(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        return true;
    }

    public boolean setSpeed(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setSpeed(d);
        this.animatorCanvas.dynamics.resetDynamicsVariables();
        return true;
    }

    public boolean setCharge(int n, double d) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing instanceof Charge) {
            ((Charge)thing).q = d;
            this.animatorCanvas.dynamics.resetDynamicsVariables();
            return true;
        }
        return false;
    }

    public double getFx(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getFx();
    }

    public boolean setReferenceFrame(int n) {
        this.animatorCanvas.clearTrails();
        if (n == 0 || n == this.animatorCanvas.hashCode()) {
            this.animatorCanvas.setReferenceObject(null);
            return true;
        }
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return false;
        }
        this.animatorCanvas.setReferenceObject(thing);
        return true;
    }

    public double getFy(int n) {
        Thing thing = this.animatorCanvas.getThing(n);
        if (thing == null) {
            return 0.0;
        }
        return thing.getFy();
    }

    public String getAppletInfo() {
        return "Animator4 Physlet by W. Christian. Email:wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"FPS", "int", "Frames per sconds"}, {"PixPerUnit", "int", "Pixels for screen unit"}, {"ShowControls", "boolean", "Show the control buttons"}, {"dt", "double", "Animation time step per frame."}};
        return stringArray;
    }

    public static void main(String[] stringArray) {
        Animator animator = new Animator();
        animator.isStandalone = true;
        SFrame sFrame = new SFrame("Animator Physlet");
        sFrame.setTitle("Applet Frame");
        sFrame.add((Component)((Object)animator), "Center");
        animator.init();
        animator.start();
        sFrame.setSize(400, 320);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        sFrame.setLocation((dimension.width - sFrame.getSize().width) / 2, (dimension.height - sFrame.getSize().height) / 2);
        sFrame.setVisible(true);
    }

    void playBtn_actionPerformed(ActionEvent actionEvent) {
        this.forward();
    }

    void pauseBtn_actionPerformed(ActionEvent actionEvent) {
        this.pause();
    }

    void stepForwardBtn_actionPerformed(ActionEvent actionEvent) {
        this.stepForward();
    }

    void stepBackBtn_actionPerformed(ActionEvent actionEvent) {
        this.stepBack();
    }

    void resetBtn_actionPerformed(ActionEvent actionEvent) {
        this.setAnimationTime(0.0);
    }
}

