/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SUtil;
import java.awt.Graphics;

public class ArrowThing
extends Thing {
    private double horz;
    private double vert;
    public int thickness = 1;

    public ArrowThing(SApplet sApplet, SScalable sScalable, int n, double d, double d2, double d3, double d4) {
        super(sScalable, d3, d4);
        this.s = n;
        this.horz = d;
        this.vert = d2;
        this.applet = sApplet;
    }

    protected double getHorz() {
        return this.horz;
    }

    protected double getVert() {
        return this.vert;
    }

    public void setProperties(int n, double d, double d2) {
        if (n == 0 || n == 1) {
            this.setXY(d, d2);
        } else if (n == 2) {
            this.horz = d;
            this.vert = d2;
        } else if (n == 6) {
            this.setX(d);
        } else if (n == 7) {
            this.setY(d2);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.pixFromX(this.x) + this.xDisplayOff;
        int n2 = this.canvas.pixFromY(this.y) - this.yDisplayOff;
        double d = this.canvas.pixFromX(1.0) - this.canvas.pixFromX(0.0);
        double d2 = -this.canvas.pixFromY(1.0) + this.canvas.pixFromY(0.0);
        double d3 = d * this.getHorz();
        double d4 = d2 * this.getVert();
        graphics.setColor(this.color);
        int n3 = (int)((double)n + d3);
        int n4 = (int)((double)n2 - d4);
        graphics.drawLine(n, n2, n3, n4);
        if (Math.abs(d3) < 1.0 && Math.abs(d4) < 1.0) {
            return;
        }
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = d5 > (double)(3 * this.s) ? (double)this.s : d5 / (double)3;
        if (this.thickness > 1) {
            SUtil.drawThickArrow(graphics, n, n2, n3, n4, (int)d6, this.thickness);
            return;
        }
        if (d5 > 1.0) {
            double d7 = d6 * d3 / d5;
            double d8 = -(d6 * d4 / d5);
            double d9 = (double)n3 - (double)3 * d7;
            double d10 = (double)n4 - (double)3 * d8;
            graphics.drawLine((int)(d9 - d8), (int)(d10 + d7), n3, n4);
            graphics.drawLine((int)(d9 + d8), (int)(d10 - d7), n3, n4);
        }
    }

    public void paintHighlight(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = this.canvas.pixFromX(this.x) + this.xDisplayOff;
        int n2 = this.canvas.pixFromY(this.y) - this.yDisplayOff;
        double d = this.canvas.pixFromX(1.0) - this.canvas.pixFromX(0.0);
        double d2 = d * this.horz;
        double d3 = d * this.vert;
        graphics.setColor(this.color);
        int n3 = (int)((double)n + d2);
        int n4 = (int)((double)n2 - d3);
        graphics.drawLine(n, n2, n3, n4);
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d4 > (double)(3 * this.s) ? (double)this.s : d4 / (double)3;
        if (d4 > 1.0) {
            double d6 = d5 * d2 / d4;
            double d7 = -(d5 * d3 / d4);
            double d8 = (double)n3 - (double)3 * d6;
            double d9 = (double)n4 - (double)3 * d7;
            graphics.drawLine((int)(d8 - d7), (int)(d9 + d6), n3, n4);
            graphics.drawLine((int)(d8 + d7), (int)(d9 - d6), n3, n4);
        }
    }

    public final boolean isInsideThing(int n, int n2) {
        int n3 = this.canvas.pixFromX(this.x) + this.xDisplayOff;
        int n4 = this.canvas.pixFromY(this.y) - this.yDisplayOff;
        return Math.abs(n - n3) < 5 && Math.abs(n2 - n4) < 5;
    }
}

