/*
 * Decompiled with CFR 0.152.
 */
package dataGraph;

import edu.davidson.display.ArrowThing;
import edu.davidson.display.BoxThing;
import edu.davidson.display.CaptionThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.ComplexThing;
import edu.davidson.display.GraphThing;
import edu.davidson.display.ImageThing;
import edu.davidson.display.MarkerThing;
import edu.davidson.display.PhaseThing;
import edu.davidson.display.ProtractorThing;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SGraph;
import edu.davidson.display.SGraphFrame;
import edu.davidson.display.SNumber;
import edu.davidson.display.SScalable;
import edu.davidson.display.ShellThing;
import edu.davidson.display.TangentThing;
import edu.davidson.display.TextThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataConnection;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;

public class DataGraph
extends SApplet {
    private String button_clear_data = "Clear";
    private String button_clear_function = "Clear";
    private String button_reset = "Reset";
    private String button_add = "Add";
    private String button_plot = "Plot";
    boolean firstTime = true;
    boolean showControls = true;
    boolean autoX;
    boolean autoY;
    String function;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    String dataFile;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    SGraph graph = new SGraph((SApplet)this);
    Button clearSeriesBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button addDatumBtn = new Button();
    Button addFuncBtn = new Button();
    Button clearFuncBtn = new Button();
    TextField funcField = new TextField();
    SNumber yField = new SNumber();
    SNumber xField = new SNumber();
    BorderLayout borderLayout2 = new BorderLayout();
    Label label1 = new Label();
    Panel border1 = new Panel();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel border2 = new Panel();
    Panel border3 = new Panel();
    Label label2 = new Label();
    Label label3 = new Label();
    BorderLayout borderLayout4 = new BorderLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    Panel panel1 = new Panel();
    Panel panel2 = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    Button button4 = new Button();

    protected void setResources() {
        this.button_clear_data = this.localProperties.getProperty("button.clear_data", this.button_clear_data);
        this.button_clear_function = this.localProperties.getProperty("button.clear_function", this.button_clear_function);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_add = this.localProperties.getProperty("button.add", this.button_add);
        this.button_plot = this.localProperties.getProperty("button.plot", this.button_plot);
    }

    public void init() {
        this.initResources(null);
        try {
            this.function = this.getParameter("Function", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmin = Double.valueOf(this.getParameter("XMin", "-1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.xmax = Double.valueOf(this.getParameter("XMax", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ymin = Double.valueOf(this.getParameter("YMin", "-1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ymax = Double.valueOf(this.getParameter("YMax", "1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dataFile = this.getParameter("DataFile", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoX = Boolean.valueOf(this.getParameter("AutoScaleX", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.autoY = Boolean.valueOf(this.getParameter("AutoScaleY", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.showControls) {
            this.etchedBorder1.setVisible(false);
        }
        if (this.function != null && !this.function.equals("")) {
            this.funcField.setText(this.function);
        }
        this.graph.setEnableMouse(true);
        this.graph.setAutoscaleX(this.autoX);
        this.graph.setAutoscaleY(this.autoY);
        this.graph.setMinMaxX(this.xmin, this.xmax);
        this.graph.setMinMaxY(this.ymin, this.ymax);
        if (this.dataFile != null && !this.dataFile.equals("")) {
            this.graph.loadFile(1, this.dataFile);
        }
    }

    private void jbInit() throws Exception {
        this.etchedBorder1.setLayout(this.borderLayout2);
        this.etchedBorder1.setBackground(Color.lightGray);
        this.graph.setSampleData(false);
        this.graph.setLabelX("x");
        this.graph.setBorders("0,10,15,0");
        this.graph.setLabelY("y");
        this.clearSeriesBtn.setLabel(this.button_clear_data);
        this.etchedBorder3.setLayout(this.borderLayout3);
        this.etchedBorder2.setLayout(this.borderLayout4);
        this.addDatumBtn.setLabel(this.button_add);
        this.addDatumBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addDatumBtn_actionPerformed(actionEvent);
            }
        });
        this.addFuncBtn.setLabel(this.button_plot);
        this.addFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.addFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.addFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.addFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.clearFuncBtn.setLabel(this.button_clear_function);
        this.clearFuncBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.clearFuncBtn_actionPerformed(actionEvent);
            }
        });
        this.funcField.setText("sin(2*pi*x)");
        this.label1.setAlignment(2);
        this.label1.setText("F(x) =");
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.border2.setLayout(this.flowLayout2);
        this.border3.setLayout(this.gridLayout1);
        this.label2.setAlignment(2);
        this.label2.setText("x = ");
        this.label3.setAlignment(2);
        this.label3.setText("y = ");
        this.flowLayout2.setHgap(0);
        this.flowLayout2.setVgap(0);
        this.button4.setLabel(this.button_reset);
        this.button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.button4_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.borderLayout6);
        this.panel2.setLayout(this.borderLayout5);
        this.border1.setLayout(this.flowLayout1);
        this.clearSeriesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataGraph.this.clearSeriesBtn_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        ((Component)((Object)this)).addComponentListener(new ComponentAdapter(){});
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "South");
        this.etchedBorder1.add((Component)this.etchedBorder3, "South");
        this.etchedBorder3.add((Component)this.border1, "East");
        this.border1.add((Component)this.addFuncBtn, null);
        this.border1.add((Component)this.clearFuncBtn, null);
        this.etchedBorder3.add((Component)this.label1, "West");
        this.etchedBorder3.add((Component)this.funcField, "Center");
        this.etchedBorder1.add((Component)this.etchedBorder2, "North");
        this.etchedBorder2.add((Component)this.border3, "Center");
        this.border3.add((Component)this.panel2, null);
        this.panel2.add((Component)this.label2, "West");
        this.panel2.add((Component)this.xField, "Center");
        this.border3.add((Component)this.panel1, null);
        this.panel1.add((Component)this.label3, "West");
        this.panel1.add((Component)this.yField, "Center");
        this.etchedBorder2.add((Component)this.border2, "East");
        this.border2.add((Component)this.addDatumBtn, null);
        this.border2.add((Component)this.clearSeriesBtn, null);
        this.etchedBorder2.add((Component)this.button4, "West");
        ((Container)((Object)this)).add((Component)this.graph, "Center");
    }

    public void destroy() {
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
        this.graph.destroy();
        super.destroy();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.graph.setOwner((SApplet)this);
            if (this.function != null && !this.function.equals("")) {
                this.graph.addFunction(this.function);
            }
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Function", "String", "A function to plot."}, {"XMin", "double", "Minumum X value"}, {"XMax", "double", "Maximum X value"}, {"YMin", "double", "Minimum Y value"}, {"YMax", "double", "Maximum Y value"}, {"AutoScaleX", "boolean", "Autoscale the x axis."}, {"AutoScaleY", "boolean", "Autoscale the y axis."}, {"ShowControls", "boolean", "Show the control buttons at the bottom of the applet."}, {"DataFile", "String", "Data points file"}};
        return stringArray;
    }

    void clearSeriesBtn_actionPerformed(ActionEvent actionEvent) {
        this.clearSeries(1);
    }

    public int getGraphID() {
        return this.graph.hashCode();
    }

    public int getSeriesID(int n) {
        return this.graph.getIDFromSID(n);
    }

    public int getRegressionID(int n, int n2, int n3) {
        return this.graph.getRegressionID(n, n2, n3);
    }

    public void addData(int n, double[] dArray, double[] dArray2) {
        this.graph.addData(n, dArray, dArray2);
    }

    public void addDatum(int n, double d, double d2) {
        this.graph.addDatum(n, d, d2);
    }

    public int addCursor(double d, double d2) {
        return this.graph.addCursor((SApplet)this, 10, d, d2);
    }

    public int addConnectorLine(int n, int n2) {
        return this.graph.addConnectorLine((SApplet)this, n, n2);
    }

    public synchronized int addObject(String string, String string2) {
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        int n = 20;
        int n2 = 20;
        int n3 = 10;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        if (string2 == null) {
            string2 = " ";
        }
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("graph")) {
            object = new GraphThing((SApplet)this, (SScalable)this.graph);
        } else if (string.equals("box")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new BoxThing((SApplet)this, (SScalable)this.graph, d, d2, n, n2);
        } else if (string.equals("rectangle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n2 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new RectangleThing((SApplet)this, (SScalable)this.graph, d, d2, n, n2);
        } else if (string.equals("protractor")) {
            int n4 = 40;
            double d3 = 0.0;
            double d4 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta=")) {
                d3 = SUtil.getParam((String)string2, (String)"theta=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta0=")) {
                d4 = SUtil.getParam((String)string2, (String)"theta0=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            ProtractorThing protractorThing = new ProtractorThing((SApplet)this, (SScalable)this.graph, n4, d3, d4, d, d2);
            if (SUtil.parameterExist((String)string2, (String)"fixedbase")) {
                protractorThing.fixedBase = true;
            }
            if (SUtil.parameterExist((String)string2, (String)"fixedlength")) {
                protractorThing.fixedlength = true;
            }
            object = protractorThing;
        } else if (string.equals("tangent")) {
            double d5 = 20.0;
            double d6 = 20.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                d6 = SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d5 = SUtil.getParam((String)string2, (String)"h=");
            }
            object = new TangentThing((SApplet)this, (SScalable)this.graph, d, d2, d6, d5);
        } else if (string.equals("circle")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new CircleThing((SApplet)this, (SScalable)this.graph, d, d2, n3);
        } else if (string.equals("cursor")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new MarkerThing((SApplet)this, (SScalable)this.graph, 2 * n3 + 1, d, d2);
        } else if (string.equals("shell")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new ShellThing((SApplet)this, (SScalable)this.graph, d, d2, n3);
        } else if (string.equals("phasewheel")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new PhaseThing((SApplet)this, (SScalable)this.graph, d, d2, n3);
        } else if (string.equals("arrow")) {
            double d7 = 1.0;
            double d8 = 1.0;
            int n5 = 4;
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n5 = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                d7 = SUtil.getParam((String)string2, (String)"h=");
            }
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d8 = SUtil.getParam((String)string2, (String)"v=");
            }
            object = new ArrowThing((SApplet)this, (SScalable)this.graph, n5, d7, d8, d, d2);
            if (SUtil.parameterExist((String)string2, (String)"thickness=")) {
                ((ArrowThing)object).thickness = Math.max((int)SUtil.getParam((String)string2, (String)"thickness="), 1);
            }
        } else if (string.equals("text") || string.equals("calculation")) {
            String string4 = "";
            String string5 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string4 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            object = new TextThing((SApplet)this, (SScalable)this.graph, string4, string5, d, d2);
        } else if (string.equals("caption")) {
            String string6 = "";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string6 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string6 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            object = new CaptionThing((SApplet)this, (SScalable)this.graph, string6, d, d2);
        } else if (string.equals("complexdata")) {
            ComplexThing complexThing = new ComplexThing((SApplet)this, (SScalable)this.graph);
            if (SUtil.parameterExist((String)string2, (String)"centered=")) {
                complexThing.setCentered(SUtil.getParamStr((String)string2, (String)"centered=").equals("true"));
            }
            object = complexThing;
        } else {
            if (string.equals("function")) {
                String string7 = "0";
                String string8 = "x";
                if (SUtil.parameterExist((String)string2, (String)"f=")) {
                    string7 = SUtil.getParamStr((String)string2, (String)"f=");
                }
                if (SUtil.parameterExist((String)string2, (String)"var=")) {
                    string8 = SUtil.getParamStr((String)string2, (String)"var=");
                }
                int n6 = this.addFunction(string8, string7);
                if (SUtil.parameterExist((String)string2, (String)"xmin=") && SUtil.parameterExist((String)string2, (String)"xmax=")) {
                    int n7 = 100;
                    n7 = Math.max(this.graph.getSize().width / 2, n7);
                    if (SUtil.parameterExist((String)string2, (String)"n=")) {
                        n7 = (int)SUtil.getParam((String)string2, (String)"n=");
                    }
                    double d9 = SUtil.getParam((String)string2, (String)"xmin=");
                    double d10 = SUtil.getParam((String)string2, (String)"xmax=");
                    this.graph.setFunctionRange(n6, d9, d10, n7);
                }
                if (SUtil.parameterExist((String)string2, (String)"ymin=") && SUtil.parameterExist((String)string2, (String)"ymax=")) {
                    double d11 = SUtil.getParam((String)string2, (String)"ymin=");
                    double d12 = SUtil.getParam((String)string2, (String)"ymax=");
                    this.graph.setFunctionClip(n6, d11, d12);
                }
                return n6;
            }
            if (string.equals("vectorfield")) {
                String string9 = "0";
                String string10 = "0";
                int n8 = 32;
                if (SUtil.parameterExist((String)string2, (String)"fx=")) {
                    string9 = SUtil.getParamStr((String)string2, (String)"fx=");
                }
                if (SUtil.parameterExist((String)string2, (String)"fy=")) {
                    string10 = SUtil.getParamStr((String)string2, (String)"fy=");
                }
                if (SUtil.parameterExist((String)string2, (String)"n=")) {
                    n8 = (int)SUtil.getParam((String)string2, (String)"n=");
                }
                int n9 = this.graph.addVectorField(string9, string10, n8);
                return n9;
            }
            if (string.equals("cfunction")) {
                String string11 = "0";
                String string12 = "0";
                String string13 = "x";
                if (SUtil.parameterExist((String)string2, (String)"re=")) {
                    string11 = SUtil.getParamStr((String)string2, (String)"re=");
                }
                if (SUtil.parameterExist((String)string2, (String)"im=")) {
                    string12 = SUtil.getParamStr((String)string2, (String)"im=");
                }
                if (SUtil.parameterExist((String)string2, (String)"var=")) {
                    string13 = SUtil.getParamStr((String)string2, (String)"var=");
                }
                boolean bl = true;
                if (SUtil.parameterExist((String)string2, (String)"centered=")) {
                    bl = SUtil.getParamStr((String)string2, (String)"centered=").equals("true");
                }
                int n10 = this.graph.addCFunction(string13, string11, string12, bl);
                if (SUtil.parameterExist((String)string2, (String)"xmin=") && SUtil.parameterExist((String)string2, (String)"xmax=")) {
                    int n11 = 100;
                    n11 = Math.max(this.graph.getSize().width / 2, n11);
                    if (SUtil.parameterExist((String)string2, (String)"n=")) {
                        n11 = (int)SUtil.getParam((String)string2, (String)"n=");
                    }
                    double d13 = SUtil.getParam((String)string2, (String)"xmin=");
                    double d14 = SUtil.getParam((String)string2, (String)"xmax=");
                    this.graph.setFunctionRange(n10, d13, d14, 400);
                }
                return n10;
            }
            if (string.equals("image")) {
                String string14 = " ";
                if (SUtil.parameterExist((String)string2, (String)"x=")) {
                    d = SUtil.getParam((String)string2, (String)"x=");
                }
                if (SUtil.parameterExist((String)string2, (String)"y=")) {
                    d2 = SUtil.getParam((String)string2, (String)"y=");
                }
                if (SUtil.parameterExist((String)string2, (String)"gif=")) {
                    string14 = SUtil.getParamStr((String)string2, (String)"gif=");
                }
                if (SUtil.parameterExist((String)string2, (String)"file=")) {
                    string14 = SUtil.getParamStr((String)string2, (String)"file=");
                }
                if (string14 == null) {
                    return 0;
                }
                Image image = this.getImage(string14);
                object = image != null ? new ImageThing((SApplet)this, (SScalable)this.graph, image, d, d2) : null;
            }
        }
        if (object != null && SUtil.parameterExist((String)string2, (String)"label=")) {
            object.setLabel(SUtil.getParamStr((String)string3, (String)"label="));
        }
        if (object == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
            return 0;
        }
        return this.graph.addThing((Thing)object);
    }

    private Image getImage(String string) {
        Serializable serializable;
        Image image;
        try {
            image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getCodeBase(), string);
        }
        catch (Exception exception) {
            image = null;
        }
        if (image == null) {
            try {
                image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getDocumentBase(), string);
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image == null) {
            try {
                serializable = new URL(string);
                image = ((Applet)((Object)this)).getImage((URL)serializable);
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image == null) {
            System.out.println("Failed to load image file.");
            return image;
        }
        serializable = new MediaTracker((Component)((Object)this));
        try {
            ((MediaTracker)serializable).addImage(image, 0);
            ((MediaTracker)serializable).waitForID(0, 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public synchronized boolean set(int n, String string, String string2) {
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        String string4 = "true";
        if (string.equals("scale")) {
            if (SUtil.parameterExist((String)string2, (String)"autoscalex")) {
                if (SUtil.parameterExist((String)string2, (String)"autoscalex=")) {
                    string4 = SUtil.getParamStr((String)string2, (String)"autoscalex=");
                }
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.graph.setAutoscaleX(false);
                } else {
                    this.graph.setAutoscaleX(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"noautoscalex")) {
                this.graph.setAutoscaleX(false);
            }
            if (SUtil.parameterExist((String)string2, (String)"autoscaley")) {
                if (SUtil.parameterExist((String)string2, (String)"autoscaley=")) {
                    string4 = SUtil.getParamStr((String)string2, (String)"autoscaley=");
                }
                if ((string4 = SUtil.removeWhitespace((String)string4.toLowerCase())).equals("false")) {
                    this.graph.setAutoscaleY(false);
                } else {
                    this.graph.setAutoscaleY(true);
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"noautoscaley")) {
                this.graph.setAutoscaleY(false);
            }
            double d = this.graph.getMinX();
            double d2 = this.graph.getMaxX();
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d2 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmin=") || SUtil.parameterExist((String)string2, (String)"xmax=")) {
                this.graph.setMinMaxX(d, d2);
            }
            double d3 = this.graph.getMinY();
            double d4 = this.graph.getMaxY();
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d3 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d4 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=") || SUtil.parameterExist((String)string2, (String)"ymax=")) {
                this.graph.setMinMaxY(d3, d4);
            }
            return true;
        }
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object property not set.  Property name=").append(string).append("Property value=").append(string2))));
            return false;
        }
        return false;
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.graph.getThing(n);
        Thing thing2 = this.graph.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        thing.addSlave(thing2);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
        return true;
    }

    public int addFunction(String string, String string2) {
        if (string2 != null) {
            this.funcField.setText(string2);
        }
        return this.graph.addFunction(string, string2);
    }

    public int addCFunction(String string, String string2, String string3) {
        return this.graph.addCFunction(string, string2, string3, true);
    }

    public void deleteFunction(int n) {
        this.graph.deleteFunction(n);
    }

    public void deleteObject(int n) {
        this.graph.deleteObject(n);
    }

    public void deleteAllFunctions() {
        this.graph.deleteAllFunctions();
    }

    public int createSeries(int n) {
        this.graph.createSeries(n);
        return this.graph.getIDFromSID(n);
    }

    public void deleteSeries(int n) {
        this.graph.deleteSeries(n);
    }

    public void deleteAllSeries() {
        this.graph.deleteAllSeries();
    }

    public void clearSeries(int n) {
        this.graph.clearSeriesData(n);
    }

    public void clearAllSeries() {
        this.graph.clearAllSeries();
    }

    public void updateDataConnections() {
        Enumeration enumeration = this.dataConnections.elements();
        while (enumeration.hasMoreElements()) {
            SDataConnection sDataConnection = (SDataConnection)enumeration.nextElement();
            sDataConnection.clearData();
            sDataConnection.registerDatum();
        }
    }

    public synchronized int makeDataConnection(int n, int n2, int n3, String string, String string2) {
        Thing thing = this.graph.getThing(n);
        if (thing instanceof SStepable) {
            this.clock.addClockListener((SStepable)thing);
            thing.setTime(this.clock.getTime());
        }
        return super.makeDataConnection(n, n2, n3, string, string2);
    }

    public void loadDataFile(int n, String string) {
        this.graph.loadFile(n, string);
    }

    public int plotRegression(int n, int n2, int n3) {
        return this.graph.plotRegression(n, n2, n3);
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        this.graph.setAutoRefresh(bl);
    }

    public void setAddRepeatedDatum(int n, boolean bl) {
        this.graph.setAddRepeatedDatum(n, bl);
    }

    public void setAutoscaleX(boolean bl) {
        this.graph.setAutoscaleX(bl);
    }

    public void setAutoscaleY(boolean bl) {
        this.graph.setAutoscaleY(bl);
    }

    public void setDrawGrid(boolean bl) {
        this.graph.setDrawGrid(bl);
    }

    public void setDrawZero(boolean bl) {
        this.graph.setDrawZero(bl);
    }

    public void setDefault() {
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.graph.setTimeDisplay(false);
        this.clock.removeClockListener((SStepable)this.graph);
        this.graph.deleteAllSeries();
        this.graph.deleteAllFunctions();
        this.graph.clearAllThings();
        this.deleteDataConnections();
    }

    public double getH(int n) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in getH method.");
            return 0.0;
        }
        return thing.getHeight();
    }

    public boolean setH(int n, double d) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in setH method.");
            return false;
        }
        thing.setHeight((int)d);
        return true;
    }

    public double getW(int n) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in getW method.");
            return 0.0;
        }
        return thing.getWidth();
    }

    public boolean setW(int n, double d) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in setW method.");
            return false;
        }
        thing.setWidth((int)d);
        return true;
    }

    public double getX(int n) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in getX method.");
            return 0.0;
        }
        return thing.getX();
    }

    public double getY(int n) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in getY method.");
            return 0.0;
        }
        return thing.getY();
    }

    public double getXPos(int n) {
        return this.getX(n);
    }

    public double getYPos(int n) {
        return this.getY(n);
    }

    public boolean setXY(int n, double d, double d2) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in setX method.");
            return false;
        }
        thing.setXY(d, d2);
        thing.updateMySlaves();
        if (!this.clock.isRunning()) {
            this.updateDataConnections();
        }
        return true;
    }

    public boolean setX(int n, double d) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in setX method.");
            return false;
        }
        thing.setX(d);
        thing.updateMySlaves();
        if (!this.clock.isRunning()) {
            this.updateDataConnections();
        }
        return true;
    }

    public boolean setXPos(int n, double d) {
        return this.setX(n, d);
    }

    public boolean setY(int n, double d) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in setY method.");
            return false;
        }
        thing.setY(d);
        thing.updateMySlaves();
        if (!this.clock.isRunning()) {
            this.updateDataConnections();
        }
        return true;
    }

    public boolean setYPos(int n, double d) {
        return this.setY(n, d);
    }

    public boolean setVisibility(int n, boolean bl) {
        Thing thing = this.graph.getThing(n);
        if (thing != null) {
            thing.setVisible(bl);
            if (this.autoRefresh) {
                this.graph.repaint();
            }
            return true;
        }
        SGraph.MathFunction mathFunction = this.graph.getFunction(n);
        if (mathFunction != null) {
            mathFunction.visible = bl;
            if (this.autoRefresh) {
                this.graph.repaint();
            }
            return true;
        }
        return false;
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
        return true;
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    public boolean setResizable(int n, boolean bl) {
        Thing thing = this.graph.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setResizable(bl);
        return true;
    }

    public int setSketchMode(boolean bl) {
        return this.graph.setSketchMode(bl);
    }

    public void setEnableMouse(boolean bl) {
        this.graph.setEnableMouse(bl);
    }

    public void setFunctionRange(int n, double d, double d2, int n2) {
        this.graph.setFunctionRange(n, d, d2, n2);
    }

    public void setFunctionClip(int n, double d, double d2) {
        this.graph.setFunctionClip(n, d, d2);
    }

    public void setYScaleFromFunction(int n) {
        this.graph.setYScaleFromFunction(n);
    }

    public boolean setFunctionString(int n, String string) {
        if (string != null) {
            this.funcField.setText(string);
        }
        return this.graph.setFunctionString(n, string);
    }

    public synchronized boolean swapZOrder(int n, int n2) {
        return this.graph.swapZOrder(n, n2);
    }

    public String getFunctionString(int n) {
        return this.graph.getFunctionString(n);
    }

    public boolean setFunctionVariable(int n, String string) {
        return this.graph.setFunctionVariable(n, string);
    }

    public synchronized void setGutters(int n, int n2, int n3, int n4) {
        this.graph.setGutters(n, n2, n3, n4);
    }

    public void setFormat(String string) {
        this.graph.setFormat(string);
    }

    public void cloneGraph() {
        SGraphFrame sGraphFrame = new SGraphFrame((SGraph)this.graph.clone());
        sGraphFrame.setSize(((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
        sGraphFrame.show();
    }

    public boolean setFormat(int n, String string) {
        Thing thing = this.graph.getThing(n);
        if (thing == null && (n == 0 || n == this.graph.hashCode())) {
            this.graph.setFormat(string);
            return true;
        }
        boolean bl = thing.setFormat(string);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
        return bl;
    }

    public void setLabelX(String string) {
        this.graph.setLabelX(string);
    }

    public void setLabelY(String string) {
        this.graph.setLabelY(string);
    }

    public void setMarkerSize(int n, double d) {
        this.graph.setMarkerSize(n, d);
    }

    public void setMinMaxX(double d, double d2) {
        this.graph.setMinMaxX(d, d2);
    }

    public void setMinMaxY(double d, double d2) {
        this.graph.setMinMaxY(d, d2);
    }

    public void setMinXRange(boolean bl, double d, double d2) {
        this.graph.setMinXRange(bl, d, d2);
    }

    public void setMinYRange(boolean bl, double d, double d2) {
        this.graph.setMinYRange(bl, d, d2);
    }

    public synchronized void setSeriesLegend(int n, int n2, int n3, String string) {
        this.graph.setSeriesLegend(n, n2, n3, string);
    }

    public synchronized void setSeriesLegendRGB(int n, int n2, int n3, int n4) {
        this.graph.setSeriesLegendColor(n, new Color(n2, n3, n4));
    }

    public synchronized void setSeriesStyle(int n, boolean bl, int n2) {
        this.graph.setSeriesStyle(n, bl, n2);
    }

    public synchronized void setSeriesRGB(int n, int n2, int n3, int n4) {
        this.graph.setSeriesColor(n, new Color(n2, n3, n4));
    }

    public synchronized void setRGB(int n, int n2, int n3, int n4) {
        Color color = new Color(n2, n3, n4);
        this.graph.setObjectColor(n, color);
    }

    public synchronized void setAutoReplaceData(int n, boolean bl) {
        this.graph.setAutoReplaceData(n, bl);
    }

    public synchronized void setLastPointMarker(int n, boolean bl) {
        this.graph.setLastPointMarker(n, bl);
    }

    public void setTitle(String string) {
        this.graph.setTitle(string);
    }

    public void setTimeDisplay(boolean bl) {
        this.graph.setTimeDisplay(bl);
        if (this.autoRefresh) {
            this.graph.repaint();
        }
    }

    public synchronized void setShowAxes(boolean bl) {
        if (this.graph.isShowAxis() == bl) {
            return;
        }
        if (bl) {
            this.graph.setGutters(20, 20, 20, 20);
            this.graph.drawgrid = true;
        } else {
            this.graph.setGutters(0, 0, 0, 0);
            this.graph.drawgrid = false;
        }
        this.graph.setShowAxes(bl);
    }

    public synchronized void setSquare(boolean bl) {
        this.graph.setSquare(bl);
    }

    public synchronized void setSorted(int n, boolean bl) {
        this.graph.setSeriesSorted(n, bl);
    }

    public synchronized void setStripChart(int n, int n2, boolean bl) {
        this.graph.setSeriesStripChart(n, n2, bl);
    }

    public double xFromPix(int n) {
        return this.graph.xFromPix(n);
    }

    public double yFromPix(int n) {
        return this.graph.yFromPix(n);
    }

    public int pixFromX(double d) {
        return this.graph.pixFromX(d);
    }

    public int pixFromY(double d) {
        return this.graph.pixFromY(d);
    }

    void addFuncBtn_actionPerformed(ActionEvent actionEvent) {
        this.graph.deleteAllFunctions();
        this.addFunction("x", this.funcField.getText());
    }

    void addDatumBtn_actionPerformed(ActionEvent actionEvent) {
        this.addDatum(1, this.xField.getValue(), this.yField.getValue());
    }

    void button4_actionPerformed(ActionEvent actionEvent) {
        this.graph.clearAllData();
    }

    void clearFuncBtn_actionPerformed(ActionEvent actionEvent) {
        this.graph.deleteAllFunctions();
    }
}

