/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Charge;
import animator4.Interaction;
import edu.davidson.display.Format;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SUtil;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class Thing
implements SDataSource,
SDataListener {
    static Color darkGreen = new Color(0, 128, 0);
    static Color lightGreen = new Color(128, 255, 128);
    static Color darkBlue = new Color(0, 0, 128);
    static Color lightBlue = new Color(128, 128, 255);
    static Color lightGray = new Color(160, 160, 160);
    Color highlightColor = lightGray;
    double mass = 1.0;
    Format format = new Format("%-+6.3g");
    Font font = new Font("Monospaced", 0, 14);
    AnimatorCanvas canvas;
    int s = 5;
    int w = 5;
    int h = 5;
    Color color = Color.black;
    double[] vars = new double[8];
    double[] initVars = new double[8];
    String[] varStrings = new String[]{"t", "x", "y", "vx", "vy", "ax", "ay", "m", "fx", "fy", "w", "h"};
    double[][] ds = new double[1][12];
    Polygon trail = new Polygon();
    int trailSize = 0;
    int trailOffset = 0;
    int trailCounter = 0;
    String label = null;
    Font f = new Font("Helvetica", 1, 14);
    boolean noDrag = true;
    boolean resizable = false;
    int footPrints = 0;
    boolean paintBeforeGrid = false;
    boolean ghost = false;
    boolean showVVector = false;
    boolean showVComponents = false;
    boolean showAVector = false;
    boolean showAComponents = false;
    boolean showFVector = false;
    boolean showFComponents = false;
    boolean visible = true;
    Thing myMaster = null;
    Vector mySlaves = new Vector();
    int xDisplayOff = 0;
    int yDisplayOff = 0;
    boolean showCoordinates = false;
    int xCoordOff = 0;
    int yCoordOff = 0;
    String xStr;
    String yStr;
    Parser xFunc = null;
    Parser yFunc = null;
    boolean dynamic = false;
    String fxStr;
    String fyStr;
    Parser xForce = null;
    Parser yForce = null;
    Vector interactions = new Vector();
    double x0;
    double y0;
    double vx0;
    double vy0;
    double constraintMin = 0.0;
    double constraintMax = 0.0;
    boolean showConstraintPath = true;
    boolean constrainX = false;
    boolean constrainY = false;
    boolean constrainR = false;
    double constantX = 0.0;
    double constantY = 0.0;
    double constantRx = 0.0;
    double constantRy = 0.0;
    double constantR = 0.0;
    boolean sticky = false;
    boolean bouncy = false;

    void setSticky(boolean bl) {
        this.sticky = bl;
        if (bl) {
            ++this.canvas.stickyCount;
        }
    }

    void setBouncy(boolean bl) {
        this.bouncy = bl;
        if (bl) {
            ++this.canvas.bouncyCount;
        }
    }

    public Thing(AnimatorCanvas animatorCanvas) {
        this.canvas = animatorCanvas;
        this.vars[7] = this.mass;
        this.initVars[7] = this.mass;
    }

    public Thing(AnimatorCanvas animatorCanvas, String string, String string2) {
        this.vars[7] = this.mass;
        this.initVars[7] = this.mass;
        this.canvas = animatorCanvas;
        this.setTrajectory(string, string2);
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SApplet.addDataListener((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getID() {
        return this.hashCode();
    }

    public final boolean isNoDrag() {
        return this.noDrag;
    }

    public final void setNoDrag(boolean bl) {
        this.noDrag = bl;
    }

    public final boolean isResizable() {
        return this.resizable;
    }

    public final void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.canvas.getOwner();
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public boolean isInsideThing(int n, int n2) {
        return false;
    }

    public final int getSize() {
        return this.s;
    }

    public final void setSize(int n) {
        this.s = n;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final void setMass(double d) {
        this.mass = d;
        this.vars[7] = d;
        this.initVars[7] = d;
    }

    public final void setLabel(String string) {
        this.label = string;
    }

    public void setProperties(int n, double d, double d2) {
    }

    public void setXY(double d, double d2) {
        if (this.myMaster != null) {
            this.vars[1] = this.myMaster.vars[1];
            this.vars[2] = this.myMaster.vars[2];
            return;
        }
        if (!this.constrainX) {
            this.vars[1] = d;
        } else {
            this.vars[2] = d2;
        }
        if (!(this.constrainX || this.constrainY || this.constrainR)) {
            this.vars[2] = d2;
            return;
        }
        if (this.constrainR) {
            this.vars[2] = d2;
            this.enforceConstraintOnR();
        } else {
            this.enforceConstraintOnXY();
        }
    }

    void updateDynamics() {
        if (!this.dynamic) {
            return;
        }
        int n = this.canvas.dynamics.dThings.indexOf(this);
        n = 1 + n * 4;
        this.canvas.dynamics.vars[n] = this.vars[1];
        this.canvas.dynamics.vars[n + 1] = this.vars[2];
    }

    public double getH() {
        return this.h;
    }

    public void setH(double d) {
        this.h = (int)d;
    }

    public double getW() {
        return this.w;
    }

    public void setW(double d) {
        this.w = (int)d;
    }

    public double getX() {
        return this.vars[1];
    }

    public final void setX(double d) {
        if (this.myMaster != null) {
            this.vars[1] = this.myMaster.vars[1];
            return;
        }
        this.vars[1] = d;
        if (!(this.constrainX || this.constrainY || this.constrainR)) {
            return;
        }
        this.enforceConstraintOnXY();
    }

    public double getY() {
        return this.vars[2];
    }

    public final void setY(double d) {
        if (this.myMaster != null) {
            this.vars[2] = this.myMaster.vars[2];
            return;
        }
        if (this.constrainY || this.constrainR) {
            return;
        }
        this.vars[2] = d;
    }

    public void setVarsFromMaster() {
        if (this.myMaster == null) {
            return;
        }
        this.vars[0] = this.myMaster.vars[0];
        this.vars[1] = this.myMaster.vars[1];
        this.vars[2] = this.myMaster.vars[2];
        this.vars[3] = this.myMaster.vars[3];
        this.vars[4] = this.myMaster.vars[4];
        this.vars[5] = this.myMaster.vars[5];
        this.vars[6] = this.myMaster.vars[6];
        this.vars[7] = this.myMaster.vars[7];
        this.mass = this.myMaster.mass;
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing == this || thing.myMaster != this) continue;
            thing.setVarsFromMaster();
        }
    }

    void updateMySlaves() {
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setVarsFromMaster();
        }
    }

    void paintMySlaves(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.mySlaves.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
        }
    }

    public double getVX() {
        return this.vars[3];
    }

    public void setVX(double d) {
        if (this.constrainX) {
            return;
        }
        this.vars[3] = d;
    }

    public double getVY() {
        return this.vars[4];
    }

    public void setVY(double d) {
        if (this.constrainY) {
            return;
        }
        this.vars[4] = d;
    }

    public final void setSpeed(double d) {
        if (this.myMaster != null) {
            return;
        }
        if (d <= 0.0) {
            this.vars[3] = 0.0;
            this.vars[4] = 0.0;
            return;
        }
        double d2 = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        if (d2 == 0.0) {
            if (this.constrainX) {
                this.vars[4] = d;
            } else if (this.constrainY) {
                this.vars[3] = d;
            } else if (this.constrainR) {
                double d3 = (this.vars[1] - this.constantRx) / this.constantR;
                double d4 = (this.vars[2] - this.constantRy) / this.constantR;
                this.vars[3] = -d4 * d;
                this.vars[4] = d3 * d;
            } else {
                this.vars[3] = d;
                this.vars[4] = 0.0;
            }
        } else {
            this.vars[3] = this.vars[3] * d / d2;
            this.vars[4] = this.vars[4] * d / d2;
        }
        this.canvas.dynamics.resetDynamicsVariables();
    }

    public final void constrainedRForce(int n, double[] dArray) {
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        double d2 = this.constantR;
        double d3 = (this.vars[1] - this.constantRx) / d2;
        double d4 = (this.vars[2] - this.constantRy) / d2;
        double d5 = this.getFx() / this.mass;
        double d6 = this.getFy() / this.mass;
        double d7 = -d5 * d4 + d6 * d3;
        double d8 = -d * d / this.constantR;
        dArray[n + 2] = -d7 * d4 + d8 * d3;
        dArray[n + 3] = d7 * d3 + d8 * d4;
    }

    public final double getTotalFx() {
        if (!this.constrainR) {
            return this.getFx();
        }
        if (this.constantR == 0.0) {
            return 0.0;
        }
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        double d2 = (this.vars[1] - this.constantRx) / this.constantR;
        double d3 = (this.vars[2] - this.constantRy) / this.constantR;
        double d4 = this.getFx();
        double d5 = this.getFy();
        double d6 = -d4 * d3 + d5 * d2;
        double d7 = -this.mass * d * d / this.constantR;
        return -d6 * d3 + d7 * d2;
    }

    public final double getTotalFy() {
        if (!this.constrainR) {
            return this.getFy();
        }
        if (this.constantR == 0.0) {
            return 0.0;
        }
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        double d2 = (this.vars[1] - this.constantRx) / this.constantR;
        double d3 = (this.vars[2] - this.constantRy) / this.constantR;
        double d4 = this.getFx();
        double d5 = this.getFy();
        double d6 = -d4 * d3 + d5 * d2;
        double d7 = -this.mass * d * d / this.constantR;
        return d6 * d2 + d7 * d3;
    }

    public final double getFx() {
        if (this.constrainX) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.interactions.size(); ++i) {
            Interaction interaction = (Interaction)this.interactions.elementAt(i);
            d += interaction.getF()[0];
        }
        if (this instanceof Charge) {
            d += this.getCoulombFx((Charge)this);
        }
        if (this.xForce == null) {
            return d;
        }
        return this.xForce.evaluate(this.vars) + d;
    }

    double getCoulombFx(Charge charge) {
        Thing thing = null;
        Charge charge2 = null;
        double d = 0.0;
        Enumeration enumeration = this.canvas.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof Charge) || thing == charge) continue;
            charge2 = (Charge)thing;
            double d2 = charge.vars[1] - charge2.vars[1];
            double d3 = charge.vars[2] - charge2.vars[2];
            double d4 = d2 * d2 + d3 * d3;
            double d5 = Math.sqrt(d4);
            if (d5 > charge2.range + charge.range) {
                d += charge.q * charge2.q * d2 / d4 / d5;
                continue;
            }
            d += charge.q * charge2.q * d2;
        }
        return d;
    }

    double getCoulombFy(Charge charge) {
        Thing thing = null;
        Charge charge2 = null;
        double d = 0.0;
        Enumeration enumeration = this.canvas.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof Charge) || thing == charge) continue;
            charge2 = (Charge)thing;
            double d2 = charge.vars[1] - charge2.vars[1];
            double d3 = charge.vars[2] - charge2.vars[2];
            double d4 = d2 * d2 + d3 * d3;
            double d5 = Math.sqrt(d4);
            if (d5 > charge2.range + charge.range) {
                d += charge.q * charge2.q * d3 / d4 / d5;
                continue;
            }
            d = charge.q * charge2.q * d3;
        }
        return d;
    }

    public final double getFy() {
        if (this.constrainY) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.interactions.size(); ++i) {
            Interaction interaction = (Interaction)this.interactions.elementAt(i);
            d += interaction.getF()[1];
        }
        if (this instanceof Charge) {
            d += this.getCoulombFy((Charge)this);
        }
        if (this.yForce == null) {
            return d;
        }
        return this.yForce.evaluate(this.vars) + d;
    }

    boolean addInteraction(Thing thing, String string, int n) {
        Interaction interaction = new Interaction(this, thing, string, n);
        if (interaction.force == null) {
            return false;
        }
        this.interactions.addElement(interaction);
        this.vars[5] = this.getFx() / this.mass;
        this.vars[6] = this.getFy() / this.mass;
        return true;
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        this.ds[0][3] = this.vars[3];
        this.ds[0][4] = this.vars[4];
        this.ds[0][5] = this.vars[5];
        this.ds[0][6] = this.vars[6];
        this.ds[0][7] = this.mass;
        if (this.myMaster == null) {
            this.ds[0][8] = this.getTotalFx();
            this.ds[0][9] = this.getTotalFy();
        } else {
            this.ds[0][8] = this.myMaster.getTotalFx();
            this.ds[0][9] = this.myMaster.getTotalFy();
        }
        this.ds[0][10] = this.w;
        this.ds[0][11] = this.h;
        return this.ds;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.showConstraintPath) {
            graphics.setColor(SUtil.paleColor((Color)this.color));
            if (this.constrainX) {
                this.paintConstraintX(graphics);
            }
            if (this.constrainY) {
                this.paintConstraintY(graphics);
            }
            if (this.constrainR) {
                this.paintConstraintR(graphics);
            }
        }
        int n3 = this.canvas.pixFromX(this.vars[1]);
        int n4 = this.canvas.pixFromY(this.vars[2]);
        if (this.showVComponents) {
            graphics.setColor(lightGreen);
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[3]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[4]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        if (this.showVVector) {
            graphics.setColor(darkGreen);
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[3]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[4]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        if (this.showFComponents) {
            graphics.setColor(lightBlue);
            n2 = this.canvas.pixFromX(this.vars[1] + this.getTotalFx());
            n = this.canvas.pixFromY(this.vars[2] + this.getTotalFy());
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        if (this.showFVector) {
            graphics.setColor(darkBlue);
            n2 = this.canvas.pixFromX(this.vars[1] + this.getTotalFx());
            n = this.canvas.pixFromY(this.vars[2] + this.getTotalFy());
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        if (this.showAComponents) {
            graphics.setColor(lightBlue);
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[5]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[6]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        if (this.showAVector) {
            graphics.setColor(darkBlue);
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[5]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[6]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        graphics.setColor(Color.black);
    }

    public void paintHighlight(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.canvas.pixFromX(this.vars[1]);
        int n4 = this.canvas.pixFromY(this.vars[2]);
        graphics.setColor(this.highlightColor);
        if (this.showVComponents) {
            graphics.setColor(lightGreen);
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[3]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[4]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        if (this.showVVector) {
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[3]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[4]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        if (this.showFComponents) {
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[5] * this.mass);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[6] * this.mass);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        if (this.showFVector) {
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[5] * this.mass);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[6] * this.mass);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        if (this.showAComponents) {
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[5]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[6]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n4);
            SUtil.drawArrow((Graphics)graphics, (int)n2, (int)n4, (int)n2, (int)n);
        }
        if (this.showAVector) {
            n2 = this.canvas.pixFromX(this.vars[1] + this.vars[5]);
            n = this.canvas.pixFromY(this.vars[2] + this.vars[6]);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n4, (int)n2, (int)n);
        }
        graphics.setColor(Color.black);
    }

    public void paintCoordinates(Graphics graphics, int n, int n2) {
        String string = this.format.form(SUtil.chop((double)this.vars[1], (double)1.0E-12));
        String string2 = this.format.form(SUtil.chop((double)this.vars[2], (double)1.0E-12));
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        graphics.drawString("x:".concat(String.valueOf(String.valueOf(string))), n + this.xCoordOff, n2 - 3 - this.yCoordOff);
        graphics.drawString("y:".concat(String.valueOf(String.valueOf(string2))), n + this.xCoordOff, n2 + 12 - this.yCoordOff);
        graphics.setFont(font);
    }

    public final void paintTrail(Graphics graphics) {
        graphics.setColor(this.color);
        if (this.trailSize > 1 && this.trail.npoints > 1) {
            if (this.footPrints == 0) {
                graphics.drawPolyline(this.trail.xpoints, this.trail.ypoints, this.trail.npoints);
            } else {
                for (int i = 0; i < this.trail.npoints; i += this.footPrints) {
                    graphics.drawLine(this.trail.xpoints[i] - 2, this.trail.ypoints[i], this.trail.xpoints[i] + 2, this.trail.ypoints[i]);
                    graphics.drawLine(this.trail.xpoints[i], this.trail.ypoints[i] - 2, this.trail.xpoints[i], this.trail.ypoints[i] + 2);
                }
            }
        }
    }

    public void paintLabel(Graphics graphics, int n, int n2) {
        if (this.label == null) {
            return;
        }
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n3 = fontMetrics.stringWidth(this.label) / 2;
        int n4 = fontMetrics.getHeight() / 2;
        graphics.drawString(this.label, n + n3, n2 + n4);
        graphics.setFont(font);
    }

    public void paintGhosts(Graphics graphics) {
        if (this.ghost && this.footPrints > 0 && this.trailSize > 1 && this.trail.npoints > 1) {
            graphics.setColor(SUtil.veryPaleColor((Color)this.color));
            for (int i = 0; i < this.trail.npoints; i += this.footPrints) {
                graphics.fillOval(this.trail.xpoints[i] - this.s, this.trail.ypoints[i] - this.s, 2 * this.s, 2 * this.s);
            }
        }
    }

    public final double getTime() {
        return this.vars[0];
    }

    public final double getMass() {
        return this.mass;
    }

    public final void setTrailSize(int n) {
        this.trailSize = n;
        this.clearTrail();
    }

    public final void setTrailSize(int n, int n2) {
        this.trailSize = n;
        this.trailOffset = n2;
        this.clearTrail();
    }

    public void clearTrail() {
        this.trailCounter = 0;
        if (this.trail == null || this.trail.npoints != 0) {
            this.trail = new Polygon();
        }
        if (this.canvas.osi != null) {
            this.incTrail();
        }
    }

    public final void incTrail() {
        if (this.trail == null || this.trailSize < 1) {
            return;
        }
        if (this.trailCounter < this.trailOffset) {
            ++this.trailCounter;
            return;
        }
        ++this.trailCounter;
        int n = 0;
        int n2 = 0;
        if (this.canvas.getReferenceObject() != null) {
            n = this.canvas.pixFromX(this.vars[1] - this.canvas.getReferenceObject().getX());
            n2 = this.canvas.pixFromY(this.vars[2] - this.canvas.getReferenceObject().getY());
        } else {
            n = this.canvas.pixFromX(this.vars[1]);
            n2 = this.canvas.pixFromY(this.vars[2]);
        }
        if (this.trail.npoints < this.trailSize) {
            this.trail.addPoint(n, n2);
        } else {
            System.arraycopy(this.trail.xpoints, 1, this.trail.xpoints, 0, this.trailSize - 1);
            System.arraycopy(this.trail.ypoints, 1, this.trail.ypoints, 0, this.trailSize - 1);
            this.trail.xpoints[this.trailSize - 1] = n;
            this.trail.ypoints[this.trailSize - 1] = n2;
        }
    }

    public void setTime(double d, double d2) {
        if (this.dynamic) {
            this.vars[0] = d;
            this.vars[1] = this.x0;
            this.vars[2] = this.y0;
            this.vars[3] = this.vx0;
            this.vars[4] = this.vy0;
            if (this.xForce != null) {
                this.vars[5] = this.xForce.evaluate(new double[]{this.vars[0], this.x0, this.y0, this.vx0, this.vy0});
            }
            if (this.yForce != null) {
                this.vars[6] = this.yForce.evaluate(new double[]{this.vars[0], this.x0, this.y0, this.vx0, this.vy0});
            }
        } else {
            this.setVars(d, d2);
        }
        this.clearTrail();
    }

    void setVars(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        this.vars[0] = d;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        this.vars[7] = this.mass;
        if (this.xFunc == null || this.yFunc == null) {
            return;
        }
        try {
            d3 = this.xFunc.evaluate(d - (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d8 = this.yFunc.evaluate(d - (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d4 = this.xFunc.evaluate(d - d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d9 = this.yFunc.evaluate(d - d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d5 = this.xFunc.evaluate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d10 = this.yFunc.evaluate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d6 = this.xFunc.evaluate(d + d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d11 = this.yFunc.evaluate(d + d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d7 = this.xFunc.evaluate(d + (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d12 = this.yFunc.evaluate(d + (double)2 * d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vars[1] = d5;
        this.vars[2] = d10;
        this.vars[3] = (d6 - d4) / d2 / (double)2;
        this.vars[4] = (d11 - d9) / d2 / (double)2;
        this.vars[5] = (-d7 + (double)16 * d6 - (double)30 * d5 + (double)16 * d4 - d3) / d2 / d2 / (double)12;
        this.vars[6] = (-d12 + (double)16 * d11 - (double)30 * d10 + (double)16 * d9 - d8) / d2 / d2 / (double)12;
    }

    public boolean hasTrajectory() {
        return this.xFunc != null && this.yFunc != null;
    }

    public boolean setTrajectory(String string, String string2) {
        this.dynamic = false;
        this.xForce = null;
        this.yForce = null;
        if (this.interactions != null) {
            this.interactions.removeAllElements();
        }
        this.vars[0] = this.canvas == null ? 0.0 : this.canvas.time;
        this.vars[1] = 0.0;
        this.vars[2] = 0.0;
        this.vars[3] = 0.0;
        this.vars[4] = 0.0;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        this.vars[7] = this.mass;
        if (string == null || string2 == null) {
            this.xStr = string;
            this.yStr = string2;
            this.xFunc = null;
            this.yFunc = null;
            return true;
        }
        this.xStr = string;
        this.yStr = string2;
        this.xFunc = new Parser(1);
        this.xFunc.defineVariable(1, "t");
        this.xFunc.define(string);
        this.xFunc.parse();
        if (this.xFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse trajectory x(t): ".concat(String.valueOf(String.valueOf(string))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.xFunc.getErrorString()).append(" at function 1, position ").append(this.xFunc.getErrorPosition()))));
            return false;
        }
        this.yFunc = new Parser(1);
        this.yFunc.defineVariable(1, "t");
        this.yFunc.define(string2);
        this.yFunc.parse();
        if (this.yFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse trajectory y(t): ".concat(String.valueOf(String.valueOf(string2))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.yFunc.getErrorString()).append(" at function 1, position ").append(this.yFunc.getErrorPosition()))));
            return false;
        }
        this.setTime(this.vars[0], 0.001);
        if (this.canvas != null && this.canvas.autoRefresh) {
            this.canvas.repaint();
        }
        return true;
    }

    public boolean setForce(String string, String string2, double d, double d2, double d3, double d4) {
        this.x0 = d;
        this.y0 = d2;
        this.vx0 = d3;
        this.vy0 = d4;
        this.vars[0] = this.canvas == null ? 0.0 : this.canvas.time;
        this.vars[1] = d;
        this.vars[2] = d2;
        this.vars[3] = d3;
        this.vars[4] = d4;
        this.vars[5] = 0.0;
        this.vars[6] = 0.0;
        this.vars[7] = this.mass;
        if (string == null || string2 == null) {
            this.fxStr = string;
            this.fyStr = string2;
            this.xForce = null;
            this.yForce = null;
            return true;
        }
        this.fxStr = string;
        this.fyStr = string2;
        this.xForce = new Parser(8);
        this.xForce.defineVariable(1, "t");
        this.xForce.defineVariable(2, "x");
        this.xForce.defineVariable(3, "y");
        this.xForce.defineVariable(4, "vx");
        this.xForce.defineVariable(5, "vy");
        this.xForce.defineVariable(6, "ax");
        this.xForce.defineVariable(7, "ay");
        this.xForce.defineVariable(8, "m");
        this.xForce.define(string);
        this.xForce.parse();
        if (this.xForce.getErrorCode() != 0) {
            System.out.println("Failed to parse force fx(t,x,y,vx,vy): ".concat(String.valueOf(String.valueOf(string))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.xForce.getErrorString()).append(" at function 1, position ").append(this.xForce.getErrorPosition()))));
            return false;
        }
        this.yForce = new Parser(8);
        this.yForce.defineVariable(1, "t");
        this.yForce.defineVariable(2, "x");
        this.yForce.defineVariable(3, "y");
        this.yForce.defineVariable(4, "vx");
        this.yForce.defineVariable(5, "vy");
        this.yForce.defineVariable(6, "ax");
        this.yForce.defineVariable(7, "ay");
        this.yForce.defineVariable(8, "m");
        this.yForce.define(string2);
        this.yForce.parse();
        if (this.yForce.getErrorCode() != 0) {
            System.out.println("Failed to parse trajectory fy(t,x,y,vx,vy): ".concat(String.valueOf(String.valueOf(string2))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.yForce.getErrorString()).append(" at function 1, position ").append(this.yForce.getErrorPosition()))));
            return false;
        }
        this.vars[1] = d;
        this.vars[2] = d2;
        this.vars[3] = d3;
        this.vars[4] = d4;
        this.vars[5] = this.xForce.evaluate(new double[]{this.vars[0], d, d2, d3, d4});
        this.vars[6] = this.yForce.evaluate(new double[]{this.vars[0], d, d2, d3, d4});
        this.clearTrail();
        this.dynamic = true;
        Thing thing = null;
        if (this.canvas != null) {
            Enumeration enumeration = this.canvas.things.elements();
            while (enumeration.hasMoreElements()) {
                thing = (Thing)enumeration.nextElement();
                if (thing == this || thing.myMaster != this) continue;
                thing.setVarsFromMaster();
            }
        }
        if (this.canvas != null && this.canvas.autoRefresh) {
            this.canvas.repaint();
        }
        return true;
    }

    final void enforceConstraintOnR() {
        double d = Math.sqrt(this.vars[3] * this.vars[3] + this.vars[4] * this.vars[4]);
        double d2 = Math.sqrt((this.vars[1] - this.constantRx) * (this.vars[1] - this.constantRx) + (this.vars[2] - this.constantRy) * (this.vars[2] - this.constantRy));
        if (d2 == 0.0) {
            this.vars[1] = this.constantRx + this.constantR;
            this.vars[2] = this.constantRy;
            this.vars[3] = 0.0;
            this.vars[4] = d;
            return;
        }
        double d3 = (this.vars[1] - this.constantRx) / d2;
        double d4 = (this.vars[2] - this.constantRy) / d2;
        this.vars[1] = this.constantRx + this.constantR * d3;
        this.vars[2] = this.constantRy + this.constantR * d4;
        if (-this.vars[3] * d4 + this.vars[4] * d3 > 0.0) {
            this.vars[3] = -d * d4;
            this.vars[4] = d * d3;
        } else {
            this.vars[3] = d * d4;
            this.vars[4] = -d * d3;
        }
    }

    private final void enforceConstraintOnX() {
        this.vars[3] = 0.0;
        if (this.constraintMin < this.constraintMax) {
            if (this.vars[2] < this.constraintMin) {
                this.vars[2] = this.constraintMin;
                if (this.vars[4] < 0.0) {
                    this.vars[4] = -this.vars[4];
                }
            } else if (this.vars[2] > this.constraintMax) {
                this.vars[2] = this.constraintMax;
                if (this.vars[4] > 0.0) {
                    this.vars[4] = -this.vars[4];
                }
            }
        }
        this.vars[1] = this.constantX;
    }

    private final void enforceConstraintOnY() {
        this.vars[4] = 0.0;
        if (this.constraintMin < this.constraintMax) {
            if (this.vars[1] < this.constraintMin) {
                this.vars[1] = this.constraintMin;
                if (this.vars[3] < 0.0) {
                    this.vars[3] = -this.vars[3];
                }
            } else if (this.vars[1] > this.constraintMax) {
                this.vars[1] = this.constraintMax;
                if (this.vars[3] > 0.0) {
                    this.vars[3] = -this.vars[3];
                }
            }
        }
        this.vars[2] = this.constantY;
    }

    final boolean enforceConstraintOnXY() {
        if (this.constrainX) {
            this.enforceConstraintOnX();
            return true;
        }
        if (this.constrainY) {
            this.enforceConstraintOnY();
            return true;
        }
        if (this.constrainR) {
            this.enforceConstraintOnR();
            return true;
        }
        return false;
    }

    public boolean setConstrainR(double d, double d2, double d3) {
        this.constrainX = false;
        this.constrainY = false;
        this.constrainR = true;
        this.constantRx = d2;
        this.constantRy = d3;
        this.constantR = d;
        this.enforceConstraintOnXY();
        if (this.canvas.autoRefresh) {
            this.canvas.repaint();
        }
        return true;
    }

    public boolean setConstrainX(double d, double d2, double d3) {
        this.constrainX = true;
        this.constrainY = false;
        this.constrainR = false;
        this.constraintMin = d2;
        this.constraintMax = d3;
        this.constantX = d;
        this.enforceConstraintOnXY();
        if (this.canvas.autoRefresh) {
            this.canvas.repaint();
        }
        return true;
    }

    public boolean setConstrainY(double d, double d2, double d3) {
        this.constrainX = false;
        this.constrainY = true;
        this.constrainR = false;
        this.constraintMin = d2;
        this.constraintMax = d3;
        this.constantY = d;
        this.enforceConstraintOnXY();
        if (this.canvas.autoRefresh) {
            this.canvas.repaint();
        }
        return true;
    }

    void paintConstraintX(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle = this.canvas.getBounds();
        int n3 = this.canvas.pixFromX(this.constantX);
        if (this.constraintMin < this.constraintMax) {
            n2 = this.canvas.pixFromY(this.constraintMin);
            n = this.canvas.pixFromY(this.constraintMax);
        } else {
            n = rectangle.y;
            n2 = rectangle.y + rectangle.height - 1;
        }
        graphics.drawLine(n3, n, n3, n2);
    }

    void paintConstraintY(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle = this.canvas.getBounds();
        int n3 = this.canvas.pixFromY(this.constantY);
        if (this.constraintMin < this.constraintMax) {
            n2 = this.canvas.pixFromX(this.constraintMin);
            n = this.canvas.pixFromX(this.constraintMax);
        } else {
            n2 = rectangle.x;
            n = rectangle.x + rectangle.width - 1;
        }
        graphics.drawLine(n2, n3, n, n3);
    }

    void paintConstraintR(Graphics graphics) {
        int n = this.canvas.pixFromX(this.constantRx);
        int n2 = this.canvas.pixFromY(this.constantRy);
        int n3 = this.canvas.pixFromX(this.constantRx + this.constantR) - n;
        n = n - n3 + this.xDisplayOff;
        n2 = n2 - n3 - this.yDisplayOff;
        graphics.drawOval(n, n2, 2 * n3 + 1, 2 * n3 + 1);
    }

    public void clearSeries(int n) {
    }

    public void deleteSeries(int n) {
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        if (this.canvas.owner.debugLevel > 127) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Animator.addDatum sid=").append(n).append("  x=").append(d).append("  y=").append(d2))));
        }
        if (n > 2) {
            this.setProperties(n, d, d2);
        } else if (n == 2) {
            this.setW(d);
            this.setH(d2);
        } else {
            this.setXY(d, d2);
        }
        this.updateDynamics();
        this.updateMySlaves();
        if (this.canvas instanceof Canvas) {
            this.canvas.repaint();
        }
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        int n2 = dArray.length - 1;
        if (this.canvas.owner.debugLevel > 127) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Animator.addDatum sid=").append(n).append("  x=").append(dArray[n2]).append("  y=").append(dArray2[n2]))));
        }
        if (n > 2) {
            this.setProperties(n, dArray[n2], dArray2[n2]);
        } else if (n == 2) {
            this.setW(dArray[n2]);
            this.setH(dArray2[n2]);
        } else {
            this.setXY(dArray[n2], dArray2[n2]);
        }
        this.updateDynamics();
        this.updateMySlaves();
        if (this.canvas instanceof Canvas) {
            this.canvas.repaint();
        }
    }
}

