/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import java.io.PrintStream;

public class Format {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leading_zeroes = false;
    private boolean show_plus = false;
    private boolean alternate = false;
    private boolean show_space = false;
    private boolean left_align = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == '%') {
                if (n3 >= n - 1) throw new IllegalArgumentException();
                if (string.charAt(n3 + 1) == '%') {
                    this.pre = String.valueOf(String.valueOf(this.pre)).concat(String.valueOf(String.valueOf('%')));
                    ++n3;
                } else {
                    n2 = 1;
                }
            } else {
                this.pre = String.valueOf(String.valueOf(this.pre)).concat(String.valueOf(String.valueOf(string.charAt(n3))));
            }
            ++n3;
        }
        while (n2 == 1) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == ' ') {
                this.show_space = true;
            } else if (string.charAt(n3) == '-') {
                this.left_align = true;
            } else if (string.charAt(n3) == '+') {
                this.show_plus = true;
            } else if (string.charAt(n3) == '0') {
                this.leading_zeroes = true;
            } else if (string.charAt(n3) == '#') {
                this.alternate = true;
            } else {
                n2 = 2;
                --n3;
            }
            ++n3;
        }
        while (n2 == 2) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.width = this.width * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            if (string.charAt(n3) == '.') {
                n2 = 3;
                this.precision = 0;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        while (n2 == 3) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.precision = this.precision * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        if (n2 == 4) {
            if (n3 >= n) {
                n2 = 5;
            } else {
                this.fmt = string.charAt(n3);
            }
            ++n3;
        }
        if (n3 >= n) return;
        this.post = string.substring(n3, n);
    }

    public static void print(PrintStream printStream, String string, double d) {
        printStream.print(new Format(string).form(d));
    }

    public static void print(PrintStream printStream, String string, long l) {
        printStream.print(new Format(string).form(l));
    }

    public static void print(PrintStream printStream, String string, char c) {
        printStream.print(new Format(string).form(c));
    }

    public static void print(PrintStream printStream, String string, String string2) {
        printStream.print(new Format(string).form(string2));
    }

    public static int atoi(String string) {
        return (int)Format.atol(string);
    }

    public static long atol(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < string.length() && string.charAt(n) == '0') {
            if (n + 1 < string.length() && (string.charAt(n + 1) == 'x' || string.charAt(n + 1) == 'X')) {
                return Format.parseLong(string.substring(n + 2), 16);
            }
            return Format.parseLong(string, 8);
        }
        return Format.parseLong(string, 10);
    }

    private static long parseLong(String string, int n) {
        int n2;
        int n3 = 1;
        long l = 0L;
        for (n2 = 0; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 < string.length() && string.charAt(n2) == '-') {
            n3 = -1;
            ++n2;
        } else if (n2 < string.length() && string.charAt(n2) == '+') {
            ++n2;
        }
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if ('0' <= c && c < 48 + n) {
                l = l * (long)n + (long)c - (long)48;
            } else if ('A' <= c && c < 65 + n - 10) {
                l = l * (long)n + (long)c - (long)65 + (long)10;
            } else if ('a' <= c && c < 97 + n - 10) {
                l = l * (long)n + (long)c - (long)97 + (long)10;
            } else {
                return l * (long)n3;
            }
            ++n2;
        }
        return l * (long)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String string) {
        int n;
        int n2 = 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        boolean bl = false;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < string.length() && string.charAt(n) == '-') {
            n2 = -1;
            ++n;
        } else if (n < string.length() && string.charAt(n) == '+') {
            ++n;
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('0' <= c && c <= '9') {
                if (!bl) {
                    d = d * (double)10 + (double)c - (double)48;
                } else if (bl) {
                    d += (d3 /= (double)10) * (double)(c - 48);
                }
            } else if (c == '.') {
                if (bl) return (double)n2 * d;
                bl = true;
            } else {
                if (c != 'e' && c != 'E') return (double)n2 * d;
                long l = (int)Format.parseLong(string.substring(n + 1), 10);
                return (double)n2 * d * Math.pow(10.0, l);
            }
            ++n;
        }
        return (double)n2 * d;
    }

    public String form(double d) {
        String string;
        if (this.fmt == 'i' || this.fmt == 'd') {
            return this.form((int)d);
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return "NaN";
        }
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d < 0.0) {
            d = -d;
            n = -1;
        }
        if (this.fmt == 'f') {
            string = this.fixed_format(d);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            string = this.exp_format(d);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    public String form(long l) {
        String string;
        int n = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (l < (long)0) {
                string = "".concat(String.valueOf(String.valueOf(l))).substring(1);
                n = -1;
            } else {
                string = "".concat(String.valueOf(String.valueOf(l)));
                n = 1;
            }
        } else if (this.fmt == 'o') {
            string = Format.convert(l, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            string = Format.convert(l, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            string = Format.convert(l, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String string = "".concat(String.valueOf(String.valueOf(c)));
        return this.pad(string);
    }

    public String form(String string) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            string = string.substring(0, this.precision);
        }
        return this.pad(string);
    }

    public static void main(String[] stringArray) {
        double d = 1.23456789012;
        double d2 = 123.0;
        double d3 = 1.2345E30;
        double d4 = 1.02;
        double d5 = 1.234E-5;
        int n = 51966;
        Format.print(System.out, "x = |%f|\n", d);
        Format.print(System.out, "u = |%20f|\n", d5);
        Format.print(System.out, "x = |% .5f|\n", d);
        Format.print(System.out, "w = |%20.5f|\n", d4);
        Format.print(System.out, "x = |%020.5f|\n", d);
        Format.print(System.out, "x = |%+20.5f|\n", d);
        Format.print(System.out, "x = |%+020.5f|\n", d);
        Format.print(System.out, "x = |% 020.5f|\n", d);
        Format.print(System.out, "y = |%#+20.5f|\n", d2);
        Format.print(System.out, "y = |%-+20.5f|\n", d2);
        Format.print(System.out, "z = |%20.5f|\n", d3);
        Format.print(System.out, "x = |%e|\n", d);
        Format.print(System.out, "u = |%20e|\n", d5);
        Format.print(System.out, "x = |% .5e|\n", d);
        Format.print(System.out, "w = |%20.5e|\n", d4);
        Format.print(System.out, "x = |%020.5e|\n", d);
        Format.print(System.out, "x = |%+20.5e|\n", d);
        Format.print(System.out, "x = |%+020.5e|\n", d);
        Format.print(System.out, "x = |% 020.5e|\n", d);
        Format.print(System.out, "y = |%#+20.5e|\n", d2);
        Format.print(System.out, "y = |%-+20.5e|\n", d2);
        Format.print(System.out, "x = |%g|\n", d);
        Format.print(System.out, "z = |%g|\n", d3);
        Format.print(System.out, "w = |%g|\n", d4);
        Format.print(System.out, "u = |%g|\n", d5);
        Format.print(System.out, "y = |%.2g|\n", d2);
        Format.print(System.out, "y = |%#.2g|\n", d2);
        Format.print(System.out, "d = |%d|\n", n);
        Format.print(System.out, "d = |%20d|\n", n);
        Format.print(System.out, "d = |%020d|\n", n);
        Format.print(System.out, "d = |%+20d|\n", n);
        Format.print(System.out, "d = |% 020d|\n", n);
        Format.print(System.out, "d = |%-20d|\n", n);
        Format.print(System.out, "d = |%20.8d|\n", n);
        Format.print(System.out, "d = |%x|\n", n);
        Format.print(System.out, "d = |%20X|\n", n);
        Format.print(System.out, "d = |%#20x|\n", n);
        Format.print(System.out, "d = |%020X|\n", n);
        Format.print(System.out, "d = |%20.8x|\n", n);
        Format.print(System.out, "d = |%o|\n", n);
        Format.print(System.out, "d = |%020o|\n", n);
        Format.print(System.out, "d = |%#20o|\n", n);
        Format.print(System.out, "d = |%#020o|\n", n);
        Format.print(System.out, "d = |%20.12o|\n", n);
        Format.print(System.out, "s = |%-20s|\n", "Hello");
        Format.print(System.out, "s = |%-20c|\n", '!');
        Format.print(System.out, "|%i|\n", Long.MIN_VALUE);
        Format.print(System.out, "|%6.2e|\n", 0.0);
        Format.print(System.out, "|%6.2g|\n", 0.0);
        Format.print(System.out, "|%6.2f|\n", 9.99);
        Format.print(System.out, "|%6.2f|\n", 9.999);
        Format.print(System.out, "|%6.0f|\n", 9.999);
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String convert(long l, int n, int n2, String string) {
        if (l == (long)0) {
            return "0";
        }
        String string2 = "";
        while (l != (long)0) {
            string2 = String.valueOf(String.valueOf(string.charAt((int)(l & (long)n2)))).concat(String.valueOf(String.valueOf(string2)));
            l >>>= n;
        }
        return string2;
    }

    private String pad(String string) {
        String string2 = Format.repeat(' ', this.width - string.length());
        if (this.left_align) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.pre))).append(string).append(string2).append(this.post)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.pre))).append(string2).append(string).append(this.post)));
    }

    private String sign(int n, String string) {
        String string2 = "";
        if (n < 0) {
            string2 = "-";
        } else if (n > 0) {
            if (this.show_plus) {
                string2 = "+";
            } else if (this.show_space) {
                string2 = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && string.length() > 0 && string.charAt(0) != '0') {
            string2 = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            string2 = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            string2 = "0X";
        }
        int n2 = 0;
        if (this.leading_zeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(Format.repeat('0', n2 - string2.length() - string.length())).append(string)));
    }

    private String fixed_format(double d) {
        boolean bl;
        boolean bl2 = bl = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d > (double)Long.MAX_VALUE) {
            return this.exp_format(d);
        }
        if (this.precision == 0) {
            return String.valueOf(String.valueOf((long)(d + 0.5))).concat(String.valueOf(String.valueOf(bl ? "" : ".")));
        }
        long l = (long)d;
        double d2 = d - (double)l;
        if (d2 >= 1.0 || d2 < 0.0) {
            return this.exp_format(d);
        }
        double d3 = 1.0;
        String string = "";
        for (int i = 1; i <= this.precision && d3 <= (double)Long.MAX_VALUE; d3 *= (double)10, ++i) {
            string = String.valueOf(String.valueOf(string)).concat("0");
        }
        long l2 = (long)(d3 * d2 + 0.5);
        if ((double)l2 >= d3) {
            l2 = 0L;
            ++l;
        }
        String string2 = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(l2)));
        string2 = ".".concat(String.valueOf(String.valueOf(string2.substring(string2.length() - this.precision, string2.length()))));
        if (bl) {
            int n;
            for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == '0'; --n) {
            }
            if (n >= 0 && string2.charAt(n) == '.') {
                --n;
            }
            string2 = string2.substring(0, n + 1);
        }
        return String.valueOf(String.valueOf(l)).concat(String.valueOf(String.valueOf(string2)));
    }

    private String exp_format(double d) {
        String string = "";
        int n = 0;
        double d2 = 1.0;
        if (d != 0.0) {
            double d3;
            for (d3 = d; d3 > (double)10; d3 /= (double)10) {
                ++n;
                d2 /= (double)10;
            }
            while (d3 < 1.0) {
                --n;
                d2 *= (double)10;
                d3 *= (double)10;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixed_format(d);
        }
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.fixed_format(d *= d2))));
        string = this.fmt == 'e' || this.fmt == 'g' ? String.valueOf(String.valueOf(string)).concat("e") : String.valueOf(String.valueOf(string)).concat("E");
        String string2 = "000";
        if (n >= 0) {
            string = String.valueOf(String.valueOf(string)).concat("+");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(n)));
        } else {
            string = String.valueOf(String.valueOf(string)).concat("-");
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(-n)));
        }
        return String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2.substring(string2.length() - 3, string2.length()))));
    }
}

