/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graph;

import edu.davidson.graph.Axis;
import edu.davidson.graph.Graph2D;
import edu.davidson.graph.Markers;
import edu.davidson.graph.TextLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DataSet {
    public static final int NOLINE = 0;
    public static final int LINE = 1;
    public static final int MAX_LENGTH = 20000;
    public Graph2D g2d;
    public int linestyle = 1;
    public Color linecolor = null;
    public int marker = 0;
    public Color markercolor = null;
    public double markerscale = 1.0;
    public Axis xaxis;
    public Axis yaxis;
    public double xmax;
    public double xmin;
    public double ymax;
    public double ymin;
    public boolean clipping = true;
    protected boolean sorted = false;
    protected boolean stripChart = false;
    protected int chartPts = 0;
    private double[] tempDatum = new double[2];
    private double[] lastPoint = new double[2];
    protected double dxmax;
    protected double dxmin;
    protected double dymax;
    protected double dymin;
    protected double[] data;
    protected int length;
    protected double xrange;
    protected double yrange;
    protected int legend_length = 20;
    protected TextLine legend_text = null;
    protected int legend_ix;
    protected int legend_iy;
    protected double legend_dx;
    protected double legend_dy;
    protected int increment = 100;
    protected int stride = 2;

    public void setSorted(boolean bl) {
        this.sorted = bl;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setStripChart(int n, boolean bl) {
        this.stripChart = bl;
        this.chartPts = Math.max(n, 1);
        if (this.stripChart) {
            this.chartPoints();
        }
    }

    public boolean isStripChart() {
        return this.stripChart;
    }

    public double[] getLastPoint() {
        return this.lastPoint;
    }

    public DataSet() {
        this.length = 0;
        this.data = null;
        this.lastPoint = new double[this.stride];
        this.range(this.stride);
    }

    public DataSet(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Invalid stride parameter!");
        }
        this.stride = n;
        this.lastPoint = new double[n];
        this.length = 0;
        this.lastPoint = new double[n];
        this.range(n);
    }

    public DataSet(double[] dArray, int n) throws Exception {
        boolean bl = false;
        this.length = 0;
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in parsed data!");
        }
        if (dArray.length > 20000 || n > 20000) {
            System.out.println("Error: DataSet passed to constructor has too many points.  Max Pointst=".concat(String.valueOf(String.valueOf(this.length / this.stride))));
            return;
        }
        this.lastPoint = new double[this.stride];
        this.data = new double[n * this.stride];
        this.length = n * this.stride;
        System.arraycopy(dArray, 0, this.data, 0, this.length);
        System.arraycopy(dArray, this.length - this.stride, this.lastPoint, 0, this.stride);
        if (this.sorted) {
            this.insertionSort();
        }
        if (this.stripChart) {
            this.chartPoints();
        }
        this.range(this.stride);
    }

    public DataSet(double[] dArray, int n, int n2) throws Exception {
        if (n2 < 2) {
            throw new Exception("Invalid stride parameter!");
        }
        boolean bl = false;
        this.length = 0;
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in parsed data!");
        }
        if (dArray.length > 20000 || n > 20000) {
            System.out.println("Error: DataSet passed to constructor has too many points.  Max Pointst=".concat(String.valueOf(String.valueOf(this.length / this.stride))));
            return;
        }
        this.stride = n2;
        this.lastPoint = new double[this.stride];
        this.data = new double[n * this.stride];
        this.length = n * this.stride;
        System.arraycopy(dArray, 0, this.data, 0, this.length);
        System.arraycopy(dArray, this.length - this.stride, this.lastPoint, 0, this.stride);
        if (this.sorted) {
            this.insertionSort();
        }
        if (this.stripChart) {
            this.chartPoints();
        }
        this.range(this.stride);
    }

    public synchronized void replace(double[] dArray, int n) throws Exception {
        if (n * this.stride > 20000) {
            System.out.println("Error: DataSet has too many points.  Max Pointst=".concat(String.valueOf(String.valueOf(this.length / this.stride))));
            return;
        }
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in replace data!");
        }
        if (this.data == null || this.data.length != dArray.length) {
            this.length = 0;
            this.data = null;
            this.append(dArray, n);
            return;
        }
        System.arraycopy(dArray, 0, this.data, 0, this.length);
        System.arraycopy(dArray, this.length - this.stride, this.lastPoint, 0, this.stride);
        if (this.sorted) {
            this.insertionSort();
        }
        if (this.stripChart) {
            this.chartPoints();
        }
        this.range(this.stride);
        if (this.xaxis != null) {
            this.xaxis.resetRange();
        }
        if (this.yaxis != null) {
            this.yaxis.resetRange();
        }
    }

    public synchronized void append(double[] dArray, int n) throws Exception {
        if (n * this.stride > 20000) {
            System.out.println("Error: DataSet has too many points.  Max Pointst=".concat(String.valueOf(String.valueOf(this.length / this.stride))));
            return;
        }
        boolean bl = false;
        int n2 = n * this.stride;
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in append data!");
        }
        if (this.data == null) {
            this.data = new double[n * this.stride];
            this.length = n * this.stride;
            System.arraycopy(dArray, 0, this.data, 0, this.length);
            if (this.sorted) {
                this.insertionSort();
            }
            if (this.stripChart) {
                this.chartPoints();
            }
            this.range(this.stride);
            if (this.xaxis != null) {
                this.xaxis.resetRange();
            }
            if (this.yaxis != null) {
                this.yaxis.resetRange();
            }
            System.arraycopy(dArray, n2 - this.stride, this.lastPoint, 0, this.stride);
            return;
        }
        if (n2 + this.length < this.data.length) {
            System.arraycopy(dArray, 0, this.data, this.length, n2);
            this.length += n2;
        } else {
            double[] dArray2 = new double[n2 + this.length + this.increment];
            if (this.length != 0) {
                System.arraycopy(this.data, 0, dArray2, 0, this.length);
            }
            System.arraycopy(dArray, 0, dArray2, this.length, n2);
            this.length += n2;
            this.data = dArray2;
        }
        if (this.sorted && n2 == this.stride) {
            this.insertDatum(this.length - n2);
        } else if (this.sorted) {
            this.insertionSort();
        }
        if (this.stripChart) {
            this.chartPoints();
        }
        System.arraycopy(dArray, n2 - this.stride, this.lastPoint, 0, this.stride);
        if (this.stripChart || n > 1 || this.stride != 2 || this.length < 6) {
            this.range(this.stride);
        } else {
            if (this.dxmax < dArray[0]) {
                this.dxmax = dArray[0];
            } else if (this.dxmin > dArray[0]) {
                this.dxmin = dArray[0];
            }
            if (this.dymax < dArray[1]) {
                this.dymax = dArray[1];
            } else if (this.dymin > dArray[1]) {
                this.dymin = dArray[1];
            }
            if (this.xaxis == null) {
                this.xmin = this.dxmin;
                this.xmax = this.dxmax;
            }
            if (this.yaxis == null) {
                this.ymin = this.dymin;
                this.ymax = this.dymax;
            }
        }
        if (this.xaxis != null) {
            this.xaxis.resetRange();
        }
        if (this.yaxis != null) {
            this.yaxis.resetRange();
        }
    }

    public synchronized void delete(int n, int n2) {
        int n3 = this.stride * n2;
        int n4 = this.stride * n;
        if (this.length <= 0) {
            return;
        }
        if (n3 < n4) {
            return;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 > this.length - this.stride) {
            n3 = this.length - this.stride;
        }
        if (n3 < this.length - this.stride) {
            System.arraycopy(this.data, n3 + this.stride, this.data, n4, this.length - n3 - this.stride);
        }
        this.length -= n3 + this.stride - n4;
        this.range(this.stride);
        if (this.xaxis != null) {
            this.xaxis.resetRange();
        }
        if (this.yaxis != null) {
            this.yaxis.resetRange();
        }
    }

    public synchronized void deleteData() {
        this.length = 0;
        this.data = null;
        this.range(this.stride);
        if (this.xaxis != null) {
            this.xaxis.resetRange();
        }
        if (this.yaxis != null) {
            this.yaxis.resetRange();
        }
    }

    public synchronized void draw_data(Graphics graphics, Rectangle rectangle) {
        if (this.xaxis != null) {
            this.xmax = this.xaxis.maximum;
            this.xmin = this.xaxis.minimum;
        }
        if (this.yaxis != null) {
            this.ymax = this.yaxis.maximum;
            this.ymin = this.yaxis.minimum;
        }
        this.xrange = this.xmax - this.xmin;
        this.yrange = this.ymax - this.ymin;
        this.draw_legend(graphics, rectangle);
        if (this.clipping) {
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Color color = graphics.getColor();
        if (this.linestyle != 0) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_lines(graphics, rectangle);
        }
        if (this.linestyle == 0 && this.marker == 0) {
            if (this.markercolor != null) {
                graphics.setColor(this.markercolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_dots(graphics, rectangle);
        }
        if (this.marker > 0) {
            if (this.markercolor != null) {
                graphics.setColor(this.markercolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_markers(graphics, rectangle);
        }
        if (this.marker == -1) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_polygon(graphics, rectangle);
        }
        if (this.marker == -2) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_polygon2(graphics, rectangle);
        }
        if (this.marker == -3) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_histogram(graphics, rectangle);
        }
        graphics.setColor(color);
    }

    public double[] getData() {
        return this.data;
    }

    public double getXmax() {
        return this.dxmax;
    }

    public double getXmin() {
        return this.dxmin;
    }

    public double getYmax() {
        return this.dymax;
    }

    public double getYmin() {
        return this.dymin;
    }

    public void legend(int n, int n2, String string) {
        if (string == null) {
            this.legend_text = null;
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine(string);
        } else {
            this.legend_text.setText(string);
        }
        this.legend_text.setJustification(1);
        this.legend_ix = n;
        this.legend_iy = n2;
        this.legend_dx = 0.0;
        this.legend_dy = 0.0;
    }

    public String getLegend() {
        return this.legend_text.getText();
    }

    public int getLegend_ix() {
        return this.legend_ix;
    }

    public int getLegend_iy() {
        return this.legend_iy;
    }

    public void legend(double d, double d2, String string) {
        if (string == null) {
            this.legend_text = null;
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine(string);
        } else {
            this.legend_text.setText(string);
        }
        this.legend_text.setJustification(1);
        this.legend_dx = d;
        this.legend_dy = d2;
        this.legend_ix = 0;
        this.legend_iy = 0;
    }

    public void legendFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine();
        }
        this.legend_text.setFont(font);
    }

    public void legendColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine();
        }
        this.legend_text.setColor(color);
    }

    public int dataPoints() {
        return this.length / this.stride;
    }

    public double[] getPoint(int n) {
        double[] dArray = new double[this.stride];
        int n2 = n * this.stride;
        if (n < 0 || n2 > this.length - this.stride) {
            return null;
        }
        for (int i = 0; i < this.stride; ++i) {
            dArray[i] = this.data[n2 + i];
        }
        return dArray;
    }

    public double[] getClosestPoint(double d, double d2) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d3 = this.data[0] - d;
        double d4 = this.data[1] - d2;
        dArray[0] = this.data[0];
        dArray[1] = this.data[1];
        dArray[2] = d3 * d3 + d4 * d4;
        for (int i = this.stride; i < this.length - 1; i += this.stride) {
            d3 = this.data[i] - d;
            d4 = this.data[i + 1] - d2;
            double d5 = d3 * d3 + d4 * d4;
            if (!(d5 < dArray[2])) continue;
            dArray[0] = this.data[i];
            dArray[1] = this.data[i + 1];
            dArray[2] = d5;
        }
        return dArray;
    }

    private void draw_polygon2(Graphics graphics, Rectangle rectangle) {
        double d;
        int n;
        if (this.data == null || this.data.length < this.stride || this.data.length < 4) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[this.data.length / this.stride + 4];
        int[] nArray2 = new int[this.data.length / this.stride + 4];
        int n7 = (int)((double)rectangle.y + (1.0 - (0.0 - this.ymin) / this.yrange) * (double)rectangle.height);
        int n8 = 0;
        Color color = graphics.getColor();
        graphics.setColor(new Color(0, 255, 255));
        n2 = this.xmin - this.data[0] > (double)10 * this.xrange ? -100000 : (this.data[0] - this.xmax > (double)10 * this.xrange ? 100000 : (int)((double)rectangle.x + (this.data[0] - this.xmin) / this.xrange * (double)rectangle.width));
        n3 = this.ymin - this.data[1] > (double)10 * this.yrange ? 100000 : (this.data[1] - this.ymax > (double)10 * this.yrange ? -100000 : (int)((double)rectangle.y + (1.0 - (this.data[1] - this.ymin) / this.yrange) * (double)rectangle.height));
        n8 = n3;
        if (n3 > n7) {
            n3 = n7;
        }
        for (n = this.stride; n < this.length; n += this.stride) {
            n4 = this.xmin - this.data[n] > (double)10 * this.xrange ? -100000 : (this.data[n] - this.xmax > (double)10 * this.xrange ? 100000 : (int)((double)rectangle.x + (this.data[n] - this.xmin) / this.xrange * (double)rectangle.width));
            n5 = this.ymin - this.data[n + 1] > (double)10 * this.yrange ? 100000 : (this.data[n + 1] - this.ymax > (double)10 * this.yrange ? -100000 : (int)((double)rectangle.y + (1.0 - (this.data[n + 1] - this.ymin) / this.yrange) * (double)rectangle.height));
            if (n5 != n7 && (double)(n3 - n7) / (double)(n5 - n7) < 0.0 && n5 != n3) {
                d = (double)(n4 - n2) / (double)(n5 - n3);
                if (n5 > n7) {
                    n4 = (int)((double)n2 + (double)(n7 - n3) * d);
                    n5 = n7;
                }
            } else if (n3 == n7 && n5 < n7) {
                n3 = n8;
                d = (double)(n4 - n2) / (double)(n5 - n3);
                n2 = (int)((double)n4 + (double)(n7 - n5) * d);
                n3 = n7;
            } else if (n5 > n7) {
                n8 = n5;
                n5 = n7;
            }
            nArray[n6] = n2;
            nArray2[n6] = n3;
            ++n6;
            n2 = n4;
            n3 = n5;
        }
        nArray[n6] = n2;
        nArray2[n6] = n3;
        nArray[++n6] = n2;
        nArray2[n6] = n7;
        nArray[++n6] = nArray[0];
        nArray2[n6] = n7;
        graphics.fillPolygon(nArray, nArray2, ++n6);
        graphics.setColor(color);
        graphics.drawPolygon(nArray, nArray2, n6);
        n6 = 0;
        graphics.setColor(new Color(255, 255, 0));
        n2 = this.xmin - this.data[0] > (double)10 * this.xrange ? -10000 : (this.data[0] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[0] - this.xmin) / this.xrange * (double)rectangle.width));
        n3 = this.ymin - this.data[1] > (double)10 * this.yrange ? 10000 : (this.data[1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[1] - this.ymin) / this.yrange) * (double)rectangle.height));
        n8 = n3;
        if (n3 < n7) {
            n3 = n7;
        }
        for (n = this.stride; n < this.length; n += this.stride) {
            n4 = this.xmin - this.data[n] > (double)10 * this.xrange ? -10000 : (this.data[n] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[n] - this.xmin) / this.xrange * (double)rectangle.width));
            n5 = this.ymin - this.data[n + 1] > (double)10 * this.yrange ? 10000 : (this.data[n + 1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[n + 1] - this.ymin) / this.yrange) * (double)rectangle.height));
            if (n5 != n7 && (double)(n3 - n7) / (double)(n5 - n7) < 0.0 && n5 != n3) {
                d = (double)(n4 - n2) / (double)(n5 - n3);
                if (n5 < n7) {
                    n4 = (int)((double)n2 + (double)(n7 - n3) * d);
                    n5 = n7;
                }
            } else if (n3 == n7 && n5 > n7) {
                n3 = n8;
                d = (double)(n4 - n2) / (double)(n5 - n3);
                n2 = (int)((double)n4 + (double)(n7 - n5) * d);
                n3 = n7;
            } else if (n5 < n7) {
                n8 = n5;
                n5 = n7;
            }
            nArray[n6] = n2;
            nArray2[n6] = n3;
            ++n6;
            n2 = n4;
            n3 = n5;
        }
        nArray[n6] = n2;
        nArray2[n6] = n3;
        nArray[++n6] = n2;
        nArray2[n6] = n7;
        nArray[++n6] = nArray[0];
        nArray2[n6] = n7;
        graphics.fillPolygon(nArray, nArray2, ++n6);
        graphics.setColor(color);
        graphics.drawPolygon(nArray, nArray2, n6);
    }

    private void draw_polygon(Graphics graphics, Rectangle rectangle) {
        if (this.data == null || this.data.length < this.stride || this.data.length < 4) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.data.length / this.stride + 4];
        int[] nArray2 = new int[this.data.length / this.stride + 4];
        int n6 = (int)((double)rectangle.y + (1.0 - (0.0 - this.ymin) / this.yrange) * (double)rectangle.height);
        n = this.xmin - this.data[0] > (double)10 * this.xrange ? -10000 : (this.data[0] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[0] - this.xmin) / this.xrange * (double)rectangle.width));
        n2 = this.ymin - this.data[1] > (double)10 * this.yrange ? 10000 : (this.data[1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[1] - this.ymin) / this.yrange) * (double)rectangle.height));
        for (int i = this.stride; i < this.length; i += this.stride) {
            n3 = this.xmin - this.data[i] > (double)10 * this.xrange ? -10000 : (this.data[i] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[i] - this.xmin) / this.xrange * (double)rectangle.width));
            n4 = this.ymin - this.data[i + 1] > (double)10 * this.yrange ? 10000 : (this.data[i + 1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)rectangle.height));
            nArray[n5] = n;
            nArray2[n5] = n2;
            ++n5;
            n = n3;
            n2 = n4;
        }
        nArray[n5] = n;
        nArray2[n5] = n2;
        nArray[++n5] = n;
        nArray2[n5] = n6;
        nArray[++n5] = nArray[0];
        nArray2[n5] = n6;
        graphics.fillPolygon(nArray, nArray2, ++n5);
    }

    protected synchronized void draw_histogram(Graphics graphics, Rectangle rectangle) {
        if (this.data == null || this.data.length < this.stride || this.data.length < 2) {
            return;
        }
        Markers markers = this.g2d.getMarkers();
        if (markers == null) {
            return;
        }
        int n = (int)(this.markerscale * (double)2);
        int n2 = 0;
        int n3 = 0;
        int n4 = (int)((double)rectangle.y + (1.0 - (0.0 - this.ymin) / this.yrange) * (double)rectangle.height);
        for (int i = 0; i < this.length; i += this.stride) {
            n2 = this.xmin - this.data[i] > (double)10 * this.xrange ? -10000 : (this.data[i] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[i] - this.xmin) / this.xrange * (double)rectangle.width));
            n3 = this.ymin - this.data[i + 1] > (double)10 * this.yrange ? 10000 : (this.data[i + 1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)rectangle.height));
            if (n4 - n3 < 0) {
                graphics.fillRect(n2 - n, n4 + 1, 2 * n + 1, -n4 + n3);
                continue;
            }
            graphics.fillRect(n2 - n, n3 + 1, 2 * n + 1, n4 - n3);
        }
    }

    protected synchronized void draw_lines(Graphics graphics, Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.data == null || this.data.length < this.stride) {
            return;
        }
        n = this.xmin - this.data[0] > (double)10 * this.xrange ? -10000 : (this.data[0] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[0] - this.xmin) / this.xrange * (double)rectangle.width));
        n2 = this.ymin - this.data[1] > (double)10 * this.yrange ? 10000 : (this.data[1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[1] - this.ymin) / this.yrange) * (double)rectangle.height));
        for (int i = this.stride; i < this.length; i += this.stride) {
            n3 = this.xmin - this.data[i] > (double)10 * this.xrange ? -10000 : (this.data[i] - this.xmax > (double)10 * this.xrange ? 10000 : (int)((double)rectangle.x + (this.data[i] - this.xmin) / this.xrange * (double)rectangle.width));
            n4 = this.ymin - this.data[i + 1] > (double)10 * this.yrange ? 10000 : (this.data[i + 1] - this.ymax > (double)10 * this.yrange ? -10000 : (int)((double)rectangle.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)rectangle.height));
            graphics.drawLine(n, n2, n3, n4);
            n = n3;
            n2 = n4;
        }
    }

    protected boolean inside(double d, double d2) {
        return d >= this.xmin && d <= this.xmax && d2 >= this.ymin && d2 <= this.ymax;
    }

    protected void draw_markers(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.x + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height;
        Markers markers = this.g2d.getMarkers();
        if (markers == null) {
            return;
        }
        for (int i = 0; i < this.length; i += this.stride) {
            if (!this.inside(this.data[i], this.data[i + 1])) continue;
            int n5 = (int)((double)rectangle.x + (this.data[i] - this.xmin) / this.xrange * (double)rectangle.width);
            int n6 = (int)((double)rectangle.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)rectangle.height);
            if (n5 < n || n5 > n2 || n6 < n3 || n6 > n4) continue;
            markers.draw(graphics, this.marker, this.markerscale, n5, n6);
        }
    }

    protected synchronized void draw_dots(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.x + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height;
        for (int i = 0; i < this.length; i += this.stride) {
            if (!this.inside(this.data[i], this.data[i + 1])) continue;
            int n5 = (int)((double)rectangle.x + (this.data[i] - this.xmin) / this.xrange * (double)rectangle.width);
            int n6 = (int)((double)rectangle.y + (1.0 - (this.data[i + 1] - this.ymin) / this.yrange) * (double)rectangle.height);
            if (n5 < n || n5 > n2 || n6 < n3 || n6 > n4) continue;
            graphics.drawLine(n5, n6, n5, n6);
        }
    }

    protected void draw_legend(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        Markers markers = null;
        if (this.legend_text == null) {
            return;
        }
        if (this.legend_text.isNull()) {
            return;
        }
        if (this.legend_ix == 0 && this.legend_iy == 0) {
            this.legend_ix = (int)((double)rectangle.x + (this.legend_dx - this.xmin) / this.xrange * (double)rectangle.width);
            this.legend_iy = (int)((double)rectangle.y + (1.0 - (this.legend_dy - this.ymin) / this.yrange) * (double)rectangle.height);
        }
        if (this.linestyle != 0) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            }
            graphics.drawLine(this.legend_ix, this.legend_iy, this.legend_ix + this.legend_length, this.legend_iy);
        }
        if (this.marker > 0 && (markers = this.g2d.getMarkers()) != null) {
            if (this.markercolor != null) {
                graphics.setColor(this.markercolor);
            } else {
                graphics.setColor(color);
            }
            markers.draw(graphics, this.marker, 1.0, this.legend_ix + this.legend_length / 2, this.legend_iy);
        }
        this.legend_text.draw(graphics, this.legend_ix + this.legend_length + this.legend_text.charWidth(graphics, ' '), this.legend_iy + this.legend_text.getAscent(graphics) / 3);
        graphics.setColor(color);
    }

    protected void range(int n) {
        if (this.length >= n) {
            this.dxmax = this.data[0];
            this.dymax = this.data[1];
            this.dxmin = this.dxmax;
            this.dymin = this.dymax;
        } else {
            this.dxmin = 0.0;
            this.dxmax = 0.0;
            this.dymin = 0.0;
            this.dymax = 0.0;
        }
        for (int i = n; i < this.length; i += n) {
            if (this.dxmax < this.data[i]) {
                this.dxmax = this.data[i];
            } else if (this.dxmin > this.data[i]) {
                this.dxmin = this.data[i];
            }
            if (this.dymax < this.data[i + 1]) {
                this.dymax = this.data[i + 1];
                continue;
            }
            if (!(this.dymin > this.data[i + 1])) continue;
            this.dymin = this.data[i + 1];
        }
        if (this.xaxis == null) {
            this.xmin = this.dxmin;
            this.xmax = this.dxmax;
        }
        if (this.yaxis == null) {
            this.ymin = this.dymin;
            this.ymax = this.dymax;
        }
    }

    private synchronized void insertDatum(int n) {
        if (this.length < 2 * this.stride) {
            return;
        }
        if (this.tempDatum.length != this.stride) {
            this.tempDatum = new double[this.stride];
        }
        System.arraycopy(this.data, n, this.tempDatum, 0, this.stride);
        for (int i = 0; i < this.length; i += this.stride) {
            if (!(this.data[i] > this.data[n])) continue;
            System.arraycopy(this.data, i, this.data, i + this.stride, this.length - i - this.stride);
            System.arraycopy(this.tempDatum, 0, this.data, i, this.stride);
            return;
        }
    }

    protected void insertionSort() {
        if (this.length < 2 * this.stride) {
            return;
        }
        for (int i = this.stride; i < this.length; i += this.stride) {
            if (!(this.data[i] < this.data[i - this.stride])) continue;
            this.insertDatum(i);
        }
    }

    protected void chartPoints() {
        if (this.length <= this.chartPts * this.stride) {
            return;
        }
        System.arraycopy(this.data, this.length - this.chartPts * this.stride, this.data, 0, this.chartPts * this.stride);
        this.length = this.chartPts * this.stride;
    }

    static {
        NOLINE = 0;
        LINE = 1;
        MAX_LENGTH = 20000;
    }
}

