/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import edu.davidson.graphics.Assert;
import edu.davidson.graphics.EtchedRectangle;
import edu.davidson.graphics.Etching;
import edu.davidson.graphics.HintPanel;
import edu.davidson.graphics.Orientation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class Box
extends Panel {
    private static Orientation _defaultOrientation = Orientation.CENTER;
    private static String _defaultString = "Title";
    private EtchedRectangle box = new EtchedRectangle(this);
    private Label titleLabel;
    private Orientation orient;
    protected Component borderMe;

    public Box() {
        this((Component)new HintPanel(), _defaultString);
    }

    public Box(Component component, String string) {
        this(component, new Label(string, 1), _defaultOrientation);
    }

    public Box(Component component, String string, Orientation orientation) {
        this(component, new Label(string, 1), orientation);
    }

    public Box(Component component, Label label) {
        this(component, label, _defaultOrientation);
    }

    public Box(Component component, Label label, Orientation orientation) {
        Assert.notNull(component);
        Assert.notNull(label);
        this.borderMe = component;
        this.titleLabel = label;
        this.orient = orientation;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        if (orientation == Orientation.CENTER) {
            gridBagConstraints.anchor = 11;
        } else if (orientation == Orientation.RIGHT) {
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        } else if (orientation == Orientation.LEFT) {
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        }
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void etchedIn() {
        this.box.etchedIn();
    }

    public void etchedOut() {
        this.box.etchedOut();
    }

    public void paint(Graphics graphics) {
        this.box.paint();
        super.paint(graphics);
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.getLocation().x, this.getLocation().y, n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        FontMetrics fontMetrics = this.titleLabel.getFontMetrics(this.titleLabel.getFont());
        int n5 = this.getInsets().top + fontMetrics.getAscent();
        Dimension dimension = this.getSize();
        this.box.setBounds(0, n5, dimension.width - 1, dimension.height - n5 - 1);
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.paramString()))).append(",etching=").append(this.box.isEtchedIn() ? Etching.IN : Etching.OUT).append(",title=").append(this.titleLabel)));
    }

    public void setHint(String string) {
        if (this.borderMe != null && this.borderMe instanceof HintPanel) {
            ((HintPanel)this.borderMe).setBubbleHelp(string);
        }
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
        this.repaint();
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public Component getComponent() {
        return this.borderMe;
    }
}

