/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import edu.davidson.graphics.Assert;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class DrawnRectangle
extends Rectangle {
    protected static int _defaultThickness = 2;
    protected Component drawInto;
    private int thick;
    private Color lineColor;
    private Color fillColor;

    public DrawnRectangle(Component component) {
        this(component, _defaultThickness, 0, 0, 0, 0);
    }

    public DrawnRectangle(Component component, int n) {
        this(component, n, 0, 0, 0, 0);
    }

    public DrawnRectangle(Component component, int n, int n2, int n3, int n4) {
        this(component, _defaultThickness, n, n2, n3, n4);
    }

    public DrawnRectangle(Component component, int n, int n2, int n3, int n4, int n5) {
        Assert.notNull(component);
        Assert.notFalse(n > 0);
        this.drawInto = component;
        this.thick = n;
        this.setBounds(n2, n3, n4, n5);
    }

    public Component component() {
        return this.drawInto;
    }

    public int getThickness() {
        return this.thick;
    }

    public void setThickness(int n) {
        this.thick = n;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void fill() {
        this.fill(this.getFillColor());
    }

    public Color getLineColor() {
        if (this.lineColor == null) {
            this.lineColor = SystemColor.controlShadow;
        }
        return this.lineColor;
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = this.drawInto.getBackground();
        }
        return this.fillColor;
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.x + this.thick, this.y + this.thick, this.width - this.thick * 2, this.height - this.thick * 2);
    }

    public void paint() {
        Graphics graphics = this.drawInto.getGraphics();
        this.paintFlat(graphics, this.getLineColor());
    }

    private void paintFlat(Graphics graphics, Color color) {
        if (graphics != null) {
            graphics.setColor(color);
            for (int i = 0; i < this.thick; ++i) {
                graphics.drawRect(this.x + i, this.y + i, this.width - i * 2 - 1, this.height - i * 2 - 1);
            }
            graphics.dispose();
        }
    }

    public void clearInterior() {
        this.fill(this.drawInto.getBackground());
    }

    public void clearExterior() {
        this.paintFlat(this.drawInto.getGraphics(), this.drawInto.getBackground());
    }

    public void clear() {
        this.clearExterior();
        this.clearInterior();
    }

    public void fill(Color color) {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            Rectangle rectangle = this.getInnerBounds();
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.setFillColor(color);
            graphics.dispose();
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.toString()))).append("[").append(this.paramString()).append("]")));
    }

    public String paramString() {
        return String.valueOf(String.valueOf(new StringBuffer("color=").append(this.getLineColor()).append(",thickness=").append(this.thick).append(",fillColor=").append(this.getFillColor())));
    }

    protected Color brighter() {
        return this.getLineColor().brighter().brighter().brighter().brighter();
    }
}

