/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.SGraph;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class ComplexThing
extends Thing {
    double[] xvec;
    double[] revec;
    double[] imvec;
    boolean centered = true;

    public ComplexThing(SApplet sApplet, SScalable sScalable) {
        super(sScalable, 0.0, 0.0);
        this.s = 1;
        this.w = 0;
        this.h = 0;
        this.applet = sApplet;
    }

    public void setCentered(boolean bl) {
        this.centered = bl;
    }

    public void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        System.out.println("Single data points not supported.  The data connection must provide a compelete data set.");
    }

    public void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return;
        }
        int n2 = dArray.length;
        if (this.xvec == null || this.xvec.length != n2) {
            this.xvec = new double[n2];
            this.revec = new double[n2];
            this.imvec = new double[n2];
            System.arraycopy(dArray, 0, this.xvec, 0, n2);
        }
        if (n == 1) {
            System.arraycopy(dArray, 0, this.xvec, 0, n2);
        } else {
            System.arraycopy(dArray2, 0, this.imvec, 0, n2);
            System.arraycopy(dArray, 0, this.revec, 0, n2);
            if (this.canvas instanceof Canvas) {
                ((Canvas)((Object)this.canvas)).repaint();
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.xvec == null) {
            return;
        }
        int n = this.canvas.pixFromX(this.xvec[0]);
        int n2 = this.canvas.pixFromX(this.xvec[this.xvec.length - 1]);
        if (this.canvas.getPixWidth() <= Math.abs(n2 - n)) {
            this.paint1(graphics);
        } else {
            this.paint2(graphics);
        }
    }

    private void paint1(Graphics graphics) {
        double[] dArray = this.xvec;
        double[] dArray2 = this.revec;
        double[] dArray3 = this.imvec;
        if (!this.visible || dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        int n = dArray.length;
        if (n != dArray2.length || n != dArray3.length) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.canvas.pixFromY(0.0);
        for (int i = 0; i < n; ++i) {
            if (this.canvas instanceof SGraph) {
                SGraph cfr_ignored_0 = (SGraph)this.canvas;
                graphics.setColor(SGraph.colorFromRadians(Math.atan2(dArray3[i], dArray2[i])));
            } else {
                graphics.setColor(Color.getHSBColor((float)(1.0 + Math.atan2(dArray3[i], dArray2[i]) / Math.PI) / (float)2, 1.0f, 1.0f));
            }
            double d = Math.sqrt(dArray2[i] * dArray2[i] + dArray3[i] * dArray3[i]);
            if (this.centered) {
                n2 = this.canvas.pixFromY(-d / (double)2);
                n3 = this.canvas.pixFromY(d / (double)2);
            } else {
                n2 = n4;
                n3 = this.canvas.pixFromY(d);
            }
            int n5 = this.canvas.pixFromX(dArray[i]);
            graphics.drawLine(n5, n2, n5, n3);
        }
    }

    private void paint2(Graphics graphics) {
        int n;
        int n2;
        double[] dArray = this.xvec;
        double[] dArray2 = this.revec;
        double[] dArray3 = this.imvec;
        if (!this.visible || dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        int n3 = dArray.length;
        if (n3 != dArray2.length || n3 != dArray3.length) {
            return;
        }
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        Polygon polygon = new Polygon(nArray, nArray2, 5);
        boolean bl = false;
        double d = Math.sqrt(dArray2[0] * dArray2[0] + dArray3[0] * dArray3[0]);
        int n4 = this.canvas.pixFromY(0.0);
        int n5 = this.canvas.pixFromX(dArray[0]);
        if (this.centered) {
            n2 = this.canvas.pixFromY(-d / (double)2);
            n = this.canvas.pixFromY(d / (double)2);
        } else {
            n2 = n4;
            n = this.canvas.pixFromY(d);
        }
        for (int i = 1; i < n3; ++i) {
            int n6;
            int n7;
            int n8 = this.canvas.pixFromX(dArray[i]);
            d = Math.sqrt(dArray2[i] * dArray2[i] + dArray3[i] * dArray3[i]);
            if (this.canvas instanceof SGraph) {
                SGraph cfr_ignored_0 = (SGraph)this.canvas;
                graphics.setColor(SGraph.colorFromRadians(Math.atan2(dArray3[i], dArray2[i])));
            } else {
                graphics.setColor(Color.getHSBColor((float)(1.0 + Math.atan2(dArray3[i], dArray2[i]) / Math.PI) / (float)2, 1.0f, 1.0f));
            }
            if (this.centered) {
                n7 = this.canvas.pixFromY(-d / (double)2);
                n6 = this.canvas.pixFromY(d / (double)2);
            } else {
                n7 = n4;
                n6 = this.canvas.pixFromY(d);
            }
            polygon.xpoints[0] = n5;
            polygon.ypoints[0] = n;
            polygon.xpoints[1] = n8;
            polygon.ypoints[1] = n6;
            polygon.xpoints[2] = n8;
            polygon.ypoints[2] = n7;
            polygon.xpoints[3] = n5;
            polygon.ypoints[3] = n2;
            polygon.xpoints[4] = n5;
            polygon.ypoints[4] = n;
            graphics.fillPolygon(polygon);
            n5 = n8;
            n = n6;
            n2 = n7;
        }
    }

    public void paintHighlight(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.paint(graphics);
    }

    public final boolean isInsideThing(int n, int n2) {
        return false;
    }
}

