/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.display;

import edu.davidson.display.ConnectorLine;
import edu.davidson.display.Format;
import edu.davidson.display.GraphThing;
import edu.davidson.display.MarkerThing;
import edu.davidson.display.SGraphFrame;
import edu.davidson.display.SGraph_mouseAdapter;
import edu.davidson.display.SGraph_mouseMotionAdapter;
import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import edu.davidson.display.TrailThing;
import edu.davidson.display.VectorField;
import edu.davidson.graph.Axis;
import edu.davidson.graph.DataSet;
import edu.davidson.graph.Graph2D;
import edu.davidson.graph.Markers;
import edu.davidson.graph.TextLine;
import edu.davidson.graphics.Util;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SGraph
extends Graph2D
implements SStepable,
Cloneable,
SDataListener,
Runnable,
SScalable {
    public String label_time = "Time: ";
    private static Color[] colors = new Color[91];
    private boolean interrupted = false;
    private boolean newData = false;
    Object delayLock = new Object();
    private Thread delayThread = null;
    public Axis xaxis;
    public Axis yaxis;
    int[] borders = new int[]{0, 10, 10, 0};
    Format format = new Format("%-+6.2g");
    private boolean autoRefresh = true;
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private int boxWidth = 0;
    private boolean sampleData = false;
    private Vector dataSetSeries = new Vector();
    private Vector functions = new Vector();
    private Vector cfunctions = new Vector();
    private double[] dPoint = new double[2];
    private String labelX = "X Axis";
    private String labelY = "Y Axis";
    private Color labelXColor = Color.black;
    private Color labelYColor = Color.black;
    private Color labelXTitleColor = Color.black;
    private Color labelYTitleColor = Color.black;
    private double defaultMarkerScale = 1.0;
    private boolean enableMouse = false;
    private boolean enableClone = true;
    private boolean enableCoordDisplay = true;
    private SApplet parentSApplet;
    private String titleStr = null;
    private TextLine title = new TextLine();
    private Color titleColor = Color.black;
    private Color dataBackground = Color.white;
    private boolean mouseDrag = false;
    private int mouseX;
    private int mouseY;
    private Thing dragThing;
    private TrailThing trailThing = null;
    private boolean sketchMode = false;
    private Font boldFont = new Font("Helvetica", 1, 14);
    private boolean hasGraphThing = false;
    boolean timeDisplay = false;
    Image sketchImage = null;
    Vector things = new Vector();
    Image offScreenImage = null;

    public SGraph() {
        SGraph.initColors();
        this.title.setFontStyle(1);
        this.title.setFontSize(16);
        this.setDataBackground(Color.white);
        this.setGraphBackground(Color.white);
        this.buildMarkers(4);
        this.drawzero = false;
        this.drawgrid = false;
        this.borderLeft = this.borders[0];
        this.borderTop = this.borders[1];
        this.borderRight = this.borders[2];
        this.borderBottom = this.borders[3];
        this.xaxis = this.createAxis(5);
        this.xaxis.setTitleColor(this.labelXTitleColor);
        this.xaxis.setLabelColor(this.labelXColor);
        this.xaxis.setTitleBackground(Color.white);
        this.xaxis.setTitleText(this.labelX);
        this.xaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.xaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.yaxis = this.createAxis(2);
        this.yaxis.setTitleColor(this.labelYTitleColor);
        this.yaxis.setLabelColor(this.labelYColor);
        this.yaxis.setTitleBackground(Color.white);
        this.yaxis.setTitleText(this.labelY);
        this.yaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.yaxis.setLabelFont(new Font("Helvetica", 0, 10));
        if (this.sampleData) {
            this.makeSampleData(100);
        }
        try {
            SApplet.addDataListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.delayThread = new Thread(this);
        this.delayThread.start();
        this.setFont(this.getFont());
    }

    public SGraph(SApplet sApplet) {
        this();
        this.parentSApplet = sApplet;
    }

    public void step(double d, double d2) {
        Thing thing = null;
        Object object = this.things.elements();
        while (object.hasMoreElements()) {
            thing = (Thing)object.nextElement();
            if (!(thing instanceof SStepable)) continue;
            thing.step(d, d2);
        }
        if (this.autoRefresh && this.parentSApplet != null) {
            if (this.parentSApplet.destroyed) {
                return;
            }
            this.parentSApplet.updateDataConnections();
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    boolean isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.noDrag || !thing.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        Font font2 = new Font(font.getFamily(), 1, font.getSize() + 2);
        this.title.setFont(font2);
        this.xaxis.setTitleFont(font);
        this.yaxis.setTitleFont(font);
        font2 = new Font(font.getFamily(), 0, font.getSize() - 4);
        this.xaxis.setLabelFont(font2);
        this.yaxis.setLabelFont(font2);
    }

    public void setForeground(Color color) {
        if (color == null) {
            return;
        }
        super.setForeground(color);
        this.xaxis.setTitleColor(color);
        this.xaxis.setLabelColor(color);
        this.yaxis.setTitleColor(color);
        this.yaxis.setLabelColor(color);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setDataBackground(Color color) {
        this.dataBackground = color;
        super.setDataBackground(color);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setGraphBackground(Color color) {
        if (color == null) {
            return;
        }
        if (this.xaxis != null) {
            this.xaxis.setTitleBackground(color);
        }
        if (this.yaxis != null) {
            this.yaxis.setTitleBackground(color);
        }
        this.setBackground(color);
    }

    public Color getDataBackground() {
        return this.dataBackground;
    }

    public void setSampleData(boolean bl) {
        if (bl == this.sampleData) {
            return;
        }
        this.sampleData = bl;
        if (bl) {
            this.makeSampleData(100);
        } else {
            this.deleteAllSeries();
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isSampleData() {
        return this.sampleData;
    }

    public void setDrawGrid(boolean bl) {
        if (bl == this.drawgrid) {
            return;
        }
        this.drawgrid = bl;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isDrawGrid() {
        return this.drawgrid;
    }

    public void setAutoRefresh(boolean bl) {
        if (bl == this.autoRefresh) {
            return;
        }
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoscaleX(boolean bl) {
        if (!bl == this.xaxis.isManualRange()) {
            return;
        }
        this.xaxis.setManualRange(!bl);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isAutoscaleX() {
        return !this.xaxis.isManualRange();
    }

    public void setAutoscaleY(boolean bl) {
        if (!bl == this.yaxis.isManualRange()) {
            return;
        }
        this.yaxis.setManualRange(!bl);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isAutoscaleY() {
        return !this.yaxis.isManualRange();
    }

    public void setDrawZero(boolean bl) {
        if (bl == this.drawzero) {
            return;
        }
        this.drawzero = bl;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isDrawZero() {
        return this.drawzero;
    }

    public synchronized void setSeriesLegend(int n, Color color, int n2, int n3, String string) {
        DataSet dataSet;
        Series series = this.getSeriesFromSID(n);
        if (series == null) {
            this.dPoint[0] = 0.0;
            this.dPoint[1] = 0.0;
            dataSet = this.attachArray(n, this.dPoint).getDataSet();
            dataSet.deleteData();
        } else {
            dataSet = series.data;
        }
        dataSet.legend(n2, n3, string);
        if (color != null) {
            dataSet.legendColor(color);
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public synchronized void setSeriesLegend(int n, int n2, int n3, String string) {
        Color color = Color.black;
        Series series = this.createSeries(n);
        color = ((Series)series).data.markercolor;
        this.setSeriesLegend(n, color, n2, n3, string);
    }

    public synchronized void setSeriesLegendColor(int n, Color color) {
        Series series = this.createSeries(n);
        series.data.legendColor(color);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    private static Color colorOf(String string) {
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("darkGray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("lightGray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        return Color.white;
    }

    public synchronized void setSeriesStyle(int n, String string, boolean bl, int n2) {
        this.setSeriesStyle(n, SGraph.colorOf(string), bl, n2);
    }

    public synchronized void setSeriesStyle(int n, String string, boolean bl, int n2, double d) {
        this.setSeriesStyle(n, SGraph.colorOf(string), bl, n2, d);
    }

    public synchronized void setSeriesStyle(int n, Color color, boolean bl, int n2, double d) {
        DataSet dataSet;
        Series series = this.getSeriesFromSID(n);
        if (series == null) {
            this.dPoint[0] = 0.0;
            this.dPoint[1] = 0.0;
            dataSet = this.attachArray(n, this.dPoint).getDataSet();
            dataSet.deleteData();
        } else {
            dataSet = series.data;
        }
        dataSet.linestyle = bl ? 1 : 0;
        dataSet.marker = n2;
        dataSet.markerscale = d;
        dataSet.markercolor = color;
        dataSet.linecolor = color;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public synchronized void setSeriesStyle(int n, Color color, boolean bl, int n2) {
        DataSet dataSet;
        Series series = this.getSeriesFromSID(n);
        if (series == null) {
            this.dPoint[0] = 0.0;
            this.dPoint[1] = 0.0;
            dataSet = this.attachArray(n, this.dPoint).getDataSet();
            dataSet.deleteData();
        } else {
            dataSet = series.data;
        }
        dataSet.linestyle = bl ? 1 : 0;
        dataSet.marker = n2;
        dataSet.markercolor = color;
        dataSet.linecolor = color;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public synchronized void setSeriesStyle(int n, boolean bl, int n2) {
        Color color = Color.black;
        Series series = this.createSeries(n);
        color = ((Series)series).data.markercolor;
        this.setSeriesStyle(n, color, bl, n2);
    }

    public synchronized void setSeriesColor(int n, Color color) {
        Series series = this.createSeries(n);
        ((Series)series).data.markercolor = color;
        ((Series)series).data.linecolor = color;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public synchronized void setSeriesSorted(int n, boolean bl) {
        Series series = this.createSeries(n);
        series.data.setSorted(bl);
    }

    public synchronized void setSeriesStripChart(int n, int n2, boolean bl) {
        Series series = this.createSeries(n);
        series.data.setStripChart(n2, bl);
    }

    public int setSketchMode(boolean bl) {
        Applet applet = Util.getApplet(this);
        this.sketchImage = Util.getImage("pencil.gif", applet);
        this.sketchMode = bl;
        if (!bl) {
            this.trailThing = null;
            return 0;
        }
        this.trailThing = new TrailThing(this.parentSApplet, this, 1);
        this.trailThing.trailSize = 2000;
        return this.trailThing.hashCode();
    }

    public synchronized void setShowAxes(boolean bl) {
        this.setShowAxis(bl);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean isShowAxes() {
        return this.isShowAxis();
    }

    public synchronized void setSquare(boolean bl) {
        this.square = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public boolean isSquare() {
        return this.square;
    }

    public String getBorders() {
        String string = String.valueOf(String.valueOf(new StringBuffer("").append(this.borders[0]).append(',').append(this.borders[1]).append(',').append(this.borders[2]).append(',').append(this.borders[3])));
        return string;
    }

    public int getID() {
        return this.hashCode();
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    public void setBorders(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() < 4) {
            bl = true;
        } else {
            for (int i = 0; i < 4; ++i) {
                try {
                    this.borders[i] = Integer.parseInt(stringTokenizer.nextToken().trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.borderLeft = this.borders[0];
            this.borderTop = this.borders[1];
            this.borderRight = this.borders[2];
            this.borderBottom = this.borders[3];
            if (this.autoRefresh) {
                this.repaint();
            }
        } else {
            this.borders[0] = this.borderLeft;
            this.borders[1] = this.borderTop;
            this.borders[2] = this.borderRight;
            this.borders[3] = this.borderBottom;
        }
    }

    public void setGutters(int n, int n2, int n3, int n4) {
        this.borderLeft = n;
        this.borderTop = n2;
        this.borderRight = n3;
        this.borderBottom = n4;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setLabelX(String string) {
        this.xaxis.setTitleColor(this.labelXTitleColor);
        this.xaxis.setTitleText(string);
        this.labelX = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setLabelX(String string, Color color) {
        this.labelXTitleColor = color;
        this.xaxis.setTitleColor(color);
        this.xaxis.setTitleText(string);
        this.labelX = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public String getLabelX() {
        return this.labelX;
    }

    public Color getLabelXTitleColor() {
        return this.labelXTitleColor;
    }

    public void setLabelXTitleColor(Color color) {
        this.labelXTitleColor = color;
        this.xaxis.setTitleColor(color);
        this.xaxis.setTitleText(this.labelX);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public Color getLabelXColor() {
        return this.labelXColor;
    }

    public void setLabelXColor(Color color) {
        this.labelXColor = color;
        this.xaxis.setLabelColor(color);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setLabelY(String string) {
        this.yaxis.setTitleColor(this.labelYTitleColor);
        this.yaxis.setTitleText(string);
        this.labelY = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setLabelY(String string, Color color) {
        this.labelYTitleColor = color;
        this.yaxis.setTitleColor(color);
        this.yaxis.setTitleText(string);
        this.labelY = string;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public String getLabelY() {
        return this.labelY;
    }

    public Color getLabelYTitleColor() {
        return this.labelYTitleColor;
    }

    public void setLabelYTitleColor(Color color) {
        this.labelYTitleColor = color;
        this.yaxis.setTitleColor(color);
        this.yaxis.setTitleText(this.labelY);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public Color getLabelYColor() {
        return this.labelYColor;
    }

    public void setLabelYColor(Color color) {
        this.labelYColor = color;
        this.yaxis.setLabelColor(color);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized void setLastPointMarker(int n, boolean bl) {
        Series series = this.createSeries(n);
        series.enableLPCursor = bl;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public synchronized void setAutoReplaceData(int n, boolean bl) {
        Series series = this.createSeries(n);
        series.autoReplace = bl;
    }

    public void setAddRepeatedDatum(int n, boolean bl) {
        Series series = this.createSeries(n);
        series.addRepeatedDatum = bl;
    }

    public void setMarkerSize(double d) {
        this.defaultMarkerScale = d;
    }

    public double getMarkerSize() {
        return this.defaultMarkerScale;
    }

    public void setDefaultMarkerSize(double d) {
        this.defaultMarkerScale = d;
    }

    public double getDefaultMarkerSize() {
        return this.defaultMarkerScale;
    }

    public void setAllMarkerSizes(double d) {
        this.defaultMarkerScale = d;
        for (int i = 0; i < this.dataSetSeries.size(); ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            ((Series)series).data.markerscale = d;
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMarkerSize(int n, double d) {
        Series series = this.createSeries(n);
        ((Series)series).data.markerscale = d;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMinMaxX(double d, double d2) {
        if (this.xaxis.isManualRange()) {
            this.xaxis.setManualRange(true, d, d2);
        } else {
            this.xaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMinXRange(boolean bl, double d, double d2) {
        this.xaxis.setMinRange(bl, d, d2);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMinYRange(boolean bl, double d, double d2) {
        this.yaxis.setMinRange(bl, d, d2);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMinX(double d) {
        if (this.xaxis.isManualRange()) {
            if (d > this.xaxis.maximum) {
                this.xaxis.setManualRange(true, d, d + 1.0);
            } else {
                this.xaxis.setManualRange(true, d, this.xaxis.maximum);
            }
        } else {
            this.xaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public double getMinX() {
        return this.xaxis.minimum;
    }

    public void setMaxX(double d) {
        if (this.xaxis.isManualRange()) {
            if (d < this.xaxis.minimum) {
                this.xaxis.setManualRange(true, d - 1.0, d);
            } else {
                this.xaxis.setManualRange(true, this.xaxis.minimum, d);
            }
        } else {
            this.xaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public double getMaxX() {
        return this.xaxis.maximum;
    }

    public void setMinMaxY(double d, double d2) {
        if (this.yaxis.isManualRange()) {
            this.yaxis.setManualRange(true, d, d2);
        } else {
            this.yaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setMinY(double d) {
        if (this.yaxis.isManualRange()) {
            if (d > this.yaxis.maximum) {
                this.yaxis.setManualRange(true, d, d + 1.0);
            } else {
                this.yaxis.setManualRange(true, d, this.yaxis.maximum);
            }
        } else {
            this.yaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public double getMinY() {
        return this.yaxis.minimum;
    }

    public void setMaxY(double d) {
        if (this.yaxis.isManualRange()) {
            if (d < this.yaxis.minimum) {
                this.yaxis.setManualRange(true, d - 1.0, d);
            } else {
                this.yaxis.setManualRange(true, this.yaxis.minimum, d);
            }
        } else {
            this.yaxis.resetRange();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public double getMaxY() {
        return this.yaxis.maximum;
    }

    private DataSet getDataSetFromSID(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            return series.data;
        }
        return null;
    }

    public MathFunction getFunction(int n) {
        Vector vector;
        MathFunction mathFunction = null;
        Vector vector2 = this.functions;
        synchronized (vector2) {
            vector = (Vector)this.functions.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            mathFunction = (MathFunction)enumeration.nextElement();
            if (mathFunction.hashCode() != n) continue;
            return mathFunction;
        }
        return null;
    }

    public ComplexFunction getCFunction(int n) {
        Vector vector;
        ComplexFunction complexFunction = null;
        Vector vector2 = this.cfunctions;
        synchronized (vector2) {
            vector = (Vector)this.cfunctions.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            complexFunction = (ComplexFunction)enumeration.nextElement();
            if (complexFunction.hashCode() != n) continue;
            return complexFunction;
        }
        return null;
    }

    public int getFunctionId(int n) {
        Vector vector;
        Vector vector2 = this.functions;
        synchronized (vector2) {
            vector = (Vector)this.functions.clone();
        }
        if (n < 1 || n > vector.size()) {
            return 0;
        }
        MathFunction mathFunction = (MathFunction)vector.elementAt(n - 1);
        return mathFunction.hashCode();
    }

    public int getCFunctionId(int n) {
        Vector vector;
        Vector vector2 = this.cfunctions;
        synchronized (vector2) {
            vector = (Vector)this.cfunctions.clone();
        }
        if (n < 1 || n > vector.size()) {
            return 0;
        }
        ComplexFunction complexFunction = (ComplexFunction)vector.elementAt(n - 1);
        return complexFunction.hashCode();
    }

    private Series getSeriesFromSID(int n) {
        Enumeration enumeration = this.dataSetSeries.elements();
        while (enumeration.hasMoreElements()) {
            Series series = (Series)enumeration.nextElement();
            if (n != series.sid) continue;
            return series;
        }
        return null;
    }

    public String getTitle() {
        return this.titleStr;
    }

    public void setTitle(String string) {
        this.titleStr = string;
        this.title.setText(string);
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void setTimeDisplay(boolean bl) {
        this.timeDisplay = bl;
        if (this.timeDisplay) {
            this.parentSApplet.clock.addClockListener(this);
        } else {
            this.parentSApplet.clock.removeClockListener(this);
        }
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    int getIDFromDataSet(DataSet dataSet) {
        int n = this.dataSetSeries.size();
        for (int i = 0; i < n; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (dataSet != series.data) continue;
            return series.hashCode();
        }
        return 0;
    }

    public int getIDFromSID(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            return series.hashCode();
        }
        return 0;
    }

    public int getRegressionID(int n, int n2, int n3) {
        Series series = this.createSeries(n);
        return series.getRegressionID(n2, n3);
    }

    public void setObjectColor(int n, Color color) {
        Vector vector;
        MathFunction mathFunction = null;
        if (n == 0 || n == this.hashCode()) {
            this.setDataBackground(color);
            this.setGraphBackground(color);
            return;
        }
        Vector vector2 = this.functions;
        synchronized (vector2) {
            vector = (Vector)this.functions.clone();
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            mathFunction = (MathFunction)object.nextElement();
            if (mathFunction.hashCode() != n) continue;
            mathFunction.color = color;
            if (!this.autoRefresh) continue;
            this.repaint();
        }
        object = null;
        Object object2 = this.dataSetSeries.elements();
        while (object2.hasMoreElements()) {
            object = (Series)object2.nextElement();
            if (object.hashCode() != n) continue;
            ((Series)object).data.markercolor = color;
            ((Series)object).data.linecolor = color;
            if (this.autoRefresh) {
                this.repaint();
            }
            return;
        }
        object2 = this.things;
        synchronized (object2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            thing.setColor(color);
            if (this.autoRefresh) {
                this.repaint();
            }
            return;
        }
    }

    public void setOwner(SApplet sApplet) {
        this.parentSApplet = sApplet;
    }

    public SApplet getOwner() {
        return this.parentSApplet;
    }

    public int getPixWidth() {
        return this.getSize().width;
    }

    public int getPixHeight() {
        return this.getSize().height;
    }

    public synchronized void deleteAllFunctions() {
        Vector vector;
        Vector vector2 = this.functions;
        synchronized (vector2) {
            vector = (Vector)this.functions.clone();
            this.functions.removeAllElements();
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)object.nextElement();
            this.parentSApplet.removeDataSource(mathFunction.hashCode());
            if (!mathFunction.explicitTime) continue;
            this.parentSApplet.clock.removeClockListener(mathFunction);
        }
        object = this.cfunctions;
        synchronized (object) {
            vector = (Vector)this.cfunctions.clone();
            this.cfunctions.removeAllElements();
        }
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            ComplexFunction complexFunction = (ComplexFunction)object2.nextElement();
            this.parentSApplet.removeDataSource(complexFunction.hashCode());
            if (!complexFunction.explicitTime) continue;
            this.parentSApplet.clock.removeClockListener(complexFunction);
        }
        object2 = this.delayLock;
        synchronized (object2) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public synchronized void deleteObject(int n) {
        if (this.deleteThing(n)) {
            return;
        }
        if (this.deleteFunction(n)) {
            return;
        }
        this.deleteSeries(n);
    }

    private boolean deleteThing(int n) {
        Thing thing = null;
        thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.stopClock();
        }
        this.things.removeElement(thing);
        if (this.parentSApplet != null) {
            this.parentSApplet.removeDataSource(thing.hashCode());
            this.parentSApplet.removeDataListener(thing.hashCode());
            if (thing instanceof SStepable) {
                this.parentSApplet.clock.removeClockListener(thing);
            }
            this.parentSApplet.cleanupDataConnections();
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return true;
    }

    public synchronized boolean deleteFunction(int n) {
        boolean bl = false;
        Vector vector = this.functions;
        synchronized (vector) {
            Enumeration enumeration = this.functions.elements();
            while (enumeration.hasMoreElements()) {
                MathFunction mathFunction = (MathFunction)enumeration.nextElement();
                if (mathFunction.hashCode() != n) continue;
                bl = true;
                this.parentSApplet.removeDataSource(mathFunction.hashCode());
                this.functions.removeElement(mathFunction);
                if (!mathFunction.explicitTime) break;
                this.parentSApplet.clock.removeClockListener(mathFunction);
                break;
            }
        }
        Vector vector2 = this.cfunctions;
        synchronized (vector2) {
            Enumeration enumeration = this.cfunctions.elements();
            while (enumeration.hasMoreElements()) {
                ComplexFunction complexFunction = (ComplexFunction)enumeration.nextElement();
                if (complexFunction.hashCode() != n) continue;
                bl = true;
                this.parentSApplet.removeDataSource(complexFunction.hashCode());
                this.cfunctions.removeElement(complexFunction);
                if (!complexFunction.explicitTime) break;
                this.parentSApplet.clock.removeClockListener(complexFunction);
                break;
            }
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return bl;
    }

    public synchronized void deleteAllSeries() {
        this.clearAllThings();
        Object object = this.dataSetSeries.elements();
        while (object.hasMoreElements()) {
            Series series = (Series)object.nextElement();
            if (series.regression != null) {
                SApplet.dataSources.remove(Integer.toString(series.regression.hashCode()));
            }
            SApplet.dataSources.remove(Integer.toString(series.hashCode()));
        }
        this.dataSetSeries.removeAllElements();
        this.detachDataSets();
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        if (!this.xaxis.isManualRange()) {
            this.setMinMaxX(0.0, 1.0);
        }
        if (!this.yaxis.isManualRange()) {
            this.setMinMaxY(0.0, 1.0);
        }
        if (this.autoRefresh) {
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void deleteAllNonSeriesData() {
        Enumeration enumeration = this.dataset.elements();
        while (enumeration.hasMoreElements()) {
            DataSet dataSet = (DataSet)enumeration.nextElement();
            int n = this.getIDFromDataSet(dataSet);
            if (n != 0) continue;
            this.detachDataSet(dataSet);
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void deleteSeries(int n) {
        this.deleteSeries(n, true);
    }

    public void deleteSeries(int n, boolean bl) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid) continue;
            if (series.regression != null) {
                SApplet.dataSources.remove(Integer.toString(series.regression.hashCode()));
            }
            SApplet.dataSources.remove(Integer.toString(series.hashCode()));
            this.dataSetSeries.removeElement(series);
            this.detachDataSet(series.data);
            break;
        }
        if (this.dataSetSeries.size() == 0) {
            this.detachDataSets();
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        if (bl && this.autoRefresh) {
            this.repaint();
        }
    }

    public void setFunctionRange(int n, double d, double d2, int n2) {
        MathFunction mathFunction = null;
        Object object = this.functions.elements();
        while (object.hasMoreElements()) {
            mathFunction = (MathFunction)object.nextElement();
            if (mathFunction.hashCode() != n) continue;
            mathFunction.setFunctionRange(d, d2, n2);
        }
        object = null;
        Object object2 = this.cfunctions.elements();
        while (object2.hasMoreElements()) {
            object = (ComplexFunction)object2.nextElement();
            if (object.hashCode() != n) continue;
            ((ComplexFunction)object).setFunctionRange(d, d2);
        }
        if (this.parentSApplet != null) {
            if (this.parentSApplet.destroyed) {
                return;
            }
            this.parentSApplet.updateDataConnection(mathFunction.hashCode());
        }
        object2 = this.delayLock;
        synchronized (object2) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public void setFunctionClip(int n, double d, double d2) {
        MathFunction mathFunction = null;
        Object object = this.functions.elements();
        while (object.hasMoreElements()) {
            mathFunction = (MathFunction)object.nextElement();
            if (mathFunction.hashCode() != n) continue;
            mathFunction.setFunctionClip(d, d2);
        }
        if (this.parentSApplet != null) {
            if (this.parentSApplet.destroyed) {
                return;
            }
            this.parentSApplet.updateDataConnection(mathFunction.hashCode());
        }
        object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public void setYScaleFromFunction(int n) {
        SStepable sStepable;
        Object object = this.functions.elements();
        while (object.hasMoreElements()) {
            sStepable = (MathFunction)object.nextElement();
            if (sStepable.hashCode() != n) continue;
            this.setMinMaxY(((MathFunction)sStepable).ymin, ((MathFunction)sStepable).ymax);
        }
        object = this.cfunctions.elements();
        while (object.hasMoreElements()) {
            sStepable = (ComplexFunction)object.nextElement();
            if (sStepable.hashCode() != n) continue;
            this.setMinMaxY(((ComplexFunction)sStepable).ymin, ((ComplexFunction)sStepable).ymax);
        }
        object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public synchronized boolean setFunctionString(int n, String string) {
        MathFunction mathFunction = this.getFunction(n);
        if (mathFunction == null) {
            return false;
        }
        if (!mathFunction.setString(string)) {
            return false;
        }
        mathFunction.setScale();
        if (this.parentSApplet != null) {
            if (this.parentSApplet.destroyed) {
                return false;
            }
            this.parentSApplet.updateDataConnection(mathFunction.hashCode());
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
        return true;
    }

    public synchronized boolean setCFunctionStrings(int n, String string, String string2) {
        ComplexFunction complexFunction = this.getCFunction(n);
        if (complexFunction == null) {
            return false;
        }
        if (!complexFunction.setStringRe(string)) {
            return false;
        }
        if (!complexFunction.setStringIm(string2)) {
            return false;
        }
        complexFunction.setScale();
        if (this.parentSApplet != null) {
            if (this.parentSApplet.destroyed) {
                return false;
            }
            this.parentSApplet.updateDataConnection(complexFunction.hashCode());
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
        return true;
    }

    public String getFunctionString(int n) {
        MathFunction mathFunction = this.getFunction(n);
        if (mathFunction == null) {
            return "";
        }
        return mathFunction.getFunctionStr();
    }

    public String getReFunctionString(int n) {
        ComplexFunction complexFunction = this.getCFunction(n);
        if (complexFunction == null) {
            return "";
        }
        return complexFunction.getFunctionStrRe();
    }

    public String getImFunctionString(int n) {
        ComplexFunction complexFunction = this.getCFunction(n);
        if (complexFunction == null) {
            return "";
        }
        return complexFunction.getFunctionStrIm();
    }

    public synchronized boolean setFunctionVariable(int n, String string) {
        MathFunction mathFunction = this.getFunction(n);
        if (mathFunction == null) {
            return false;
        }
        mathFunction.setVariable(string);
        return true;
    }

    public synchronized boolean setFunction(int n, String string, String string2) {
        MathFunction mathFunction = this.getFunction(n);
        if (mathFunction == null) {
            return false;
        }
        if (!mathFunction.setString(string2)) {
            return false;
        }
        mathFunction.setVariable(string);
        mathFunction.setScale();
        if (this.parentSApplet != null) {
            if (this.parentSApplet.destroyed) {
                return false;
            }
            this.parentSApplet.updateDataConnection(mathFunction.hashCode());
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
        return true;
    }

    public Object clone() {
        int n;
        Object object;
        SGraph sGraph = new SGraph(this.parentSApplet);
        sGraph.autoRefresh = this.autoRefresh;
        sGraph.setSampleData(false);
        sGraph.setTitle(this.titleStr);
        sGraph.setTitleColor(this.titleColor);
        sGraph.setAutoscaleX(this.isAutoscaleX());
        sGraph.setAutoscaleY(this.isAutoscaleY());
        sGraph.setLabelX(this.labelX, this.labelXTitleColor);
        sGraph.setLabelY(this.labelY, this.labelYTitleColor);
        sGraph.setLabelXColor(this.labelXColor);
        sGraph.setLabelYColor(this.labelYColor);
        sGraph.setMinMaxX(this.getMinX(), this.getMaxX());
        sGraph.setMinMaxY(this.getMinY(), this.getMaxY());
        sGraph.defaultMarkerScale = this.defaultMarkerScale;
        sGraph.drawgrid = this.isDrawGrid();
        sGraph.drawzero = this.isDrawZero();
        sGraph.setEnableMouse(this.enableMouse);
        sGraph.setEnableClone(false);
        sGraph.setEnableCoordDisplay(this.enableCoordDisplay);
        sGraph.deleteAllSeries();
        for (int i = 0; i < this.dataSetSeries.size(); ++i) {
            object = (Series)this.dataSetSeries.elementAt(i);
            sGraph.addDataSeries((Series)object);
            sGraph.setLastPointMarker(((Series)object).sid, ((Series)object).enableLPCursor);
        }
        sGraph.deleteAllFunctions();
        object = this.functions.elements();
        while (object.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)object.nextElement();
            int n2 = sGraph.addFunction(mathFunction.variable, mathFunction.getFunctionStr());
            sGraph.setFunctionRange(n2, mathFunction.xmin, mathFunction.xmax, mathFunction.numPts);
            sGraph.setFunctionClip(n2, mathFunction.minClip, mathFunction.maxClip);
            sGraph.setObjectColor(n2, mathFunction.color);
        }
        Enumeration enumeration = this.cfunctions.elements();
        while (enumeration.hasMoreElements()) {
            object = (ComplexFunction)enumeration.nextElement();
            n = sGraph.addCFunction(((ComplexFunction)object).variable, ((ComplexFunction)object).getFunctionStrRe(), ((ComplexFunction)object).getFunctionStrRe(), ((ComplexFunction)object).centered);
            sGraph.setFunctionRange(n, ((ComplexFunction)object).xmin, ((ComplexFunction)object).xmax, 400);
            sGraph.setObjectColor(n, ((ComplexFunction)object).color);
        }
        boolean bl = sGraph.xaxis.manualRange;
        sGraph.xaxis.manualRange = true;
        n = sGraph.yaxis.manualRange;
        sGraph.yaxis.manualRange = true;
        sGraph.setMinMaxX(this.xaxis.minimum, this.xaxis.maximum);
        sGraph.setMinMaxY(this.yaxis.minimum, this.yaxis.maximum);
        sGraph.xaxis.manualRange = bl;
        sGraph.yaxis.manualRange = n;
        return sGraph;
    }

    public synchronized Series createSeries(int n) {
        Series series = this.getSeriesFromSID(n);
        if (series == null) {
            series = this.makeEmptySeries(n);
        }
        return series;
    }

    public void clearAllData() {
        int n = this.dataSetSeries.size();
        for (int i = 0; i < n; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            series.data.deleteData();
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void clearSeries(int n) {
        this.clearSeriesData(n);
    }

    public void clearAllSeries() {
        int n = this.dataSetSeries.size();
        for (int i = 0; i < n; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            series.data.deleteData();
            series.setOwner(this.parentSApplet);
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void clearSeriesData(int n) {
        int n2 = this.dataSetSeries.size();
        for (int i = 0; i < n2; ++i) {
            Series series = (Series)this.dataSetSeries.elementAt(i);
            if (n != series.sid || series.autoReplace) continue;
            series.data.deleteData();
            series.setOwner(this.parentSApplet);
            if (!this.autoRefresh) break;
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
                break;
            }
        }
    }

    public void adjustScale() {
        Vector vector;
        if (this.yaxis.isManualRange()) {
            return;
        }
        double d = this.yaxis.minimum;
        double d2 = this.yaxis.maximum;
        Vector vector2 = this.functions;
        synchronized (vector2) {
            vector = (Vector)this.functions.clone();
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            MathFunction mathFunction = (MathFunction)object.nextElement();
            d = Math.min(mathFunction.ymin, d);
            d2 = Math.max(mathFunction.ymax, d2);
        }
        Vector vector3 = this.cfunctions;
        synchronized (vector3) {
            vector = (Vector)this.cfunctions.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ComplexFunction)enumeration.nextElement();
            d = Math.min(((ComplexFunction)object).ymin, d);
            d2 = Math.max(((ComplexFunction)object).ymax, d2);
        }
        if (d == d2) {
            d -= 0.5;
            d2 += 0.5;
        }
        this.yaxis.minimum = d;
        this.yaxis.maximum = d2;
        this.yaxis.calculateGridLabels();
    }

    public void paintFunctions(Graphics graphics, Rectangle rectangle) {
        Vector vector = this.functions;
        synchronized (vector) {
            Enumeration enumeration = this.functions.elements();
            while (enumeration.hasMoreElements()) {
                MathFunction mathFunction = (MathFunction)enumeration.nextElement();
                mathFunction.paint(graphics, rectangle);
            }
        }
        Vector vector2 = this.cfunctions;
        synchronized (vector2) {
            Enumeration enumeration = this.cfunctions.elements();
            while (enumeration.hasMoreElements()) {
                ComplexFunction complexFunction = (ComplexFunction)enumeration.nextElement();
                complexFunction.paint(graphics, rectangle);
            }
        }
    }

    public void repaint() {
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public void startPaintThread() {
        if (this.delayThread != null) {
            return;
        }
        this.interrupted = false;
        this.delayThread = new Thread(this);
        this.newData = true;
        this.delayThread.start();
    }

    public void destroy() {
        this.interrupted = true;
        if (this.delayThread == null) {
            return;
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
        Thread thread = this.delayThread;
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.delayThread = null;
    }

    public void run() {
        while (!this.interrupted) {
            Object object = this.delayLock;
            synchronized (object) {
                if (!this.newData) {
                    try {
                        this.delayLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                this.newData = false;
                if (!this.interrupted) {
                    this.paintOffScreen();
                }
            }
            if (this.interrupted) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void paintOffScreen(Graphics graphics) {
        if (this.parentSApplet != null && this.parentSApplet.destroyed) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n < 10 || n2 < 10) {
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        if (this.offScreenImage == null || this.offScreenImage.getWidth(this) != n || this.offScreenImage.getHeight(this) != n2) {
            this.offScreenImage = this.createImage(n, n2);
        }
        if (this.offScreenImage == null) {
            return;
        }
        Image image = this.offScreenImage;
        synchronized (image) {
            Graphics graphics2 = this.offScreenImage.getGraphics();
            if (this.parentSApplet != null && this.parentSApplet.destroyed) {
                return;
            }
            this.update(graphics2);
            graphics.drawImage(this.offScreenImage, 0, 0, n, n2, this);
            if (this.mouseDrag) {
                this.drawCoords(this.mouseX, this.mouseY);
            }
            graphics2.dispose();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.sync();
        }
    }

    public void paintOffScreen() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            this.repaint();
            return;
        }
        this.paintOffScreen(graphics);
        graphics.dispose();
    }

    public void paintBeforeData(Graphics graphics, Rectangle rectangle) {
        Vector vector;
        if (!this.hasGraphThing) {
            return;
        }
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (thing instanceof GraphThing) {
                return;
            }
            thing.paint(graphics);
        }
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        Vector vector;
        boolean bl = false;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (thing instanceof GraphThing) {
                bl = true;
            }
            if (this.hasGraphThing && !bl) continue;
            thing.paint(graphics);
        }
        enumeration = this.dataSetSeries.elements();
        while (enumeration.hasMoreElements()) {
            Series series = (Series)enumeration.nextElement();
            series.paintLastPoint(graphics, rectangle);
        }
        if (this.titleStr != null) {
            graphics.setColor(this.titleColor);
            this.title.draw(graphics, rectangle.x + rectangle.width / 2, rectangle.y + Math.max(10 + rectangle.height / 20, 16), 0);
        }
        if (this.timeDisplay) {
            this.paintTime(graphics, rectangle);
        }
    }

    void paintTime(Graphics graphics, Rectangle rectangle) {
        if (!this.timeDisplay || this.parentSApplet == null) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
        graphics.setClip(rectangle2);
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.boldFont);
        String string = new Format("%7.4g").form(SUtil.chop(this.parentSApplet.clock.getTime(), 1.0E-12));
        graphics.drawString(String.valueOf(String.valueOf(this.label_time)).concat(String.valueOf(String.valueOf(string))), 10, this.getBounds().height - 5);
        graphics.setFont(font);
    }

    public int pixFromX(double d) {
        int n;
        try {
            n = this.xaxis.getInteger(d);
        }
        catch (Exception exception) {
            int n2 = 0;
            return n2;
        }
        return n;
    }

    public int pixFromY(double d) {
        int n;
        try {
            n = this.yaxis.getInteger(d);
        }
        catch (Exception exception) {
            int n2 = 0;
            return n2;
        }
        return n;
    }

    public double xFromPix(int n) {
        double d;
        try {
            d = this.xaxis.getDouble(n);
        }
        catch (Exception exception) {
            double d2 = 0.0;
            return d2;
        }
        return d;
    }

    public double yFromPix(int n) {
        double d;
        try {
            d = this.yaxis.getDouble(n);
        }
        catch (Exception exception) {
            double d2 = 0.0;
            return d2;
        }
        return d;
    }

    public synchronized DataSet addDataSet(double[] dArray, int n) {
        DataSet dataSet = this.loadDataSet(dArray, n);
        this.xaxis.attachDataSet(dataSet);
        this.yaxis.attachDataSet(dataSet);
        return dataSet;
    }

    private synchronized DataSet addDataSeries(Series series) {
        DataSet dataSet = null;
        this.addData(series.sid, series.getX(), series.getY(), series.getNumpts());
        dataSet = this.getDataSetFromSID(series.sid);
        if (dataSet == null) {
            System.out.println("Error: DataSet not created in SGraph.addDataSetSeries.");
            return null;
        }
        dataSet.markercolor = series.getDataSet().markercolor;
        dataSet.linestyle = series.getDataSet().linestyle;
        dataSet.linecolor = series.getDataSet().linecolor;
        dataSet.markercolor = series.getDataSet().markercolor;
        dataSet.markerscale = series.getDataSet().markerscale;
        dataSet.marker = series.getDataSet().marker;
        dataSet.legend(series.getDataSet().getLegend_ix(), series.getDataSet().getLegend_iy(), series.getDataSet().getLegend());
        dataSet.legendColor(series.getDataSet().linecolor);
        return dataSet;
    }

    public synchronized void addDatum(int n, double d, double d2) {
        Object object;
        Series series = this.getSeriesFromSID(n);
        this.dPoint[0] = d;
        this.dPoint[1] = d2;
        if (series == null) {
            series = this.attachArray(n, this.dPoint);
        } else {
            try {
                if (series.addRepeatedDatum) {
                    series.data.append(this.dPoint, 1);
                } else {
                    object = series.getLastPoint();
                    if (object == null || object[0] != d || object[1] != d2) {
                        series.data.append(this.dPoint, 1);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        if (!this.autoRefresh) {
            return;
        }
        object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public synchronized void addDatum(SDataSource sDataSource, int n, double d, double d2) {
        this.addDatum(n, d, d2);
    }

    public void clearAllThings() {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
            this.things.removeAllElements();
        }
        this.hasGraphThing = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            this.parentSApplet.removeDataListener(thing.hashCode());
            this.parentSApplet.removeDataSource(thing.hashCode());
            if (!(thing instanceof SStepable)) continue;
            this.parentSApplet.clock.removeClockListener(thing);
        }
    }

    public int addCursor(SApplet sApplet, int n, double d, double d2) {
        MarkerThing markerThing = new MarkerThing(sApplet, this, n, d, d2);
        this.things.addElement(markerThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return markerThing.hashCode();
    }

    public int addConnectorLine(SApplet sApplet, int n, int n2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        ConnectorLine connectorLine = new ConnectorLine(sApplet, this, thing, thing2);
        this.things.addElement(connectorLine);
        if (this.autoRefresh) {
            this.repaint();
        }
        return connectorLine.hashCode();
    }

    public synchronized boolean swapZOrder(int n, int n2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        int n3 = this.things.indexOf(thing);
        int n4 = this.things.indexOf(thing2);
        this.things.removeElementAt(n3);
        this.things.insertElementAt(thing2, n3);
        this.things.removeElementAt(n4);
        this.things.insertElementAt(thing, n4);
        return true;
    }

    public int addThing(Thing thing) {
        if (thing instanceof GraphThing) {
            this.hasGraphThing = true;
        }
        this.things.addElement(thing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return thing.hashCode();
    }

    public synchronized void addData(int n, double[] dArray, double[] dArray2) {
        this.addData(n, dArray, dArray2, dArray.length);
    }

    public synchronized void addData(SDataSource sDataSource, int n, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length || dArray.length == 0) {
            if (this.getSeriesFromSID(n) == null) {
                this.makeEmptySeries(n);
            }
            return;
        }
        int n2 = dArray.length;
        Series series = this.getSeriesFromSID(n);
        double[] dArray3 = new double[2 * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            dArray3[n3] = dArray[n4];
            dArray3[n3 + 1] = dArray2[n4];
            ++n4;
            n3 += 2;
        }
        if (series == null) {
            series = this.attachArray(n, dArray3);
        } else {
            try {
                series.data.replace(dArray3, n2);
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public synchronized void addData(int n, double[] dArray, double[] dArray2, int n2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length || n2 == 0) {
            if (this.getSeriesFromSID(n) == null) {
                this.makeEmptySeries(n);
            }
            return;
        }
        int n3 = dArray.length;
        if (n3 > n2) {
            n3 = n2;
        }
        Series series = this.getSeriesFromSID(n);
        double[] dArray3 = new double[2 * n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            dArray3[n4] = dArray[n5];
            dArray3[n4 + 1] = dArray2[n5];
            ++n5;
            n4 += 2;
        }
        if (series == null) {
            series = this.attachArray(n, dArray3);
        } else {
            try {
                if (series.autoReplace) {
                    series.data.replace(dArray3, n3);
                    Object object = this.delayLock;
                    synchronized (object) {
                        this.newData = true;
                        this.delayLock.notify();
                    }
                    return;
                }
                series.data.append(dArray3, n3);
            }
            catch (Exception exception) {
                System.out.println("Error appending Data!");
            }
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public synchronized int addFunction(String string, String string2) {
        MathFunction mathFunction = new MathFunction(string, string2);
        Vector vector = this.functions;
        synchronized (vector) {
            this.functions.addElement(mathFunction);
            if (this.datarect != null && this.datarect.width > 20) {
                Rectangle rectangle = this.datarect;
                mathFunction.xmin = this.xFromPix(rectangle.x);
                mathFunction.xmax = this.xFromPix(rectangle.x + rectangle.width - 1);
                mathFunction.numPts = rectangle.width;
                mathFunction.setScale();
            } else {
                mathFunction.xmin = -1.0;
                mathFunction.xmax = 1.0;
                mathFunction.numPts = 200;
                mathFunction.setScale();
            }
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return mathFunction.hashCode();
    }

    public synchronized int addVectorField(String string, String string2, int n) {
        VectorFieldThing vectorFieldThing = new VectorFieldThing(string, string2, n);
        this.things.addElement(vectorFieldThing);
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
        return vectorFieldThing.hashCode();
    }

    public synchronized int addCFunction(String string, String string2, String string3, boolean bl) {
        ComplexFunction complexFunction = new ComplexFunction(string, string2, string3);
        complexFunction.centered = bl;
        Vector vector = this.cfunctions;
        synchronized (vector) {
            this.cfunctions.addElement(complexFunction);
            if (this.datarect != null && this.datarect.width > 20) {
                Rectangle rectangle = this.datarect;
                complexFunction.xmin = this.xFromPix(rectangle.x);
                complexFunction.xmax = this.xFromPix(rectangle.x + rectangle.width - 1);
                complexFunction.setScale();
            } else {
                complexFunction.xmin = -1.0;
                complexFunction.xmax = 1.0;
                complexFunction.setScale();
            }
        }
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return complexFunction.hashCode();
    }

    public synchronized int addFunction(String string) {
        return this.addFunction("x", string);
    }

    public void loadFile(int n, String string) {
        Object object;
        boolean bl = false;
        Applet applet = this.parentSApplet;
        if (applet == null) {
            applet = Util.getApplet(this);
        }
        if (applet == null) {
            System.out.println("File load failed. Applet not found.");
            return;
        }
        boolean bl2 = this.autoRefresh;
        this.autoRefresh = false;
        this.clearSeries(n);
        try {
            object = new URL(applet.getCodeBase(), string).openStream();
            this.readFile(n, (InputStream)object);
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            try {
                object = new URL(applet.getDocumentBase(), string).openStream();
                this.readFile(n, (InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                System.out.println("file load failed: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
                return;
            }
        }
        this.autoRefresh = bl2;
        if (this.autoRefresh) {
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    void readFile(int n, InputStream inputStream) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        block5: while (streamTokenizer.ttype != -1) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    break block5;
                }
                case 10: {
                    break;
                }
                case -3: {
                    if ("series".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        n = (int)streamTokenizer.nval;
                        this.clearSeries(n);
                        break;
                    }
                }
                case -2: {
                    double d = streamTokenizer.nval;
                    streamTokenizer.nextToken();
                    double d2 = streamTokenizer.nval;
                    this.addDatum(n, d, d2);
                }
            }
            while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                streamTokenizer.nextToken();
            }
        }
    }

    public int plotRegression(int n, int n2, int n3) {
        double d = 2.0;
        double d2 = 0.5;
        Series series = this.getSeriesFromSID(n);
        double[] dArray = series.getSlopeIntercept(n2, n3);
        d = dArray[0];
        d2 = dArray[1];
        String string = d2 >= 0.0 ? String.valueOf(String.valueOf(new StringBuffer("").append(d).append("*x+").append(d2))) : String.valueOf(String.valueOf(new StringBuffer("").append(d).append("*x-").append(Math.abs(d2))));
        return this.addFunction("x", string);
    }

    public void drawCoords(Graphics graphics, int n, int n2) {
        if (!this.enableCoordDisplay) {
            return;
        }
        String string = String.valueOf(String.valueOf(new StringBuffer("").append(this.format.form(this.xFromPix(n))).append(" , ").append(this.format.form(this.yFromPix(n2)))));
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
    }

    public void drawCoords(int n, int n2) {
        Graphics graphics = this.getGraphics();
        this.drawCoords(graphics, n, n2);
        graphics.dispose();
    }

    public boolean isEnableCoordDisplay() {
        return this.enableCoordDisplay;
    }

    public void setEnableCoordDisplay(boolean bl) {
        this.enableCoordDisplay = bl;
    }

    public boolean isEnableClone() {
        return this.enableClone;
    }

    public void setEnableClone(boolean bl) {
        this.enableClone = bl;
    }

    public boolean isEnableMouse() {
        return this.enableMouse;
    }

    public void setEnableMouse(boolean bl) {
        if (this.enableMouse == bl) {
            return;
        }
        this.enableMouse = bl;
        if (this.enableMouse) {
            this.mouseMotionAdapter = new SGraph_mouseMotionAdapter(this);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.mouseAdapter = new SGraph_mouseAdapter(this);
            this.addMouseListener(this.mouseAdapter);
        } else {
            this.removeMouseMotionListener(this.mouseMotionAdapter);
            this.removeMouseListener(this.mouseAdapter);
        }
    }

    public void setParentSApplet(SApplet sApplet) {
        this.parentSApplet = sApplet;
    }

    public void setFormat(String string) {
        this.format = new Format(string);
    }

    public String getFormat() {
        return this.format.toString();
    }

    static Color colorFromRadians(double d) {
        int n = (int)((double)45 + (double)45 * d / Math.PI);
        return colors[n];
    }

    static Color colorFromDegrees(int n) {
        if (n >= 0) {
            return colors[(45 + n / 4) % 90];
        }
        return colors[89 - (45 - n / 4) % 90];
    }

    private static void initColors() {
        double d = Math.PI;
        for (int i = 0; i < 91; ++i) {
            int n = (int)((double)255 * Math.sin(d * (double)i / (double)90) * Math.sin(d * (double)i / (double)90));
            int n2 = (int)((double)255 * Math.sin(d * (double)i / (double)90 + d / (double)3) * Math.sin(d * (double)i / (double)90 + d / (double)3));
            int n3 = (int)((double)255 * Math.sin(d * (double)i / (double)90 + (double)2 * d / (double)3) * Math.sin(d * (double)i / (double)90 + (double)2 * d / (double)3));
            SGraph.colors[i] = new Color(n3, n2, n);
        }
    }

    void sGraph_mousePressed(MouseEvent mouseEvent) {
        if (this.enableClone && (mouseEvent.getModifiers() & 4) != 0) {
            SGraphFrame sGraphFrame = new SGraphFrame((SGraph)this.clone());
            ((Component)sGraphFrame).setSize(this.getSize().width, this.getSize().height);
            sGraphFrame.show();
        } else {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.mouseDrag = true;
            Graphics graphics = this.getGraphics();
            int n = this.things.size();
            for (int i = 0; i < n; ++i) {
                Thing thing = (Thing)this.things.elementAt(i);
                if (thing.noDrag || !thing.isInsideThing(this.mouseX, this.mouseY)) continue;
                this.dragThing = thing;
            }
            if (this.dragThing != null) {
                this.sGraph_mouseDragged(mouseEvent);
            } else if (this.sketchMode && this.trailThing != null) {
                this.trailThing.clearTrail();
                this.parentSApplet.clearData(this.trailThing.hashCode());
                this.setCursor(Cursor.getPredefinedCursor(1));
                this.sGraph_mouseDragged(mouseEvent);
            }
            graphics.dispose();
            this.drawCoords(this.mouseX, this.mouseY);
        }
    }

    void sGraph_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.pixFromX(this.xaxis.maximum);
        int n2 = this.pixFromX(this.xaxis.minimum);
        if (this.mouseX < n2) {
            this.mouseX = n2;
        } else if (this.mouseX > n - 2) {
            this.mouseX = n - 2;
        }
        double d = this.xFromPix(this.mouseX);
        n2 = this.pixFromY(this.yaxis.maximum);
        n = this.pixFromY(this.yaxis.minimum);
        if (this.mouseY < n2) {
            this.mouseY = n2;
        } else if (this.mouseY > n - 2) {
            this.mouseY = n - 2;
        }
        double d2 = this.yFromPix(this.mouseY);
        if (this.dragThing != null) {
            this.dragThing.dragMe(d, d2);
            if (this.parentSApplet != null) {
                if (this.parentSApplet.destroyed) {
                    return;
                }
                this.parentSApplet.updateDataConnection(this.dragThing.hashCode());
            }
            if (this.parentSApplet != null || !this.parentSApplet.clock.isRunning()) {
                this.paintOffScreen();
            }
        } else if (this.sketchMode && this.trailThing != null) {
            d = Math.min(d, this.xaxis.maximum);
            d = Math.max(d, this.xaxis.minimum);
            d2 = Math.min(d2, this.yaxis.maximum);
            d2 = Math.max(d2, this.yaxis.minimum);
            this.trailThing.incTrail(d, d2);
            Graphics graphics = this.getGraphics();
            this.paintOffScreen(graphics);
            this.trailThing.paint(graphics);
            if (this.sketchImage != null) {
                graphics.drawImage(this.sketchImage, this.mouseX, this.mouseY - this.sketchImage.getHeight(this), this);
            }
            graphics.dispose();
            if (this.parentSApplet.destroyed) {
                return;
            }
            this.parentSApplet.updateDataConnection(this.trailThing.hashCode());
        }
        this.drawCoords(this.mouseX, this.mouseY);
    }

    void sGraph_mouseReleased(MouseEvent mouseEvent) {
        Object object;
        this.mouseDrag = false;
        Rectangle rectangle = this.getBounds();
        if (this.dragThing == null) {
            this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        } else {
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        this.dragThing = null;
        this.boxWidth = 0;
        if (this.sketchMode && this.trailThing != null) {
            this.attachDataSet(this.trailThing.dataset);
            this.xaxis.attachDataSet(this.trailThing.dataset);
            this.yaxis.attachDataSet(this.trailThing.dataset);
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        this.sGraph_mouseMoved(mouseEvent);
    }

    public void sGraph_mouseEntered(MouseEvent mouseEvent) {
        if (this.sketchMode) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void sGraph_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void sGraph_mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.isInsideDragableThing(n2, n = mouseEvent.getY())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (this.sketchMode) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    private Series attachArray(int n, double[] dArray) {
        if (dArray.length < 2) {
            return null;
        }
        int n2 = dArray.length / 2;
        DataSet dataSet = this.loadDataSet(dArray, n2);
        dataSet.linestyle = 1;
        dataSet.marker = 3;
        dataSet.markerscale = this.defaultMarkerScale;
        dataSet.markercolor = new Color(0, 0, 255);
        dataSet.linecolor = new Color(0, 0, 255);
        dataSet.legendColor(Color.black);
        this.xaxis.attachDataSet(dataSet);
        this.yaxis.attachDataSet(dataSet);
        Series series = new Series(n, dataSet);
        this.dataSetSeries.addElement(series);
        return series;
    }

    private Series makeEmptySeries(int n) {
        this.dPoint[0] = 0.0;
        this.dPoint[1] = 0.0;
        Series series = this.attachArray(n, this.dPoint);
        DataSet dataSet = series.getDataSet();
        dataSet.deleteData();
        return series;
    }

    private void makeSampleData(int n) {
        double[] dArray = new double[2 * n];
        int n2 = 0;
        int n3 = 0;
        n3 = 0;
        n2 = 0;
        while (n2 < n) {
            dArray[n3] = n3 - n;
            dArray[n3 + 1] = (double)60000 * Math.pow(dArray[n3] / (double)(n - 2), 2.0);
            ++n2;
            n3 += 2;
        }
        Series series = this.attachArray(1, dArray);
        DataSet dataSet = series.getDataSet();
        dataSet.legend(200, 100, "sample data");
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    private void buildMarkers(int n) {
        Markers markers = new Markers();
        this.setMarkers(markers);
        boolean[] blArray = new boolean[5];
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        blArray[0] = false;
        blArray[1] = true;
        blArray[2] = false;
        blArray[3] = true;
        nArray[0] = n;
        nArray[1] = -n;
        nArray[2] = -n;
        nArray[3] = n;
        nArray2[0] = n;
        nArray2[1] = -n;
        nArray2[2] = n;
        nArray2[3] = -n;
        markers.AddMarker(1, 4, blArray, nArray, nArray2);
        blArray[0] = false;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        nArray[0] = n;
        nArray[1] = -n;
        nArray[2] = -n;
        nArray[3] = n;
        nArray[4] = n;
        nArray2[0] = n;
        nArray2[1] = n;
        nArray2[2] = -n;
        nArray2[3] = -n;
        nArray2[4] = n;
        markers.AddMarker(2, 5, blArray, nArray, nArray2);
        markers.AddMarker(3, n, Markers.TYPE_CIRCLE);
        markers.AddMarker(4, n, Markers.TYPE_SQUARE);
    }

    class VectorFieldThing
    extends Thing
    implements Cloneable,
    SStepable {
        Parser parserFx = null;
        Parser parserFy = null;
        private Parser checkFunc = new Parser(2);
        boolean explicitTime = false;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        double time = 0.0;
        String stringFx = null;
        String stringFy = null;
        int gridSize = 0;
        VectorField field;
        double[][][] fieldData;

        VectorFieldThing(String string, String string2, int n) {
            super(SGraph.this);
            this.field = new VectorField(n, n);
            this.fieldData = this.field.resize(n, n);
            this.gridSize = n;
            this.xmin = SGraph.this.xaxis.minimum;
            this.xmax = SGraph.this.xaxis.maximum;
            this.ymin = SGraph.this.yaxis.minimum;
            this.ymax = SGraph.this.yaxis.maximum;
            string = string.trim();
            this.stringFx = new String(string);
            string2 = string2.trim();
            this.stringFy = new String(string2);
            this.explicitTime = this.checkFunctionForTime(this.stringFx) || this.checkFunctionForTime(this.stringFy);
            this.parserFx = new Parser(3);
            this.parserFx.defineVariable(1, "x");
            this.parserFx.defineVariable(2, "y");
            this.parserFx.defineVariable(3, "t");
            this.parserFx.define(string);
            this.parserFx.parse();
            if (this.parserFx.getErrorCode() != 0) {
                System.out.println("Failed to parse fx(x,y,t)): ".concat(String.valueOf(String.valueOf(string))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in VectorField: ").append(this.parserFx.getErrorString()).append(" at position ").append(this.parserFx.getErrorPosition()))));
            }
            this.parserFy = new Parser(3);
            this.parserFy.defineVariable(1, "x");
            this.parserFy.defineVariable(2, "y");
            this.parserFy.defineVariable(3, "t");
            this.parserFy.define(string2);
            this.parserFy.parse();
            if (this.parserFy.getErrorCode() != 0) {
                System.out.println("Failed to parse fy(x,y,t)): ".concat(String.valueOf(String.valueOf(string2))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in VectorField: ").append(this.parserFy.getErrorString()).append(" at position ").append(this.parserFy.getErrorPosition()))));
            }
            if (SGraph.this.parentSApplet != null) {
                this.time = ((SGraph)SGraph.this).parentSApplet.clock.getTime();
                if (this.explicitTime) {
                    ((SGraph)SGraph.this).parentSApplet.clock.addClockListener(this);
                }
            }
        }

        public void step(double d, double d2) {
            this.time = d2 + d;
            if (this.explicitTime && SGraph.this.autoRefresh) {
                Object object = SGraph.this.delayLock;
                synchronized (object) {
                    SGraph.this.newData = true;
                    SGraph.this.delayLock.notify();
                }
            }
        }

        boolean checkFunctionForTime(String string) {
            boolean bl = false;
            String string2 = new String(string);
            this.checkFunc.defineVariable(1, "x");
            this.checkFunc.defineVariable(2, "y");
            this.checkFunc.define(string2.toLowerCase());
            this.checkFunc.parse();
            bl = this.checkFunc.getErrorCode() != 0;
            return bl;
        }

        public void paint(Graphics graphics) {
            for (int i = 0; i < this.gridSize; ++i) {
                this.x = (this.xmax - this.xmin) * (double)i / (double)(this.gridSize - 1) + this.xmin;
                for (int j = 0; j < this.gridSize; ++j) {
                    double d;
                    this.y = (this.ymax - this.ymin) * (double)j / (double)(this.gridSize - 1) + this.ymin;
                    double d2 = this.parserFx.evaluate(this.x, this.y, this.time);
                    double d3 = Math.sqrt(d2 * d2 + (d = this.parserFy.evaluate(this.x, this.y, this.time)) * d);
                    if (d3 > 0.0) {
                        this.fieldData[j][i][0] = d2 / d3;
                        this.fieldData[j][i][1] = d / d3;
                        this.fieldData[j][i][2] = d3;
                        continue;
                    }
                    this.fieldData[j][i][0] = 0.0;
                    this.fieldData[j][i][1] = 0.0;
                    this.fieldData[j][i][2] = 0.0;
                }
            }
            this.field.paint(graphics, SGraph.this.datarect);
        }
    }

    class ComplexFunction
    implements Cloneable,
    SDataSource,
    SStepable {
        Parser parserIm = null;
        Parser parserRe = null;
        private Parser checkFunc = new Parser(1);
        boolean explicitTime = false;
        Color color = Color.black;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        double time = 0.0;
        boolean fixedRange = false;
        String[] varStrings = new String[]{"x", "y", "v", "a"};
        double[][] v = new double[100][4];
        SApplet owner = null;
        String stringRe = null;
        String stringIm = null;
        String variable = null;
        boolean centered = true;

        ComplexFunction(String string, String string2, String string3) {
            this.xmin = SGraph.this.xaxis.minimum;
            this.xmax = SGraph.this.xaxis.maximum;
            if (this.xmin >= this.xmax) {
                this.xmax += 1.0;
                this.xmin = this.xmax - 1.0;
            }
            string2 = string2.trim();
            this.stringRe = new String(string2);
            string3 = string3.trim();
            this.stringIm = new String(string3);
            this.variable = new String(string.trim());
            if (!string.equals("t")) {
                this.explicitTime = this.checkFunctionForTime(this.stringRe) || this.checkFunctionForTime(this.stringRe);
            }
            this.parserRe = new Parser(2);
            this.parserRe.defineVariable(1, string);
            if (!string.equals("t")) {
                this.parserRe.defineVariable(2, "t");
            } else {
                this.parserRe.defineVariable(2, "time");
            }
            this.parserRe.define(string2);
            this.parserRe.parse();
            if (this.parserRe.getErrorCode() != 0) {
                System.out.println("Failed to parse f(x,t)): ".concat(String.valueOf(String.valueOf(string2))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in ComplexFunction: ").append(this.parserRe.getErrorString()).append(" at position ").append(this.parserRe.getErrorPosition()))));
            }
            this.parserIm = new Parser(2);
            this.parserIm.defineVariable(1, string);
            if (!string.equals("t")) {
                this.parserIm.defineVariable(2, "t");
            } else {
                this.parserIm.defineVariable(2, "time");
            }
            this.parserIm.define(string3);
            this.parserIm.parse();
            if (this.parserIm.getErrorCode() != 0) {
                System.out.println("Failed to parse f(x,t)): ".concat(String.valueOf(String.valueOf(string3))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in ComplexFunction: ").append(this.parserIm.getErrorString()).append(" at math position ").append(this.parserIm.getErrorPosition()))));
            }
            this.setScale();
            this.owner = SGraph.this.parentSApplet;
            try {
                SApplet.addDataSource(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.owner != null) {
                if (this.explicitTime) {
                    this.owner.clock.addClockListener(this);
                }
                this.time = this.owner.clock.getTime();
            }
        }

        public void step(double d, double d2) {
            this.time = d2 + d;
            if (SGraph.this.parentSApplet != null && ((SGraph)SGraph.this).parentSApplet.destroyed) {
                return;
            }
            this.owner.clearData(this.hashCode());
            this.owner.updateDataConnection(this.hashCode());
            if (SGraph.this.autoRefresh) {
                Object object = SGraph.this.delayLock;
                synchronized (object) {
                    SGraph.this.newData = true;
                    SGraph.this.delayLock.notify();
                }
            }
        }

        public boolean setStringIm(String string) {
            string = string.trim();
            this.stringIm = new String(string);
            this.parserIm.define(string);
            this.parserIm.parse();
            if (this.parserIm.getErrorCode() != 0) {
                System.out.println("Failed to parse f(x,t)): ".concat(String.valueOf(String.valueOf(string))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in ComplexFunction: ").append(this.parserIm.getErrorString()).append(" at position ").append(this.parserIm.getErrorPosition()))));
                return false;
            }
            this.setScale();
            if (this.owner != null) {
                if (SGraph.this.parentSApplet != null && ((SGraph)SGraph.this).parentSApplet.destroyed) {
                    return false;
                }
                this.owner.clearData(this.hashCode());
                this.owner.updateDataConnection(this.hashCode());
            }
            return true;
        }

        public boolean setStringRe(String string) {
            string = string.trim();
            this.stringRe = new String(string);
            this.parserRe.define(string);
            this.parserRe.parse();
            if (this.parserRe.getErrorCode() != 0) {
                System.out.println("Failed to parse Re(x,t)): ".concat(String.valueOf(String.valueOf(string))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in ComplexFunction: ").append(this.parserRe.getErrorString()).append(" at position ").append(this.parserRe.getErrorPosition()))));
                return false;
            }
            this.setScale();
            if (this.owner != null) {
                if (SGraph.this.parentSApplet != null && ((SGraph)SGraph.this).parentSApplet.destroyed) {
                    return false;
                }
                this.owner.clearData(this.hashCode());
                this.owner.updateDataConnection(this.hashCode());
            }
            return true;
        }

        String getString() {
            return this.variable;
        }

        void setVariable(String string) {
            this.variable = new String(string.trim());
            this.parserRe.defineVariable(1, string);
            this.parserIm.defineVariable(1, string);
        }

        String getVariable() {
            return this.variable;
        }

        boolean checkFunctionForTime(String string) {
            boolean bl = false;
            String string2 = new String(string);
            this.checkFunc.defineVariable(1, "x");
            this.checkFunc.define(string2.toLowerCase());
            this.checkFunc.parse();
            bl = this.checkFunc.getErrorCode() != 0;
            return bl;
        }

        public void setOwner(SApplet sApplet) {
            this.owner = sApplet;
        }

        public SApplet getOwner() {
            return this.owner;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public final int getID() {
            return this.hashCode();
        }

        Parser getParserRe() {
            return this.parserRe;
        }

        Parser getParserIm() {
            return this.parserIm;
        }

        String getFunctionStrRe() {
            return this.parserRe.getFunctionString();
        }

        String getFunctionStrIm() {
            return this.parserIm.getFunctionString();
        }

        void setFunctionRange(double d, double d2) {
            if (d >= d2) {
                this.fixedRange = false;
                return;
            }
            this.xmin = d;
            this.xmax = d2;
            this.fixedRange = true;
        }

        void paint(Graphics graphics, Rectangle rectangle) {
            this.paint1(graphics, rectangle);
        }

        void paint1(Graphics graphics, Rectangle rectangle) {
            if (rectangle.width < 3) {
                return;
            }
            Shape shape = graphics.getClip();
            graphics.setClip(rectangle);
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            int n3 = SGraph.this.pixFromY(0.0);
            double d3 = SGraph.this.xFromPix(rectangle.x);
            double d4 = SGraph.this.xFromPix(rectangle.x + rectangle.width - 1);
            double d5 = this.parserRe.evaluate(this.xmin, this.time);
            double d6 = this.parserIm.evaluate(this.xmin, this.time);
            this.ymax = this.ymin = Math.sqrt(d5 * d5 + d6 * d6);
            for (int i = 1; i < rectangle.width - 1; ++i) {
                d = SGraph.this.xFromPix(rectangle.x + i);
                if (this.fixedRange && (d < this.xmin || d > this.xmax)) continue;
                d5 = this.parserRe.evaluate(d, this.time);
                d6 = this.parserIm.evaluate(d, this.time);
                d2 = Math.sqrt(d5 * d5 + d6 * d6);
                graphics.setColor(SGraph.colorFromRadians(Math.atan2(d6, d5)));
                if (d2 < this.ymin) {
                    this.ymin = d2;
                }
                if (d2 > this.ymax) {
                    this.ymax = d2;
                }
                if (this.centered) {
                    n = SGraph.this.pixFromY(-d2 / (double)2);
                    n2 = SGraph.this.pixFromY(d2 / (double)2);
                } else {
                    n = n3;
                    n2 = SGraph.this.pixFromY(d2);
                }
                graphics.drawLine(rectangle.x + i, n, rectangle.x + i, n2);
            }
            graphics.setClip(shape);
        }

        public double[][] getVariables() {
            return this.v;
        }

        void setScale() {
            int n = 500;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = (this.xmax - this.xmin) / (double)(n - 1);
            d = this.xmin;
            double d4 = this.parserRe.evaluate(d, this.time);
            double d5 = this.parserIm.evaluate(d, this.time);
            this.ymax = this.ymin = Math.sqrt(d4 * d4 + d5 * d5);
            for (int i = 1; i < n; ++i) {
                d4 = this.parserRe.evaluate(d += d3, this.time);
                d5 = this.parserIm.evaluate(d, this.time);
                d2 = Math.sqrt(d4 * d4 + d5 * d5);
                this.ymin = Math.min(this.ymin, d2);
                this.ymax = Math.max(this.ymax, d2);
            }
        }
    }

    public class MathFunction
    implements Cloneable,
    SDataSource,
    SStepable {
        Parser parser = null;
        private Parser checkFunc = new Parser(1);
        boolean explicitTime = false;
        Color color = Color.black;
        int numPts = 100;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        double minClip;
        double maxClip = 0.0;
        double time = 0.0;
        boolean fixedRange = false;
        boolean functionClip = false;
        String[] varStrings = new String[]{"x", "y", "v", "a"};
        double[][] v = new double[this.numPts][4];
        SApplet owner = null;
        String string = null;
        String variable = null;
        public boolean visible = true;

        MathFunction(String string, String string2) {
            this.xmin = SGraph.this.xaxis.minimum;
            this.xmax = SGraph.this.xaxis.maximum;
            if (this.xmin >= this.xmax) {
                this.xmax += 1.0;
                this.xmin = this.xmax - 1.0;
            }
            string2 = string2.trim();
            this.variable = new String(string.trim());
            this.string = new String(string2);
            if (!string.equals("t")) {
                this.checkFunctionForTime(this.string);
            }
            this.parser = new Parser(2);
            this.parser.defineVariable(1, string);
            if (!string.equals("t")) {
                this.parser.defineVariable(2, "t");
            } else {
                this.parser.defineVariable(2, "time");
            }
            this.parser.define(string2);
            this.parser.parse();
            if (this.parser.getErrorCode() != 0) {
                System.out.println("Failed to parse f(x,t)): ".concat(String.valueOf(String.valueOf(string2))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in MathFunction: ").append(this.parser.getErrorString()).append(" at math function, position ").append(this.parser.getErrorPosition()))));
            } else {
                this.setScale();
            }
            this.owner = SGraph.this.parentSApplet;
            try {
                SApplet.addDataSource(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.owner != null) {
                if (this.explicitTime) {
                    this.owner.clock.addClockListener(this);
                }
                this.time = this.owner.clock.getTime();
            }
        }

        public void step(double d, double d2) {
            this.time = d2 + d;
            this.owner.clearData(this.hashCode());
            if (SGraph.this.parentSApplet != null && ((SGraph)SGraph.this).parentSApplet.destroyed) {
                return;
            }
            this.owner.updateDataConnection(this.hashCode());
            if (SGraph.this.autoRefresh) {
                Object object = SGraph.this.delayLock;
                synchronized (object) {
                    SGraph.this.newData = true;
                    SGraph.this.delayLock.notify();
                }
            }
        }

        public boolean setString(String string) {
            string = string.trim();
            this.string = new String(string);
            this.parser.define(string);
            this.parser.parse();
            if (this.parser.getErrorCode() != 0) {
                System.out.println("Failed to parse f(x,t)): ".concat(String.valueOf(String.valueOf(string))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in MathFunction: ").append(this.parser.getErrorString()).append(" at function 1, position ").append(this.parser.getErrorPosition()))));
                return false;
            }
            this.setScale();
            if (this.owner != null) {
                if (SGraph.this.parentSApplet != null && ((SGraph)SGraph.this).parentSApplet.destroyed) {
                    return false;
                }
                this.owner.clearData(this.hashCode());
                this.owner.updateDataConnection(this.hashCode());
            }
            return true;
        }

        String getString() {
            return this.variable;
        }

        void setVariable(String string) {
            this.variable = new String(string.trim());
            this.parser.defineVariable(1, string);
        }

        String getVariable() {
            return this.variable;
        }

        void checkFunctionForTime(String string) {
            String string2 = new String(string);
            this.checkFunc.defineVariable(1, "x");
            this.checkFunc.define(string2.toLowerCase());
            this.checkFunc.parse();
            this.explicitTime = this.checkFunc.getErrorCode() != 0;
        }

        public void setOwner(SApplet sApplet) {
            this.owner = sApplet;
        }

        public SApplet getOwner() {
            return this.owner;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public final int getID() {
            return this.hashCode();
        }

        Parser getParser() {
            return this.parser;
        }

        String getFunctionStr() {
            return this.parser.getFunctionString();
        }

        void setFunctionRange(double d, double d2, int n) {
            if (n < 1) {
                this.fixedRange = false;
                return;
            }
            this.xmin = d;
            this.xmax = d2;
            this.numPts = n;
            if (this.numPts != this.v.length) {
                this.v = new double[this.numPts][4];
            }
            this.fixedRange = true;
        }

        void setFunctionClip(double d, double d2) {
            if (d >= d2) {
                this.functionClip = false;
                return;
            }
            this.minClip = d;
            this.maxClip = d2;
            this.functionClip = true;
        }

        void paint(Graphics graphics, Rectangle rectangle) {
            if (!this.visible) {
                return;
            }
            if (this.fixedRange) {
                this.paint2(graphics, rectangle);
            } else {
                this.paint1(graphics, rectangle);
            }
        }

        void paint1(Graphics graphics, Rectangle rectangle) {
            this.numPts = rectangle.width;
            if (this.numPts != this.v.length) {
                this.v = new double[this.numPts][4];
            }
            if (this.numPts < 1) {
                return;
            }
            Shape shape = graphics.getClip();
            graphics.setClip(rectangle);
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            this.xmin = SGraph.this.xFromPix(rectangle.x);
            this.xmax = SGraph.this.xFromPix(rectangle.x + rectangle.width - 1);
            d = this.xmin;
            d3 = this.ymin = this.parser.evaluate(d, this.time);
            this.ymax = this.ymin;
            n = SGraph.this.pixFromY(this.ymin);
            graphics.setColor(this.color);
            for (int i = 1; i < rectangle.width; ++i) {
                d2 = SGraph.this.xFromPix(rectangle.x + i);
                d4 = this.parser.evaluate(d2, this.time);
                if (!this.functionClip || d4 > this.minClip && d4 < this.maxClip) {
                    if (d4 < this.ymin) {
                        this.ymin = d4;
                    }
                    if (d4 > this.ymax) {
                        this.ymax = d4;
                    }
                }
                n2 = SGraph.this.pixFromY(d4);
                if (!this.functionClip || d3 > this.minClip && d3 < this.maxClip && d4 > this.minClip && d4 < this.maxClip) {
                    graphics.drawLine(rectangle.x + i - 1, n, rectangle.x + i, n2);
                }
                n = n2;
                d3 = d4;
            }
            graphics.setClip(shape);
        }

        void paint2(Graphics graphics, Rectangle rectangle) {
            if (this.numPts < 1) {
                return;
            }
            Shape shape = graphics.getClip();
            graphics.setClip(rectangle);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = (this.xmax - this.xmin) / (double)(this.numPts - 1);
            d = this.xmin;
            n = SGraph.this.pixFromX(d);
            this.ymax = this.ymin = this.parser.evaluate(d, this.time);
            n3 = SGraph.this.pixFromY(this.ymin);
            graphics.setColor(this.color);
            for (int i = 1; i < this.numPts; ++i) {
                n2 = SGraph.this.pixFromX(d += d3);
                d2 = this.parser.evaluate(d, this.time);
                if (d2 < this.ymin) {
                    this.ymin = d2;
                }
                if (d2 > this.ymax) {
                    this.ymax = d2;
                }
                n4 = SGraph.this.pixFromY(d2);
                graphics.drawLine(n, n3, n2, n4);
                n = n2;
                n3 = n4;
            }
            graphics.setClip(shape);
        }

        public double[][] getVariables() {
            double[][] dArray = this.v;
            int n = dArray.length;
            Vector vector = SGraph.this.functions;
            synchronized (vector) {
                int n2;
                double d = SGraph.this.xaxis.minimum;
                double d2 = SGraph.this.xaxis.maximum;
                if (this.fixedRange) {
                    d = this.xmin;
                    d2 = this.xmax;
                }
                double d3 = (d2 - d) / (double)(n - 1);
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2][0] = d;
                    dArray[n2][1] = this.parser.evaluate(d, this.time);
                    d += d3;
                }
                if (n < 4) {
                    double[][] dArray2 = dArray;
                    return dArray2;
                }
                for (n2 = 2; n2 < n - 2; ++n2) {
                    dArray[n2][2] = (-dArray[n2 + 2][1] + (double)8 * dArray[n2 + 1][1] - (double)8 * dArray[n2 - 1][1] + dArray[n2 - 2][1]) / d3 / (double)12;
                    dArray[n2][3] = (-dArray[n2 + 2][1] + (double)16 * dArray[n2 + 1][1] - (double)30 * dArray[n2][1] + (double)16 * dArray[n2 - 1][1] - dArray[n2 - 2][1]) / d3 / d3 / (double)12;
                }
                d = SGraph.this.xaxis.minimum;
                dArray[1][2] = (-dArray[3][1] + (double)8 * dArray[2][1] - (double)8 * dArray[0][1] + this.parser.evaluate(d - d3, this.time)) / d3 / (double)12;
                dArray[0][2] = (-dArray[2][1] + (double)8 * dArray[1][1] - (double)8 * this.parser.evaluate(d - d3, this.time) + this.parser.evaluate(d - (double)2 * d3, this.time)) / d3 / (double)12;
                dArray[n - 1][2] = (-this.parser.evaluate(d2 + (double)2 * d3, this.time) + (double)8 * this.parser.evaluate(d2 + d3, this.time) - (double)8 * dArray[n - 2][1] + dArray[n - 3][1]) / d3 / (double)12;
                dArray[n - 2][2] = (-this.parser.evaluate(d2 + d3, this.time) + (double)8 * dArray[n - 1][1] - (double)8 * dArray[n - 3][1] + dArray[n - 4][1]) / d3 / (double)12;
                dArray[1][3] = (-dArray[3][1] + (double)16 * dArray[2][1] - (double)30 * dArray[1][1] + (double)16 * dArray[0][1] - this.parser.evaluate(d - d3, this.time)) / d3 / d3 / (double)12;
                dArray[0][3] = (-dArray[2][1] + (double)16 * dArray[1][1] - (double)30 * dArray[0][1] + (double)16 * this.parser.evaluate(d - d3, this.time) - this.parser.evaluate(d - (double)2 * d3, this.time)) / d3 / d3 / (double)12;
                dArray[n - 1][3] = (-this.parser.evaluate(d2 + (double)2 * d3, this.time) + (double)16 * this.parser.evaluate(d2 + d3, this.time) - (double)30 * dArray[n - 1][1] + (double)16 * dArray[n - 2][1] - dArray[n - 3][1]) / d3 / d3 / (double)12;
                dArray[n - 2][3] = (-this.parser.evaluate(d2 + d3, this.time) + (double)16 * dArray[n - 1][1] - (double)30 * dArray[n - 2][1] + (double)16 * dArray[n - 3][1] - dArray[n - 4][1]) / d3 / d3 / (double)12;
                double[][] dArray3 = dArray;
                return dArray3;
            }
        }

        void setScale() {
            if (this.numPts < 2) {
                return;
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = (this.xmax - this.xmin) / (double)(this.numPts - 1);
            d = this.xmin;
            d2 = this.parser.evaluate(d, this.time);
            this.ymin = !this.functionClip || d2 > this.minClip && d2 < this.maxClip ? (this.ymax = d2) : (this.ymax = this.minClip);
            for (int i = 1; i < this.numPts; ++i) {
                d2 = this.parser.evaluate(d += d3, this.time);
                if (this.functionClip && (!(d2 > this.minClip) || !(d2 < this.maxClip))) continue;
                this.ymin = Math.min(this.ymin, d2);
                this.ymax = Math.max(this.ymax, d2);
            }
        }
    }

    class Series
    implements SDataSource {
        private DataSet data;
        private int sid;
        boolean enableLPCursor = false;
        boolean addRepeatedDatum = true;
        String[] varStrings = new String[]{"x", "y", "u", "v"};
        SApplet owner = null;
        boolean autoReplace = false;
        RegressionDataSource regression = null;

        public Series(int n, DataSet dataSet) {
            this.sid = n;
            this.data = dataSet;
            this.owner = SGraph.this.parentSApplet;
            try {
                SApplet.addDataSource(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setOwner(SApplet sApplet) {
            this.owner = sApplet;
        }

        public SApplet getOwner() {
            return this.owner;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        DataSet getDataSet() {
            return this.data;
        }

        public final int getID() {
            return this.hashCode();
        }

        int getRegressionID(int n, int n2) {
            if (this.regression == null) {
                this.regression = new RegressionDataSource(this, n, n2);
            }
            return this.regression.getID();
        }

        void paintLastPoint(Graphics graphics, Rectangle rectangle) {
            int n = 2;
            int n2 = this.data.dataPoints();
            if (n2 < 1 || !this.enableLPCursor) {
                return;
            }
            double[] dArray = this.data.getLastPoint();
            if (dArray == null) {
                return;
            }
            int n3 = SGraph.this.pixFromX(dArray[0]);
            int n4 = SGraph.this.pixFromY(dArray[1]);
            if (this.data.marker > 0) {
                n = Math.max(n, (int)Math.round((double)4 * this.data.markerscale) - 1);
            }
            int n5 = n * 2 + 1;
            graphics.setColor(Color.red);
            graphics.fillOval(n3 - n - 1, n4 - n - 1, n5, n5);
            graphics.setColor(Color.black);
            graphics.drawOval(n3 - n - 1, n4 - n - 1, n5, n5);
        }

        double[] getLastPoint() {
            int n = this.data.dataPoints();
            if (n < 1) {
                return null;
            }
            double[] dArray = this.data.getPoint(n - 1);
            return dArray;
        }

        double[] getX() {
            double[] dArray = this.data.getData();
            int n = this.data.dataPoints();
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = dArray[2 * i];
            }
            return dArray2;
        }

        double[] getY() {
            double[] dArray = this.data.getData();
            int n = this.data.dataPoints();
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = dArray[2 * i + 1];
            }
            return dArray2;
        }

        int getNumpts() {
            return this.data.dataPoints();
        }

        public double[] getSlopeIntercept(int n, int n2) {
            int n3;
            double[] dArray = new double[2];
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n4 = this.data.dataPoints();
            int n5 = n2 <= n ? n4 : Math.min(n4, n2);
            if (n5 - (n3 = Math.max(1, n) - 1) < 2) {
                return dArray;
            }
            for (int i = n3; i < n5; ++i) {
                double[] dArray2 = this.data.getPoint(i);
                d += dArray2[0];
                d2 += dArray2[1];
                d3 += dArray2[0] * dArray2[0];
                d4 += dArray2[0] * dArray2[1];
            }
            dArray[0] = ((double)n4 * d4 - d * d2) / ((double)n4 * d3 - d * d);
            dArray[1] = d2 / (double)n4 - dArray[0] * d / (double)n4;
            return dArray;
        }

        public double[][] getVariables() {
            int n = this.data.dataPoints();
            double[][] dArray = new double[n][4];
            if (n < 1) {
                return dArray;
            }
            double[] dArray2 = this.data.getPoint(0);
            dArray[0][0] = dArray2[0];
            dArray[0][1] = dArray2[1];
            for (int i = 1; i < n; ++i) {
                dArray2 = this.data.getPoint(i);
                dArray[i][0] = dArray2[0];
                dArray[i][1] = dArray2[1];
                dArray[i][2] = dArray[i][0] - dArray[i - 1][0];
                dArray[i][3] = dArray[i][1] - dArray[i - 1][1];
            }
            return dArray;
        }
    }

    public class RegressionDataSource
    implements SDataSource {
        String[] regStrings = new String[]{"m", "b", "dm", "db"};
        double[][] ds = new double[1][4];
        Series series = null;
        SApplet owner = null;
        int start = 0;
        int end = 0;

        RegressionDataSource(Series series, int n, int n2) {
            this.owner = SGraph.this.parentSApplet;
            this.series = series;
            this.start = n;
            this.end = n2;
            try {
                SApplet.addDataSource(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            this.ds[0][0] = 0.0;
            this.ds[0][1] = 0.0;
            this.ds[0][2] = 0.0;
            this.ds[0][3] = 0.0;
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double[] dArray = this.series.data.getData();
            int n3 = this.series.data.dataPoints();
            n2 = this.end <= this.start ? n3 : Math.min(n3, this.end);
            if (n2 - (n = Math.max(1, this.start) - 1) < 2) {
                return this.ds;
            }
            for (int i = n; i < n2; ++i) {
                double d5 = dArray[2 * i];
                double d6 = dArray[2 * i + 1];
                d += d5;
                d2 += d6;
                d3 += d5 * d5;
                d4 += d5 * d6;
            }
            double d7 = (double)n3 * d3 - d * d;
            if (d7 == 0.0) {
                this.ds[0][0] = 1.0E64;
                this.ds[0][1] = 1.0E64;
            }
            double d8 = ((double)n3 * d4 - d * d2) / d7;
            double d9 = (d3 * d2 - d * d4) / d7;
            this.ds[0][0] = d8;
            this.ds[0][1] = d9;
            if (n2 - n < 3) {
                return this.ds;
            }
            double d10 = 0.0;
            for (int i = n; i < n2; ++i) {
                double d11 = dArray[2 * i + 1] - d9 - d8 * dArray[2 * i];
                d10 += d11 * d11;
            }
            this.ds[0][2] = Math.sqrt(d10 * (double)n3 / d7 / (double)(n3 - 2));
            this.ds[0][3] = Math.sqrt(d10 * d3 / d7 / (double)(n3 - 2));
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.regStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return SGraph.this.parentSApplet;
        }
    }
}

