/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graph;

import edu.davidson.display.Format;
import edu.davidson.graph.DataSet;
import edu.davidson.graph.Graph2D;
import edu.davidson.graph.RTextLine;
import edu.davidson.graph.SpecialFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class Axis {
    private Format labelFormat = new Format("%5.2f");
    double rangeMinimum = 0.0;
    double rangeMaximum = 0.0;
    boolean rangeBounded = false;
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    static final int NUMBER_OF_TICS = 4;
    public boolean drawgrid = false;
    public boolean drawzero = false;
    public Color gridcolor = null;
    public Color zerocolor = null;
    public boolean redraw = true;
    public boolean force_end_labels = false;
    public int major_tic_size = 10;
    public int minor_tic_size = 5;
    public int minor_tic_count = 1;
    public Color axiscolor;
    public double minimum;
    public double maximum;
    public Dimension data_window = new Dimension(0, 0);
    public Graph2D g2d = null;
    protected Point amin;
    protected Point amax;
    protected int orientation;
    protected int position;
    protected int width = 0;
    protected RTextLine title = new RTextLine();
    protected RTextLine label = new RTextLine("0");
    protected RTextLine exponent = new RTextLine();
    protected int max_label_width = 0;
    protected Vector dataset = new Vector();
    protected String[] label_string = null;
    protected float[] label_value = null;
    protected double label_start = 0.0;
    protected double label_step = 0.0;
    protected int label_exponent = 0;
    protected int label_count = 0;
    protected int guess_label_number = 4;
    public boolean manualRange = false;

    public void setMinRange(boolean bl, double d, double d2) {
        this.rangeBounded = bl;
        this.rangeMinimum = d;
        this.rangeMaximum = d2;
        if (bl) {
            this.resetRange();
        }
    }

    public Axis() {
        this.orientation = 0;
        this.position = 5;
    }

    public Axis(int n) {
        this.setPosition(n);
        switch (this.position) {
            case 1: 
            case 2: {
                this.title.setRotation(90);
                break;
            }
            case 3: {
                this.title.setRotation(-90);
                break;
            }
            default: {
                this.title.setRotation(0);
            }
        }
    }

    public void setPosition(int n) {
        this.position = n;
        switch (this.position) {
            case 2: {
                this.orientation = 1;
                break;
            }
            case 3: {
                this.orientation = 1;
                break;
            }
            case 4: {
                this.orientation = 0;
                break;
            }
            case 5: {
                this.orientation = 0;
                break;
            }
            case 0: {
                this.orientation = 0;
                this.position = 5;
                break;
            }
            case 1: {
                this.orientation = 1;
                this.position = 2;
                break;
            }
            default: {
                this.orientation = 0;
                this.position = 5;
            }
        }
    }

    public void attachDataSet(DataSet dataSet) {
        if (this.orientation == 0) {
            this.attachXdata(dataSet);
        } else {
            this.attachYdata(dataSet);
        }
    }

    public void detachDataSet(DataSet dataSet) {
        boolean bl = false;
        if (dataSet == null) {
            return;
        }
        if (this.orientation == 0) {
            dataSet.xaxis = null;
        } else {
            dataSet.yaxis = null;
        }
        this.dataset.removeElement(dataSet);
        if (!this.manualRange && !this.dataset.isEmpty()) {
            this.resetRange();
        }
    }

    public void detachAll() {
        if (this.dataset.isEmpty()) {
            if (!this.manualRange) {
                this.minimum = 0.0;
                this.maximum = 1.0;
            }
            return;
        }
        if (this.orientation == 0) {
            for (int i = 0; i < this.dataset.size(); ++i) {
                DataSet dataSet = (DataSet)this.dataset.elementAt(i);
                dataSet.xaxis = null;
            }
        } else {
            for (int i = 0; i < this.dataset.size(); ++i) {
                DataSet dataSet = (DataSet)this.dataset.elementAt(i);
                dataSet.yaxis = null;
            }
        }
        this.dataset.removeAllElements();
        if (!this.manualRange) {
            this.minimum = 0.0;
            this.maximum = 1.0;
        }
    }

    public double getDataMin() {
        if (this.dataset.isEmpty()) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        if (this.orientation == 0) {
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                DataSet dataSet = (DataSet)enumeration.nextElement();
                if (dataSet.length <= 0) continue;
                d = Math.min(dataSet.getXmin(), d);
            }
        } else {
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                DataSet dataSet = (DataSet)enumeration.nextElement();
                if (dataSet.length <= 0) continue;
                d = Math.min(dataSet.getYmin(), d);
            }
        }
        return d;
    }

    public double getDataMax() {
        if (this.dataset.isEmpty()) {
            return 1.0;
        }
        double d = -1.7976931348623157E308;
        if (this.orientation == 0) {
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                DataSet dataSet = (DataSet)enumeration.nextElement();
                if (dataSet.length <= 0) continue;
                d = Math.max(dataSet.getXmax(), d);
            }
        } else {
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                DataSet dataSet = (DataSet)enumeration.nextElement();
                if (dataSet.length <= 0) continue;
                d = Math.max(dataSet.getYmax(), d);
            }
        }
        return d;
    }

    public int getInteger(double d) {
        int n = 0;
        if (this.amax == null || this.amin == null) {
            return 0;
        }
        if (this.maximum == this.minimum) {
            return (this.amax.x - this.amin.x) / 2;
        }
        if (this.orientation == 0) {
            double d2 = (double)(this.amax.x - this.amin.x) / (this.maximum - this.minimum);
            n = (int)((d - this.minimum) * d2);
            n = Math.max(n, -100000);
            n = Math.min(n, 100000);
            return this.amin.x + n;
        }
        double d3 = (double)(this.amax.y - this.amin.y) / (this.maximum - this.minimum);
        n = (int)((d - this.minimum) * d3);
        n = Math.max(n, -100000);
        n = Math.min(n, 100000);
        return this.amax.y - n;
    }

    public double getDouble(int n) {
        if (this.amax == null || this.amin == null) {
            return (this.maximum + this.minimum) / 2.0;
        }
        if (this.orientation == 0) {
            double d = (this.maximum - this.minimum) / (double)(this.amax.x - this.amin.x);
            return this.minimum + (double)(n - this.amin.x) * d;
        }
        double d = (this.maximum - this.minimum) / (double)(this.amax.y - this.amin.y);
        return this.maximum - (double)(n - this.amin.y) * d;
    }

    public void resetRange() {
        if (this.manualRange || this.dataset.isEmpty()) {
            if (this.rangeBounded) {
                if (this.minimum > this.rangeMinimum) {
                    this.minimum = this.rangeMinimum;
                }
                if (this.maximum < this.rangeMaximum) {
                    this.maximum = this.rangeMaximum;
                }
            }
            if (this.minimum >= this.maximum) {
                this.maximum = this.minimum + 1.0;
            }
            return;
        }
        this.minimum = this.getDataMin();
        this.maximum = this.getDataMax();
        if (this.minimum == Double.MAX_VALUE || this.maximum == Double.MIN_VALUE) {
            this.minimum = 0.0;
            this.maximum = 1.0;
        }
        if (this.minimum == this.maximum) {
            if (this.dataset.isEmpty()) {
                this.minimum = 0.0;
                this.maximum = 1.0;
            } else if (this.maximum < (double)20) {
                this.minimum -= 1.0;
                this.maximum += 1.0;
            } else {
                this.minimum -= 0.1 * this.maximum;
                this.maximum += 0.1 * this.maximum;
            }
        }
        double d = this.maximum - this.minimum;
        double d2 = Math.max(Math.abs(this.maximum), Math.abs(this.minimum));
        if (d2 > 0.1 && d / d2 < 1.0E-4) {
            d = 1.0E-4;
        }
        if (this.rangeBounded) {
            if (this.minimum > this.rangeMinimum) {
                this.minimum = this.rangeMinimum;
            }
            if (this.maximum < this.rangeMaximum) {
                this.maximum = this.rangeMaximum;
            }
            this.minimum -= 0.05 * (this.rangeMaximum - this.rangeMinimum);
            this.maximum += 0.05 * (this.rangeMaximum - this.rangeMinimum);
        } else {
            this.minimum -= 0.05 * d;
            this.maximum += 0.05 * d;
        }
    }

    public int getAxisPos() {
        return this.position;
    }

    public boolean isVertical() {
        return this.orientation != 0;
    }

    public int getAxisWidth(Graphics graphics) {
        this.width = 0;
        if (this.minimum == this.maximum) {
            this.resetRange();
        }
        if (this.minimum == this.maximum) {
            return 0;
        }
        this.calculateGridLabels();
        this.exponent.setText(null);
        if (this.label_exponent != 0) {
            this.exponent.copyState(this.label);
            this.exponent.setText("x10^".concat(String.valueOf(String.valueOf(String.valueOf(this.label_exponent)))));
        }
        if (this.orientation == 0) {
            this.width = this.label.getRHeight(graphics) + this.label.getLeading(graphics);
            this.width += Math.max(this.title.getRHeight(graphics), this.exponent.getRHeight(graphics));
        } else {
            for (int i = 0; i < this.label_string.length; ++i) {
                this.label.setText(" ".concat(String.valueOf(String.valueOf(this.label_string[i]))));
                this.width = Math.max(this.label.getRWidth(graphics), this.width);
            }
            this.max_label_width = this.width;
            this.width = 0;
            if (!this.title.isNull()) {
                this.width = Math.max(this.width, this.title.getRWidth(graphics) + this.title.charWidth(graphics, ' '));
            }
            if (!this.exponent.isNull()) {
                this.width = Math.max(this.width, this.exponent.getRWidth(graphics) + this.exponent.charWidth(graphics, ' '));
            }
            this.width += this.max_label_width;
        }
        return this.width;
    }

    public boolean positionAxis(int n, int n2, int n3, int n4) {
        this.amin = null;
        this.amax = null;
        if (this.orientation == 0 && n3 != n4) {
            return false;
        }
        if (this.orientation == 1 && n != n2) {
            return false;
        }
        this.amin = new Point(n, n3);
        this.amax = new Point(n2, n4);
        return true;
    }

    public void drawAxis(Graphics graphics) {
        try {
            if (!this.redraw) {
                return;
            }
            if (this.minimum == this.maximum) {
                this.resetRange();
                if (this.minimum == this.maximum) {
                    return;
                }
            }
            if (this.amin.equals(this.amax)) {
                return;
            }
            if (this.width == 0) {
                this.width = this.getAxisWidth(graphics);
            }
            Graphics graphics2 = graphics.create();
            if (this.force_end_labels && !this.manualRange) {
                this.minimum = this.label_start;
                this.maximum = this.minimum + (double)(this.label_count - 1) * this.label_step;
            }
            if (this.title != null) {
                this.title.setDrawingComponent(this.g2d);
            }
            if (this.label != null) {
                this.label.setDrawingComponent(this.g2d);
            }
            if (this.exponent != null) {
                this.exponent.setDrawingComponent(this.g2d);
            }
            if (this.orientation == 0) {
                this.drawHAxis(graphics2);
            } else {
                this.drawVAxis(graphics2);
            }
            graphics2.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTitleText(String string) {
        this.title.setText(string);
    }

    public void setTitleBackground(Color color) {
        this.title.setBackground(color);
    }

    public void setTitleColor(Color color) {
        this.title.setColor(color);
    }

    public void setTitleFont(Font font) {
        this.title.setFont(font);
    }

    public void setTitleRotation(int n) {
        this.title.setRotation(n);
    }

    public void setLabelColor(Color color) {
        this.label.setColor(color);
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
    }

    public void setExponentColor(Color color) {
        this.exponent.setColor(color);
    }

    public void setExponentFont(Font font) {
        this.exponent.setFont(font);
    }

    public boolean isManualRange() {
        return this.manualRange;
    }

    public void setManualRange(boolean bl) {
        this.manualRange = bl;
        this.resetRange();
        if (this.manualRange && this.maximum == this.minimum) {
            this.maximum = this.minimum + 1.0E-6;
        }
        this.calculateGridLabels();
    }

    public void setManualRange(boolean bl, double d, double d2) {
        this.manualRange = bl;
        this.minimum = d;
        this.maximum = d2;
        this.resetRange();
        this.calculateGridLabels();
    }

    protected void drawHAxis(Graphics graphics) {
        int n;
        int n2;
        int n3;
        double d = this.maximum - this.minimum;
        double d2 = this.minimum - d * 1.0E-4;
        double d3 = this.maximum + d * 1.0E-4;
        double d4 = (double)(this.amax.x - this.amin.x) / (this.maximum - this.minimum);
        if (this.axiscolor != null) {
            graphics.setColor(this.axiscolor);
        }
        if (this.g2d.showAxis) {
            graphics.drawLine(this.amin.x, this.amin.y, this.amax.x, this.amax.y);
        }
        int n4 = this.position == 4 ? 1 : -1;
        double d5 = this.label_step / (double)(this.minor_tic_count + 1);
        double d6 = this.label_start;
        for (n3 = 0; n3 < this.label_count; ++n3) {
            int n5;
            int n6;
            Color color;
            if (d6 >= d2 && d6 <= d3) {
                n2 = this.amin.y;
                n = this.amin.x + (int)((d6 - this.minimum) * d4);
                if ((double)Math.abs(this.label_value[n3]) <= 1.0E-4 && this.drawzero) {
                    color = graphics.getColor();
                    if (this.zerocolor != null) {
                        graphics.setColor(this.zerocolor);
                    }
                    if (this.g2d.showAxis) {
                        graphics.drawLine(n, n2, n, n2 + this.data_window.height * n4);
                    }
                    graphics.setColor(color);
                } else if (this.drawgrid) {
                    color = graphics.getColor();
                    if (this.gridcolor != null) {
                        graphics.setColor(this.gridcolor);
                    }
                    graphics.drawLine(n, n2, n, n2 + this.data_window.height * n4);
                    graphics.setColor(color);
                }
                n6 = n;
                n5 = n2 + this.major_tic_size * n4;
                if (this.g2d.showAxis) {
                    graphics.drawLine(n, n2, n6, n5);
                }
            }
            double d7 = d6 + d5;
            for (int i = 0; i < this.minor_tic_count; ++i) {
                if (d7 >= d2 && d7 <= d3) {
                    n2 = this.amin.y;
                    n = this.amin.x + (int)((d7 - this.minimum) * d4);
                    if (this.drawgrid) {
                        color = graphics.getColor();
                        if (this.gridcolor != null) {
                            graphics.setColor(this.gridcolor);
                        }
                        if (this.g2d.showAxis) {
                            graphics.drawLine(n, n2, n, n2 + this.data_window.height * n4);
                        }
                        graphics.setColor(color);
                    }
                    n6 = n;
                    n5 = n2 + this.minor_tic_size * n4;
                    if (this.g2d.showAxis) {
                        graphics.drawLine(n, n2, n6, n5);
                    }
                }
                d7 += d5;
            }
            d6 += this.label_step;
        }
        int n7 = this.position == 4 ? -this.label.getLeading(graphics) - this.label.getDescent(graphics) : this.label.getLeading(graphics) + this.label.getAscent(graphics);
        d6 = this.label_start;
        for (n3 = 0; n3 < this.label_count; ++n3) {
            if (d6 >= d2 && d6 <= d3) {
                n2 = this.amin.y + n7;
                n = this.amin.x + (int)((d6 - this.minimum) * d4);
                this.label.setText(this.label_string[n3]);
                this.label.draw(graphics, n, n2, 0);
            }
            d6 += this.label_step;
        }
        if (!this.exponent.isNull()) {
            n = this.amax.x;
            if (this.position == 4) {
                n2 = this.amin.y - this.label.getLeading(graphics) - this.label.getDescent(graphics) - this.exponent.getLeading(graphics) - this.exponent.getDescent(graphics);
            } else {
                n2 = this.amax.y + this.label.getLeading(graphics) + this.label.getAscent(graphics) + this.exponent.getLeading(graphics) + this.exponent.getAscent(graphics);
                n -= 25;
            }
            this.exponent.draw(graphics, n, n2, 1);
        }
        if (!this.title.isNull()) {
            n2 = this.position == 4 ? this.amin.y - this.label.getLeading(graphics) - this.label.getDescent(graphics) - this.title.getLeading(graphics) - this.title.getDescent(graphics) : this.amax.y + this.label.getLeading(graphics) + this.label.getAscent(graphics) + this.title.getLeading(graphics) + this.title.getAscent(graphics);
            n = this.amin.x + (this.amax.x - this.amin.x) / 2;
            this.title.draw(graphics, n, n2, 0);
        }
    }

    protected void drawVAxis(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        double d = this.maximum - this.minimum;
        double d2 = this.minimum - d * 1.0E-4;
        double d3 = this.maximum + d * 1.0E-4;
        double d4 = (double)(this.amax.y - this.amin.y) / (this.maximum - this.minimum);
        if (this.axiscolor != null) {
            graphics.setColor(this.axiscolor);
        }
        if (this.g2d.showAxis) {
            graphics.drawLine(this.amin.x, this.amin.y, this.amax.x, this.amax.y);
        }
        int n5 = this.position == 3 ? -1 : 1;
        double d5 = this.label_step / (double)(this.minor_tic_count + 1);
        double d6 = this.label_start;
        for (n3 = 0; n3 < this.label_count; ++n3) {
            int n6;
            int n7;
            Color color2;
            if (d6 >= d2 && d6 <= d3) {
                n2 = this.amin.x;
                n = this.amax.y - (int)((d6 - this.minimum) * d4);
                if ((double)Math.abs(this.label_value[n3]) <= 1.0E-4 && this.drawzero) {
                    color2 = graphics.getColor();
                    if (this.zerocolor != null) {
                        graphics.setColor(this.zerocolor);
                    }
                    if (this.g2d.showAxis) {
                        graphics.drawLine(n2, n, n2 + this.data_window.width * n5, n);
                    }
                    graphics.setColor(color2);
                } else if (this.drawgrid) {
                    color2 = graphics.getColor();
                    if (this.gridcolor != null) {
                        graphics.setColor(this.gridcolor);
                    }
                    graphics.drawLine(n2, n, n2 + this.data_window.width * n5, n);
                    graphics.setColor(color2);
                }
                n7 = n2 + this.major_tic_size * n5;
                n6 = n;
                if (this.g2d.showAxis) {
                    graphics.drawLine(n2, n, n7, n6);
                }
            }
            double d7 = d6 + d5;
            for (int i = 0; i < this.minor_tic_count; ++i) {
                if (d7 >= d2 && d7 <= d3) {
                    n2 = this.amin.x;
                    n = this.amax.y - (int)((d7 - this.minimum) * d4);
                    if (this.drawgrid) {
                        color2 = graphics.getColor();
                        if (this.gridcolor != null) {
                            graphics.setColor(this.gridcolor);
                        }
                        if (this.g2d.showAxis) {
                            graphics.drawLine(n2, n, n2 + this.data_window.width * n5, n);
                        }
                        graphics.setColor(color2);
                    }
                    n7 = n2 + this.minor_tic_size * n5;
                    n6 = n;
                    if (this.g2d.showAxis) {
                        graphics.drawLine(n2, n, n7, n6);
                    }
                }
                d7 += d5;
            }
            d6 += this.label_step;
        }
        d6 = this.label_start;
        for (n3 = 0; n3 < this.label_count; ++n3) {
            if (d6 >= d2 && d6 <= d3) {
                n2 = this.amin.x + n4;
                n = this.amax.y - (int)((d6 - this.minimum) * d4) + this.label.getAscent(graphics) / 2;
                if (this.position == 3) {
                    this.label.setText(" ".concat(String.valueOf(String.valueOf(this.label_string[n3]))));
                    this.label.draw(graphics, n2, n, 1);
                } else {
                    this.label.setText(String.valueOf(String.valueOf(this.label_string[n3])).concat(" "));
                    this.label.draw(graphics, n2, n, 2);
                }
            }
            d6 += this.label_step;
        }
        if (!this.exponent.isNull()) {
            n = this.amin.y;
            if (this.position == 3) {
                n2 = this.amin.x + this.max_label_width + this.exponent.charWidth(graphics, ' ');
                this.exponent.draw(graphics, n2, n, 1);
            } else {
                n2 = this.amin.x - this.max_label_width - this.exponent.charWidth(graphics, ' ');
                this.exponent.draw(graphics, n2 += 3, n += 5, 2);
            }
        }
        if (!this.title.isNull()) {
            n = this.amin.y + (this.amax.y - this.amin.y) / 2;
            if (this.title.getRotation() == 0 || this.title.getRotation() == 180) {
                if (this.position == 3) {
                    n2 = this.amin.x + this.max_label_width + this.title.charWidth(graphics, ' ');
                    this.title.draw(graphics, n2, n, 1);
                } else {
                    n2 = this.amin.x - this.max_label_width - this.title.charWidth(graphics, ' ');
                    this.title.draw(graphics, n2, n, 2);
                }
            } else {
                this.title.setJustification(0);
                n2 = this.position == 3 ? this.amin.x + this.max_label_width - this.title.getLeftEdge(graphics) + this.title.charWidth(graphics, ' ') : this.amin.x - this.max_label_width - this.title.getRightEdge(graphics) - this.title.charWidth(graphics, ' ');
                this.title.draw(graphics, n2, n);
            }
        }
    }

    protected void attachXdata(DataSet dataSet) {
        this.dataset.addElement(dataSet);
        dataSet.xaxis = this;
        if (this.manualRange) {
            return;
        }
        if (this.dataset.size() == 1) {
            this.minimum = dataSet.dxmin;
            this.maximum = dataSet.dxmax;
        } else {
            if (this.minimum > dataSet.dxmin) {
                this.minimum = dataSet.dxmin;
            }
            if (this.maximum < dataSet.dxmax) {
                this.maximum = dataSet.dxmax;
            }
        }
    }

    protected void attachYdata(DataSet dataSet) {
        this.dataset.addElement(dataSet);
        dataSet.yaxis = this;
        if (this.manualRange) {
            return;
        }
        if (this.dataset.size() == 1) {
            this.minimum = dataSet.dymin;
            this.maximum = dataSet.dymax;
        } else {
            if (this.minimum > dataSet.dymin) {
                this.minimum = dataSet.dymin;
            }
            if (this.maximum < dataSet.dymax) {
                this.maximum = dataSet.dymax;
            }
        }
    }

    public void calculateGridLabels() {
        if (Math.abs(this.minimum) == 0.0 && Math.abs(this.maximum) == 0.0) {
            this.maximum = this.minimum + 1.0E-6;
        }
        this.label_exponent = Math.abs(this.minimum) > Math.abs(this.maximum) ? (int)Math.floor(SpecialFunction.log10(Math.abs(this.minimum)) / 3.0) * 3 : (int)Math.floor(SpecialFunction.log10(Math.abs(this.maximum)) / 3.0) * 3;
        this.label_step = this.RoundUp((this.maximum - this.minimum) / (double)this.guess_label_number);
        double d = this.label_start = Math.floor(this.minimum / this.label_step) * this.label_step;
        this.label_count = 1;
        while (d < this.maximum) {
            d += this.label_step;
            ++this.label_count;
        }
        this.label_string = new String[this.label_count];
        this.label_value = new float[this.label_count];
        for (int i = 0; i < this.label_count; ++i) {
            int n;
            d = this.label_start + (double)i * this.label_step;
            if (this.label_exponent < 0) {
                for (n = this.label_exponent; n < 0; ++n) {
                    d *= (double)10;
                }
            } else {
                for (n = 0; n < this.label_exponent; ++n) {
                    d /= (double)10;
                }
            }
            this.label_string[i] = this.labelFormat.form(d);
            this.label_value[i] = (float)d;
        }
    }

    private double RoundUp(double d) {
        int n;
        int n2 = (int)Math.floor(SpecialFunction.log10(d));
        if (n2 < 0) {
            for (n = n2; n < 0; ++n) {
                d *= 10.0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                d /= 10.0;
            }
        }
        d = d > 5.0 ? 10.0 : (d > 2.0 ? 5.0 : (d > 1.0 ? 2.0 : 1.0));
        if (n2 < 0) {
            for (n = n2; n < 0; ++n) {
                d /= 10.0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                d *= 10.0;
            }
        }
        return d;
    }
}

