/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import edu.davidson.graphics.Orientation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ColumnLayout
implements LayoutManager {
    private static int _defaultGap = 5;
    private int gap;
    private Orientation horizontalOrientation;
    private Orientation verticalOrientation;

    public ColumnLayout() {
        this(Orientation.CENTER, Orientation.CENTER, _defaultGap);
    }

    public ColumnLayout(int n) {
        this(Orientation.CENTER, Orientation.CENTER, n);
    }

    public ColumnLayout(Orientation orientation, Orientation orientation2) {
        this(orientation, orientation2, _defaultGap);
    }

    public ColumnLayout(Orientation orientation, Orientation orientation2, int n) {
        if (n < 0 || orientation != Orientation.LEFT && orientation != Orientation.CENTER && orientation != Orientation.RIGHT || orientation2 != Orientation.TOP && orientation2 != Orientation.CENTER && orientation2 != Orientation.BOTTOM) {
            throw new IllegalArgumentException("bad gap or orientation");
        }
        this.gap = n;
        this.verticalOrientation = orientation2;
        this.horizontalOrientation = orientation;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            if (i > 0) {
                dimension.height += this.gap;
            }
            dimension.height += dimension2.height;
            dimension.width = Math.max(dimension2.width, dimension.width);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height;
            if (i <= 0) continue;
            dimension.height += this.gap;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = 0;
        int n3 = container.getComponentCount();
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        if (this.verticalOrientation == Orientation.CENTER) {
            n += dimension2.height / 2 - dimension.height / 2;
        } else if (this.verticalOrientation == Orientation.BOTTOM) {
            n = dimension2.height - dimension.height + insets.top;
        }
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            n2 = insets.left;
            if (!component.isVisible()) continue;
            Dimension dimension3 = component.getPreferredSize();
            if (this.horizontalOrientation == Orientation.CENTER) {
                n2 = dimension2.width / 2 - dimension3.width / 2;
            } else if (this.horizontalOrientation == Orientation.RIGHT) {
                n2 = dimension2.width - dimension3.width - insets.right;
            }
            component.setBounds(n2, n, dimension3.width, dimension3.height);
            n += dimension3.height + this.gap;
        }
    }
}

