/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graphics;

import java.awt.Button;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ThreadButton
extends Button
implements Runnable {
    ActionEvent evt = new ActionEvent(this, 1001, "THREAD");
    Color backgroundColor = Color.lightGray;
    Color downColor = Color.green;
    Thread thread = null;
    int longTick = 500;
    int shortTick = 100;
    private int tick = this.longTick;
    private boolean running = false;
    private int count = 0;
    private Object runLock = new Object();

    public ThreadButton() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void destroy() {
        Object object = this.runLock;
        synchronized (object) {
            this.thread = null;
            this.running = true;
            this.runLock.notifyAll();
        }
    }

    private synchronized void startThread() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            Object object = this.runLock;
            synchronized (object) {
                this.running = true;
                this.runLock.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void stopThread() {
        if (!this.running) {
            return;
        }
        this.running = false;
        Object object = this.runLock;
        // MONITORENTER : object
        // MONITOREXIT : object
        this.tick = this.longTick;
        this.count = 0;
    }

    public void run() {
        this.count = 0;
        while (this.thread != null && this.count < 100000) {
            Object object = this.runLock;
            synchronized (object) {
                while (!this.running) {
                    try {
                        this.runLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++this.count;
                if (this.thread != null) {
                    this.dispatchEvent(this.evt);
                }
                if (this.count > 0) {
                    this.tick = this.shortTick;
                }
            }
            if (this.thread == null) continue;
            try {
                Thread.sleep(this.tick);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void jbInit() throws Exception {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ThreadButton.this.this_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ThreadButton.this.this_mouseReleased(mouseEvent);
            }
        });
    }

    synchronized void this_mousePressed(MouseEvent mouseEvent) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.setBackground(this.downColor);
        this.startThread();
    }

    synchronized void this_mouseReleased(MouseEvent mouseEvent) {
        this.setBackground(this.backgroundColor);
        this.stopThread();
        this.running = false;
    }
}

