/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.numerics;

import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SODE;

public final class SRK45Old
extends SODE {
    static double[][] b = new double[][]{{0.2222222222222222}, {0.08333333333333333, 0.25}, {0.5390625, -1.8984375, 2.109375}, {-1.4166666666666667, 6.75, -5.4, 1.0666666666666667}, {0.15046296296296297, -0.3125, 0.8125, 0.14814814814814814, 0.034722222222222224}};
    static double[] ch = new double[]{0.10444444444444445, 0.0, 0.48, 0.14222222222222222, 0.03333333333333333, 0.24};
    static double[] ct = new double[]{-0.006666666666666667, 0.0, 0.03, -0.21333333333333335, -0.05, 0.24};
    double h = 0.01;
    int numEqu = 0;
    double[] dydx;
    double[] xTemp;
    double[][] f;
    double[] truncErr;
    SDifferentiable equations;
    double err;
    double tol = 1.0E-8;
    double hmin = 1.0E-7;

    public double getH() {
        return this.h;
    }

    public void setH(double d) {
        this.h = d;
    }

    public double getTol() {
        return this.tol;
    }

    public void setTol(double d) {
        this.tol = d;
        this.hmin = this.tol * (double)10;
    }

    private int stepBack(double d, double[] dArray) {
        int n = 0;
        this.h = -Math.abs(this.h);
        while (d < 0.0) {
            if (this.h < d) {
                double d2 = this.h;
                this.h = d;
                d -= this.stepRK45(dArray);
                this.h = d2;
                ++n;
                continue;
            }
            d -= this.stepRK45(dArray);
            ++n;
        }
        this.h = Math.abs(this.h);
        return n;
    }

    public int step(double d, double[] dArray) {
        if (dArray.length < this.numEqu) {
            this.numEqu = dArray.length;
            this.xTemp = new double[this.numEqu];
            this.dydx = new double[this.numEqu];
            this.truncErr = new double[this.numEqu];
            this.f = new double[6][this.numEqu];
            System.out.println("Warning:  Temporary arrays reset.");
        }
        if (d < 0.0) {
            return this.stepBack(d, dArray);
        }
        int n = 0;
        while (d > 0.0) {
            if (this.h > d) {
                double d2 = this.h;
                this.h = d;
                d -= this.stepRK45(dArray);
                this.h = d2;
                ++n;
                continue;
            }
            d -= this.stepRK45(dArray);
            ++n;
        }
        return n;
    }

    public double stepODE(double d, double[] dArray) {
        if (dArray.length < this.numEqu) {
            System.out.println("Error:  The temporary arrays are not large enough.");
            return 0.0;
        }
        this.h = d;
        return this.stepRK45(dArray);
    }

    public double stepRK45(double[] dArray) {
        int n;
        double d = this.h;
        this.dydx = this.equations.rate(dArray);
        for (n = 0; n < this.numEqu; ++n) {
            this.f[0][n] = this.dydx[n];
            this.xTemp[n] = dArray[n];
        }
        this.err = (double)2 * this.tol;
        if (this.h >= 0.0 && this.h <= this.hmin) {
            this.h = 1.1 * this.hmin;
        } else if (this.h < 0.0 && -this.h <= this.hmin) {
            this.h = -1.1 * this.hmin;
        }
        while (this.err > this.tol && Math.abs(this.h) > this.hmin) {
            int n2;
            for (n2 = 1; n2 < 6; ++n2) {
                for (n = 0; n < this.numEqu; ++n) {
                    dArray[n] = this.xTemp[n];
                    for (int i = 0; i < n2; ++i) {
                        dArray[n] = dArray[n] + this.h * b[n2 - 1][i] * this.f[i][n];
                    }
                }
                this.dydx = this.equations.rate(dArray);
                for (n = 0; n < this.numEqu; ++n) {
                    this.f[n2][n] = this.dydx[n];
                }
            }
            for (n = 0; n < this.numEqu; ++n) {
                dArray[n] = this.xTemp[n];
                this.truncErr[n] = 0.0;
                for (n2 = 0; n2 < 6; ++n2) {
                    dArray[n] = dArray[n] + this.h * ch[n2] * this.f[n2][n];
                    this.truncErr[n] = this.truncErr[n] + this.h * ct[n2] * this.f[n2][n];
                }
                this.truncErr[n] = Math.abs(this.truncErr[n]);
            }
            this.err = 0.0;
            for (n = 0; n < this.numEqu; ++n) {
                if (!(this.err < this.truncErr[n])) continue;
                this.err = this.truncErr[n];
            }
            d = this.h;
            if (this.err == 0.0) {
                this.err = this.tol / 100000.0;
            }
            this.h = this.err > this.tol ? 0.9 * this.h * Math.pow(this.tol / this.err, 0.25) : 0.9 * this.h * Math.pow(this.tol / this.err, 0.2);
            if (this.h >= 0.0 && this.h < this.hmin) {
                this.h = this.hmin;
                continue;
            }
            if (!(this.h < 0.0) || !(-this.h < this.hmin)) continue;
            this.h = -this.hmin;
        }
        return d;
    }

    public final void setDifferentials(SDifferentiable sDifferentiable) {
        this.equations = sDifferentiable;
        this.numEqu = this.equations.getNumEqu();
        this.xTemp = new double[this.numEqu];
        this.dydx = new double[this.numEqu];
        this.truncErr = new double[this.numEqu];
        this.f = new double[6][this.numEqu];
    }

    public final SDifferentiable getDiffernetials() {
        return this.equations;
    }

    public final void setNumberOfEquations(int n) {
        this.numEqu = n;
        this.xTemp = new double[this.numEqu];
        this.dydx = new double[this.numEqu];
        this.truncErr = new double[this.numEqu];
        this.f = new double[6][this.numEqu];
    }
}

