/*
 * Decompiled with CFR 0.152.
 */
package optics;

import edu.davidson.display.SScalable;
import edu.davidson.display.Thing;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import optics.Aperature;
import optics.BeamStop;
import optics.BenchThing;
import optics.Dielectric;
import optics.ISource;
import optics.IndexChange;
import optics.Lens;
import optics.Matrix;
import optics.Mirror;
import optics.Mirror2;
import optics.OpticElement;
import optics.OpticsApplet;
import optics.PSource;
import optics.Refraction;
import optics.Screen;
import optics.Source;

public final class Bench
extends Panel
implements SScalable {
    int inc;
    int pixPerUnit = 100;
    int maxNumber = 100;
    int maxSNumber = 100;
    int widthOfLens;
    int spacingInt;
    int temp1;
    int temp2;
    PSource tempPSource = new PSource(this, 0, 0, 0.0, 0, true, false, 1.0, false);
    Vector v = new Vector();
    Vector sv = new Vector();
    Vector things = new Vector();
    Color rayColor = null;
    Color elementColor = null;
    DecimalFormat df = new DecimalFormat("0.##");
    int[] x = new int[this.maxNumber];
    int[] y = new int[this.maxNumber];
    int[] sx = new int[this.maxNumber];
    int[] sy = new int[this.maxNumber];
    int xOld;
    int xNew;
    int yOld;
    int yNew;
    int indexOfPSources;
    double mOld;
    double slope;
    double yNewDouble;
    double[] f = new double[this.maxNumber];
    double[] ray = new double[2];
    OpticElement activeElement = null;
    Thing dragThing = null;
    int isInsideOpticElement;
    boolean isControlDown;
    boolean blocked = false;
    boolean hasBench = false;
    Image osi = null;
    int iheight;
    int iwidth;
    int step;
    private int xDown = 0;
    private int yDown = 0;
    private int xLast = 0;
    private int yLast = 0;
    OpticsApplet owner = null;

    public Bench(OpticsApplet opticsApplet) {
        this.owner = opticsApplet;
        this.setBackground(Color.black);
        int n = this.addScreen(2000, 0, false, false, 1.0, false);
        OpticElement opticElement = this.getElement(n);
        opticElement.setPixX(2000, new Rectangle(0, 0));
        n = this.addScreen(-100, 0, false, false, 1.0, false);
        opticElement = this.getElement(n);
        opticElement.setPixX(-100, new Rectangle(0, 0));
    }

    void createOSI() {
        Rectangle rectangle = this.getBounds();
        this.iheight = rectangle.height;
        this.iwidth = rectangle.width;
        this.osi = this.createImage(this.iwidth, this.iheight);
    }

    public int getPixWidth() {
        return this.iwidth;
    }

    public int getPixHeight() {
        return this.iheight;
    }

    public double xFromPix(int n) {
        return (double)n / (double)this.pixPerUnit;
    }

    public int pixFromX(double d) {
        return (int)Math.round(d * (double)this.pixPerUnit);
    }

    public double yFromPix(int n) {
        return -((double)n - (double)this.iheight / 2.0) / (double)this.pixPerUnit;
    }

    public int pixFromY(double d) {
        return (int)Math.round((double)this.iheight / 2.0 - d * (double)this.pixPerUnit);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setPixPerUnit(int n) {
        OpticElement opticElement;
        int n2;
        this.pixPerUnit = n;
        for (n2 = 0; n2 < this.v.size(); ++n2) {
            opticElement = (OpticElement)((Object)this.v.elementAt(n2));
            opticElement.setPixPerUnit(this.pixPerUnit);
        }
        for (n2 = 0; n2 < this.sv.size(); ++n2) {
            opticElement = (OpticElement)((Object)this.sv.elementAt(n2));
            opticElement.setPixPerUnit(this.pixPerUnit);
        }
    }

    void setRayColor(Color color) {
        this.rayColor = color;
    }

    void setElementColor(Color color) {
        this.elementColor = color;
    }

    private void adjustHeight() {
        OpticElement opticElement;
        int n;
        int n2 = (this.getBounds().height - this.iheight) / 2;
        for (n = 0; n < this.v.size(); ++n) {
            opticElement = (OpticElement)((Object)this.v.elementAt(n));
            opticElement.yPosition += n2;
        }
        for (n = 0; n < this.sv.size(); ++n) {
            opticElement = (OpticElement)((Object)this.sv.elementAt(n));
            opticElement.yPosition += n2;
        }
    }

    public void paintThings(Graphics graphics) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
        }
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.osi == null || rectangle.width != this.iwidth || rectangle.height != this.iheight) {
            this.adjustHeight();
            this.iheight = rectangle.height;
            this.iwidth = rectangle.width;
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        if (this.osi == null) {
            return;
        }
        Graphics graphics2 = this.osi.getGraphics();
        if (graphics2 == null) {
            return;
        }
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, this.iwidth, this.iheight);
        if (!this.hasBench) {
            this.paintBench(graphics2);
        }
        this.paintThings(graphics2);
        if (this.activeElement != null) {
            this.drawCoords(graphics2, this.activeElement.getPixX(), this.activeElement.getPixY());
        }
        if (this.dragThing != null) {
            this.drawCoords(graphics2, this.pixFromX(this.dragThing.getX()), this.pixFromY(this.dragThing.getY()));
        }
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, this);
    }

    void paintBench(Graphics graphics) {
        OpticElement opticElement;
        int n;
        this.sort(this.v);
        Rectangle rectangle = this.getBounds();
        for (n = 0; n < this.v.size(); ++n) {
            opticElement = (OpticElement)((Object)this.v.elementAt(n));
            this.x[n] = opticElement.getPixX();
            this.y[n] = opticElement.getPixY();
            if (opticElement.getType() == "lens") {
                this.f[n] = opticElement.getFocalLength();
            }
            if (!opticElement.isVisible()) continue;
            opticElement.paint(graphics, rectangle);
        }
        for (n = 0; n < this.sv.size(); ++n) {
            opticElement = (OpticElement)((Object)this.sv.elementAt(n));
            this.sx[n] = opticElement.getPixX();
            this.sy[n] = opticElement.getPixY();
            if (!opticElement.isVisible()) continue;
            opticElement.paint(graphics, rectangle);
        }
        if (this.activeElement != null && this.activeElement.isVisible()) {
            this.activeElement.paintActive(graphics, rectangle);
        }
        graphics.setColor(Color.yellow);
        graphics.drawLine(0, rectangle.height / 2, rectangle.width, rectangle.height / 2);
        for (n = 0; n < this.sv.size(); ++n) {
            int n2;
            opticElement = (OpticElement)((Object)this.sv.elementAt(n));
            int n3 = 1;
            if (opticElement.getRayIncrement() != 0.0) {
                n3 = (int)Math.abs((double)2 * opticElement.getRaySlope() / opticElement.getRayIncrement());
            }
            n3 = Math.max(1, n3);
            n3 = Math.min(100, n3);
            double d = opticElement.getRayIncrement();
            if (opticElement.getRaySlope() > 0.0) {
                d *= (double)-1;
            }
            if (opticElement.getRayIncrement() != (double)3 && opticElement.getType() == "source") {
                this.slope = opticElement.getRaySlope();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.xOld = opticElement.getPixX();
                    this.yOld = opticElement.getPixY();
                    this.ray[0] = this.yOld;
                    this.ray[1] = this.slope;
                    graphics.setColor(opticElement.getRayColor());
                    this.drawRay(graphics, rectangle, opticElement.getDirection());
                    this.slope += d;
                }
            }
            if (opticElement.getRayIncrement() == (double)3 && opticElement.getType() == "source") {
                this.xOld = opticElement.getPixX();
                this.yOld = opticElement.getPixY();
                this.ray[0] = this.yOld;
                this.ray[1] = 0.0;
                graphics.setColor(opticElement.getRayColor());
                this.drawRay(graphics, rectangle, opticElement.getDirection());
            }
            if (opticElement.getType() == "isource") {
                n2 = opticElement.getSpread();
                int n4 = opticElement.getSpacing();
                double d2 = opticElement.getAngle();
                this.spacingInt = 0;
                while (this.spacingInt <= n2 / 2) {
                    this.xOld = opticElement.getPixX();
                    this.yOld = opticElement.getPixY() - this.spacingInt;
                    this.ray[0] = this.yOld;
                    this.ray[1] = d2;
                    graphics.setColor(opticElement.getRayColor());
                    this.drawRay(graphics, rectangle, opticElement.getDirection());
                    this.xOld = opticElement.getPixX();
                    this.yOld = opticElement.getPixY() + this.spacingInt;
                    this.ray[0] = this.yOld;
                    this.ray[1] = d2;
                    this.drawRay(graphics, rectangle, opticElement.getDirection());
                    this.spacingInt += n4;
                }
            }
            if (opticElement.getType() != "psource") continue;
            opticElement.setNextElement(this.findStart(opticElement.getPixX(), 1));
            for (n2 = 0; opticElement != null && n2 < 10; ++n2) {
                opticElement = this.drawPSourceRay((Source)opticElement, graphics, rectangle);
            }
            this.indexOfPSources = 0;
        }
    }

    public OpticElement drawPSourceRay(OpticElement opticElement, Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        graphics.setColor(Color.red);
        int n3 = opticElement.getPixX();
        int n4 = opticElement.getPixY();
        OpticElement opticElement2 = null;
        OpticElement opticElement3 = null;
        boolean bl = false;
        int n5 = n2 = opticElement.getDirection();
        for (n = opticElement.getNextElement(); n < this.v.size() - 1 && n >= 0 && !bl; n += n5) {
            opticElement2 = (OpticElement)((Object)this.v.elementAt(n));
            if (opticElement2.getType() != "lens" && opticElement2.getType() != "mirror" && opticElement2.getType() != "dielectric") continue;
            opticElement3 = opticElement2;
            bl = true;
            if (!(opticElement3 instanceof Mirror)) continue;
            n5 = -n2;
        }
        if (!bl) {
            return null;
        }
        if ((double)n3 != (double)opticElement3.getPixX() - opticElement3.getFocalLength()) {
            int n6 = opticElement3.getPixX();
            int n7 = opticElement3.getPixY();
            double d = opticElement3.getFocalLength();
            int n8 = 0;
            int n9 = 0;
            if (opticElement3 instanceof Mirror) {
                if (d == 0.0) {
                    n9 = n4;
                    n8 = 2 * n6 - n3;
                } else {
                    int n10 = d - (double)(n6 - n3) == 0.0 ? 10000 : (int)((double)n6 - d * (double)(n6 - n3) / (d - (double)(n6 - n3)));
                    n8 = 2 * n6 - n10;
                    n9 = (int)((double)rectangle.height / 2.0 + (double)(n10 - n6) * ((double)rectangle.height / 2.0 - (double)n4) / (double)(n6 - n3));
                }
            } else {
                n8 = d - (double)(n6 - n3) == 0.0 ? 10000 : n6 - (int)(d * (double)(n6 - n3) / (d - (double)(n2 * (n6 - n3))));
                n9 = (int)((double)rectangle.height / 2.0 + (double)(n8 - n6) * ((double)rectangle.height / 2.0 - (double)n4) / (double)(n6 - n3));
            }
            if (opticElement.drawDashedRay && opticElement.showRays) {
                this.drawDashedLine(n3, n4, n6, n4, graphics);
                this.drawDashedLine(n3, n4, n6, rectangle.height / 2, graphics);
                this.drawDashedLine(n3, n4, n6, n9, graphics);
                this.drawDashedLine(n6, n4, n8, n9, graphics);
                this.drawDashedLine(n6, rectangle.height / 2, n8, n9, graphics);
                this.drawDashedLine(n6, n9, n8, n9, graphics);
            }
            if (opticElement.drawSourceRay && opticElement.showRays) {
                graphics.setColor(opticElement.getRayColor());
                this.xOld = n3;
                this.yOld = n4;
                this.ray[0] = n4;
                this.ray[1] = (double)(n6 - n3) - d == 0.0 ? 0.0 : (double)(-(n4 - rectangle.height / 2)) / ((double)(n6 - n3) - d);
                this.drawRay(graphics, rectangle, 1);
                this.xOld = n3;
                this.yOld = n4;
                this.ray[0] = n4;
                this.ray[1] = 0.0;
                this.drawRay(graphics, rectangle, 1);
                this.xOld = n3;
                this.yOld = n4;
                this.ray[0] = n4;
                if (n3 - n6 != 0 || !(opticElement3 instanceof Mirror) && n8 - n6 != 0) {
                    this.ray[1] = opticElement3 instanceof Mirror ? ((double)n4 - (double)rectangle.height / 2.0) / (double)(n3 - n6) : ((double)n9 - (double)rectangle.height / 2.0) / (double)(n8 - n6);
                    this.drawRay(graphics, rectangle, 1);
                }
            }
            ++this.indexOfPSources;
            this.tempPSource.init(n8, n9, 0.0, 0, true, false, 1.0, false);
            graphics.setColor(Color.white);
            if (opticElement.imageLabel) {
                if (n9 - rectangle.height / 2 < 0) {
                    graphics.drawString("".concat(String.valueOf(String.valueOf(this.indexOfPSources))), n8, n9 - 20);
                } else {
                    graphics.drawString("".concat(String.valueOf(String.valueOf(this.indexOfPSources))), n8, n9 + 20);
                }
            }
            this.tempPSource.setNextElement(n);
            this.tempPSource.paintTemp(graphics, rectangle);
            this.tempPSource.setPixPerUnit(this.pixPerUnit);
            this.tempPSource.info = opticElement.info;
            this.tempPSource.drawDashedRay = false;
            this.tempPSource.drawSourceRay = false;
            this.tempPSource.setDirection(n5);
            if (this.activeElement instanceof PSource) {
                this.tempPSource.paintTempActive(graphics, rectangle);
            }
        }
        bl = false;
        return this.tempPSource;
    }

    public void drawDashedLine(int n, int n2, int n3, int n4, Graphics graphics) {
        graphics.setColor(new Color(191, 191, 255));
        if (n - n3 == 0) {
            return;
        }
        double d = (double)(n2 - n4) * 1.0 / (double)(n - n3);
        double d2 = n;
        double d3 = n2;
        for (int i = 0; i < Math.abs(n3 - n); i += 3) {
            graphics.fillOval((int)d2, (int)d3, 1, 1);
            if (d2 < (double)n3) {
                d2 += 3.0;
                d3 += 3.0 * d;
                continue;
            }
            d2 -= 3.0;
            d3 -= 3.0 * d;
        }
    }

    private int findStart(int n, int n2) {
        for (int i = 0; i < this.v.size(); ++i) {
            OpticElement opticElement = (OpticElement)((Object)this.v.elementAt(i));
            if (n2 == 1 && opticElement.getPixX() > n) {
                return i;
            }
            if (n2 != -1 || opticElement.getPixX() <= n) continue;
            return i - 1;
        }
        if (n2 == 1) {
            return this.v.size() - 1;
        }
        return this.v.size() - 1;
    }

    public void drawRay(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 0;
        this.step = n;
        for (int i = this.findStart(this.xOld, this.step); i >= 0 && i < this.v.size(); i += this.step) {
            Object object;
            if (n2 > 30) {
                return;
            }
            ++n2;
            OpticElement opticElement = (OpticElement)((Object)this.v.elementAt(i));
            this.xNew = opticElement.getPixX();
            this.yNewDouble = this.ray[0] + this.ray[1] * (double)(this.xNew - this.xOld);
            this.yNew = (int)this.yNewDouble;
            if (opticElement instanceof Aperature && (opticElement.getOpeningSize() == 0 || this.yNew < rectangle.height / 2 - opticElement.getOpeningSize() / 2 || this.yNew > rectangle.height / 2 + opticElement.getOpeningSize() / 2)) {
                this.blocked = true;
            }
            if (opticElement instanceof BeamStop && this.yNew < (object = (BeamStop)opticElement).getBottomBlock() && this.yNew > object.getTopBlock()) {
                this.blocked = true;
            }
            if ((opticElement instanceof Lens || opticElement instanceof Mirror || opticElement instanceof Matrix) && ((double)this.yNew < (double)(rectangle.height / 2) - (double)rectangle.height * opticElement.percentSize / (double)2 || (double)this.yNew > (double)(rectangle.height / 2) + (double)rectangle.height * opticElement.percentSize / (double)2)) {
                this.blocked = true;
            }
            if (this.yNew < 0 || this.yNew > rectangle.height || this.xNew < 0 || this.xNew > rectangle.width) {
                this.blocked = true;
            }
            if (!this.blocked) {
                graphics.drawLine(this.xOld, this.yOld, this.xNew, this.yNew);
            }
            if (this.blocked) {
                graphics.drawLine(this.xOld, this.yOld, this.xNew, this.yNew);
                break;
            }
            this.yOld = this.yNew;
            this.ray[0] = this.yNewDouble;
            this.xOld = this.xNew;
            object = this.getBounds();
            this.ray = opticElement.transform(this.ray, (Rectangle)object, this.step);
            if (opticElement.errCode == 2) {
                this.step = -this.step;
            }
            if (opticElement.errCode == 1) {
                this.blocked = true;
                break;
            }
            if (opticElement instanceof Screen) {
                graphics.fillOval(this.xNew - 2, this.yNew - 2, 4, 4);
            }
            if (!(opticElement instanceof Mirror)) continue;
            this.step = -this.step;
        }
        this.blocked = false;
    }

    public synchronized void sort(Vector vector) {
        boolean bl = false;
        this.inc = 0;
        while (this.inc <= this.maxNumber) {
            for (int i = 0; i < vector.size() - 1; ++i) {
                OpticElement opticElement = (OpticElement)((Object)vector.elementAt(i));
                OpticElement opticElement2 = (OpticElement)((Object)vector.elementAt(i + 1));
                if (opticElement.getPixX() <= opticElement2.getPixX()) continue;
                bl = true;
                vector.removeElementAt(i);
                vector.insertElementAt(opticElement, i + 1);
            }
            ++this.inc;
        }
        if (bl) {
            this.recalculateIndexOfRefraction();
        }
    }

    synchronized void recalculateIndexOfRefraction() {
        double d = 1.0;
        for (int i = 0; i < this.v.size() - 1; ++i) {
            OpticElement opticElement = (OpticElement)((Object)this.v.elementAt(i));
            opticElement.indexOfRefraction = d;
            if (!(opticElement instanceof Dielectric)) continue;
            if ((d += ((Dielectric)opticElement).delN) < 1.0) {
                d = 1.0;
            }
            opticElement.focalLength = (double)((Dielectric)opticElement).R / ((Dielectric)opticElement).delN;
        }
    }

    public void propagate(double[] dArray, int n) {
        dArray[0] = dArray[0] * 1.0 + dArray[1] * (double)n;
        dArray[1] = dArray[0] * 0.0 + dArray[1] * 1.0;
    }

    public OpticElement getElement(int n) {
        OpticElement opticElement = null;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            opticElement = (OpticElement)((Object)enumeration.nextElement());
            if (((Object)((Object)opticElement)).hashCode() != n) continue;
            return opticElement;
        }
        enumeration = this.sv.elements();
        while (enumeration.hasMoreElements()) {
            opticElement = (OpticElement)((Object)enumeration.nextElement());
            if (((Object)((Object)opticElement)).hashCode() != n) continue;
            return opticElement;
        }
        return null;
    }

    public void addThing(Thing thing) {
        this.things.addElement(thing);
    }

    public boolean deleteObject(int n) {
        Thing thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        if (thing == this.activeElement) {
            this.clearActiveElement();
            return true;
        }
        this.owner.removeDataListener(thing.hashCode());
        this.owner.removeDataSource(thing.hashCode());
        this.owner.cleanupDataConnections();
        this.v.removeElement(thing);
        this.sv.removeElement(thing);
        this.things.removeElement(thing);
        if (thing instanceof BenchThing) {
            this.hasBench = false;
        }
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        if (this.owner.isAutoRefresh()) {
            this.repaint();
        }
        return true;
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        enumeration = this.sv.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    public int addLens(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        Lens lens = new Lens(this, n, n2, d, bl, bl2, d2, bl3);
        lens.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            lens.setElementColor(this.elementColor);
        }
        this.v.addElement(lens);
        return ((Object)((Object)lens)).hashCode();
    }

    public int addMatrix(int n, int n2, String string, String string2) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        Matrix matrix = new Matrix(this, n, n2, string, string2);
        matrix.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            matrix.setElementColor(this.elementColor);
        }
        this.v.addElement(matrix);
        return ((Object)((Object)matrix)).hashCode();
    }

    public int addIndexChange(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        IndexChange indexChange = new IndexChange(this, n, n2, d, bl, bl2, d2, bl3);
        indexChange.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            indexChange.setElementColor(this.elementColor);
        }
        this.v.addElement(indexChange);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        return ((Object)((Object)indexChange)).hashCode();
    }

    public int addMirror(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        Mirror mirror = new Mirror(this, n, n2, d, bl, bl2, d2, bl3);
        mirror.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            mirror.setElementColor(this.elementColor);
        }
        this.v.addElement(mirror);
        return ((Object)((Object)mirror)).hashCode();
    }

    public int addSphericalMirror(int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        Mirror2 mirror2 = new Mirror2(this, n, n2, d, bl, bl2, d2, bl3);
        mirror2.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            mirror2.setElementColor(this.elementColor);
        }
        this.v.addElement(mirror2);
        return ((Object)((Object)mirror2)).hashCode();
    }

    public int addDielectric(int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        Dielectric dielectric = new Dielectric(this, n, n2, d, n3, bl, bl2, d2, bl3);
        dielectric.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            dielectric.setElementColor(this.elementColor);
        }
        this.v.addElement(dielectric);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        return ((Object)((Object)dielectric)).hashCode();
    }

    public int addSource(int n, int n2, double d, double d2, boolean bl, boolean bl2, int n3, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return 0;
        }
        Source source = new Source(this, n, n2, d, d2, bl, bl2, n3, bl3);
        source.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            source.setElementColor(this.elementColor);
        }
        if (this.rayColor != null) {
            source.setRayColor(this.rayColor);
        }
        this.sv.addElement(source);
        return ((Object)((Object)source)).hashCode();
    }

    public int addAperature(int n, int n2, int n3, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return 0;
        }
        Rectangle rectangle = this.getBounds();
        Aperature aperature = new Aperature(this, n, n2, n3, bl, bl2, d, bl3);
        aperature.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            aperature.setElementColor(this.elementColor);
        }
        this.v.addElement(aperature);
        return ((Object)((Object)aperature)).hashCode();
    }

    public int addBeamStop(int n, int n2, int n3, int n4, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return 0;
        }
        Rectangle rectangle = this.getBounds();
        BeamStop beamStop = new BeamStop(this, n, n2, n3, n4, bl, bl2, d, bl3);
        beamStop.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            beamStop.setElementColor(this.elementColor);
        }
        this.v.addElement(beamStop);
        return ((Object)((Object)beamStop)).hashCode();
    }

    public int addPSource(int n, int n2, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return 0;
        }
        PSource pSource = new PSource(this, n, n2, 0.0, 0, bl, bl2, d, bl3);
        pSource.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            pSource.setElementColor(this.elementColor);
        }
        if (this.rayColor != null) {
            pSource.setRayColor(this.rayColor);
        }
        this.sv.addElement(pSource);
        return ((Object)((Object)pSource)).hashCode();
    }

    public int addRefraction(int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        Refraction refraction = new Refraction(this, n, n2, d, n3, bl, bl2, d2, bl3);
        refraction.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            refraction.setElementColor(this.elementColor);
        }
        this.v.addElement(refraction);
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        return ((Object)((Object)refraction)).hashCode();
    }

    public int addISource(int n, int n2, int n3, double d, boolean bl, boolean bl2, int n4, boolean bl3) {
        if (this.sv.size() >= this.maxSNumber) {
            return 0;
        }
        ISource iSource = new ISource(this, n, n2, n3, d, bl, bl2, n4, bl3);
        iSource.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            iSource.setElementColor(this.elementColor);
        }
        if (this.rayColor != null) {
            iSource.setRayColor(this.rayColor);
        }
        this.sv.addElement(iSource);
        return ((Object)((Object)iSource)).hashCode();
    }

    public int addScreen(int n, int n2, boolean bl, boolean bl2, double d, boolean bl3) {
        if (this.v.size() >= this.maxNumber) {
            return 0;
        }
        Screen screen = new Screen(this, n, n2, bl, bl2, d, bl3);
        screen.setPixPerUnit(this.pixPerUnit);
        if (this.elementColor != null) {
            screen.setElementColor(this.elementColor);
        }
        this.v.addElement(screen);
        return ((Object)((Object)screen)).hashCode();
    }

    public void clearThings() {
        Thing thing;
        Vector vector;
        this.activeElement = null;
        Vector vector2 = this.v;
        synchronized (vector2) {
            vector = (Vector)this.v.clone();
            this.v.removeAllElements();
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            thing = (Thing)object.nextElement();
            this.owner.removeDataListener(thing.hashCode());
            this.owner.removeDataSource(thing.hashCode());
        }
        object = this.sv;
        synchronized (object) {
            vector = (Vector)this.sv.clone();
            this.sv.removeAllElements();
        }
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            thing = (Thing)object2.nextElement();
            this.owner.removeDataListener(thing.hashCode());
            this.owner.removeDataSource(thing.hashCode());
        }
        object2 = this.things;
        synchronized (object2) {
            vector = (Vector)this.things.clone();
            this.things.removeAllElements();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            this.owner.removeDataListener(thing.hashCode());
            this.owner.removeDataSource(thing.hashCode());
        }
        this.hasBench = false;
        int n = this.addScreen(2000, 0, false, false, 1.0, false);
        OpticElement opticElement = this.getElement(n);
        opticElement.setPixX(2000, new Rectangle(0, 0));
        n = this.addScreen(-100, 0, false, false, 1.0, false);
        opticElement = this.getElement(n);
        opticElement.setPixX(-100, new Rectangle(0, 0));
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        if (this.owner.isAutoRefresh()) {
            this.repaint();
        }
    }

    public void clearActiveElement() {
        if (this.activeElement != null) {
            if (this.v.indexOf((Object)this.activeElement) != -1) {
                this.v.removeElementAt(this.v.indexOf((Object)this.activeElement));
            }
            if (this.sv.indexOf((Object)this.activeElement) != -1) {
                this.sv.removeElementAt(this.sv.indexOf((Object)this.activeElement));
            }
        }
        this.activeElement = null;
        this.sort(this.v);
        this.recalculateIndexOfRefraction();
        if (this.owner.isAutoRefresh()) {
            this.repaint();
        }
    }

    public void mousePressed(int n, int n2) {
        OpticElement opticElement;
        int n3;
        this.xDown = n;
        this.yDown = n2;
        this.xLast = n;
        this.yLast = n2;
        Rectangle rectangle = this.getBounds();
        this.dragThing = null;
        this.activeElement = null;
        for (n3 = 0; n3 < this.v.size(); ++n3) {
            opticElement = (OpticElement)((Object)this.v.elementAt(n3));
            if (!(opticElement.isNoDrag() && !opticElement.isResizable() || opticElement.isInside(n, n2, rectangle) != 1 && opticElement.isInside(n, n2, rectangle) != 2 && opticElement.isInside(n, n2, rectangle) != 3)) {
                this.activeElement = opticElement;
                break;
            }
            this.activeElement = null;
        }
        if (this.activeElement == null) {
            for (n3 = 0; n3 < this.sv.size(); ++n3) {
                opticElement = (OpticElement)((Object)this.sv.elementAt(n3));
                if (!(opticElement.isNoDrag() && !opticElement.isResizable() || opticElement.isInside(n, n2, rectangle) != 1 && opticElement.isInside(n, n2, rectangle) != 2)) {
                    this.activeElement = opticElement;
                    break;
                }
                this.activeElement = null;
            }
        }
        if (this.activeElement == null) {
            for (n3 = 0; n3 < this.things.size(); ++n3) {
                opticElement = (Thing)this.things.elementAt(n3);
                if ((!opticElement.isNoDrag() || opticElement.isResizable()) && opticElement.isInsideThing(n, n2)) {
                    this.dragThing = opticElement;
                    break;
                }
                this.dragThing = null;
            }
        }
    }

    public void mouseReleased(int n, int n2) {
        this.isControlDown = false;
        this.dragThing = null;
        this.repaint();
    }

    public void mouseDragged(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        if (this.activeElement != null) {
            if (this.activeElement.getDrag() || this.activeElement.isResizable()) {
                if (this.isInsideOpticElement == 1 && !this.isControlDown && this.activeElement.getType() != "source" || this.activeElement.getType() == "psource") {
                    if (this.activeElement.getDrag()) {
                        this.activeElement.setPixX(n, rectangle);
                    }
                    if (this.activeElement.isResizable()) {
                        this.activeElement.setPixY(n2, rectangle);
                    }
                    this.repaint();
                }
                if (this.isInsideOpticElement == 1 && !this.isControlDown && (this.activeElement.getType() == "source" || this.activeElement.getType() == "isource") && this.activeElement.getDrag()) {
                    this.activeElement.setPixX(n, rectangle);
                    this.activeElement.setPixY(n2, rectangle);
                    this.repaint();
                }
                if (this.activeElement.getType() == "aperature" && this.isInsideOpticElement == 2) {
                    if (this.activeElement.isResizable()) {
                        this.activeElement.setOpeningSize(2 * (rectangle.height / 2 - n2));
                    }
                    if (this.activeElement.getDrag()) {
                        this.activeElement.setPixX(n, rectangle);
                    }
                    if (this.activeElement.isResizable()) {
                        this.activeElement.setPixY(n2, rectangle);
                    }
                    this.repaint();
                }
                if (this.activeElement.getType() == "aperature" && this.isInsideOpticElement == 3) {
                    if (this.activeElement.isResizable()) {
                        this.activeElement.setOpeningSize(2 * (n2 - rectangle.height / 2));
                    }
                    if (this.activeElement.getDrag()) {
                        this.activeElement.setPixX(n, rectangle);
                    }
                    if (this.activeElement.isResizable()) {
                        this.activeElement.setPixY(n2, rectangle);
                    }
                    this.repaint();
                }
            }
            if (this.activeElement.isResizable()) {
                if (this.isInsideOpticElement == 2 && (this.activeElement.getType() == "lens" || this.activeElement.getType() == "mirror")) {
                    this.activeElement.setFocalLength(n - this.activeElement.getPixX(), rectangle);
                    this.repaint();
                }
                if (this.isInsideOpticElement == 3 && (this.activeElement.getType() == "lens" || this.activeElement.getType() == "mirror")) {
                    this.activeElement.setFocalLength(-(n - this.activeElement.getPixX()), rectangle);
                    this.repaint();
                }
                if (this.isInsideOpticElement == 2 && this.activeElement.getType() == "dielectric") {
                    this.activeElement.setRadius(n - this.activeElement.getPixX(), rectangle);
                    ((Dielectric)this.activeElement).setDelN(-((double)n2 - (double)rectangle.height / 2.0) / (double)50);
                    this.recalculateIndexOfRefraction();
                    this.repaint();
                }
                if (this.isInsideOpticElement == 3 && this.activeElement.getType() == "dielectric") {
                    this.activeElement.setRadius(-(n - this.activeElement.getPixX()), rectangle);
                    ((Dielectric)this.activeElement).setDelN(-((double)n2 - (double)rectangle.height / 2.0) / (double)50);
                    this.recalculateIndexOfRefraction();
                    this.repaint();
                }
                if (this.isInsideOpticElement == 1 && this.isControlDown && this.activeElement.getType() == "source") {
                    this.activeElement.setRayIncrement(1.0 - (double)(n - this.activeElement.getPixX()) * 0.005);
                    if (n <= this.activeElement.getPixX() + 15) {
                        this.activeElement.setRayIncrement(1.0);
                    }
                    if (n - this.activeElement.getPixX() < 0) {
                        this.activeElement.setRayIncrement(3.0);
                    }
                    this.repaint();
                }
                if (this.isInsideOpticElement == 2 && this.activeElement.getType() == "source") {
                    this.activeElement.setRaySlope(1.0 * (double)(n2 - this.activeElement.getPixY()) / (double)(n - this.activeElement.getPixX()));
                    if (this.activeElement.getPixX() > n) {
                        this.activeElement.setDirection(-1);
                    } else {
                        this.activeElement.setDirection(1);
                    }
                    this.repaint();
                }
                if (this.isInsideOpticElement == 1 && this.isControlDown && this.activeElement.getType() == "isource") {
                    this.activeElement.setSpread(100 + (this.activeElement.getPixY() - n2));
                    this.activeElement.setSpacing(10 + (this.activeElement.getPixX() - n));
                    this.repaint();
                }
                if (this.isInsideOpticElement == 2 && this.activeElement.getType() == "isource") {
                    this.activeElement.setAngle((1.0 * (double)this.activeElement.getPixY() - (double)n2) / (double)(1 * (this.activeElement.getPixX() - n)));
                    if (this.activeElement.getPixX() > n) {
                        this.activeElement.setDirection(-1);
                    } else {
                        this.activeElement.setDirection(1);
                    }
                    this.repaint();
                }
            }
        } else if (this.dragThing != null) {
            this.activeElement = null;
            this.dragThing.dragMe(this.xFromPix(n), this.yFromPix(n2));
            Thing thing = null;
            Enumeration enumeration = this.dragThing.getSlaves().elements();
            while (enumeration.hasMoreElements()) {
                thing = (Thing)enumeration.nextElement();
                thing.setVarsFromMaster();
                if (!(thing instanceof OpticElement)) continue;
                ((OpticElement)thing).adjustPosition();
            }
            this.repaint();
        } else {
            this.drawAngle(n, n2);
        }
        this.owner.updateDataConnections();
    }

    public void mouseMoved(int n, int n2) {
        OpticElement opticElement;
        int n3;
        Rectangle rectangle = this.getBounds();
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.isInsideOpticElement = 0;
        for (n3 = 0; n3 < this.v.size(); ++n3) {
            opticElement = (OpticElement)((Object)this.v.elementAt(n3));
            if (opticElement.isInside(n, n2, rectangle) != 1 && opticElement.isInside(n, n2, rectangle) != 2 && opticElement.isInside(n, n2, rectangle) != 3) continue;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.isInsideOpticElement = opticElement.isInside(n, n2, rectangle);
            break;
        }
        for (n3 = 0; n3 < this.sv.size(); ++n3) {
            opticElement = (OpticElement)((Object)this.sv.elementAt(n3));
            if (opticElement.isInside(n, n2, rectangle) != 1 && opticElement.isInside(n, n2, rectangle) != 2) continue;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.isInsideOpticElement = opticElement.isInside(n, n2, rectangle);
            break;
        }
        for (n3 = 0; n3 < this.things.size(); ++n3) {
            opticElement = (Thing)this.things.elementAt(n3);
            if (opticElement.isNoDrag() && !opticElement.isResizable() || !opticElement.isInsideThing(n, n2)) continue;
            this.setCursor(Cursor.getPredefinedCursor(12));
            break;
        }
        Graphics graphics = this.getGraphics();
        this.drawCoords(graphics, n, n2);
        graphics.dispose();
    }

    public void drawCoords(Graphics graphics, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, rectangle.height - 20, 100, 20);
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer("").append(this.df.format(1.0 * (double)n / (double)this.pixPerUnit)).append(" , ").append(this.df.format(1.0 * (double)rectangle.height / (double)2 / (double)this.pixPerUnit - 1.0 * (double)n2 / (double)this.pixPerUnit)))), 10, rectangle.height - 5);
    }

    public void drawAngle(int n, int n2) {
        Graphics graphics = this.getGraphics();
        double d = n - this.xDown;
        double d2 = -n2 + this.yDown;
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        graphics.drawLine(this.xDown, this.yDown, this.xDown + 30, this.yDown);
        graphics.fillRect(0, rectangle.height - 20, 100, 20);
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(String.valueOf(this.owner.label_angle)).concat(String.valueOf(String.valueOf((int)((double)180 * Math.atan2(d2, d) / Math.PI)))), 10, rectangle.height - 5);
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.red);
        graphics.drawLine(this.xDown, this.yDown, this.xLast, this.yLast);
        graphics.drawLine(this.xDown, this.yDown, n, n2);
        this.xLast = n;
        this.yLast = n2;
        graphics.setPaintMode();
        graphics.dispose();
    }
}

