/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import optics.Bench;
import optics.OpticElement;

public class Mirror
extends OpticElement {
    int curvatureFactor;
    int radius;
    private Polygon outline = new Polygon();
    private int iheight = 0;

    public Mirror(Bench bench, int n, int n2, double d, boolean bl, boolean bl2, double d2, boolean bl3) {
        super(bench);
        this.info = bl;
        this.noDrag = !bl2;
        this.percentSize = d2;
        this.resizable = bl3;
        this.curvatureFactor = 3;
        this.xPosition = n;
        this.yPosition = n2;
        this.setX((double)this.xPosition / (double)this.bench.pixPerUnit);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
        this.focalLength = d;
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = this.focalLength == 0.0 ? 0.0 : (double)-1 / this.focalLength;
        this.mat[1][1] = 1.0;
    }

    public void setFocalLength(double d, Rectangle rectangle) {
        if (d != this.focalLength) {
            this.makeOutline(this.iheight);
        }
        this.focalLength = d > (double)(rectangle.width - 20) ? (double)(rectangle.width - 20) : (-d > (double)(rectangle.width - 20) ? (double)(-(rectangle.width - 20)) : d);
        if (Math.abs(this.focalLength) < (double)3) {
            this.focalLength = 0.0;
            this.mat[1][0] = 0.0;
        } else {
            this.mat[1][0] = (double)-1 / this.focalLength;
        }
    }

    public void setY(double d) {
    }

    public void setPixX(int n, Rectangle rectangle) {
        super.setPixX(n, rectangle);
        this.makeOutline(this.iheight);
    }

    void adjustPosition() {
        super.adjustPosition();
        this.makeOutline(this.iheight);
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = dArray[0] - (double)(rectangle.height / 2);
        dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
        dArray[1] = (double)-1 * (d * this.mat[1][0] + dArray[1] * this.mat[1][1]);
        return dArray;
    }

    private void makeOutline(int n) {
        if (this.focalLength < 0.0) {
            this.makeOutlineMinus(n);
        } else {
            this.makeOutlinePlus(n);
        }
    }

    private void makeOutlinePlus(int n) {
        double d;
        this.iheight = n;
        n = (int)((double)n * this.percentSize);
        this.outline = new Polygon();
        this.radius = (int)Math.abs(this.focalLength * (double)2);
        double d2 = n / 2 < this.radius ? Math.asin((double)n / (double)this.radius / 2.0) : 1.5707963267948966;
        double d3 = d2 / (double)50;
        double d4 = (double)this.radius * Math.cos(d2);
        double d5 = (double)this.radius - d4 - 1.0;
        int n2 = this.xPosition;
        int n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2));
        this.outline.addPoint(n2, n3);
        for (d = d2; d > -d2; d -= d3) {
            n2 = (int)((double)this.xPosition - d4 + (double)this.radius * Math.cos(d) - d5);
            n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2));
            this.outline.addPoint(n2, n3);
        }
        n2 = this.xPosition;
        n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2) + (double)2);
        this.outline.addPoint(n2, n3);
        for (int i = this.outline.npoints - 1; i >= 0; --i) {
            this.outline.addPoint(this.outline.xpoints[i] + 3, this.outline.ypoints[i]);
        }
    }

    private void makeOutlineMinus(int n) {
        double d;
        this.iheight = n;
        n = (int)((double)n * this.percentSize);
        this.outline = new Polygon();
        this.radius = (int)Math.abs(this.focalLength * (double)2);
        double d2 = n / 2 < this.radius ? Math.asin((double)n / (double)this.radius / 2.0) : 1.5707963267948966;
        double d3 = d2 / (double)50;
        double d4 = (double)this.radius * Math.cos(d2);
        double d5 = (double)this.radius - d4 - 1.0;
        int n2 = this.xPosition;
        int n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2));
        this.outline.addPoint(n2, n3);
        for (d = d2; d > -d2; d -= d3) {
            n2 = (int)((double)this.xPosition + d4 - (double)this.radius * Math.cos(d) + d5);
            n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2));
            this.outline.addPoint(n2, n3);
        }
        n2 = this.xPosition;
        n3 = (int)((double)this.radius * Math.sin(d) + (double)(this.iheight / 2) + (double)2);
        this.outline.addPoint(n2, n3);
        for (int i = this.outline.npoints - 1; i >= 0; --i) {
            this.outline.addPoint(this.outline.xpoints[i] + 3, this.outline.ypoints[i]);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (rectangle.height != this.iheight) {
            this.makeOutline(rectangle.height);
        }
        graphics.setColor(Color.lightGray);
        graphics.fillPolygon(this.outline);
        if (this.color == null) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(this.color);
        }
        if (this.focalLength != 0.0) {
            graphics.drawPolygon(this.outline);
        } else {
            graphics.drawLine(this.xPosition + 1, 0, this.xPosition + 1, rectangle.height);
            graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
            graphics.drawLine(this.xPosition - 1, 0, this.xPosition - 1, rectangle.height);
        }
        graphics.drawLine(this.xPosition, (int)((double)rectangle.height * (1.0 - this.percentSize) / 2.0), this.xPosition, 0);
        graphics.drawLine(this.xPosition, (int)((double)rectangle.height * (1.0 + this.percentSize) / 2.0), this.xPosition, rectangle.height);
        if (this.showFocus) {
            int n = (int)this.focalLength;
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition - n - 3, rectangle.height / 2 - 3, 6, 6);
            graphics.fillOval(this.xPosition + n - 3, rectangle.height / 2 - 3, 6, 6);
        }
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        int n = (int)this.focalLength;
        if (Math.abs(this.focalLength) < (double)3) {
            n = 20;
        }
        if (!this.noDrag) {
            graphics.setColor(Color.green);
            graphics.drawLine(this.xPosition, 0, this.xPosition, rectangle.height);
        }
        if (this.showFocus || this.resizable) {
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition - n - 3, rectangle.height / 2 - 3, 6, 6);
            graphics.fillOval(this.xPosition + n - 3, rectangle.height / 2 - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString("x = ".concat(String.valueOf(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit)))), this.xPosition, rectangle.height - 70);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.bench.owner.label_focal_length))).append(" ").append(this.df.format(1.0 * this.focalLength / (double)this.pixPerUnit)))), this.xPosition, rectangle.height - 30);
        }
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        int n3 = (int)this.focalLength;
        if (Math.abs(this.focalLength) < (double)3) {
            n3 = 20;
        }
        if (this.resizable && n > this.xPosition + n3 - 15 && n < this.xPosition + n3 + 15 && n2 < rectangle.height / 2 + 15 && n2 > rectangle.height / 2 - 15) {
            return 2;
        }
        if (this.resizable && n > this.xPosition - n3 - 15 && n < this.xPosition - n3 + 15 && n2 < rectangle.height / 2 + 15 && n2 > rectangle.height / 2 - 15) {
            return 3;
        }
        if ((!this.noDrag || this.resizable) && n > this.xPosition - 10 && n < this.xPosition + 10) {
            return 1;
        }
        return 0;
    }

    public String getType() {
        return "mirror";
    }
}

