/*
 * Decompiled with CFR 0.152.
 */
package optics;

import edu.davidson.display.BoxThing;
import edu.davidson.display.CircleThing;
import edu.davidson.display.Constraint;
import edu.davidson.display.ImageThing;
import edu.davidson.display.ProtractorThing;
import edu.davidson.display.RectangleThing;
import edu.davidson.display.SScalable;
import edu.davidson.display.ShellThing;
import edu.davidson.display.Thing;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import optics.Bench;
import optics.BenchThing;
import optics.CalcThing;
import optics.Dielectric;
import optics.OpticElement;
import optics.OpticsApplet_aperatureBtn_actionAdapter;
import optics.OpticsApplet_bench_keyAdapter;
import optics.OpticsApplet_bench_mouseAdapter;
import optics.OpticsApplet_bench_mouseMotionAdapter;
import optics.OpticsApplet_bevelPanel1_mouseAdapter;
import optics.OpticsApplet_clearActiveElementBtn_actionAdapter;
import optics.OpticsApplet_clearBtn_actionAdapter;
import optics.OpticsApplet_isourceBtn_actionAdapter;
import optics.OpticsApplet_lensBtn_actionAdapter;
import optics.OpticsApplet_mirrorBtn_actionAdapter;
import optics.OpticsApplet_psourceBtn_actionAdapter;
import optics.OpticsApplet_sourceBtn_actionAdapter;
import optics.Source;

public class OpticsApplet
extends SApplet {
    private String button_lens = "  Lens  ";
    private String button_source = " Source ";
    private String button_clear = "Clear All";
    private String button_object = " Object ";
    private String button_active = "Clear Active";
    private String button_mirror = " Mirror ";
    private String button_aperture = "Aperture";
    private String button_beam = "  Beam  ";
    String label_angle = "Angle:";
    String label_spacing = "spacing=";
    String label_spread = "spread =";
    String label_anglevalue = "angle =";
    String label_rayinc = "rayIncrement =";
    String label_rayslope = "raySlope =";
    String label_opening = "opening =";
    String label_top = "top =";
    String label_bottom = "bottom =";
    String label_index_error = "ERROR: n2<1.0 ";
    String label_focal_length = "fl =";
    private boolean showControls = true;
    private boolean clipOn = true;
    boolean info = false;
    boolean propertyDrag = false;
    boolean drag = true;
    double size = 0.5;
    int direction = 1;
    int defaultPixPerUnit;
    int pixPerUnit;
    String example;
    String opticString = null;
    EtchedBorder bevelPanel1 = new EtchedBorder();
    Button lensBtn = new Button();
    Button sourceBtn = new Button();
    Bench bench = new Bench(this);
    EtchedBorder bevelPanel2 = new EtchedBorder();
    BorderLayout borderLayout2 = new BorderLayout();
    Button clearBtn = new Button();
    BorderLayout borderLayout1 = new BorderLayout();
    Button psourceBtn = new Button();
    int defaultFocalLength = 50;
    int defaultOpeningSize = 100;
    double defaultDelN = 1.4;
    int defaultR = -50;
    Button isourceBtn = new Button();
    EtchedBorder bevelPanel3 = new EtchedBorder();
    Button aperatureBtn = new Button();
    Button clearActiveElementBtn = new Button();
    Button mirrorBtn = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    static Class class$java$awt$Dimension;

    protected void setResources() {
        this.button_lens = this.localProperties.getProperty("button.lens", this.button_lens);
        this.button_source = this.localProperties.getProperty("button.source", this.button_source);
        this.button_clear = this.localProperties.getProperty("button.clear", this.button_clear);
        this.button_object = this.localProperties.getProperty("button.object", this.button_object);
        this.button_active = this.localProperties.getProperty("button.active", this.button_active);
        this.button_mirror = this.localProperties.getProperty("button.mirror", this.button_mirror);
        this.button_aperture = this.localProperties.getProperty("button.aperture", this.button_aperture);
        this.button_beam = this.localProperties.getProperty("button.beam", this.button_beam);
        this.label_angle = this.localProperties.getProperty("label.angle", this.label_angle);
        this.label_spacing = this.localProperties.getProperty("label.spacing", this.label_spacing);
        this.label_spread = this.localProperties.getProperty("label.spread", this.label_spread);
        this.label_anglevalue = this.localProperties.getProperty("label.anglevalue", this.label_anglevalue);
        this.label_rayinc = this.localProperties.getProperty("label.rayinc", this.label_rayinc);
        this.label_rayslope = this.localProperties.getProperty("label.rayslope", this.label_rayslope);
        this.label_opening = this.localProperties.getProperty("label.opening", this.label_opening);
        this.label_top = this.localProperties.getProperty("label.top", this.label_top);
        this.label_bottom = this.localProperties.getProperty("label.bottom", this.label_bottom);
        this.label_index_error = this.localProperties.getProperty("label.index_error", this.label_index_error);
        this.label_focal_length = this.localProperties.getProperty("label.focal_length", this.label_focal_length);
    }

    public void init() {
        this.initResources(null);
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.defaultPixPerUnit = Integer.parseInt(this.getParameter("PixPerUnit", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.showControls) {
            this.setUnDefault();
        } else {
            this.setDefault();
        }
        this.pixPerUnit = this.defaultPixPerUnit;
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.bevelPanel2.setBackground(Color.lightGray);
        this.bevelPanel3.setBackground(Color.lightGray);
        this.bench.setPixPerUnit(this.pixPerUnit);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
    }

    public void jbInit() throws Exception {
        this.bevelPanel1.setLayout(this.flowLayout2);
        this.setSize(new Dimension(437, 426));
        this.bevelPanel1.addMouseListener(new OpticsApplet_bevelPanel1_mouseAdapter(this));
        this.lensBtn.setLabel(this.button_lens);
        this.lensBtn.addActionListener(new OpticsApplet_lensBtn_actionAdapter(this));
        this.sourceBtn.setLabel(this.button_source);
        this.sourceBtn.addActionListener(new OpticsApplet_sourceBtn_actionAdapter(this));
        this.bench.addKeyListener(new OpticsApplet_bench_keyAdapter(this));
        this.bench.addMouseMotionListener(new OpticsApplet_bench_mouseMotionAdapter(this));
        this.clearBtn.setLabel(this.button_clear);
        this.psourceBtn.setLabel(this.button_object);
        this.isourceBtn.setActionCommand("Add ISource");
        this.aperatureBtn.setActionCommand("aperatureBtn");
        this.clearActiveElementBtn.setLabel(this.button_active);
        this.clearActiveElementBtn.setActionCommand("clearActiveElementBtn");
        this.mirrorBtn.setActionCommand("mirrorBtn");
        this.mirrorBtn.addActionListener(new OpticsApplet_mirrorBtn_actionAdapter(this));
        this.mirrorBtn.setLabel(this.button_mirror);
        this.clearActiveElementBtn.addActionListener(new OpticsApplet_clearActiveElementBtn_actionAdapter(this));
        this.aperatureBtn.addActionListener(new OpticsApplet_aperatureBtn_actionAdapter(this));
        this.aperatureBtn.setLabel(this.button_aperture);
        this.bevelPanel3.setLayout(this.flowLayout1);
        this.isourceBtn.addActionListener(new OpticsApplet_isourceBtn_actionAdapter(this));
        this.isourceBtn.setLabel(this.button_beam);
        this.psourceBtn.addActionListener(new OpticsApplet_psourceBtn_actionAdapter(this));
        this.clearBtn.addActionListener(new OpticsApplet_clearBtn_actionAdapter(this));
        this.bevelPanel2.setLayout(this.borderLayout2);
        this.bench.addMouseListener(new OpticsApplet_bench_mouseAdapter(this));
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.bench.repaint();
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel1, "South");
        }
        this.bevelPanel1.add((Component)this.lensBtn, null);
        this.bevelPanel1.add((Component)this.mirrorBtn, null);
        this.bevelPanel1.add((Component)this.aperatureBtn, null);
        this.bevelPanel1.add((Component)this.clearActiveElementBtn, null);
        ((Container)((Object)this)).add((Component)this.bevelPanel2, "Center");
        this.bevelPanel2.add((Component)this.bench, "Center");
        if (this.showControls) {
            ((Container)((Object)this)).add((Component)this.bevelPanel3, "North");
        }
        this.bevelPanel3.add((Component)this.isourceBtn, null);
        this.bevelPanel3.add((Component)this.psourceBtn, null);
        this.bevelPanel3.add((Component)this.sourceBtn, null);
        this.bevelPanel3.add((Component)this.clearBtn, null);
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.bench.createOSI();
        }
        super.start();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"example", "String", "an example parameter"}};
        return stringArray;
    }

    public boolean setDisplayOffset(int n, int n2, int n3) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDisplayOff(n2, n3);
        thing.setVarsFromMaster();
        if (thing instanceof OpticElement) {
            ((OpticElement)thing).adjustPosition();
        }
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return true;
    }

    public void clearAll() {
        this.bench.clearThings();
        if (this.autoRefresh) {
            ((Component)((Object)this)).repaint();
        }
    }

    public boolean setDragable(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setDragable(bl);
        return true;
    }

    public boolean setShowFocus(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        if (thing instanceof OpticElement) {
            ((OpticElement)thing).setResizable(bl);
        }
        return true;
    }

    public boolean setConstraint(int n, int n2) {
        Thing thing = this.bench.getThing(n);
        Thing thing2 = this.bench.getThing(n2);
        if (thing == null) {
            return false;
        }
        if (thing2 == null) {
            return false;
        }
        if (!(thing2 instanceof Constraint)) {
            return false;
        }
        thing.setConstraint((Constraint)thing2);
        return true;
    }

    public void setDrag(boolean bl) {
        this.drag = bl;
    }

    public boolean setAnimationSlave(int n, int n2) {
        Thing thing = this.bench.getThing(n);
        Thing thing2 = this.bench.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        thing.addSlave(thing2);
        thing.updateMySlaves();
        if (thing2 instanceof OpticElement) {
            thing2.setVarsFromMaster();
            ((OpticElement)thing2).adjustPosition();
        }
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return true;
    }

    public boolean setResizable(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setResizable(bl);
        return true;
    }

    public void setPropertyDrag(boolean bl) {
        this.propertyDrag = bl;
    }

    public void setInfo(boolean bl) {
        this.info = bl;
    }

    public void setElementRGB(int n, int n2, int n3) {
        if (n == 0 && n2 == 0 && n3 == 0) {
            this.bench.setElementColor(null);
        } else {
            this.bench.setElementColor(new Color(n, n2, n3));
        }
    }

    public boolean setObjectFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        Thing thing = this.bench.getThing(n);
        if (thing == null || font == null) {
            return false;
        }
        thing.setFont(font);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return true;
    }

    public void setRayRGB(int n, int n2, int n3) {
        this.bench.setRayColor(new Color(n, n2, n3));
    }

    public boolean setRGB(int n, int n2, int n3, int n4) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setColor(new Color(n2, n3, n4));
        return true;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setPixPerUnit(int n) {
        this.pixPerUnit = n;
        this.bench.setPixPerUnit(n);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            this.bench.repaint();
        }
    }

    public void setDefault() {
        this.deleteDataConnections();
        this.info = false;
        this.drag = false;
        this.propertyDrag = false;
        this.bench.setElementColor(null);
        this.bench.setRayColor(null);
        this.clearAll();
        this.setPixPerUnit(this.defaultPixPerUnit);
        this.setInfo(false);
        this.setSize(0.8);
        this.setDrag(false);
        this.setPropertyDrag(false);
        this.setDirection(1);
    }

    public void setUnDefault() {
        this.clearAll();
        this.setPixPerUnit(this.defaultPixPerUnit);
        this.setInfo(true);
        this.setSize(0.8);
        this.setDrag(true);
        this.setPropertyDrag(true);
        this.setDirection(1);
    }

    public boolean setVisibility(int n, boolean bl) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return false;
        }
        thing.setVisible(bl);
        return true;
    }

    void lensBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.opticString != null && this.opticString.equals("lens")) {
            this.setNull();
        } else {
            this.opticString = "lens";
            this.setBtnOff();
            this.lensBtn.setForeground(Color.blue);
            this.lensBtn.repaint();
        }
    }

    void sourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.sourceBtn.getForeground() == Color.red) {
            this.setNull();
        } else {
            this.opticString = "source";
            this.setBtnOff();
            this.sourceBtn.setForeground(Color.red);
            this.sourceBtn.repaint();
        }
    }

    public double getFocalLength(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        return opticElement.focalLength / (double)this.pixPerUnit;
    }

    public double getX(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        return (double)opticElement.getPixX() / (double)this.pixPerUnit;
    }

    public void setX(int n, double d) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return;
        }
        thing.setX(d);
    }

    public void setXY(int n, double d, double d2) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return;
        }
        thing.setXY(d, d2);
    }

    public void setXPos(int n, double d) {
        this.setX(n, d);
    }

    public void setY(int n, double d) {
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            return;
        }
        thing.setY(d);
    }

    public void setYPos(int n, double d) {
        this.setY(n, d);
    }

    public double getY(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        Rectangle rectangle = this.bench.getBounds();
        return (double)(-(opticElement.getPixY() - rectangle.height / 2)) / (double)this.pixPerUnit;
    }

    public double getXPos(int n) {
        return this.getX(n);
    }

    public double getYPos(int n) {
        return this.getY(n);
    }

    public void setElementSize(double d) {
        this.setSize(d);
    }

    public void setSize(Dimension dimension) {
        if (this.started && !(class$java$awt$Dimension == null ? (class$java$awt$Dimension = OpticsApplet.class$("java.awt.Dimension")) : class$java$awt$Dimension).isInstance(dimension)) {
            dimension = super.getSize();
            System.out.println("SCRIPT ERROR: Java 1.4 plug-in does not support method overloading.");
            System.out.println("Method: setSize");
            System.out.println("Alternate method: setElementSize.");
            System.out.println("");
        }
        super.setSize(dimension);
    }

    public void setSize(int n, int n2) {
        if (this.started) {
            n = super.getWidth();
            n2 = super.getHeight();
            System.out.println("SCRIPT ERROR: Java 1.4 plug-in does not support method overloading.");
            System.out.println("Method: setSize");
            System.out.println("Alternate method: setElementSize.");
            System.out.println("");
        }
        super.setSize(n, n2);
    }

    public double getIndex(int n) {
        OpticElement opticElement = this.bench.getElement(n);
        if (opticElement == null) {
            return 0.0;
        }
        return opticElement.indexOfRefraction;
    }

    public synchronized boolean set(int n, String string, String string2) {
        double d;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        Thing thing = this.bench.getThing(n);
        if (thing == null) {
            System.out.println("Object not found in set method.");
            return false;
        }
        if (thing instanceof OpticElement) {
            double d2;
            OpticElement opticElement;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                opticElement = (OpticElement)thing;
                d2 = SUtil.getParam((String)string2, (String)"x=");
                opticElement.setX(d2);
                opticElement.adjustPosition();
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                opticElement = (OpticElement)thing;
                d2 = SUtil.getParam((String)string2, (String)"y=");
                opticElement.setY(d2);
                opticElement.adjustPosition();
            }
            if (SUtil.parameterExist((String)string2, (String)"f=")) {
                opticElement = (OpticElement)thing;
                d2 = SUtil.getParam((String)string2, (String)"f=");
                Rectangle rectangle = this.bench.getBounds();
                opticElement.setFocalLength(d2 * (double)this.pixPerUnit, rectangle);
            }
            if (SUtil.parameterExist((String)string2, (String)"dn=") && thing instanceof Dielectric) {
                opticElement = (Dielectric)thing;
                d2 = SUtil.getParam((String)string2, (String)"dn=");
                ((Dielectric)opticElement).setDelN(d2);
                this.bench.recalculateIndexOfRefraction();
            }
            if (this.autoRefresh) {
                this.bench.repaint();
            }
            return true;
        }
        if (SUtil.parameterExist((String)string2, (String)"x=")) {
            d = SUtil.getParam((String)string2, (String)"x=");
            thing.setX(d);
        }
        if (SUtil.parameterExist((String)string2, (String)"y=")) {
            d = SUtil.getParam((String)string2, (String)"y=");
            thing.setY(d);
        }
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return true;
    }

    public synchronized int addObject(String string, String string2) {
        Object object = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        String string3 = string2.trim();
        string2 = SUtil.removeWhitespace((String)string2);
        if (string.equals("matrix")) {
            String string4 = "h";
            String string5 = "a";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"height=")) {
                string4 = SUtil.getParamStr((String)string2, (String)"height=");
            }
            if (SUtil.parameterExist((String)string2, (String)"angle=")) {
                string5 = SUtil.getParamStr((String)string2, (String)"angle=");
            }
            int n = this.bench.addMatrix((int)(d * (double)this.pixPerUnit), 0, string4, string5);
            if (this.autoRefresh) {
                this.bench.repaint();
            }
            return n;
        }
        if (string.equals("lens")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"f=")) {
                d3 = SUtil.getParam((String)string2, (String)"f=");
            }
            return this.addLens(d, d3);
        }
        if (string.equals("screen")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            return this.addScreen(d);
        }
        if (string.equals("source")) {
            OpticElement opticElement;
            String string6;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"infinite")) {
                int n = 20;
                double d4 = 0.0;
                if (SUtil.parameterExist((String)string2, (String)"s=")) {
                    n = (int)SUtil.getParam((String)string2, (String)"s=");
                }
                if (SUtil.parameterExist((String)string2, (String)"slope=")) {
                    d4 = SUtil.getParam((String)string2, (String)"slope=");
                }
                return this.addISource(d, d2, n, d4);
            }
            if (SUtil.parameterExist((String)string2, (String)"point")) {
                double d5 = 0.1;
                double d6 = 0.5;
                if (SUtil.parameterExist((String)string2, (String)"slope=")) {
                    d6 = SUtil.getParam((String)string2, (String)"slope=");
                }
                if (SUtil.parameterExist((String)string2, (String)"inc=")) {
                    d5 = SUtil.getParam((String)string2, (String)"inc=");
                }
                int n = this.addSource(d, d2, d5, d6);
                Source source = (Source)this.bench.getThing(n);
                if (SUtil.parameterExist((String)string2, (String)"nrays=")) {
                    int n2;
                    source.numberOfRays = n2 = (int)SUtil.getParam((String)string2, (String)"nrays=");
                }
                return n;
            }
            int n = this.addPSource(d, d2);
            if (SUtil.parameterExist((String)string2, (String)"rays=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"rays=");
                opticElement = this.bench.getElement(n);
                if (string6.toLowerCase().equals("false")) {
                    opticElement.showRays = false;
                }
            }
            if (SUtil.parameterExist((String)string2, (String)"imagelabel=")) {
                string6 = SUtil.getParamStr((String)string2, (String)"imagelabel=");
                opticElement = this.bench.getElement(n);
                if (string6.toLowerCase().equals("false")) {
                    opticElement.imageLabel = false;
                }
            }
            return n;
        }
        if (string.equals("dielectric")) {
            double d7 = 1.0;
            double d8 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"dn=")) {
                d7 = SUtil.getParam((String)string2, (String)"dn=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                d8 = SUtil.getParam((String)string2, (String)"r=");
            }
            if (d8 == 0.0) {
                return this.addIndexChange(d, d7);
            }
            return this.addDielectric(d, d7, d8);
        }
        if (string.equals("refraction")) {
            double d9 = 1.0;
            double d10 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"dn=")) {
                d9 = SUtil.getParam((String)string2, (String)"dn=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                d10 = SUtil.getParam((String)string2, (String)"r=");
            }
            return this.addRefraction(d, d9, d10);
        }
        if (string.equals("mirror")) {
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"f=")) {
                d3 = SUtil.getParam((String)string2, (String)"f=");
            }
            if (SUtil.parameterExist((String)string2, (String)"spherical")) {
                return this.addSphericalMirror(d, d3);
            }
            return this.addMirror(d, d3);
        }
        if (string.equals("aperture")) {
            double d11 = 1.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"opening=")) {
                d11 = SUtil.getParam((String)string2, (String)"opening=");
            }
            d11 = Math.min(1.0, d11);
            d11 = Math.max(0.0, d11);
            return this.addAperture(d, d11);
        }
        if (string.equals("beamstop")) {
            double d12 = 0.0;
            double d13 = 1.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"top=")) {
                d12 = SUtil.getParam((String)string2, (String)"top=");
            }
            if (SUtil.parameterExist((String)string2, (String)"bottom=")) {
                d13 = SUtil.getParam((String)string2, (String)"bottom=");
            }
            d12 = Math.min(1.0, d12);
            d12 = Math.max(0.0, d12);
            d13 = Math.min(1.0, d13);
            d13 = Math.max(0.0, d13);
            return this.addBeamStop(d, d12, d13);
        }
        if (string.equals("constraint")) {
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"xmin=")) {
                d14 = SUtil.getParam((String)string2, (String)"xmin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymin=")) {
                d16 = SUtil.getParam((String)string2, (String)"ymin=");
            }
            if (SUtil.parameterExist((String)string2, (String)"xmax=")) {
                d15 = SUtil.getParam((String)string2, (String)"xmax=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ymax=")) {
                d17 = SUtil.getParam((String)string2, (String)"ymax=");
            }
            object = new Constraint((SApplet)this, (SScalable)this.bench, d14, d15, d16, d17);
            object.setColor(Color.pink);
        } else if (string.equals("protractor")) {
            int n = 40;
            double d18 = 0.0;
            double d19 = 0.0;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta=")) {
                d18 = SUtil.getParam((String)string2, (String)"theta=");
            }
            if (SUtil.parameterExist((String)string2, (String)"theta0=")) {
                d19 = SUtil.getParam((String)string2, (String)"theta0=");
            }
            if (SUtil.parameterExist((String)string2, (String)"s=")) {
                n = (int)SUtil.getParam((String)string2, (String)"s=");
            }
            ProtractorThing protractorThing = new ProtractorThing((SApplet)this, (SScalable)this.bench, n, d18, d19, d, d2);
            if (SUtil.parameterExist((String)string2, (String)"fixedbase")) {
                protractorThing.fixedBase = true;
            }
            if (SUtil.parameterExist((String)string2, (String)"fixedlength")) {
                protractorThing.fixedlength = true;
            }
            object = protractorThing;
        } else if (string.equals("rectangle")) {
            int n = 20;
            int n3 = 20;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n3 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new RectangleThing((SApplet)this, (SScalable)this.bench, d, d2, n, n3);
        } else if (string.equals("circle")) {
            int n = 10;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new CircleThing((SApplet)this, (SScalable)this.bench, d, d2, n);
        } else if (string.equals("shell")) {
            int n = 10;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                n = (int)SUtil.getParam((String)string2, (String)"r=");
            }
            object = new ShellThing((SApplet)this, (SScalable)this.bench, d, d2, n);
        } else if (string.equals("box")) {
            int n = 20;
            int n4 = 20;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"w=")) {
                n = (int)SUtil.getParam((String)string2, (String)"w=");
            }
            if (SUtil.parameterExist((String)string2, (String)"h=")) {
                n4 = (int)SUtil.getParam((String)string2, (String)"h=");
            }
            object = new BoxThing((SApplet)this, (SScalable)this.bench, d, d2, n, n4);
        } else if (string.equals("text") || string.equals("calculation")) {
            String string7 = "";
            String string8 = null;
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"txt=")) {
                string7 = SUtil.getParamStr((String)string3, (String)"txt=");
            }
            if (SUtil.parameterExist((String)string2, (String)"text=")) {
                string7 = SUtil.getParamStr((String)string3, (String)"text=");
            }
            if (SUtil.parameterExist((String)string2, (String)"calc=")) {
                string8 = SUtil.getParamStr((String)string2, (String)"calc=");
            }
            object = new CalcThing(this, this.bench, string7, string8, d, d2);
        } else if (string.equals("image")) {
            String string9 = " ";
            if (SUtil.parameterExist((String)string2, (String)"x=")) {
                d = SUtil.getParam((String)string2, (String)"x=");
            }
            if (SUtil.parameterExist((String)string2, (String)"y=")) {
                d2 = SUtil.getParam((String)string2, (String)"y=");
            }
            if (SUtil.parameterExist((String)string2, (String)"gif=")) {
                string9 = SUtil.getParamStr((String)string2, (String)"gif=");
            }
            if (SUtil.parameterExist((String)string2, (String)"file=")) {
                string9 = SUtil.getParamStr((String)string2, (String)"file=");
            }
            if (string9 == null) {
                return 0;
            }
            Image image = this.getImage(string9);
            object = image != null ? new ImageThing((SApplet)this, (SScalable)this.bench, image, d, d2) : null;
        } else if (string.equals("bench")) {
            object = new BenchThing(this.bench);
            this.bench.hasBench = true;
        }
        if (object == null) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Object not created. name:").append(string).append("parameter list:").append(string2))));
            return 0;
        }
        object.setResizable(false);
        if (SUtil.parameterExist((String)string2, (String)"label=")) {
            object.setLabel(SUtil.getParamStr((String)string3, (String)"label="));
        }
        this.bench.addThing((Thing)object);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return object.hashCode();
    }

    public synchronized boolean deleteObject(int n) {
        return this.bench.deleteObject(n);
    }

    public synchronized void deleteActiveElement() {
        this.bench.clearActiveElement();
    }

    public synchronized int makeDataConnection(int n, int n2, int n3, String string, String string2) {
        Thing thing = this.bench.getThing(n);
        if (thing instanceof SStepable) {
            this.clock.addClockListener((SStepable)thing);
            thing.setTime(this.clock.getTime());
        }
        return super.makeDataConnection(n, n2, n3, string, string2);
    }

    private Image getImage(String string) {
        Serializable serializable;
        Image image;
        try {
            image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getCodeBase(), string);
        }
        catch (Exception exception) {
            image = null;
        }
        if (image == null) {
            try {
                image = ((Applet)((Object)this)).getImage(((Applet)((Object)this)).getDocumentBase(), string);
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image == null) {
            try {
                serializable = new URL(string);
                image = ((Applet)((Object)this)).getImage((URL)serializable);
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image == null) {
            System.out.println("Failed to load image file.");
            return image;
        }
        serializable = new MediaTracker((Component)((Object)this));
        try {
            ((MediaTracker)serializable).addImage(image, 0);
            ((MediaTracker)serializable).waitForID(0, 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public int addAperture(double d, double d2) {
        return this.addAperature(d, d2);
    }

    private int addAperature(double d, double d2) {
        int n = this.bench.addAperature((int)(d * (double)this.pixPerUnit), 0, (int)(d2 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    private int addBeamStop(double d, double d2, double d3) {
        int n = this.bench.addBeamStop((int)(d * (double)this.pixPerUnit), 0, (int)(d3 * (double)this.bench.getBounds().height), (int)(d2 * (double)this.bench.getBounds().height), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addDielectric(double d, double d2, double d3) {
        int n = this.bench.addDielectric((int)(d * (double)this.pixPerUnit), 0, d2, (int)(d3 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addIndexChange(double d, double d2) {
        int n = this.bench.addIndexChange((int)(d * (double)this.pixPerUnit), 0, d2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addRefraction(double d, double d2, double d3) {
        int n = this.bench.addRefraction((int)(d * (double)this.pixPerUnit), 0, d2, (int)(d3 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addISource(double d, double d2, int n, double d3) {
        Rectangle rectangle = this.bench.getBounds();
        int n2 = this.bench.addISource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), n, d3, this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addLens(double d, double d2) {
        int n = this.bench.addLens((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addMirror(double d, double d2) {
        int n = this.bench.addMirror((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addSphericalMirror(double d, double d2) {
        int n = this.bench.addSphericalMirror((int)(d * (double)this.pixPerUnit), 0, d2 * (double)this.pixPerUnit, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addPSource(double d, double d2) {
        Rectangle rectangle = this.bench.getBounds();
        int n = this.bench.addPSource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addScreen(double d) {
        int n = this.bench.addScreen((int)(d * (double)this.pixPerUnit), 0, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addSource(double d, double d2, double d3, double d4) {
        Rectangle rectangle = this.bench.getBounds();
        int n = this.bench.addSource((int)(d * (double)this.pixPerUnit), (int)((double)rectangle.height / 2.0 - d2 * (double)this.pixPerUnit), d3, -Math.abs(d4), this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n;
    }

    public int addApertureP(int n, int n2) {
        return this.addAperatureP(n, n2);
    }

    private int addAperatureP(int n, int n2) {
        int n3 = this.bench.addAperature(n, 0, n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addDielectricP(int n, double d, int n2) {
        int n3 = this.bench.addDielectric(n, 0, d, n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addIndexChangeP(int n, double d) {
        int n2 = this.bench.addIndexChange(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addRefractionP(int n, double d, int n2) {
        int n3 = this.bench.addRefraction(n, 0, d, n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addISourceP(int n, int n2, int n3, double d) {
        Rectangle rectangle = this.bench.getBounds();
        int n4 = this.bench.addISource(n, rectangle.height / 2 - n2, n3, d, this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n4;
    }

    public int addLensP(int n, double d) {
        int n2 = this.bench.addLens(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addMirrorP(int n, double d) {
        int n2 = this.bench.addMirror(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addSphericalMirrorP(int n, double d) {
        int n2 = this.bench.addSphericalMirror(n, 0, d, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addPSourceP(int n, int n2) {
        Rectangle rectangle = this.bench.getBounds();
        int n3 = this.bench.addPSource(n, rectangle.height / 2 - n2, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    public int addScreenP(int n) {
        int n2 = this.bench.addScreen(n, 0, this.info, this.drag, this.size, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n2;
    }

    public int addSourceP(int n, int n2, double d, double d2) {
        Rectangle rectangle = this.bench.getBounds();
        int n3 = this.bench.addSource(n, rectangle.height / 2 - n2, d, -Math.abs(d2), this.info, this.drag, this.direction, this.propertyDrag);
        if (this.autoRefresh) {
            this.bench.repaint();
        }
        return n3;
    }

    void bench_mousePressed(MouseEvent mouseEvent) {
        this.bench.isControlDown = mouseEvent.isControlDown();
        if (this.opticString == "lens") {
            this.bench.addLens(mouseEvent.getX(), mouseEvent.getY(), this.defaultFocalLength, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "mirror") {
            this.bench.addMirror(mouseEvent.getX(), mouseEvent.getY(), this.defaultFocalLength, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "source") {
            this.bench.addSource(mouseEvent.getX(), mouseEvent.getY(), 0.25, -1.0, this.info, this.drag, this.direction, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "psource") {
            this.bench.addPSource(mouseEvent.getX(), mouseEvent.getY(), this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "screen") {
            this.bench.addScreen(mouseEvent.getX(), mouseEvent.getY(), this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "isource") {
            this.bench.addISource(mouseEvent.getX(), mouseEvent.getY(), 100, 0.0, this.info, this.drag, this.direction, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "aperature") {
            this.bench.addAperature(mouseEvent.getX(), mouseEvent.getY(), this.defaultOpeningSize, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == "dielectric") {
            this.bench.addDielectric(mouseEvent.getX(), mouseEvent.getY(), this.defaultDelN, this.defaultR, this.info, this.drag, this.size, this.propertyDrag);
            this.setNull();
        }
        if (this.opticString == null) {
            this.bench.mousePressed(mouseEvent.getX(), mouseEvent.getY());
        }
        ((Component)((Object)this)).repaint();
    }

    public void setNull() {
        this.opticString = null;
        this.setBtnOff();
    }

    void nullBtn_actionPerformed(ActionEvent actionEvent) {
        this.setNull();
    }

    void clearBtn_actionPerformed(ActionEvent actionEvent) {
        this.bench.clearThings();
        this.opticString = null;
        this.setBtnOff();
        ((Component)((Object)this)).repaint();
    }

    void bench_mouseReleased(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseReleased(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void bench_mouseDragged(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseDragged(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void bench_mouseMoved(MouseEvent mouseEvent) {
        if (this.opticString == null) {
            this.bench.mouseMoved(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void psourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.psourceBtn.getForeground() == Color.red) {
            this.setNull();
        } else {
            this.opticString = "psource";
            this.setBtnOff();
            this.psourceBtn.setForeground(Color.red);
            this.psourceBtn.repaint();
        }
    }

    void isourceBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.isourceBtn.getForeground() == Color.green) {
            this.setNull();
        } else {
            this.opticString = "isource";
            this.setBtnOff();
            this.isourceBtn.setForeground(Color.green);
            this.isourceBtn.repaint();
        }
    }

    public void setBtnOff() {
        this.lensBtn.setForeground(Color.black);
        this.sourceBtn.setForeground(Color.black);
        this.psourceBtn.setForeground(Color.black);
        this.isourceBtn.setForeground(Color.black);
        this.aperatureBtn.setForeground(Color.black);
        this.mirrorBtn.setForeground(Color.black);
        this.bench.repaint();
    }

    void aperatureBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.aperatureBtn.getForeground() == Color.yellow) {
            this.setNull();
        } else {
            this.opticString = "aperature";
            this.setBtnOff();
            this.aperatureBtn.setForeground(Color.yellow);
            this.aperatureBtn.repaint();
        }
    }

    void clearActiveElementBtn_actionPerformed(ActionEvent actionEvent) {
        this.bench.clearActiveElement();
    }

    void mirrorBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.mirrorBtn.getForeground() == Color.blue) {
            this.setNull();
        } else {
            this.opticString = "mirror";
            this.setBtnOff();
            this.mirrorBtn.setForeground(Color.blue);
            this.mirrorBtn.repaint();
        }
    }

    void buttonControl1_actionPerformed(ActionEvent actionEvent) {
        this.addSource(50.0, 50.0, 0.25, -1.0);
    }

    void bench_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 && this.showControls) {
            this.bench.clearActiveElement();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

