/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import optics.Bench;
import optics.OpticElement;

public class Source
extends OpticElement {
    String typeOfSource;
    int numberOfRays;
    int i;
    int lengthOfRay = 1000;
    int interval;
    int direction = 1;
    double theta;
    double rayIncrement = 0.25;
    double raySlope = -1.0;
    int nRays = -1;

    public Source(Bench bench) {
        super(bench);
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if ((!this.noDrag || this.resizable) && n > this.xPosition - 10 && n < this.xPosition + 10 && n2 > this.yPosition - 10 && n2 < this.yPosition + 10) {
            return 1;
        }
        if (this.resizable && n > this.xPosition + this.direction * 40 - 5 && n < this.xPosition + this.direction * 40 + 5 && (double)n2 > (double)this.yPosition + this.raySlope * (double)(this.direction * 40) - (double)5 && (double)n2 < (double)this.yPosition + this.raySlope * (double)(this.direction * 40) + (double)5) {
            return 2;
        }
        return 0;
    }

    public Source(Bench bench, String string) {
        super(bench);
        this.typeOfSource = string;
    }

    public Source(Bench bench, int n, int n2, double d, double d2, boolean bl, boolean bl2, int n3, boolean bl3) {
        super(bench);
        this.rayIncrement = d;
        this.raySlope = d2;
        this.info = bl;
        this.noDrag = !bl2;
        this.direction = n3;
        this.xPosition = n;
        this.yPosition = n2;
        this.setX((double)this.xPosition / (double)this.bench.pixPerUnit);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
        this.mat[0][0] = 1.0;
        this.mat[0][1] = 0.0;
        this.mat[1][0] = 0.0;
        this.mat[1][1] = 1.0;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(new Color(200, 50, 50));
        graphics.fillRect(this.xPosition - 8, this.yPosition - 8, 16, 16);
        if (this.color == null) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(this.color);
        }
        graphics.fillOval(this.xPosition - 3, this.yPosition - 3, 6, 6);
        graphics.setColor(Color.gray);
        graphics.drawRect(this.xPosition - 9, this.yPosition - 9, 17, 17);
        graphics.setColor(Color.black);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (!this.noDrag) {
            graphics.setColor(Color.white);
            graphics.fillRect(this.xPosition - 8, this.yPosition - 8, 16, 16);
            graphics.setColor(Color.gray);
            graphics.drawRect(this.xPosition - 9, this.yPosition - 9, 17, 17);
        }
        if (this.resizable) {
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition + this.direction * 40 - 3, (int)((double)this.yPosition + this.raySlope * (double)(this.direction * 40) - (double)3), 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer("x = ").append(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit)).append(" , y =").append(this.df.format(1.0 * (double)rectangle.height / (double)2 / (double)this.pixPerUnit - 1.0 * (double)this.yPosition / (double)this.pixPerUnit)))), this.xPosition, rectangle.height - 70);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.bench.owner.label_rayinc))).append(" ").append(this.df.format(this.rayIncrement)))), this.xPosition, rectangle.height - 50);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.bench.owner.label_rayslope))).append(" ").append(this.df.format(-this.raySlope)))), this.xPosition, rectangle.height - 30);
        }
    }

    public String getType() {
        return "source";
    }

    public double getTheta() {
        return (double)2 / (this.theta - 1.0);
    }

    public int getRays() {
        return this.numberOfRays;
    }

    public void setRayIncrement(double d) {
        this.rayIncrement = d <= 0.0 ? 0.005 : d;
    }

    public double getRayIncrement() {
        return this.rayIncrement;
    }

    public void setRaySlope(double d) {
        this.raySlope = d;
        if (this.raySlope > (double)5) {
            this.raySlope = 5.0;
        }
        if (this.raySlope < (double)-5) {
            this.raySlope = -5.0;
        }
    }

    public double getRaySlope() {
        return this.raySlope;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }
}

