/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.Animator;
import animator4.Animator_mouseAdapter;
import animator4.Animator_mouseMotionAdapter;
import animator4.Arrow;
import animator4.ArrowStatic;
import animator4.Box;
import animator4.CalcThing;
import animator4.CaptionThing;
import animator4.Charge;
import animator4.Circle;
import animator4.CollisionDataSource;
import animator4.Connector;
import animator4.CursorThing;
import animator4.Doppler;
import animator4.DrawnRectangle;
import animator4.ExShell;
import animator4.FunctionThing;
import animator4.ImageThing;
import animator4.Interaction;
import animator4.MouseDataSource;
import animator4.Piston;
import animator4.Protractor;
import animator4.ShapeThing;
import animator4.Shell;
import animator4.Spring;
import animator4.TextThing;
import animator4.Thing;
import animator4.TrailThing;
import edu.davidson.display.Format;
import edu.davidson.graphics.Util;
import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SRK45;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;

public final class AnimatorCanvas
extends Canvas
implements SStepable,
SDataSource {
    private MouseMotionAdapter mouseMotionAdapter;
    private MouseAdapter mouseAdapter;
    private boolean enableMouse = false;
    private int boxWidth = 0;
    private Format mouseFormat = new Format("%-+6.3g");
    private Image sketchImage = null;
    private boolean sketchMode = false;
    private TrailThing trailThing = null;
    private Cursor sketchCursor = null;
    private Thing referenceObject = null;
    CollisionDataSource collisionDataSource = null;
    Thing dragThing = null;
    Color defaultColor = null;
    Vector things = new Vector();
    Font boldFont = new Font("Helvetica", 1, 14);
    Animator owner = null;
    int pixPerUnit = 10;
    Image backgroundImage = null;
    Image osi;
    int iwidth = 0;
    int iheight = 0;
    int xOffset = 0;
    int yOffset = 0;
    double gridUnit = 1.0;
    double time = 0.0;
    boolean timeDisplay = true;
    boolean coordDisplay = true;
    boolean autoRefresh = true;
    String message = null;
    boolean mouseDrag = false;
    int mouseX = 0;
    int mouseY = 0;
    String[] varStrings = new String[]{"t", "xcm", "ycm", "px", "py", "m", "ke"};
    double[][] ds = new double[1][7];
    DynamicsSolver dynamics = new DynamicsSolver();
    int stickyCount = 0;
    int bouncyCount = 0;
    boolean dampOnMousePressed = true;

    public AnimatorCanvas(Animator animator) {
        this();
        this.owner = animator;
    }

    public AnimatorCanvas() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setEnableMouse(true);
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public double[][] getVariables() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            d5 += thing.mass;
            d += thing.mass * thing.vars[1];
            d2 += thing.mass * thing.vars[2];
            d3 += thing.mass * thing.vars[3];
            d4 += thing.mass * thing.vars[4];
            d6 += thing.mass * (thing.vars[3] * thing.vars[3] + thing.vars[4] * thing.vars[4]);
        }
        this.ds[0][0] = this.time;
        this.ds[0][1] = d5 > 0.0 ? d / d5 : 0.0;
        this.ds[0][2] = d5 > 0.0 ? d2 / d5 : 0.0;
        this.ds[0][3] = d3;
        this.ds[0][4] = d4;
        this.ds[0][5] = d5;
        this.ds[0][6] = d6 / 2.0;
        return this.ds;
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    void clearTrails() {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.clearTrail();
        }
    }

    public void setReferenceObject(Thing thing) {
        boolean bl = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        this.referenceObject = thing;
        this.clearTrails();
        this.paintOSI();
        if (bl) {
            this.owner.clock.startClock();
        } else {
            this.repaint();
        }
    }

    public Thing getReferenceObject() {
        return this.referenceObject;
    }

    public int addParametricCurve(int n, double d, double d2, String string, String string2) {
        FunctionThing functionThing = new FunctionThing(this, n, d, d2, string, string2);
        if (this.defaultColor != null) {
            functionThing.color = this.defaultColor;
        }
        this.things.addElement(functionThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return functionThing.hashCode();
    }

    public int addPolyShape(int n, int[] nArray, int[] nArray2, String string, String string2) {
        ShapeThing shapeThing = new ShapeThing(this, n, nArray, nArray2, string, string2);
        if (this.defaultColor != null) {
            shapeThing.color = this.defaultColor;
        }
        this.things.addElement(shapeThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return shapeThing.hashCode();
    }

    public boolean addInteraction(int n, int n2, String string, String string2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        string2 = string2.trim();
        int n3 = (string2 = string2.toLowerCase()).equals("x") ? Interaction.XMODE : (string2.equals("y") ? Interaction.YMODE : Interaction.RMODE);
        if (thing != null && thing.dynamic) {
            thing.addInteraction(thing2, string, n3);
        }
        if (thing2 != null && thing2.dynamic) {
            thing2.addInteraction(thing, string, n3);
        }
        return true;
    }

    public boolean deleteObject(int n) {
        Thing thing = null;
        thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        if (this.owner != null) {
            this.owner.stop();
        }
        this.things.removeElement(thing);
        if (this.owner != null) {
            this.owner.removeDataSource(thing.hashCode());
            this.owner.removeDataListener(thing.hashCode());
            this.owner.cleanupDataConnections();
        }
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    public int addArrow(int n, String string, String string2, String string3, String string4) {
        Arrow arrow = new Arrow(this, n, string, string2, string3, string4);
        if (this.defaultColor != null) {
            arrow.color = this.defaultColor;
        }
        this.things.addElement(arrow);
        if (this.autoRefresh) {
            this.repaint();
        }
        return arrow.hashCode();
    }

    public int addArrowStatic(int n, double d, double d2, String string, String string2) {
        ArrowStatic arrowStatic = new ArrowStatic(this, n, d, d2, string, string2);
        if (this.defaultColor != null) {
            arrowStatic.color = this.defaultColor;
        }
        this.things.addElement(arrowStatic);
        if (this.autoRefresh) {
            this.repaint();
        }
        return arrowStatic.hashCode();
    }

    public int addProtractor(int n, double d, double d2, String string, String string2) {
        Protractor protractor = new Protractor(this, n, d, d2, string, string2);
        if (this.defaultColor != null) {
            protractor.color = this.defaultColor;
        }
        this.things.addElement(protractor);
        if (this.autoRefresh) {
            this.repaint();
        }
        return protractor.hashCode();
    }

    public int addPiston(int n, String string, String string2, String string3, String string4) {
        Piston piston = new Piston(this, n, string, string2, string3, string4);
        if (this.defaultColor != null) {
            piston.color = this.defaultColor;
        }
        this.things.addElement(piston);
        if (this.autoRefresh) {
            this.repaint();
        }
        return piston.hashCode();
    }

    public int addSpring(int n, String string, String string2, String string3, String string4) {
        Spring spring = new Spring(this, n, string, string2, string3, string4);
        if (this.defaultColor != null) {
            spring.color = this.defaultColor;
        }
        this.things.addElement(spring);
        if (this.autoRefresh) {
            this.repaint();
        }
        return spring.hashCode();
    }

    public int addCircle(int n, String string, String string2) {
        Circle circle = new Circle(this, n, string, string2);
        if (this.defaultColor != null) {
            circle.color = this.defaultColor;
        }
        this.things.addElement(circle);
        if (this.autoRefresh) {
            this.repaint();
        }
        return circle.hashCode();
    }

    public int addDoppler(int n, String string, String string2, int n2, double d, double d2) {
        Doppler doppler = new Doppler(this, n, string, string2, n2, d, d2);
        if (this.defaultColor != null) {
            doppler.color = this.defaultColor;
        }
        this.things.addElement(doppler);
        if (this.autoRefresh) {
            this.repaint();
        }
        return doppler.hashCode();
    }

    public int addCharge(int n, String string, String string2, double d) {
        Charge charge = new Charge(this, n, string, string2, d);
        if (this.defaultColor != null) {
            charge.color = this.defaultColor;
        }
        this.things.addElement(charge);
        if (this.autoRefresh) {
            this.repaint();
        }
        return charge.hashCode();
    }

    public int addShell(int n, String string, String string2) {
        Shell shell = new Shell(this, n, string, string2);
        if (this.defaultColor != null) {
            shell.color = this.defaultColor;
        }
        this.things.addElement(shell);
        if (this.autoRefresh) {
            this.repaint();
        }
        return shell.hashCode();
    }

    public int addExShell(int n, String string, String string2, String string3) {
        ExShell exShell = new ExShell(this, n, string, string2, string3);
        if (this.defaultColor != null) {
            exShell.color = this.defaultColor;
        }
        this.things.addElement(exShell);
        if (this.autoRefresh) {
            this.repaint();
        }
        return exShell.hashCode();
    }

    public int addBox(int n, int n2, String string, String string2) {
        Box box = new Box(this, n, n2, string, string2);
        if (this.defaultColor != null) {
            box.color = this.defaultColor;
        }
        this.things.addElement(box);
        if (this.autoRefresh) {
            this.repaint();
        }
        return box.hashCode();
    }

    public int addRectangle(int n, int n2, String string, String string2) {
        DrawnRectangle drawnRectangle = new DrawnRectangle(this, n, n2, string, string2);
        if (this.defaultColor != null) {
            drawnRectangle.color = this.defaultColor;
        }
        this.things.addElement(drawnRectangle);
        if (this.autoRefresh) {
            this.repaint();
        }
        return drawnRectangle.hashCode();
    }

    public int addText(String string, String string2, String string3, String string4) {
        TextThing textThing = new TextThing(this, string, string2, string3, string4);
        if (this.defaultColor != null) {
            textThing.color = this.defaultColor;
        }
        this.things.addElement(textThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return textThing.hashCode();
    }

    public int addCalcThing(String string, String string2, String string3) {
        CalcThing calcThing = new CalcThing(this, string, string2, string3);
        if (this.defaultColor != null) {
            calcThing.color = this.defaultColor;
        }
        this.things.addElement(calcThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return calcThing.hashCode();
    }

    public int addCaption(String string, String string2, String string3, String string4) {
        CaptionThing captionThing = new CaptionThing(this, string, string2, string3, string4);
        this.things.addElement(captionThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return captionThing.hashCode();
    }

    public int addCursor(int n, String string, String string2) {
        CursorThing cursorThing = new CursorThing(this, n, string, string2);
        this.things.addElement(cursorThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return cursorThing.hashCode();
    }

    public MouseDataSource addMouseThing() {
        MouseDataSource mouseDataSource = new MouseDataSource(this);
        this.things.addElement(mouseDataSource);
        return mouseDataSource;
    }

    public CollisionDataSource getCollisionThing() {
        if (this.collisionDataSource != null) {
            return this.collisionDataSource;
        }
        this.collisionDataSource = new CollisionDataSource(this);
        this.things.addElement(this.collisionDataSource);
        return this.collisionDataSource;
    }

    public int addImage(Image image, String string, String string2) {
        if (image == null) {
            return 0;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0, 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageThing imageThing = new ImageThing(this, image, string, string2);
        this.things.addElement(imageThing);
        if (this.autoRefresh) {
            this.repaint();
        }
        return imageThing.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMouseMovedListeners(int n, int n2) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof MouseDataSource)) continue;
            ((MouseDataSource)thing).moveXY(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMouseDragListeners(double d, double d2) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof MouseDataSource)) continue;
            ((MouseDataSource)thing).dragXY(d, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMouseClickListeners(int n, int n2) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof MouseDataSource)) continue;
            ((MouseDataSource)thing).clickXY(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMouseReleaseListeners(int n, int n2) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof MouseDataSource)) continue;
            ((MouseDataSource)thing).releaseXY(n, n2);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.osi == null) {
            return;
        }
        Image image = this.osi;
        synchronized (image) {
            this.paintOSI();
            graphics.drawImage(this.osi, 0, 0, this);
            if (this.mouseDrag && this.sketchMode && this.sketchImage != null) {
                graphics.drawImage(this.sketchImage, this.mouseX, this.mouseY - this.sketchImage.getHeight(this), this);
            }
            graphics.dispose();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (!this.autoRefresh) {
            return;
        }
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osi = this.createImage(this.iwidth, this.iheight);
        }
        if (this.owner.isClockRunning()) {
            return;
        }
        if (this.osi == null) {
            return;
        }
        Image image = this.osi;
        synchronized (image) {
            this.paintOSI();
            graphics.drawImage(this.osi, 0, 0, this);
        }
    }

    public void paintOSI() {
        int n = this.iwidth / 2 - this.xOffset;
        int n2 = this.iheight / 2 + this.yOffset;
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (graphics == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (this.referenceObject != null) {
            n3 = this.pixFromX(this.referenceObject.getX()) - this.pixFromX(0.0);
            n4 = this.pixFromY(this.referenceObject.getY()) - this.pixFromY(0.0);
        }
        this.xOffset += n3;
        this.yOffset -= n4;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.iwidth, this.iheight);
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, 0, 0, this);
        }
        graphics.clipRect(0, 0, this.iwidth, this.iheight);
        this.paintThingsBeforeGrid(graphics);
        this.paintGrid(graphics, n, n2);
        this.paintThingsAfterGrid(graphics);
        this.xOffset -= n3;
        this.yOffset += n4;
        this.paintTime(graphics);
        this.paintMessage(graphics);
        if (this.mouseDrag) {
            this.paintCoords(graphics, this.mouseX, this.mouseY);
        }
        graphics.dispose();
    }

    void setTime() {
        Object object;
        this.time = this.owner.clock.getTime();
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            object = (Thing)enumeration.nextElement();
            ((Thing)object).setTime(this.time, this.owner.dt / 10000.0);
        }
        object = this.things.elements();
        while (object.hasMoreElements()) {
            Thing thing = (Thing)object.nextElement();
            thing.setVarsFromMaster();
        }
        this.dynamics.resetDynamicsVariables();
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
        if (this.autoRefresh) {
            this.paint();
        }
    }

    public void step(double d, double d2) {
        Object object;
        if (d == 0.0) {
            return;
        }
        if (this.testForCollision()) {
            if (this.owner.label_collision != null && !this.owner.label_collision.equals("")) {
                this.setMessage(this.owner.label_collision);
            }
            this.owner.stopClock();
            return;
        }
        this.bounceThings();
        this.dynamics.step(d, d2);
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            object = (Thing)enumeration.nextElement();
            if (!((Thing)object).dynamic && ((Thing)object).noDrag && ((Thing)object).myMaster == null) {
                ((Thing)object).setVars(this.time + d, d);
            }
            if (!((Thing)object).dynamic) {
                ((Thing)object).vars[0] = this.time + d;
            }
            if (((Thing)object).myMaster != null || object instanceof TrailThing) continue;
            ((Thing)object).incTrail();
        }
        if (this.dragThing != null) {
            this.dragThing.vars[0] = this.time + d;
            this.dragThing.vars[3] = 0.0;
            this.dragThing.vars[4] = 0.0;
        }
        object = this.things.elements();
        while (object.hasMoreElements()) {
            Thing thing = (Thing)object.nextElement();
            if (thing.myMaster == null) continue;
            thing.setVarsFromMaster();
            thing.incTrail();
        }
        this.time = d2 + d;
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
        this.paint();
    }

    public void setMessage(String string) {
        if (this.message == null && string == null || this.message != null && this.message.equals(string)) {
            return;
        }
        this.message = string;
        this.paintMessage();
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public int setCaption(String string) {
        int n = this.addCaption(string, null, "0", "0");
        if (this.autoRefresh) {
            this.repaint();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintThingsBeforeGrid(Graphics graphics) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!thing.paintBeforeGrid) continue;
            thing.paint(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintThingsAfterGrid(Graphics graphics) {
        Vector vector;
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (thing.paintBeforeGrid) continue;
            thing.paint(graphics);
        }
    }

    void paintTime(Graphics graphics) {
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(this.boldFont);
        String string = new Format("%7.4g").form(SUtil.chop((double)this.time, (double)1.0E-12));
        if (this.timeDisplay) {
            if (this.iwidth > 150) {
                graphics.drawString(this.owner.label_time + ": " + string, 10, 15);
            } else {
                graphics.drawString(this.owner.label_time + ": " + string, 10, this.iheight - 40);
            }
        }
        graphics.setFont(font);
    }

    void paintGrid(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setColor(Color.lightGray);
        int n4 = (int)Math.round((double)this.pixPerUnit * this.gridUnit);
        if (n4 > 0) {
            n3 = n % n4;
            while (n3 < this.iwidth) {
                graphics.drawLine(n3, 0, n3, this.iheight);
                n3 += n4;
            }
        }
        if (n4 > 0) {
            n3 = n2 % n4;
            while (n3 < this.iheight) {
                graphics.drawLine(0, n3, this.iwidth, n3);
                n3 += n4;
            }
        }
    }

    void paintMessage() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintMessage(graphics);
            graphics.dispose();
        }
    }

    void paintMessage(Graphics graphics) {
        String string = this.message;
        if (string == null || graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(string);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.iwidth - n + 2, this.iheight - 3);
        graphics.drawRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
    }

    void paintCoords(int n, int n2) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintCoords(graphics, n, n2);
            graphics.dispose();
        }
    }

    void paintCoords(Graphics graphics, int n, int n2) {
        if (!this.coordDisplay) {
            return;
        }
        String string = "" + this.mouseFormat.form(this.xFromPix(n)) + " , " + this.mouseFormat.form(this.yFromPix(n2));
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.yellow);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        this.boxWidth = Math.max(20 + fontMetrics.stringWidth(string), this.boxWidth);
        graphics.fillRect(0, rectangle.height - 20, this.boxWidth, 20);
        graphics.setColor(Color.black);
        graphics.drawString(string, 10, rectangle.height - 5);
        graphics.drawRect(0, rectangle.height - 20, this.boxWidth - 1, 20);
    }

    double xFromPix(int n) {
        int n2 = this.iwidth / 2 - this.xOffset;
        return (double)(n - n2) / (1.0 * (double)this.pixPerUnit);
    }

    double yFromPix(int n) {
        int n2 = this.iheight / 2 + this.yOffset;
        return (double)(-(n - n2)) / (1.0 * (double)this.pixPerUnit);
    }

    int pixFromX(double d) {
        int n = (int)((double)(this.iwidth / 2) + d * (double)this.pixPerUnit - (double)this.xOffset);
        return n;
    }

    int pixFromY(double d) {
        int n = (int)((double)(this.iheight / 2) - d * (double)this.pixPerUnit + (double)this.yOffset);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDefault() {
        Vector vector;
        this.defaultColor = null;
        this.referenceObject = null;
        this.dragThing = null;
        this.collisionDataSource = null;
        this.setBackground(Color.white);
        this.xOffset = 0;
        this.yOffset = 0;
        this.dynamics = new DynamicsSolver();
        Vector vector2 = this.things;
        synchronized (vector2) {
            vector = (Vector)this.things.clone();
            this.things.removeAllElements();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            this.owner.removeDataListener(thing.hashCode());
            this.owner.removeDataSource(thing.hashCode());
        }
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public final boolean setFormat(String string) {
        try {
            this.mouseFormat = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public int setSketchMode(boolean bl) {
        this.sketchImage = Util.getImage((String)"pencil.gif", (Applet)((Object)this.owner));
        boolean bl2 = false;
        int n = 29;
        this.sketchMode = bl;
        if (!bl) {
            this.trailThing = null;
            return 0;
        }
        this.sketchCursor = null;
        return 0;
    }

    public synchronized boolean swapZOrder(int n, int n2) {
        Thing thing = this.getThing(n);
        Thing thing2 = this.getThing(n2);
        if (thing == null || thing2 == null) {
            return false;
        }
        int n3 = this.things.indexOf(thing);
        int n4 = this.things.indexOf(thing2);
        this.things.removeElementAt(n3);
        this.things.insertElementAt(thing2, n3);
        this.things.removeElementAt(n4);
        this.things.insertElementAt(thing, n4);
        if (this.autoRefresh) {
            this.repaint();
        }
        return true;
    }

    void highlightMySlaves(Thing thing, Graphics graphics) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (thing2.myMaster != thing) continue;
            thing2.paintHighlight(graphics);
        }
    }

    void paintMyConnectors(Thing thing, Graphics graphics) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (!(thing2 instanceof Connector) || thing != ((Connector)thing2).thing1 && thing != ((Connector)thing2).thing2) continue;
            thing2.paint(graphics);
        }
    }

    public boolean isEnableMouse() {
        return this.enableMouse;
    }

    boolean isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.noDrag && !thing.resizable || !thing.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    boolean isInsideStickyThing(int n, int n2, Thing thing) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (thing2.dynamic || thing2 == thing || !thing2.sticky || !thing2.isInsideThing(n, n2) && !thing.isInsideThing(this.pixFromX(thing2.vars[1]), this.pixFromY(thing2.vars[2]))) continue;
            return true;
        }
        return false;
    }

    void bounceMe(int n, int n2, Thing thing) {
        Thing thing2 = null;
        Enumeration enumeration = this.things.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (thing2 == thing || !thing2.bouncy || !thing2.isInsideThing(n, n2)) continue;
            double d = Math.abs(thing.vars[1] - thing2.vars[1]) - (double)(thing2.w / this.pixPerUnit) / 2.0;
            double d2 = Math.abs(thing.vars[2] - thing2.vars[2]) - (double)(thing2.h / this.pixPerUnit) / 2.0;
            if (Math.abs(d) < Math.abs(d2)) {
                if (thing.vars[3] < thing2.vars[3] && thing.vars[1] > thing2.vars[1]) {
                    thing.vars[3] = -thing.vars[3];
                    this.dynamics.resetDynamicsVariable(thing);
                    continue;
                }
                if (!(thing.vars[3] > thing2.vars[3]) || !(thing.vars[1] < thing2.vars[1])) continue;
                thing.vars[3] = -thing.vars[3];
                this.dynamics.resetDynamicsVariable(thing);
                continue;
            }
            if (thing.vars[4] < thing2.vars[4] && thing.vars[2] > thing2.vars[2]) {
                thing.vars[4] = -thing.vars[4];
                this.dynamics.resetDynamicsVariable(thing);
                continue;
            }
            if (!(thing.vars[4] > thing2.vars[4]) || !(thing.vars[2] < thing2.vars[2])) continue;
            thing.vars[4] = -thing.vars[4];
            this.dynamics.resetDynamicsVariable(thing);
        }
    }

    public boolean testForCollision() {
        if (this.stickyCount == 0) {
            return false;
        }
        int n = this.things.size();
        this.stickyCount = 0;
        int n2 = 0;
        while (n2 < n) {
            Thing thing = (Thing)this.things.elementAt(n2);
            if (thing.sticky && thing.dynamic) {
                ++this.stickyCount;
                if (this.isInsideStickyThing(this.pixFromX(thing.vars[1]), this.pixFromY(thing.vars[2]), thing)) {
                    if (this.collisionDataSource != null) {
                        this.collisionDataSource.setXY(thing.vars[1], thing.vars[2]);
                        this.collisionDataSource.setBlock(false);
                        this.owner.updateDataConnection(this.collisionDataSource.hashCode());
                        this.collisionDataSource.setBlock(true);
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public void bounceThings() {
        if (this.bouncyCount == 0) {
            return;
        }
        int n = this.things.size();
        this.bouncyCount = 0;
        int n2 = 0;
        while (n2 < n) {
            Thing thing = (Thing)this.things.elementAt(n2);
            if (thing.dynamic) {
                ++this.bouncyCount;
                this.bounceMe(this.pixFromX(thing.vars[1]), this.pixFromY(thing.vars[2]), thing);
            }
            ++n2;
        }
    }

    public void setEnableMouse(boolean bl) {
        if (this.enableMouse == bl) {
            return;
        }
        this.enableMouse = bl;
        if (this.enableMouse) {
            this.mouseMotionAdapter = new Animator_mouseMotionAdapter(this);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.mouseAdapter = new Animator_mouseAdapter(this);
            this.addMouseListener(this.mouseAdapter);
        } else {
            this.removeMouseMotionListener(this.mouseMotionAdapter);
            this.removeMouseListener(this.mouseAdapter);
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        int n;
        if ((mouseEvent.getModifiers() & 4) == 0) {
            this.mouseDrag = true;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.updateMouseClickListeners(this.mouseX, this.mouseY);
            Graphics graphics = this.getGraphics();
            n = this.things.size();
            int n2 = 0;
            while (n2 < n) {
                Thing thing = (Thing)this.things.elementAt(n2);
                if ((!thing.noDrag || thing.resizable) && thing.isInsideThing(this.mouseX, this.mouseY)) {
                    this.dragThing = thing;
                }
                ++n2;
            }
            if (this.dragThing != null) {
                this.mouseX = this.pixFromX(this.dragThing.getX());
                this.mouseY = this.pixFromY(this.dragThing.getY());
                double d = this.xFromPix(this.mouseX);
                double d2 = this.yFromPix(this.mouseY);
                if (this.dragThing.dynamic) {
                    this.dynamics.resetDynamicsDragThingVariables(d, d2);
                } else {
                    if (!(this.dragThing instanceof ArrowStatic)) {
                        this.dragThing.setXY(d, d2);
                    }
                    if (this.dampOnMousePressed) {
                        this.dragThing.setVX(0.0);
                        this.dragThing.setVY(0.0);
                    }
                }
                this.dragThing.updateMySlaves();
                this.owner.updateDataConnection(this.dragThing.hashCode());
                graphics.setXORMode(this.getBackground());
                this.dragThing.paintHighlight(graphics);
                this.highlightMySlaves(this.dragThing, graphics);
                graphics.setPaintMode();
            }
            graphics.dispose();
            this.paintCoords(this.mouseX, this.mouseY);
        }
        if (this.sketchMode) {
            if (this.trailThing == null) {
                this.trailThing = new TrailThing(this, 1);
                this.trailThing.trailSize = 2000;
                this.things.addElement(this.trailThing);
            }
            int n3 = this.iwidth;
            n = 0;
            if (this.mouseX < n) {
                this.mouseX = n;
            } else if (this.mouseX > n3 - 2) {
                this.mouseX = n3 - 2;
            }
            double d = this.xFromPix(this.mouseX);
            n = 0;
            n3 = this.iheight;
            if (this.mouseY < n) {
                this.mouseY = n;
            } else if (this.mouseY > n3 - 2) {
                this.mouseY = n3 - 2;
            }
            double d3 = this.yFromPix(this.mouseY);
            this.trailThing.incTrail(d, d3);
            this.owner.clearData(this.trailThing.hashCode());
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.this_mouseDragged(mouseEvent);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.iwidth;
        int n2 = 0;
        if (this.mouseX < n2) {
            this.mouseX = n2;
        } else if (this.mouseX > n - 2) {
            this.mouseX = n - 2;
        }
        double d = this.xFromPix(this.mouseX);
        n2 = 0;
        n = this.iheight;
        if (this.mouseY < n2) {
            this.mouseY = n2;
        } else if (this.mouseY > n - 2) {
            this.mouseY = n - 2;
        }
        double d2 = this.yFromPix(this.mouseY);
        this.updateMouseDragListeners(d, d2);
        if (this.dragThing != null) {
            if (this.dragThing.dynamic) {
                this.dynamics.resetDynamicsDragThingVariables(d, d2);
            } else {
                this.dragThing.setXY(d, d2);
                if (this.dampOnMousePressed) {
                    this.dragThing.setVX(0.0);
                    this.dragThing.setVY(0.0);
                }
            }
            this.dragThing.updateMySlaves();
            if (!this.owner.isClockRunning()) {
                this.owner.updateDataConnection(this.dragThing.hashCode());
                this.paint();
            }
        } else if (this.sketchMode && this.trailThing != null) {
            this.trailThing.incTrail(d, d2);
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            if (this.sketchImage != null) {
                graphics.drawImage(this.sketchImage, this.mouseX, this.mouseY - this.sketchImage.getHeight(this), this);
            }
            this.trailThing.paint(graphics);
            graphics.dispose();
            this.owner.updateDataConnection(this.trailThing.hashCode());
        }
        this.paintCoords(this.mouseX, this.mouseY);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.mouseDrag = false;
        Rectangle rectangle = this.getBounds();
        if (this.sketchMode && this.trailThing != null) {
            this.owner.updateDataConnection(this.trailThing.hashCode());
            this.trailThing = null;
        }
        if (this.dragThing == null && !this.sketchMode) {
            this.repaint(0, rectangle.height - 20, this.boxWidth, 20);
        } else {
            this.paint();
        }
        this.dragThing = null;
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.boxWidth = 0;
        if (mouseEvent == null) {
            return;
        }
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.updateMouseReleaseListeners(this.mouseX, this.mouseY);
    }

    public void this_mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void this_mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void this_mouseMoved(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.updateMouseMovedListeners(this.mouseX, this.mouseY);
        if (this.isInsideDragableThing(this.mouseX, this.mouseY)) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    final class DynamicsSolver
    implements SDifferentiable {
        int n = 1;
        private SRK45 odeSolver = new SRK45();
        private double[] dxdt = new double[1];
        double[] vars = new double[1];
        Vector dThings = new Vector();

        public DynamicsSolver() {
            this.odeSolver.setDifferentials((SDifferentiable)this);
        }

        public final double[] rate(double[] dArray) {
            if (4 * this.dThings.size() != this.n - 1) {
                return new double[this.n];
            }
            this.updateThings();
            this.dxdt[0] = 1.0;
            int n = 1;
            while (n < this.n) {
                Thing thing = (Thing)this.dThings.elementAt((n - 1) / 4);
                this.dxdt[n] = thing.constrainX ? 0.0 : dArray[n + 2];
                this.dxdt[n + 1] = thing.constrainY ? 0.0 : dArray[n + 3];
                if (thing.constrainR) {
                    thing.constrainedRForce(n, this.dxdt);
                } else {
                    this.dxdt[n + 2] = thing.getFx() / thing.mass;
                    this.dxdt[n + 3] = thing.getFy() / thing.mass;
                }
                n += 4;
            }
            return this.dxdt;
        }

        public final int getNumEqu() {
            return this.n;
        }

        synchronized void addRateEquation(Thing thing) {
            boolean bl = false;
            if (AnimatorCanvas.this.owner.isClockRunning()) {
                bl = true;
                AnimatorCanvas.this.owner.pause();
            }
            this.dThings.addElement(thing);
            this.dxdt = new double[this.n + 4];
            this.vars = new double[this.n + 4];
            this.vars[0] = AnimatorCanvas.this.time;
            this.n += 4;
            int n = 1;
            while (n < this.n) {
                thing = (Thing)this.dThings.elementAt((n - 1) / 4);
                this.vars[n] = thing.vars[1];
                this.vars[n + 1] = thing.vars[2];
                this.vars[n + 2] = thing.vars[3];
                this.vars[n + 3] = thing.vars[4];
                n += 4;
            }
            thing.vars[5] = thing.getTotalFx() / thing.mass;
            thing.vars[6] = thing.getTotalFy() / thing.mass;
            this.odeSolver.setDifferentials((SDifferentiable)this);
            if (bl) {
                AnimatorCanvas.this.owner.forward();
            }
        }

        synchronized void resetDynamicsDragThingVariables(double d, double d2) {
            boolean bl = false;
            if (AnimatorCanvas.this.owner.isClockRunning()) {
                bl = true;
                AnimatorCanvas.this.owner.pause();
            }
            this.vars[0] = AnimatorCanvas.this.time;
            int n = 1;
            while (n < this.n) {
                Thing thing = (Thing)this.dThings.elementAt((n - 1) / 4);
                if (thing == AnimatorCanvas.this.dragThing) {
                    thing.vars[1] = d;
                    thing.vars[2] = d2;
                    if (AnimatorCanvas.this.dampOnMousePressed) {
                        thing.vars[3] = 0.0;
                        thing.vars[4] = 0.0;
                    }
                    thing.enforceConstraintOnXY();
                    this.vars[n] = thing.vars[1];
                    this.vars[n + 1] = thing.vars[2];
                    this.vars[n + 2] = thing.vars[3];
                    this.vars[n + 3] = thing.vars[4];
                    thing.vars[5] = 0.0;
                    thing.vars[6] = 0.0;
                }
                n += 4;
            }
            if (bl) {
                AnimatorCanvas.this.owner.forward();
            }
        }

        synchronized void resetDynamicsVariable(Thing thing) {
            int n = this.dThings.indexOf(thing);
            n = 1 + n * 4;
            this.vars[n] = thing.vars[1];
            this.vars[n + 1] = thing.vars[2];
            this.vars[n + 2] = thing.vars[3];
            this.vars[n + 3] = thing.vars[4];
        }

        synchronized void resetDynamicsVariables() {
            boolean bl = false;
            if (AnimatorCanvas.this.owner.isClockRunning()) {
                bl = true;
                AnimatorCanvas.this.owner.pause();
            }
            this.vars[0] = AnimatorCanvas.this.time;
            int n = 1;
            while (n < this.n) {
                Thing thing = (Thing)this.dThings.elementAt((n - 1) / 4);
                this.vars[n] = thing.vars[1];
                this.vars[n + 1] = thing.vars[2];
                this.vars[n + 2] = thing.vars[3];
                this.vars[n + 3] = thing.vars[4];
                thing.vars[5] = thing.getTotalFx() / thing.mass;
                thing.vars[6] = thing.getTotalFy() / thing.mass;
                n += 4;
            }
            if (bl) {
                AnimatorCanvas.this.owner.forward();
            }
        }

        void updateThings() {
            int n = 1;
            while (n < this.n) {
                Thing thing = (Thing)this.dThings.elementAt((n - 1) / 4);
                thing.vars[0] = this.vars[0];
                thing.vars[1] = this.vars[n];
                thing.vars[2] = this.vars[n + 1];
                thing.vars[3] = this.vars[n + 2];
                thing.vars[4] = this.vars[n + 3];
                n += 4;
            }
        }

        void setTolerance(double d) {
            this.odeSolver.setTol(d);
        }

        void step(double d, double d2) {
            if (d == 0.0) {
                return;
            }
            if (this.n < 2) {
                return;
            }
            this.vars[0] = d2;
            this.odeSolver.step(d, this.vars);
            int n = 1;
            while (n < this.n) {
                Thing thing = (Thing)this.dThings.elementAt((n - 1) / 4);
                thing.vars[0] = d2 + d;
                thing.vars[1] = this.vars[n];
                thing.vars[2] = this.vars[n + 1];
                thing.vars[3] = this.vars[n + 2];
                thing.vars[4] = this.vars[n + 3];
                if (thing.enforceConstraintOnXY()) {
                    this.vars[n + 2] = thing.vars[3];
                    this.vars[n + 3] = thing.vars[4];
                }
                thing.vars[5] = thing.getTotalFx() / thing.mass;
                thing.vars[6] = thing.getTotalFy() / thing.mass;
                if (thing == AnimatorCanvas.this.dragThing) {
                    this.vars[n] = AnimatorCanvas.this.xFromPix(AnimatorCanvas.this.mouseX);
                    this.vars[n + 1] = AnimatorCanvas.this.yFromPix(AnimatorCanvas.this.mouseY);
                    this.vars[n + 2] = 0.0;
                    this.vars[n + 3] = 0.0;
                }
                n += 4;
            }
            if (AnimatorCanvas.this.dragThing != null && AnimatorCanvas.this.dragThing.dynamic) {
                AnimatorCanvas.this.dragThing.vars[1] = AnimatorCanvas.this.xFromPix(AnimatorCanvas.this.mouseX);
                AnimatorCanvas.this.dragThing.vars[2] = AnimatorCanvas.this.yFromPix(AnimatorCanvas.this.mouseY);
                if (AnimatorCanvas.this.dampOnMousePressed) {
                    AnimatorCanvas.this.dragThing.vars[3] = 0.0;
                    AnimatorCanvas.this.dragThing.vars[4] = 0.0;
                }
                AnimatorCanvas.this.dragThing.enforceConstraintOnXY();
                AnimatorCanvas.this.dragThing.vars[5] = AnimatorCanvas.this.dragThing.getTotalFx() / AnimatorCanvas.this.dragThing.mass;
                AnimatorCanvas.this.dragThing.vars[6] = AnimatorCanvas.this.dragThing.getTotalFy() / AnimatorCanvas.this.dragThing.mass;
            }
        }
    }
}

