/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.graph;

import edu.davidson.graph.SpecialFunction;
import edu.davidson.graph.TextState;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Stack;
import java.util.Vector;

public class TextLine {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int SCIENTIFIC = 1;
    public static final int ALGEBRAIC = 2;
    static final int MINIMUM_SIZE = 6;
    protected double script_fraction = 0.8;
    protected double sup_offset = 0.6;
    protected double sub_offset = 0.7;
    protected Font font = null;
    protected Color color = null;
    protected Color background = null;
    protected String text = null;
    protected String fontname = "TimesRoman";
    protected int fontsize = 0;
    protected int fontstyle = 0;
    protected int justification = 1;
    protected int width = 0;
    protected int ascent = 0;
    protected int maxAscent = 0;
    protected int descent = 0;
    protected int maxDescent = 0;
    protected int height = 0;
    protected int leading = 0;
    protected boolean parse = true;
    protected Graphics lg = null;
    protected Vector list = new Vector(8, 4);

    public TextLine() {
    }

    public TextLine(String string) {
        this.text = string;
    }

    public TextLine(String string, Font font) {
        this(string);
        this.font = font;
        if (this.font == null) {
            return;
        }
        this.fontname = font.getName();
        this.fontstyle = font.getStyle();
        this.fontsize = font.getSize();
    }

    public TextLine(String string, Font font, Color color, int n) {
        this(string, font);
        this.color = color;
        this.justification = n;
    }

    public TextLine(String string, Color color) {
        this(string);
        this.color = color;
    }

    public TextLine(Font font, Color color, int n) {
        this.font = font;
        this.color = color;
        this.justification = n;
        if (this.font == null) {
            return;
        }
        this.fontname = font.getName();
        this.fontstyle = font.getStyle();
        this.fontsize = font.getSize();
    }

    public TextLine copyState() {
        return new TextLine(this.font, this.color, this.justification);
    }

    public void copyState(TextLine textLine) {
        if (textLine == null) {
            return;
        }
        this.font = textLine.getFont();
        this.color = textLine.getColor();
        this.justification = textLine.getJustification();
        if (this.font == null) {
            return;
        }
        this.fontname = this.font.getName();
        this.fontstyle = this.font.getStyle();
        this.fontsize = this.font.getSize();
        this.parse = true;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontname = font.getName();
        this.fontstyle = font.getStyle();
        this.fontsize = font.getSize();
        this.parse = true;
    }

    public void setText(String string) {
        this.text = string;
        this.parse = true;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setJustification(int n) {
        switch (n) {
            case 0: {
                this.justification = 0;
                break;
            }
            default: {
                this.justification = 1;
                break;
            }
            case 2: {
                this.justification = 2;
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getBackground() {
        return this.background;
    }

    public int getJustification() {
        return this.justification;
    }

    public FontMetrics getFM(Graphics graphics) {
        if (graphics == null) {
            return null;
        }
        if (this.font == null) {
            return graphics.getFontMetrics();
        }
        return graphics.getFontMetrics(this.font);
    }

    public int charWidth(Graphics graphics, char c) {
        if (graphics == null) {
            return 0;
        }
        FontMetrics fontMetrics = this.font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.font);
        return fontMetrics.charWidth(c);
    }

    public int getWidth(Graphics graphics) {
        this.parseText(graphics);
        return this.width;
    }

    public int getHeight(Graphics graphics) {
        this.parseText(graphics);
        return this.height;
    }

    public int getAscent(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        this.parseText(graphics);
        return this.ascent;
    }

    public int getMaxAscent(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        this.parseText(graphics);
        return this.maxAscent;
    }

    public int getDescent(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        this.parseText(graphics);
        return this.descent;
    }

    public int getMaxDescent(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        this.parseText(graphics);
        return this.maxDescent;
    }

    public int getLeading(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        this.parseText(graphics);
        return this.leading;
    }

    public void parseText(Graphics graphics) {
        Vector vector;
        TextState textState = new TextState();
        Stack<TextState> stack = new Stack<TextState>();
        int n = 0;
        if (this.lg != graphics) {
            this.parse = true;
        }
        this.lg = graphics;
        if (!this.parse) {
            return;
        }
        this.parse = false;
        this.width = 0;
        this.leading = 0;
        this.ascent = 0;
        this.descent = 0;
        this.height = 0;
        this.maxAscent = 0;
        this.maxDescent = 0;
        if (this.text == null || graphics == null) {
            return;
        }
        this.list.removeAllElements();
        textState.f = this.font == null ? graphics.getFont() : this.font;
        stack.push(textState);
        this.list.addElement(textState);
        FontMetrics fontMetrics = graphics.getFontMetrics(textState.f);
        block10: for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            switch (c) {
                case '$': {
                    if (++i >= this.text.length()) continue block10;
                    textState.s.append(this.text.charAt(i));
                    continue block10;
                }
                case '{': {
                    n = textState.getWidth(graphics);
                    if (!textState.isEmpty()) {
                        textState = textState.copyState();
                        this.list.addElement(textState);
                    }
                    stack.push(textState);
                    textState.x += n;
                    continue block10;
                }
                case '}': {
                    n = textState.x + textState.getWidth(graphics);
                    stack.pop();
                    textState = ((TextState)stack.peek()).copyState();
                    this.list.addElement(textState);
                    textState.x = n;
                    continue block10;
                }
                case '^': {
                    n = textState.getWidth(graphics);
                    if (!textState.isEmpty()) {
                        textState = textState.copyState();
                        this.list.addElement(textState);
                    }
                    textState.f = this.getScriptFont(textState.f);
                    textState.x += n;
                    textState.y -= (int)((double)textState.getAscent(graphics) * this.sup_offset + 0.5);
                    continue block10;
                }
                case '_': {
                    n = textState.getWidth(graphics);
                    if (!textState.isEmpty()) {
                        textState = textState.copyState();
                        this.list.addElement(textState);
                    }
                    textState.f = this.getScriptFont(textState.f);
                    textState.x += n;
                    textState.y += (int)((double)textState.getDescent(graphics) * this.sub_offset + 0.5);
                    continue block10;
                }
                default: {
                    textState.s.append(c);
                }
            }
        }
        Vector vector2 = this.list;
        synchronized (vector2) {
            vector = (Vector)this.list.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            textState = (TextState)vector.elementAt(i);
            if (textState.isEmpty()) continue;
            this.width += textState.getWidth(graphics);
            this.ascent = Math.max(this.ascent, Math.abs(textState.y) + textState.getAscent(graphics));
            this.descent = Math.max(this.descent, Math.abs(textState.y) + textState.getDescent(graphics));
            this.leading = Math.max(this.leading, textState.getLeading(graphics));
            this.maxDescent = Math.max(this.maxDescent, Math.abs(textState.y) + textState.getMaxDescent(graphics));
            this.maxAscent = Math.max(this.maxAscent, Math.abs(textState.y) + textState.getMaxAscent(graphics));
        }
        this.height = this.ascent + this.descent + this.leading;
    }

    public boolean isNull() {
        return this.text == null;
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.justification = n3;
        if (graphics == null) {
            return;
        }
        this.draw(graphics, n, n2);
    }

    public void draw(Graphics graphics, int n, int n2) {
        Vector vector;
        int n3 = n;
        int n4 = n2;
        if (graphics == null || this.text == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        if (graphics2 == null) {
            return;
        }
        this.parseText(graphics);
        if (this.justification == 0) {
            n3 = n - this.width / 2;
        } else if (this.justification == 2) {
            n3 = n - this.width;
        }
        if (this.background != null) {
            graphics2.setColor(this.background);
            graphics2.fillRect(n3, n4 - this.ascent, this.width, this.height);
            graphics2.setColor(graphics.getColor());
        }
        if (this.font != null) {
            graphics2.setFont(this.font);
        }
        if (this.color != null) {
            graphics2.setColor(this.color);
        }
        Vector vector2 = this.list;
        synchronized (vector2) {
            vector = (Vector)this.list.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            TextState textState = (TextState)vector.elementAt(i);
            if (textState.f != null) {
                graphics2.setFont(textState.f);
            }
            if (textState.s == null) continue;
            graphics2.drawString(textState.toString(), textState.x + n3, textState.y + n4);
        }
        graphics2.dispose();
        graphics2 = null;
    }

    public String getFontName() {
        return this.fontname;
    }

    public int getFontStyle() {
        return this.fontstyle;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontName(String string) {
        this.fontname = string;
        this.rebuildFont();
    }

    public void setFontStyle(int n) {
        this.fontstyle = n;
        this.rebuildFont();
    }

    public void setFontSize(int n) {
        this.fontsize = n;
        this.rebuildFont();
    }

    private void rebuildFont() {
        this.parse = true;
        this.font = this.fontsize <= 0 || this.fontname == null ? null : new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public Font getScriptFont(Font font) {
        if (font == null) {
            return font;
        }
        int n = font.getSize();
        if (n <= 6) {
            return font;
        }
        n = (int)((double)font.getSize() * this.script_fraction + 0.5);
        if (n <= 6) {
            return font;
        }
        return new Font(font.getName(), font.getStyle(), n);
    }

    public boolean parseDouble(double d) {
        return this.parseDouble(d, 7, 6, 2);
    }

    public boolean parseDouble(double d, int n) {
        return this.parseDouble(d, n + 1, n, 2);
    }

    public boolean parseDouble(double d, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        double d2 = d;
        int n7 = n - n2;
        double d3 = 0.0;
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        if (n7 < 0) {
            System.out.println("TextLine.parseDouble: Precision > significant figures!");
            return false;
        }
        if (d < 0.0) {
            d2 = -d;
            stringBuffer.append("-");
        }
        if ((n6 = (n5 = d == 0.0 ? 0 : (int)Math.floor(SpecialFunction.log10(d2))) - (n7 - 1)) < 0) {
            for (n4 = n6; n4 < 0; ++n4) {
                d2 *= 10.0;
            }
        } else {
            for (n4 = 0; n4 < n6; ++n4) {
                d2 /= 10.0;
            }
        }
        n7 = (int)d2;
        stringBuffer.append(n7);
        if (n2 > 0) {
            stringBuffer.append('.');
            d3 = d2 - (double)n7;
            for (n4 = 0; n4 < n2; ++n4) {
                int n8 = (int)Math.round(d3 *= (double)10);
                stringBuffer.append(n8);
                d3 -= (double)n8;
            }
        }
        if (n6 != 0) {
            if (n3 == 1) {
                stringBuffer.append('E');
                if (n6 < 0) {
                    stringBuffer.append('-');
                } else {
                    stringBuffer.append('+');
                }
                n6 = Math.abs(n6);
                if (n6 > 9) {
                    stringBuffer.append(n6);
                } else {
                    stringBuffer.append('0');
                    stringBuffer.append(n6);
                }
            } else {
                stringBuffer.append("x10{^");
                stringBuffer.append(n6);
                stringBuffer.append("}");
            }
        }
        this.setText(stringBuffer.toString());
        return true;
    }

    static {
        CENTER = 0;
        LEFT = 1;
        RIGHT = 2;
        SCIENTIFIC = 1;
        ALGEBRAIC = 2;
        MINIMUM_SIZE = 6;
    }
}

