/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.numerics;

import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SODE;

public final class SRK45
extends SODE {
    private static int maxMessages = 4;
    static double[][] b = new double[][]{{0.2222222222222222}, {0.08333333333333333, 0.25}, {0.5390625, -1.8984375, 2.109375}, {-1.4166666666666667, 6.75, -5.4, 1.0666666666666667}, {0.15046296296296297, -0.3125, 0.8125, 0.14814814814814814, 0.034722222222222224}};
    static double[] ch = new double[]{0.10444444444444445, 0.0, 0.48, 0.14222222222222222, 0.03333333333333333, 0.24};
    static double[] ct = new double[]{-0.006666666666666667, 0.0, 0.03, -0.21333333333333335, -0.05, 0.24};
    double stepSize;
    double fixedStepSize;
    int numEqu;
    double[] tempState;
    double[][] f;
    SDifferentiable equations;
    double err;
    double tol;
    int count;

    public SRK45() {
        this.fixedStepSize = this.stepSize = 0.01;
        this.numEqu = 0;
        this.tol = 1.0E-6;
        this.count = 0;
    }

    public double getH() {
        return this.stepSize;
    }

    public void setH(double d) {
        this.stepSize = d;
    }

    public double getTol() {
        return this.tol;
    }

    public void setTol(double d) {
        this.tol = d;
    }

    public int step(double d, double[] dArray) {
        if (d == 0.0) {
            return 0;
        }
        if (dArray.length < this.numEqu) {
            this.numEqu = dArray.length;
            this.tempState = new double[this.numEqu];
            this.f = new double[6][this.numEqu];
            System.out.println("Warning:  Temporary arrays reset.");
        }
        this.fixedStepSize = d;
        this.stepSize = d > 0.0 ? Math.abs(this.stepSize) : -Math.abs(this.stepSize);
        double d2 = 0.0;
        this.count = 0;
        d2 = this.fixedStepSize > 0.0 ? this.fixedStepSize - this.plus(dArray) : this.fixedStepSize - this.minus(dArray);
        return this.count;
    }

    public double stepODE(double d, double[] dArray) {
        if (dArray.length < this.numEqu) {
            System.out.println("Error:  The temporary arrays are not large enough.");
            return 0.0;
        }
        this.stepSize = d >= 0.0 ? Math.abs(d) : -Math.abs(d);
        return this.stepRK45(dArray);
    }

    public double stepRK45(double[] dArray) {
        int n;
        double[] dArray2 = dArray;
        if (dArray2.length < this.numEqu) {
            this.numEqu = dArray2.length;
            this.tempState = new double[this.numEqu];
            this.f = new double[6][this.numEqu];
            System.out.println("Warning:  Temporary arrays reset.");
        }
        double d = this.stepSize;
        System.arraycopy(dArray2, 0, this.tempState, 0, this.numEqu);
        double[] dArray3 = this.equations.rate(dArray2);
        for (n = 0; n < this.numEqu; ++n) {
            this.f[0][n] = dArray3[n];
        }
        do {
            int n2;
            d = this.stepSize;
            for (n2 = 1; n2 < 6; ++n2) {
                for (n = 0; n < this.numEqu; ++n) {
                    dArray2[n] = this.tempState[n];
                    for (int i = 0; i < n2; ++i) {
                        dArray2[n] = dArray2[n] + this.stepSize * b[n2 - 1][i] * this.f[i][n];
                    }
                }
                dArray3 = this.equations.rate(dArray2);
                for (n = 0; n < this.numEqu; ++n) {
                    this.f[n2][n] = dArray3[n];
                }
            }
            this.err = 0.0;
            for (n = 0; n < this.numEqu; ++n) {
                dArray2[n] = this.tempState[n];
                double d2 = 0.0;
                for (n2 = 0; n2 < 6; ++n2) {
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + this.stepSize * ch[n2] * this.f[n2][n];
                    d2 += this.stepSize * ct[n2] * this.f[n2][n];
                }
                if (!(this.err < (d2 = Math.abs(d2)))) continue;
                this.err = d2;
            }
            if (this.err <= Double.MIN_VALUE) {
                this.err = this.tol / 100000.0;
            }
            if (this.err > this.tol) {
                this.stepSize = 0.9 * this.stepSize * Math.pow(this.tol / this.err, 0.25);
                continue;
            }
            if (!(this.err < 2.0 * this.tol)) continue;
            this.stepSize = 0.9 * this.stepSize * Math.pow(this.tol / this.err, 0.2);
        } while (this.err > this.tol);
        return d;
    }

    public final void setDifferentials(SDifferentiable sDifferentiable) {
        this.equations = sDifferentiable;
        this.numEqu = this.equations.getNumEqu();
        this.tempState = new double[this.numEqu];
        this.f = new double[6][this.numEqu];
    }

    public final SDifferentiable getDiffernetials() {
        return this.equations;
    }

    public final void setNumberOfEquations(int n) {
        this.numEqu = n;
        this.tempState = new double[this.numEqu];
        this.f = new double[6][this.numEqu];
    }

    private double plus(double[] dArray) {
        double d = this.fixedStepSize;
        if (this.stepSize <= 0.0 || this.stepSize > this.fixedStepSize || this.fixedStepSize - this.stepSize == this.fixedStepSize) {
            this.stepSize = this.fixedStepSize;
        }
        while (d > this.tol * this.fixedStepSize) {
            ++this.count;
            double d2 = d;
            if (d <= this.stepSize) {
                double d3 = this.stepSize;
                this.stepSize = d;
                double d4 = this.stepRK45(dArray);
                d -= d4;
                this.stepSize = Math.min(d3, d4);
            } else {
                d -= this.stepRK45(dArray);
            }
            if (!(Math.abs(d2 - d) <= (double)100 * Double.MIN_VALUE) && !(this.tol * this.fixedStepSize / 100.0 > this.stepSize)) continue;
            if (maxMessages <= 0) break;
            System.out.println("Warning: RK45MultiStep did not converge. Remainder=".concat(String.valueOf(String.valueOf(d))));
            if (--maxMessages != 0) break;
            System.out.println("Further warnings surppressed.");
            break;
        }
        return d;
    }

    private double minus(double[] dArray) {
        double d = this.fixedStepSize;
        if (this.stepSize >= 0.0 || this.stepSize < this.fixedStepSize || this.fixedStepSize - this.stepSize == this.fixedStepSize) {
            this.stepSize = this.fixedStepSize;
        }
        while (d < this.tol * this.fixedStepSize) {
            ++this.count;
            double d2 = d;
            if (d >= this.stepSize) {
                double d3 = this.stepSize;
                this.stepSize = d;
                double d4 = this.stepRK45(dArray);
                d -= d4;
                this.stepSize = Math.max(d3, d4);
            } else {
                d -= this.stepRK45(dArray);
            }
            if (!(Math.abs(d2 - d) <= (double)100 * Double.MIN_VALUE) && !(this.tol * this.fixedStepSize / 100.0 < this.stepSize)) continue;
            if (maxMessages <= 0) break;
            System.out.println("Warning: RK45MultiStep did not converge. Remainder=".concat(String.valueOf(String.valueOf(d))));
            if (--maxMessages != 0) break;
            System.out.println("Further warnings surppressed.");
            break;
        }
        return d;
    }
}

