unit fahrbahn_u;

{ (c) Klaus-Dieter Grninger 2008, alle Rechte vorbehalten
  Bentzt die Kompontenten TAudioIO von John Mertus und AMixer von Vit Kovalcik 

  Der Eintrag 8820 fr die Puffergre (BufferSize) in AudioIn1 bestimmt,
  dass der Puffer vollstndige Fllung meldet, wenn 4410 Bytes eingelaufen sind - die Hlfte, weil die
  andere Hlfte fr den anderen Kanal bestimmt ist.

  Bei einer Frame-Rate von 22050 werden je Sekunde 22050 Messwerte erfasst.
  Der Puffer ist also jeweils nach 0,2 s voll und meldet sich.
  Aus der Zahl der schon ausgewerteten Puffer pz und der aktuellen
  Stelle im Puffereintrag i lsst sich die Zeit fe ein Ereignis (hell/dunkel)
  bestimmen. Dabei ist im Prinzip eine Auflsung 0,000045 s mglich.

  Tatschlich ist die maximal erreichbare Auflsung durch die Frequenz des
  eingespeisten Tonsignals bestimmt. Diese kann maximal 20.000 Hz (Grenze der Soundkarte)
  sein. Damit wre im Prinzip eine Auflsung von 0,00005 s mglich.

  Bei einer Frequenz von 5000 Hz (Hrbereich) ist die Auflsung immer noch 0,0002 s als
  1/5 Millisekunde, was ausreichen sollte.

  In der Realitt muss erst festgestellt werden, dass am Signalende keine weitere Amplitude mehr
  folgt. Dies kann zu geringfgigen Zeitverlngerungen fr die Verdunklungszeit fhren.

  Der erste Puffer muss verworfen werden, weil sich beim Ankoppeln des Eingangs an das System
  eine Ladung des Kondensators im Eingang der Soundkarte ergibt. Die Messung darf mit der Verdunklung
  der ersten Schranke also frhestens 0,2 s nach Drcken der Starttaste beginnen }


interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AudioIO, Grids, AMixer, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    AudioIn: TAudioIn;
    B_Start: TButton;
    SG: TStringGrid;
    Mixer: TAudioMixer;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    Messen1: TMenuItem;
    Laden1: TMenuItem;
    Speichernunter1: TMenuItem;
    Ende1: TMenuItem;
    L_status: TLabel;
    B_abbruch: TButton;
    Dunkelzeit1: TMenuItem;
    Dunkelundhell1: TMenuItem;
    GB1: TGroupBox;
    RB1: TRadioButton;
    RB2: TRadioButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Tabelle1: TMenuItem;
    L_mixer: TLabel;
    stTabelle1: TMenuItem;
    vtTabelle1: TMenuItem;
    Einstellungen1: TMenuItem;
    function AudioInBufferFilled(Buffer: PChar;
      var Size: Integer): Boolean;
    procedure B_StartClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Ende1Click(Sender: TObject);
    procedure B_abbruchClick(Sender: TObject);
    procedure Dunkelzeit1Click(Sender: TObject);
    procedure Dunkelundhell1Click(Sender: TObject);
    procedure RB2Click(Sender: TObject);
    procedure RB1Click(Sender: TObject);
    procedure StarteMessung;
    procedure Laden1Click(Sender: TObject);
    procedure Speichernunter1Click(Sender: TObject);
    procedure ZeigeTabelle;
    procedure Einstellungen1Click(Sender: TObject);
    procedure stTabelle1Click(Sender: TObject);
    procedure vtTabelle1Click(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

    type Sounddaten=Record        { Record aus den Daten der Soundkarte}
     device: integer;             { Nummer der Verbindung }
     L     : integer;             { Volume Links}
     R     : integer;             { Volume Rechts}
     M     : integer;             { Volume Balance}
     Stereo: boolean;             { Stereo ja nein }
     VD    : boolean;             {? }
     VM    : boolean;             {? }
     IsSelect: boolean;           { gewhlt }
end;

var
  Form1: TForm1;                                  { Das Formular }
  Zeit: array [0..1,0..10] of Real;               { Speicherfeld fr die Ereigniszeiten }
  t,pz,v,N  :integer;                             { Variablen fr die Erfassung der Zeiten}
  e : integer;                                    { Ereignis Nr }
  Verbindung: Array [0..3,0..10] of Sounddaten;   { Kanle der Soundkarte(n) }
  Spaltenzahl: integer;                           { Wieviele Spalten die Tabelle hat }
  zustand,tEvent,tstart: integer;                 { Zeitfelder }
  aufloesung: integer;                            { Auflsung der Messgenauigkeit }
  Dateiname: TFilename;                           { Dateivariable }
  Datei: TextFile;                                { Filetyp }
  messung: boolean;                               { Messung gemacht / geladen }
  Mixernummer, Kanalein: integer;                 { Einstellungen der Soundkarte }
  MindestAmpl: integer;                           { Mindestamplitude fr Messung }

const
   PausenDauer=7;          { muss zur Frequenz des Generators passen }

implementation
uses config_u , keine_Daten;      { eingebundene andere Formulare }
{$R *.dfm}

{ Nach einer Idee von Klaus J Koch }

function TForm1.AudioInBufferFilled(Buffer: PChar;
  var Size: Integer): Boolean;
{ der Puffer ist voll, was soll ich tun? }

var SP       : ^SmallInt;      { Zeiger auf den Speicher }
     i       : integer;        { Laufvariable }

begin
  N  := Size div 2;            { geteilt durch 2 wegen Stereo - Mono }
  SP := Pointer(Buffer);

  if pz > 0 then begin         { erste 0,2 s nach Start nicht bercksichtigen }

  for i := 0 to N-1 do         { gesamten Speicher abklappern }
     begin
       v := SP^; Inc(SP);      { aktueller Wert - value}
       t := (pz*N)+i;          { aktueller Kanalwert, pz - Periodenzhler , N Speichergre}

       if zustand = 0 then begin
          if abs(v) > MindestAmpl then begin
            zustand := 1;                           { Signal entdeckt }
            if e = 0 then tstart:=(pz*N)+i;         { Startzeit merken }
            tEvent := t;                            { aktuelle Zeit feststellen }
            Zeit[0,e]:=(tEvent-tstart)/22050;       { Laufzeit ins Dunkel-Feld }
            if aufloesung = 1 then
            SG.Cells[1,e+1]:=FormatFloat('0.000',Zeit[0,e]) { und in die Tabelle }
            else
            SG.Cells[1,e+1]:=FormatFloat('0.00',Zeit[0,e]); { und in die Tabelle }
         end
       end;                                         { von Zustand = 0}

       if zustand = 1 then begin
        if abs(v) > MindestAmpl then tEvent := t;   { Signal noch da }
             if ((t - tEvent > PausenDauer)AND(abs(v) < 100))then { mehr als eine Pause nichts }
           begin
                zustand := 0;
                Zeit[1,e]:=(tEvent-tstart)/22050;           { Zeit ins Hell-Feld }
                if aufloesung = 1 then begin
                SG.Cells[2,e+1]:=FormatFloat('0.000',Zeit[1,e]-0.0002); { Zeit in Tabelle }
                SG.Cells[3,e+1]:=FormatFloat('0.000',Zeit[1,e]-Zeit[0,e]-0.0002); { Differenz }
                { kurzer Zeitabzug, da mglicherweise die letzte halbe Periode zu viel ist }
                end
                else begin
                SG.Cells[2,e+1]:=FormatFloat('0.00',Zeit[1,e]-0.0002); { Zeit in Tabelle }
                SG.Cells[3,e+1]:=FormatFloat('0.00',Zeit[1,e]-Zeit[0,e]-0.0002); { Differenz }
                end;
                inc(e);                                      { Ereigniszhler erhhen }
              end
            end
       end;                     { Ende Laufschleife Speicher }
   end;
  inc(pz);                      { Pufferzhler erhhen }

  if e > 9 then begin           { 10 mal unterbrochen -> Fahrzeug ist durchgelaufen }
     L_status.Font.Color:=clRed;
     L_status.Caption:='  Messung beendet  '
  end

  else if e > 0 then begin
     L_status.Font.Color:=clGreen;
     L_status.Caption:='  Messung gestartet  '
  end

  else begin
   L_status.Font.Color:=clRed;
   L_status.Caption:='  Warte auf Start  ';
  end;

  if e > 9 then begin
  AudioIn.StopGracefully;   { Messung fertig -> stop }
  messung:=true;            { Messung erfolgreich beendet }
  end;
  Result := TRUE;           { fertig }
end;

{ ------ wenn eine Messung gestartet wurde ----------------- }

procedure TForm1.B_StartClick(Sender: TObject);
var j,k:integer;
begin
zustand:=0;                 { Flanklenmarkierung }
e:=0;                       { Ereigniszhler }
pz:=0;                      { Periodenzhler }

 for j:=0 to 9 do begin     { Tabelle lschen }
  for k:=1 to 2 do begin
   SG.Cells[k,j+1]:='     ';
  end;
  end;
AudioIn.Start(AudioIn);     { Start fr Soundkarte }

end;


{ ------------------- Abbruch einer Messung --------------- }

procedure TForm1.B_abbruchClick(Sender: TObject);
var j,k: integer;
begin
e:=10;                     { Ereigniszhler auf Ende }

for j:=0 to 9 do begin     { Tabelle lschen }
  SG.cells[0,j+1]:=FormatFloat('0.0',j/10)+ ' m';
  for k:=1 to 2 do begin
   SG.Cells[k,j+1]:='     ';
  end;
  end;
L_status.Caption:='   Abgebrochen    ';
AudioIn.StopGracefully;     { Soundkarte anhalten }
end;

{ ------------- Messroutine fr nur Dunkelzeit messen ------------------- }

procedure TForm1.Dunkelzeit1Click(Sender: TObject);
begin
L_mixer.Visible:=true;
Spaltenzahl:=2;             { Darstellung zweispaltig }
StarteMessung;
end;

{ ----------------- Messroutine fr Dunkel- und Hellzeit messen ------- }

procedure TForm1.Dunkelundhell1Click(Sender: TObject);
begin
L_mixer.Visible:=true;
Spaltenzahl:=3;             { Darstellung dreispaltig }
StarteMessung;
end;

{ ------------------ Die Auflsung bei den Messung festlegen -------------- }

procedure TForm1.RB2Click(Sender: TObject);
begin
RB2.Checked:=true;           { dir Radiobuttons entsprechend setzen }
RB1.Checked:=false;
aufloesung:=1;
end;

procedure TForm1.RB1Click(Sender: TObject);
begin
RB1.Checked:=true;
RB2.Checked:=false;
aufloesung:=0;
end;

{ --------------- Die Tabelle zur Anzeige aufbereiten -------------- }

procedure TForm1.ZeigeTabelle;
var j,k:integer;
begin

with SG do begin
  Left:=round(Form1.Width*0.2);
  Top:=round(Form1.Height*0.15);
  Font.Size:=18;
  DefaultColWidth:=125;
  ColCount:=Spaltenzahl;
  Width:=SG.DefaultColWidth*Spaltenzahl+Spaltenzahl;
  Visible:=true;

 for j:=0 to 9 do begin       { Tabelle lschen }
  Cells[0,j+1]:=FormatFloat('0.0',j/10)+' m';
  for k:=1 to 2 do begin
   Cells[k,j+1]:='     ';
  end;
  end;
end;
end;

{ ------------- Was beim Start einer Messung geschehen muss ------ }

procedure TForm1.StarteMessung;

begin
B_start.Left:=round(Form1.Width*0.05);     { alle Bedienknpfe anzeigen unr richtig positionieren }
B_start.Visible:=true;

B_abbruch.Left:=round(Form1.Width*0.05);
B_abbruch.Visible:=true;

GB1.Left:=round(Form1.Width*0.05);
GB1.Visible:=true;

L_status.Left:=round(Form1.Width*0.2);
L_status.Top:=round(Form1.Height*0.1);
L_status.Visible:=true;
L_status.Caption:='                     ';

L_mixer.Caption:='SOUNDKARTE :  '+Mixer.ProductName+'       EINGANG:  '+Mixer.Destinations[1].Connections[Kanalein].Data.szName+'        MINDESTAMPLITUDE :  '+IntToStr(MindestAmpl);

ZeigeTabelle;                            { Tabelle aufbereiten und sichtbar machen }
SG.Visible:=true;
end;


{ -------------------- Gespeicherte Messdaten laden -----------------}


procedure TForm1.Laden1Click(Sender: TObject);
var n,i,z : integer;
instr,CopyStr : String;
begin
SG.Visible:=false;              { alle Messfelder ausblenden }
B_start.Visible:=false;         { alle Steuerknpfe ausblenden }
B_abbruch.Visible:=false;
GB1.Visible:=false;
L_status.Visible:=false;
L_mixer.Visible:=false;

{ --------- Datei laden -------------- }

OpenDialog1.Filter := 'Fahrbahndaten (*.fbd)|*.FBD|Alle Dateien (*.*)|*.*';   { Auswahlfilter }
if OpenDialog1.Execute then begin    { Den Namen der zu ladenden Datei ermitteln }
Dateiname:=OpenDialog1.Filename;     { den ermittelten Dateinamen zuweisen }

AssignFile(Datei,Dateiname);         { den File zuweisen und ffnen }
reset(Datei);                        { zu Lesen ffnen }
n:=0; z:=0;
while not Eof(Datei) do begin        { solange noch Daten da }
  readln(Datei,instr);               { eine Zeile lesen }

  if n = 0 then begin                { Kopfzeile und Anweisungsfeld entschlsseln }
   Copystr:=copy(instr,length(instr)-1,length(instr));
   aufloesung:=StrToInt(copy(Copystr,2,length(copystr)));
  end
  else begin                            { den Rest auswerten }
     while length(instr) > 0 do begin   { solange noch was da }
     i:=Pos(';',instr);
       if (i <> 0) then begin
       CopyStr:=copy(instr,0,i-1);
        if z > 0 then begin             { erstes Element 'Weg' ignorieren }
         Zeit[0,n-1]:=StrToFloat(CopyStr);  { Dunkelzeit }
        end;
       delete(instr,1,i);                   { String verkrzen }
       inc(z);
      end
      else begin
       Zeit[1,n-1]:=StrToFloat(instr);     { Hellzeit }
       instr:='';
       z:=0;
      end;
      end;  { von i <> 0 }
    end;    { von length(instr) }
  inc(n);                                { nchstes Element holen }
end;
CloseFile(Datei);                        { Datei schlieen }
messung:=true;                           { Daten vorhanden }
stTabelle1.Click;                        { Daten zweispaltig darstellen }
end;
end;

{ --------------------- Messdaten abspeichern --------------------- }

procedure TForm1.Speichernunter1Click(Sender: TObject);
{ Eine Speicherdatei besteht aus folgenden Daten:
1. Zeile "Ort ; Zeit dunkel ; Zeit hell
es folgt nach einem ';' eine Ziffern:
1 steht fr Auflsung 1ms , 0 fr Auflsng 10 ms
Danach folgen Messfelder fr Ort, Zeit dunkel und Zeit hell
der jeweiligen Lichtschranken }

var n:integer;
outstr: string;
begin
if not messung then Form4.ShowModal { keine Daten Informationsdialog holen }
else begin

SaveDialog1.Filter := 'Fahrbahndaten (*.fbd)|*.FBD|Alle Dateien (*.*)|*.*';
SaveDialog1.FileName:=Dateiname;

if SaveDialog1.Execute then
Dateiname:=SaveDialog1.Filename;       { eingetragenen Dateinamen bergeben }

if Dateiname <> '' then begin          { hier ist keine Sicherheitsabfrage, ob es die Datei schon gibt, vorgesehen! }
   Dateiname:=ChangeFileExt(Dateiname, '.fbd');
   AssignFile(Datei,Dateiname);        { vorbereiten und ffnen }
   Rewrite(Datei);
   writeln(Datei,'Ort ; Zeit dunkel; Zeit hell;' + IntToStr(Spaltenzahl)+IntToStr(aufloesung));  {Kopfzeile }
   {Format: Ort ; Zeit dunkel ; Zeit hell }
   for n:=0 to 9 do begin
    outstr:=FloatToStr(n*0.1)+';'+FloatToStr(Zeit[0,n])+';'+FloatToStr(Zeit[1,n]);
    writeln(Datei,outstr);             { schreibe in Datei }
   end;
   CloseFile(Datei);                  { Datei abschlieen }
end;
end;
end;

{ ------------------- Tabelle mit zwei Spalten darstellen --------------------- }

procedure TForm1.stTabelle1Click(Sender: TObject);
var i: integer;
begin
B_start.Visible:=false;
B_abbruch.Visible:=false;
GB1.Visible:=false;
L_status.Visible:=false;
L_mixer.visible:=false;
Spaltenzahl:=2;
ZeigeTabelle;
for i:=0 to 9 do begin        { Messdaten ins Feld schreiben }
if aufloesung = 1 then SG.Cells[1,i+1]:=FormatFloat('0.000',Zeit[0,i])
else SG.Cells[1,i+1]:=FormatFloat('0.00',Zeit[0,i])
end;
end;

{ --------------- Tabelle mit drei Spalten darstellen ----------------- }

procedure TForm1.vtTabelle1Click(Sender: TObject);
var i: integer;
begin
B_start.Visible:=false;
B_abbruch.Visible:=false;
GB1.Visible:=false;
L_status.Visible:=false;
L_mixer.visible:=false;
Spaltenzahl:=3;
ZeigeTabelle;
for i:=0 to 9 do begin        { Beginn Lichtschranke dunkel }
if aufloesung = 1 then SG.Cells[1,i+1]:=FormatFloat('0.000',Zeit[0,i])
else SG.Cells[1,i+1]:=FormatFloat('0.00',Zeit[0,i])
end;
for i:=0 to 9 do begin        { Lichtschranke wieder hell }
if aufloesung = 1 then SG.Cells[2,i+1]:=FormatFloat('0.000',Zeit[1,i])
else SG.Cells[2,i+1]:=FormatFloat('0.00',Zeit[1,i])
end
end;

{ ------------- Den Einstellungsdialog aufrufen --------------------- }

procedure TForm1.Einstellungen1Click(Sender: TObject);
begin
Form2.ShowModal;
end;


{ ----------------- beim Start des Programmes zu erledigen -------------- }

procedure TForm1.FormCreate(Sender: TObject);
var j,a,b,mix :integer;
    L,M,R : integer;
    Stereo: boolean;
    VD,VM: boolean;
    IsSelect:boolean;
    eingabe: string;

begin
e:=0;             { Ereigniszhler auf 0 }
messung:=false;   { noch keine Messung vorhanden }
aufloesung:=1;    { Standard 1 ms Auflsung }
Spaltenzahl:=2;   { Standard 2 Spalten darstellen }

SG.Visible:=false;        { Felder fr die Messung erst einmal ausblenden }
B_Start.Visible:=false;
B_abbruch.Visible:=false;
GB1.Visible:=false;
L_status.Visible:=false;

with SG do begin          { Das Tabellenfeld im Hintergrund beschriften }
  Cells[0,0]:='Schranke';
  Cells[1,0]:='Zeit dunkel';
  Cells[2,0]:='Zeit hell';
  for j:=0 to 9 do begin
  cells[0,j+1]:=FormatFloat('0.0',j/10)+' m';  { Wegdaten eintragen }
  end;
end;

{ alle Mixereinstellungen smtlicher Gerte merken , nur Aufnahme }

for mix:=0 to Mixer.MixerCount-1 do begin   { fr alle Mixer im System }
Mixer.MixerId:=mix;
for a:=0 to 10 do begin
 Mixer.GetVolume(1,a,L,R,M,Stereo,VD,VM,IsSelect);
 Verbindung[mix,a].device:=a;
 Verbindung[mix,a].L:=L;
 Verbindung[mix,a].R:=R;
 Verbindung[mix,a].M:=M;
 Verbindung[mix,a].Stereo:=Stereo;
 Verbindung[mix,a].VD:=VD;
 Verbindung[Mix,a].VM:=VM;
 Verbindung[Mix,a].IsSelect:=IsSelect;
end;
end;

{$I-}                               { Gibt es eine Konfigurationsdatei?}
AssignFile(Datei,'fahrbahn.cfg');
Reset(Datei);
closeFile(Datei);
{SI+}
if IOResult <> 0 then begin         { keine Konfigurationsdatei gefunden }
Mixernummer:=0;                     { dann die Standardeinstellungen setzen }
Kanalein:=0;
MindestAmpl:=5000;
end

else begin                          { Konfigurationsdatei gefunden, Werte auslesen }
AssignFile(Datei,'fahrbahn.cfg');
Reset(Datei);
readln(Datei,eingabe);
Mixernummer:=StrToInt(eingabe);     { erster Wert, Nummer der Soundkarte }
readln(Datei,eingabe);
Kanalein:=StrToInt(eingabe);        { zweiter Wert, Nummer der Schnittstelle }
readln(Datei,eingabe);
MindestAmpl:=StrToInt(eingabe);     { dritter Wert, Mindestamplitude }
readln(Datei,eingabe);
closeFile(Datei);                   { Datei schlieen }
end;

for b:=0 to Mixer.Destinations[1].Connections.Count-1 do
Mixer.SetVolume(1,b,0,0,0);                          { nicht gewhlte Kanle auf 0}
Mixer.SetVolume(1,Kanalein,65535,65535,0);           { gewhlter Kanal auf Maximum }

L_mixer.Top:=round(Form1.Height*0.05);               { Positionierung des Feldes fr die Mixerdaten }
L_mixer.Left:=round(Form1.Width*0.2);
end;


{ ----------- Wenn das Programm beendet wird noch zu erledigen ----------- }

procedure TForm1.Ende1Click(Sender: TObject);
var a,b,mix:integer;
    L,M,R : integer;
    Stereo: boolean;
    VD,VM: boolean;
    IsSelect:boolean;
begin
AudioIn.StopAtOnce;  { Soundkarte stop }

{ alle Mixereinstellungen fr Aufnahme zurckschreiben }
for mix:=0 to Mixer.MixerCount-1 do begin
Mixer.MixerId:=mix;
for a:=0 to 10 do begin
 b:=Verbindung[mix,a].device;
 L:=Verbindung[mix,a].L;
 R:=Verbindung[mix,a].R;
 M:=Verbindung[mix,a].M;
 Stereo:=Verbindung[mix,a].Stereo;
 VD:=Verbindung[mix,a].VD;
 VM:=Verbindung[mix,a].VM;
 IsSelect:=Verbindung[mix,a].IsSelect;
 Mixer.SetVolume(1,b,L,R,M);
end;
end;
close();            { Programm beenden }
end;

end.
