.syntax unified
//.include "C:/Users/joerg_000/workspace/BasicASM/src/regs.asm"
.include "../src/regs.asm"
.global startup
.global	ISRTabelle
.global Ain0
.global Ain1
.global Ain2
.global Ain3
.global Ain4
.global Ain5
.global initIRQ 	//Startadresse der ISR in R0, Interrupt Nr in R1
//ex3: PB3 (D3) ex2:PA2 (D1) ex1: PA1 (A1) ex0: PB0 (A3)
//ex7: PA7(D11) ex6: PA6 (D12)  ex5: PA5(D13) ex4: PB4 (D5)
//ex11: PA11  ex10: PA10 (D2) ex9: PA9 (D8) ex8: PA8 (D7)
//ex11: PA11  ex10: PA10 (D2) ex9: PA9 (D8) ex8: PA8 (D7)

.global	I2C_init
.global I2C1_sendBytes	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse
.global Grove_LCD_RGB_Backlight_displayOn
/*This function is used to clear display on the LCD.  It sends the
hexadecimal code for the clear instruction to the device in order to
clear the display*/
.global Grove_LCD_RGB_Backlightclear
/*This function is used to write to one of the registers for the backlight
of the LCD display.  The function takes in the address of which register to
write to and the value to be written to that register and then sends it to the
LCD display via the mbed I2C library*/
.global Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
/*This function is used to set the backlight color of the dispaly.
It writes the provided r, g, and b values to the registers for the red
value, the green value, and the blue value respectively.*/
.global Grove_LCD_RGB_BacklightsetRGB	//R0: char r, R1: char g, R2: char b
/*This function is used to write to the LCD screen.  It takes in a string of
characters and writes them to the 0x40 register of the display.*/
.global Grove_LCD_RGB_Backlightprint	//R0: char *str)
/*This function sets where on the screen the text will be written next.  It
takes in two values which indicate the row and column on the display that
the cursor should be moved to*/
.global Grove_LCD_RGB_Backlightlocate	//R0: char col, R1: char row
.global Grove_LCD_RGB_Backlightinit
/*This function is used to write to the LCD screen.  It takes in a number writes it to the 0x40 register of the display.*/
.global Grove_LCD_RGB_Backlightdezaus	//R0: nummer
.global USART2_sendbyte	//Byte in R0
.global EPort
.global MFS_sendWord
.global MFS_serial_init


startup:
		pop	{r0}
		ldr	sp,=0x20013000
		push	{r0}



//Hardware mit Clk versorgen
//RCC
		ldr	r1,=flash
		//loadImm32	r1,flash



		mov	r2,#0x07
		str	r2,[r1]

        ldr r1,=rcc

        ldr r2,=0x01050101

        str r2,[r1]			//rcc cr
WarteAufRdy:
		ldr	r2,=0x02020202
		ldr	r3,[r1]
		and	r4,r3,r2
		cmp	r4,r2
		bne	WarteAufRdy

        ldr r2,=0x0091000F		//HSE
		str r2,[r1,#RCC_CFGR]

        ldr r2,[r1,#RCC_AHBENR]
		orr r2,#0x7		//GPIO A, B und C
		str	r2,[r1,#RCC_AHBENR]



		ldr r2,[r1,#RCC_APB1ENR]
		ldr r3,=0b111111+(1<<21)+(1<<17)	//TIM2 - TIM7 + I2C1 + USART2
		//loadImm32	r3,(0b111111+(1<<21)+(1<<17))
		orr r2,r3
		str r2,[r1,#RCC_APB1ENR]

		ldr r2,[r1,#RCC_APB2ENR]	//APB2 peripheral clock enable register
		ldr r3,=0x00000001+(1<<9)
		//loadImm32	r3,(0x00000001+(1<<9))
		orr r2,r3	//SYSCFGEN: System configuration controller clock enable, ADC Clock Enable
		str r2,[r1,#RCC_APB2ENR]

		ldr	r4,=ISRTabelle

		ldr	r3,=IRQFehler
		//loadImm32	r3,IRQFehler
		mov	r2,#64
FuelleVectortabelle:
		str	r3,[r4]
		add	r4,#4
		subs	r2,#1
		bne	FuelleVectortabelle
		ldr	r4,=ISRTabelle
		//loadImm32	r4,ISRTabelle
//Aus Kompatibilittsgrnden werden Teile der MBed ISR-Tabelle kopiert.
//MBed verwendet TIM5 ISR
		ldr	r3,=0x20000000
		//loadImm32	r3,0x20000000
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		add	r3,#4
		add	r4,#4
		ldr	r2,[r3]
		str	r2,[r4]
		ldr	r4,=ISRTabelle
		//loadImm32	r4,ISRTabelle
		ldr	r3,=0x20000000
		//loadImm32	r3,0x20000000
		//TIM5 ISR
		ldr	r2,[r3,0xF8]
		str r2,[r4,0xF8]

		ldr r2,=VectorTableOffsetRegister
		//loadImm32 r2,VectorTableOffsetRegister
		ldr	r4,=ISRTabelle
		//loadImm32	r4,ISRTabelle
		str	r4,[r2]		//VectorTableOffsetRegister initialisieren (0x20000000)

//GPIO High Speed
		ldr r2,=0xAAAAAAAA
		ldr r1,=0x40020000
		str r2,[r1,#8]
		ldr r1,=0x40020400
		str r2,[r1,#8]
		ldr r1,=0x40020800
		str r2,[r1,#8]


//Analog init
		ldr r1,=ADC
		//loadImm32 r1,ADC
		ldr r2,=ADC_CR1_OVRIE<<26+ADC_CR1_RES<<24+ADC_CR1_AWDEN<<23+ADC_CR1_JAWDEN<<22+ADC_CR1_PDI<<17+ADC_CR1_PDD<<16+ADC_CR1_DISCNUM<<13+ADC_CR1_JDISCEN<<12+ADC_CR1_DISCEN<<11+ADC_CR1_JAUTO<<10+ADC_CR1_AWDSGL<<9+ADC_CR1_SCAN<<8+ADC_CR1_JEOCIE<<7+ADC_CR1_AWDIE<<6+ADC_CR1_EOCIE<<5+ADC_CR1_AWDCH
		//loadImm32 r2,(ADC_CR1_OVRIE<<26+ADC_CR1_RES<<24+ADC_CR1_AWDEN<<23+ADC_CR1_JAWDEN<<22+ADC_CR1_PDI<<17+ADC_CR1_PDD<<16+ADC_CR1_DISCNUM<<13+ADC_CR1_JDISCEN<<12+ADC_CR1_DISCEN<<11+ADC_CR1_JAUTO<<10+ADC_CR1_AWDSGL<<9+ADC_CR1_SCAN<<8+ADC_CR1_JEOCIE<<7+ADC_CR1_AWDIE<<6+ADC_CR1_EOCIE<<5+ADC_CR1_AWDCH)
		str r2,[r1,#ADC_CR1]
		ldr r2,=ADC_CR2_SWSTART<<30+ADC_CR2_EXTEN<<28+ADC_CR2_EXTSEL<<24+ADC_CR2_JSWSTART<<22+ADC_CR2_JEXTEN<<20+ADC_CR2_JEXTSEL<<16+ADC_CR2_ALIGN<<11+ADC_CR2_EOCS<<10+ADC_CR2_DDS<<9+ADC_CR2_DMA<<8+ADC_CR2_DELS<<4+ADC_CR2_ADC_CFG<<2+ADC_CR2_CONT<<1+ADC_CR2_ADON
		//loadImm32 r2,(ADC_CR2_SWSTART<<30+ADC_CR2_EXTEN<<28+ADC_CR2_EXTSEL<<24+ADC_CR2_JSWSTART<<22+ADC_CR2_JEXTEN<<20+ADC_CR2_JEXTSEL<<16+ADC_CR2_ALIGN<<11+ADC_CR2_EOCS<<10+ADC_CR2_DDS<<9+ADC_CR2_DMA<<8+ADC_CR2_DELS<<4+ADC_CR2_ADC_CFG<<2+ADC_CR2_CONT<<1+ADC_CR2_ADON)
		str r2,[r1,#ADC_CR2]

//USART2 init

		ldr r1,=USART2
		//loadImm32 r1,USART2
		mov	r2,#(1<<13)+1<<3+1<<2		//UE Bit=1 M=0 (8 Databits) TE=1 RE=1
		str r2,[r1,#USART2_CR1]
		//fPCLK	=32 MHz
		//BRRDIV = 208,3125
		//128 64 32 16 8 4 2 1|0,5 0,25 0,125 0,0625
		//  1  1  0  1 0 0 0 0|  0    1     0      1
		mov.w	r2,#0b110100000101
		strh	r2,[r1,#USART2_BRR]

		//Ports	PA2 = TxD Alternate
		//Ports	PA3 = RxD Alternate
		setDir	PA3,Alternate
		setDir	PA2,Alternate
		setAusgangstyp PA2,PushPull
		ldr 	r1,=GPIOA
		//loadImm32	r1,GPIOA
		ldr		r2,[r1,#0x20]	//20 Alternat Function reg low
		orr		r2,#0x7700
		str		r2,[r1,#0x20]

.equ	pre,31

//TIM6 und TIM7 initialisierung als 16Bit Timer mit MZ=1s

initTim6:

	ldr r0,=tim6 //0x40001000	//tim6
	//loadImm32 r0,tim6 //0x40001000	//tim6
	mov.w r1,#0x00
	str r1,[r0,#TIMx_CR1]
	mov r1,#pre
	str r1,[r0,#TIMx_PSC]	//32MHz /32 =1 MHz

initTim7:

	ldr r0,=tim7	//0x40001400	//tim7
	//loadImm32 r0,tim7	//0x40001400	//tim7
	mov.w r1,#0x00
	str r1,[r0,#TIMx_CR1]
	mov r1,#pre
	str r1,[r0,#TIMx_PSC]	//8MHz / 8000 = 1000Hz



//TIM2 Initialisierung als Ereigniszhler

	ldr	r0,=TIM2
	//loadImm32	r0,TIM2
	mov	r1,#0b10<<8					//fDTS= fCK_Int/4
	str	r1,[r0,#TIMx_CR1]
	mov.w	r1,#pre					//Prescaler fr 1s
	str		r1,[r0,#TIMx_PSC]
	mov.w	r1,#0b01<<8+0b1111<<12 	//CC1S=0b01 Input on TI2, ICF2: fSAMPLING=fDTS/32 mit  N=8
	str	r1,[r0,#TIMx_CCMR1]
	mov.w	r1,#0b111+0b110<<4+0b0011<<8		//SMS=0b111: External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.

/*
000: Slave mode disabled - if CEN = 1 then the prescaler is clocked directly by the internal
clock.
001: Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2
level.
010: Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1
level.
011: Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges
depending on the level of the other input.
100: Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter
and generates an update of the registers.
101: Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The
counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of
the counter are controlled.
110: Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not
reset). Only the start of the counter is controlled.
111: External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
*/
								//Select TI2 as the input source by writing TS=110
	str	r1,[r0,#TIMx_SMCR]


//TIM3 Initialisierung als Ereigniszhler

	ldr	r0,=TIM3
	//loadImm32	r0,TIM3
	mov	r1,#0b10<<8					//fDTS= fCK_Int/4
	str	r1,[r0,#TIMx_CR1]
	mov.w	r1,#pre					//Prescaler fr 1s
	str		r1,[r0,#TIMx_PSC]
	mov.w	r1,#0b01<<8+0b1111<<12 	//CC1S=0b01 Input on TI2, ICF2: fSAMPLING=fDTS/32 mit  N=8
	str	r1,[r0,#TIMx_CCMR1]
	mov.w	r1,#0b111+0b110<<4+0b0011<<8		//SMS=0b111: External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.

/*
000: Slave mode disabled - if CEN = 1 then the prescaler is clocked directly by the internal
clock.
001: Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2
level.
010: Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1
level.
011: Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges
depending on the level of the other input.
100: Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter
and generates an update of the registers.
101: Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The
counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of
the counter are controlled.
110: Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not
reset). Only the start of the counter is controlled.
111: External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
*/
								//Select TI2 as the input source by writing TS=110
	str	r1,[r0,#TIMx_SMCR]


//Zhleingang TIM2: Alternate Function AFIO1 an PB3(D3) oder PA1(A1) (vorkonfiguriert)
//Zhleingang TIM3: Alternate Function AFIO1 an  PA7 (D11)(vorkonfiguriert) oder PB5 (D4)

	ldr	r0,=GPIOA
	ldr	r1,[r0,#GPIOx_AFRL]
	orr	r1,#0b0001<<4+0b0010<<12
	str	r1,[r0,#GPIOx_AFRL]
	setDir	A1,Alternate
	setDir	D11,Alternate


//NVIC alle Interrupts einschalten
	//NVIC config enable Interrupt
		ldr r1,=nvic
		//loadImm32 r1,nvic
		ldr r2,=0xFFFFFFFF
		//loadImm32 r2,0xFFFFFFFF
		str r2,[r1,isrEnableReg0]
		str r2,[r1,isrEnableReg1]



//EXTI initialisierung
//alle externen Interrupts mit fallender Flanke
		ldr	r1,=exti
		//loadImm32	r1,exti
		ldr	r2,=0x00ffffff
		//loadImm32	r2,0x00ffffff
		str r2,[r1,#exti_FTSR]
//alle anhngigen Interrupts lschen
		mov	r2,#0
		str r2,[r1,#exti_PR]

//Vorbelegung der interruptquellen
		ldr r1,=SysCFG
		mov.w r2,#0b0010000000000001		//EXTI3: PB3 (D3) EXTI2:PA2 (D1) EXTI1: PA1 (A1) EXTI0: PB0 (A3)
		str	r2,[r1,#SYSCFG_EXTICR1]

		mov.w r2,#0b0000000000000001		//EXTI7: PA7(D11) EXTI6: PA6 (D12)  EXTI5: PA5(D13) EXTI4: PB4 (D5)
		str	r2,[r1,#SYSCFG_EXTICR2]

		mov.w r2,#0b0000000000000000		//EXTI11: PA11  EXTI10: PA10 (D2) EXTI9: PA9 (D8) EXTI8: PA8 (D7)
		str	r2,[r1,#SYSCFG_EXTICR3]

		mov.w r2,#0x0020					//EXTI15: PA15 EXTI14:PA14 EXTI13: PC13  EXTI12: PB0 PA12
		str	r2,[r1,#SYSCFG_EXTICR4]


		ldr r0,=USART2_RX_ISR
		mov		r1,#usart2Int_nr
		call 	initIRQ

		setb	RXNEIE			//enable RX Interrupt

		ldr	dptr,=Datenspeicher

//Ende Startup
		bx lr
.ltorg

//USART2 sendByte
.type USART2_sendbyte,function
USART2_sendbyte:	//byte in r0
		push	{r0,r1,r2}
		ldr r1,=USART2
USART2_WarteTXE:
		ldr	r2,[r1,#USART2_SR]
		lsrs	r2,#8	//TXE -> Cy
		bcc		USART2_WarteTXE
		strb	r0,[r1,#USART2_DR]
		pop		{r0,r1,r2}
		bx	lr
USART2_readbyte:
		ldr 	r0,=USART2
		ldrb	r0,[r0,#USART2_DR]	//Command aus DR
		bx	lr
//USART sendBytes
USART2_sendBytes:	//R0 Zeiger auf Buffer, Letztes Zeichen: 0 als Startbyte wird immer eine 1 weggeschickt
		push	{r0,r1,r2}
		mov		r1,r0
		mov		r0,#1
		call	USART2_sendbyte
USART2_sendBytesWdh:
		ldrb	r0,[r1]
		call	USART2_sendbyte
		add		r1,#1
		cmp		r0,#0
		bne		USART2_sendBytesWdh
		pop		{r0,r1,r2}
		bx lr
.ltorg
/*
The stack frame contains the following information:
 R0-R3, R12
 Return address
 PSR
 LR.
*/

.equ	identify,0x01		//Command 0x01, 0x00 Antwort 0x01, 0x32		//identify
.equ	readPorts,0x02		//Command 0x02, 0x00,0x00, 0x00, 0x00, 0x00, 0x00 Antwort: 0x02 PAL, PAH, PBL, PBH, PCL, PCH jeweils IDR
.equ	writePorts,0x03		//Command 0x03, PAL, PAH, PBL, PBH, PCL, PCH jeweils ODR Antwort: 0x03 PAL, PAH, PBL, PBH, PCL, PCH jeweils ODR
USART2_RX_ISR:	//Command 0x01, 0x00 Antwort 0x01, 0x32		//identify
		ldr		r0,=PortMonZustand
		ldrb	r1,[r0]
		cmp		r1,#0
		beq		PortMonZ0
		cmp		r1,#1
		beq		PortMonZ1
		cmp		r1,#2
		beq		PortMonZ2
		cmp		r1,#3
		beq		PortMonZ3
		cmp		r1,#4
		beq		PortMonZ4
		cmp		r1,#5
		beq		PortMonZ5
		cmp		r1,#6
		beq		PortMonZ6
PortMonDefault:
		mov		r1,#0
		ldr		r0,=PortMonZustand
		strb	r1,[r0]
		ldr 	r0,=PortMonCommand
		strb	r1,[r0]				//Command speichern
		reti
PortMonZ0:
		add		r1,#1		//nchster Zustand = 1
		str		r1,[r0]
		ldr 	r0,=USART2
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r0,#USART2_DR]	//Command aus DR
		strb	r0,[r1]				//Command speichern
		call	USART2_sendbyte		//Command zurckschicken
		reti
PortMonZ1:
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r1]
		cmp		r0,#identify
		beq		PortMonZ1Identify
		cmp		r0,#readPorts
		beq		PortMonZ1readPorts
		cmp		r0,#writePorts
		beq		PortMonZ1writePorts
		b		PortMonDefault
PortMonZ1Identify:
		mov		r0,#0x32
		call	USART2_sendbyte		//Command zurckschicken
		b		PortMonDefault
PortMonZ1readPorts:
		ldr		r1,=GPIOA
		ldr		r0,[r1,#GPIOx_IDR]
		call	USART2_sendbyte
		b		PortMonIncZustandFertig
PortMonZ1writePorts:
		call 	USART2_readbyte
		ldr		r1,=GPIOA
		strb	r0,[r1,#GPIOx_ODR]
		b		PortMonIncZustandFertig
PortMonZ2:
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r1]
		cmp		r0,#readPorts
		beq		PortMonZ2readPorts
		cmp		r0,#writePorts
		beq		PortMonZ2writePorts
		b		PortMonDefault
PortMonZ2readPorts:
		ldr		r1,=GPIOA
		ldr		r0,[r1,#GPIOx_IDR]
		lsr		r0,#8
		call	USART2_sendbyte
		b		PortMonIncZustandFertig
PortMonZ2writePorts:
		call 	USART2_readbyte
		ldr		r1,=GPIOA
		ldr		r2,[r1,#GPIOx_ODR]
		lsl		r0,#8
		add		r0,r2
		strb	r0,[r1,#GPIOx_ODR]
		b		PortMonIncZustandFertig

PortMonZ3:
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r1]
		cmp		r0,#readPorts
		beq		PortMonZ3readPorts
		cmp		r0,#writePorts
		beq		PortMonZ3writePorts
		b		PortMonDefault
PortMonZ3readPorts:
		ldr		r1,=GPIOB
		ldr		r0,[r1,#GPIOx_IDR]
		call	USART2_sendbyte
		b		PortMonIncZustandFertig
PortMonZ3writePorts:
		call 	USART2_readbyte
		ldr		r1,=GPIOB
		strb	r0,[r1,#GPIOx_ODR]
		b		PortMonIncZustandFertig

PortMonZ4:
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r1]
		cmp		r0,#readPorts
		beq		PortMonZ4readPorts
		cmp		r0,#writePorts
		beq		PortMonZ4writePorts
		b		PortMonDefault
PortMonZ4readPorts:
		ldr		r1,=GPIOB
		ldr		r0,[r1,#GPIOx_IDR]
		lsr		r0,#8
		call	USART2_sendbyte
		b		PortMonIncZustandFertig
PortMonZ4writePorts:
		call 	USART2_readbyte
		ldr		r1,=GPIOB
		ldr		r2,[r1,#GPIOx_ODR]
		lsl		r0,#8
		add		r0,r2
		strb	r0,[r1,#GPIOx_ODR]
		b		PortMonIncZustandFertig

PortMonZ5:
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r1]
		cmp		r0,#readPorts
		beq		PortMonZ5readPorts
		cmp		r0,#writePorts
		beq		PortMonZ5writePorts
		b		PortMonDefault
PortMonZ5readPorts:
		ldr		r1,=GPIOB
		ldr		r0,[r1,#GPIOx_IDR]
		call	USART2_sendbyte
		b		PortMonIncZustandFertig
PortMonZ5writePorts:
		call 	USART2_readbyte
		ldr		r1,=GPIOC
		strb	r0,[r1,#GPIOx_ODR]
		b		PortMonIncZustandFertig

PortMonZ6:
		ldr 	r1,=PortMonCommand
		ldrb	r0,[r1]
		cmp		r0,#readPorts
		beq		PortMonZ6readPorts
		cmp		r0,#writePorts
		beq		PortMonZ6writePorts
		b		PortMonDefault
PortMonZ6readPorts:
		ldr		r1,=GPIOB
		ldr		r0,[r1,#GPIOx_IDR]
		lsr		r0,#8
		call	USART2_sendbyte
		b		PortMonDefault
PortMonZ6writePorts:
		call 	USART2_readbyte
		ldr		r1,=GPIOC
		ldr		r2,[r1,#GPIOx_ODR]
		lsl		r0,#8
		add		r0,r2
		strb	r0,[r1,#GPIOx_ODR]
		b		PortMonDefault
PortMonIncZustandFertig:
		ldr		r0,=PortMonZustand
		ldrb	r1,[r0]
		add		r1,#1
		strb	r1,[r0]
		reti
.ltorg
//Interruptinitialisierungen
initIRQ: //Startadresse der ISR in R0, Interrupt Nr in R1
	//interrupt vector auf isr einstellen
	push {r0,r1,r2,r3,r4}
	ldr r2,=VectorTableOffsetRegister
	ldr r2,[r2]
	ldr r3,=vektorLocationTabelle
	add r3,r1
	ldrb r3,[r3]
	and r3,#0xff
	add r2,r3
	orr r0,#1		//????
	str r0,[r2]
	pop {r0,r1,r2,r3,r4}
	bx lr

//Interruptinitialisierungen
.global	setIntVector
setIntVector: //Startadresse der ISR in R0, Interrupt Nr in R1
	//interrupt vector auf isr einstellen
	push {r0,r1,r2,r3,r4}
	ldr r2,=VectorTableOffsetRegister
	ldr r2,[r2]
	and r1,#0xff
	add r2,r1
	orr r0,#1		//????
	str r0,[r2]
	pop {r0,r1,r2,r3,r4}
	bx lr

IRQFehler:
	b	IRQFehler
//exti 9-5 und exti 15-10 mit gleicher Vectoradresse!!!
vektorLocationTabelle:
.byte 0x58,0x5c,0x60,0x64,0x68,0x9c,0x9c,0x9c,0x9c,0x9c,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xec,0xf0,0xD8,0xB0,0xB4,0x3C



//I2C1 init
I2C_init:
		setPullUpDown PB8,Pullup
		setPullUpDown PB9,Pullup
		setb	PB8
		setb	PB9
I2C_Warte5ms:
	ldr	r1,=2500000
I2C_WarteWdh1:
	subs	r1,#1
	bne		I2C_WarteWdh1
		push {r1,r2}
		ldr r1,=I2C1
		ldr r2,=I2C1_FREQ
		str r2,[r1,#I2C1_CR2]
		ldr r2,=I2C1_CCRValue
		str r2,[r1,#I2C1_CCR]
		ldr r2,=I2C1_TRISEValue
		str r2,[r1,#I2C1_TRISE]
		mov r2,#1	//enable
		str r2,[r1,#I2C1_CR1]
		ldr r1,=GPIOB
		ldr r2,[r1,#GPIOx_AFRH]
		orr r2,#0x44			//Select AF4 fr PB8 un PB9
		strh r2,[r1,#GPIOx_AFRH]
		setDir PB8,Alternate
		setDir PB9,Alternate
		setAusgangstyp PB8,PushPull
		setAusgangstyp PB9,OpenDrain
		setPullUpDown PB8,Pullup
		setPullUpDown PB9,Pullup



		//call I2C1_stop
		pop {r1,r2}
		bx lr
.ltorg


I2C1_start:
		push {r1,r2}
		ldr r1,=I2C1
		ldr r2,[r1,#I2C1_CR1]
		orr r2,#0x10		//start Bit 8 CR
		str r2,[r1,#I2C1_CR1]
		pop {r1,r2}
		bx lr

I2C1_stop:
		push {r1,r2}
		ldr r1,=I2C1
		ldr r2,[r1,#I2C1_CR1]
		orr r2,#0x200		//Stop Bit 8 CR
		str r2,[r1,#I2C1_CR1]
		pop {r1,r2}
		bx lr

I2C1_sendBytes:	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse
		push	{r4,r5,r6,r7}
		//call 	I2C1_start
		push {r1,r2}
		ldr r1,=I2C1
		ldr r2,[r1,#I2C1_CR1]
		ldr r6,=0x100
		orr r2,r6		//start Bit 8 CR1
		str r2,[r1,#I2C1_CR1]
		pop {r1,r2}
		ldr  	r4,=I2C1
I2C1_warteStart:
		ldr 	r5,[r4,#I2C1_SR1]
		ands	r5,#1
		beq		I2C1_warteStart

		and 	r2,#0xfe		//transmitmode LSB Adresse reset
		strb	r2,[r4,#I2C1_DR]
I2C1_warteAdresse:
		ldr 	r5,[r4,#I2C1_SR1]
		ands	r5,#2
		beq		I2C1_warteAdresse
		ldr 	r5,[r4,#I2C1_SR2]
I2C1_sendeByte:
		ldr 	r5,[r4,#I2C1_SR1]
		ands	r5,#0x80		//Bit 7: TxE
		beq		I2C1_sendeByte	//Senderegister noch nicht bereit
		ldrb	r5,[r0]
		strb	r5,[r4,#I2C1_DR]
		add		r0,#1
		subs	r1,#1
		bne	    I2C1_sendeByte
I2C1_ByteTransferNotFinished:
		ldr 	r5,[r4,#I2C1_SR1]
		ands	r5,#0x80		//Bit 2: BTF
		beq	I2C1_ByteTransferNotFinished
		call 	I2C1_stop
		ldr r1,=I2C1
		ldr r2,[r1,#I2C1_CR1]
		ldr r6,=0x200
		orr r2,r6		//Stop Bit 8 CR
		str r2,[r1,#I2C1_CR1]

		pop		{r4,r5,r6,r7}
		bx lr
.ltorg


//Analog	Rckgabewert: r0 AD-Wandelwert
Ain0:
	push {R1,R2,R3}
	ldr r1,=ADC
	ldr r2,=ADC_A0
	b 	Ain

Ain1:
	push {R1,R2,R3}
	ldr r1,=ADC
	ldr r2,=ADC_A1
	b 	Ain

Ain2:
	push {R1,R2,R3}
	ldr r1,=ADC
	ldr r2,=ADC_A2
	b 	Ain

Ain3:
	push {R1,R2,R3}
	ldr r1,=ADC
	ldr r2,=ADC_A3
	b 	Ain

Ain4:
	push {R1,R2,R3}
	ldr r1,=ADC
	ldr r2,=ADC_A4
	b 	Ain
Ain5:
	push {R1,R2,R3}
	ldr r1,=ADC
	ldr r2,=ADC_A5
	b 	Ain


Ain:
	str r2,[r1,#ADC_SQR5]
	ldr r2,=1<<30		//SWSTART
	ldr r3,[r1,#ADC_CR2]
	orr r2,r2,r3
	str	r2,[r1,#ADC_CR2]
AinWarte:
	ldr r2,[r1]		//ADC_SR Bit 1 == EOC
	ands r2,r2,#2
	beq	AinWarte
	ldr r0,[r1,#ADC_DR]
	pop {R1,R2,R3}
	bx lr
.ltorg

//Grove-LCD RGB Backlight

/*This function sends an instruction to the LCD display using the
 built in instruction codes from the device  datasheet using the mbed
 I2C library*/
Grove_LCD_RGB_Backlight_sendCommand: //char value in r0
	push 	{r0,r1,r2}
	mov		r1,#0x80
	ldr 	r2,=GroveBuffer
	strb	r1,[r2]
	strb	r0,[r2,#1]
	ldr		r0,=GroveBuffer
	mov		r1,#2
	mov		r2,#LCD_ADDRESS
	call	I2C1_sendBytes	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse
	pop 	{r0,r1,r2}
	bx lr

/*This function is used to turn on the display on the LCD.  It sends the
hexadecimal code for the display on setting to the device in order to
turn on the display*/

Grove_LCD_RGB_Backlight_displayOn:
    push {r0}
    ldr r0,=_displaycontrol
    ldrb r0,[r0]
    orr r0,#LCD_DISPLAYON;
    orr r0,#LCD_DISPLAYCONTROL
    call Grove_LCD_RGB_Backlight_sendCommand //char value in r0
	pop	{r0}
	bx lr

/*This function is used to clear display on the LCD.  It sends the
hexadecimal code for the clear instruction to the device in order to
clear the display*/
Grove_LCD_RGB_Backlightclear:
	push	{r0}
	mov 	r0,#LCD_CLEARDISPLAY
	call	Grove_LCD_RGB_Backlight_sendCommand //char value in r0
	ldr		r0,=128000		//4000s
Grove_LCD_RGB_BacklightclearWait:
	subs	r0,#1
	bne		Grove_LCD_RGB_BacklightclearWait
	pop		{r0}
	bx		lr

/*This function is used to write to one of the registers for the backlight
of the LCD display.  The function takes in the address of which register to
write to and the value to be written to that register and then sends it to the
LCD display via the mbed I2C library*/
Grove_LCD_RGB_BacklightsetReg:	//R0: char addr, R1: char val
	push	{r0,r1,r2}
	ldr		r2,=GroveBuffer
	strb	r0,[r2]
	strb	r1,[r2,#1]
	ldr		r0,=GroveBuffer
	mov		r1,#2
	mov		r2,#RGB_ADDRESS
	call	I2C1_sendBytes	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse
	pop		{r0,r1,r2}
	bx 		lr

/*This function is used to set the backlight color of the dispaly.
It writes the provided r, g, and b values to the registers for the red
value, the green value, and the blue value respectively.*/
Grove_LCD_RGB_BacklightsetRGB:	//R0: char r, R1: char g, R2: char b
	push	{r0,r1,r2,r3}
	mov		r3,r0
	mov		r0,#GREEN_REG
	call 	Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
	mov		r0,#RED_REG
	mov		r1,r3
	call 	Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
	mov		r0,#BLUE_REG
	mov		r1,r2
	call 	Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
	pop		{r0,r1,r2,r3}
	bx	lr

/*This function is used to write to the LCD screen.  It takes in a string of
characters and writes them to the 0x40 register of the display.*/
Grove_LCD_RGB_Backlightprint:	//R0: char *str)
	push	{r0,r1,r2,r3}
	mov		r3,#0
	ldr		r1,=GroveBuffer
	mov		r2,#0x40
	strb	r2,[r1]
	add		r3,#1
Grove_LCD_RGB_Backlightprintrepeat:
	add		r1,#1
	ldrb	r2,[r0]
	ands	r2,0xff
	beq		Grove_LCD_RGB_Backlightprintfertig
	strb	r2,[r1]
	add		r3,#1
	add		r0,#1
	b		Grove_LCD_RGB_Backlightprintrepeat
Grove_LCD_RGB_Backlightprintfertig:
	ldr		r0,=GroveBuffer
	mov		r1,r3
	mov		r2,#LCD_ADDRESS
	call	I2C1_sendBytes	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse
	pop		{r0,r1,r2,r3}
	bx	lr

/*This function sets where on the screen the text will be written next.  It
takes in two values which indicate the row and column on the display that
the cursor should be moved to*/
Grove_LCD_RGB_Backlightlocate:	//R0: char col, R1: char row
	push	{r0,r1,r2,r3}
	subs	r1,#0
	ite eq
    orreq r0,#0x80
    orrne r0,#0xC0
    ldr	r2,=GroveBuffer
    mov	r3,#0x80
    strb r3,[r2]
    strb r0,[r2,#1]
    ldr	r0,=GroveBuffer
    mov	r1,#2
    mov	r2,#LCD_ADDRESS
   	call	I2C1_sendBytes	//R0: Startadresse der Daten, R1: Anzahl der Datenbytes, R2: Zieladresse
	pop	{r0,r1,r2,r3}
   	bx 	lr

Grove_LCD_RGB_Backlightinit:

	push	{r0,r1,r2,r3}

	mov		r0,#255
	mov		r1,#255
	mov		r2,#255
	call 	Grove_LCD_RGB_BacklightsetRGB

	ldr	r0,=_displayfunction
	ldrb r1,[r0]
	orr	 r1,#LCD_2LINE
	orr	 r1,#LCD_5x10DOTS
    //Initialize displayfunction parameter for setting up LCD display
   //_displayfunction |= LCD_2LINE;
   //_displayfunction |= LCD_5x10DOTS;

   //Wait for more than 30 ms after power rises above 4.5V per the data sheet
   // wait_ms(50);
    ldr	r2,=3200000
Grove_LCD_RGB_BacklightinitWait50ms:
	subs	r2,#1
	bne	  Grove_LCD_RGB_BacklightinitWait50ms


    // Send first function set command. Wait longer that 39 us per the data sheet
    //sendCommand(LCD_FUNCTIONSET | _displayfunction);
    orr	r1,#LCD_FUNCTIONSET
    mov	r0,r1
    call	Grove_LCD_RGB_Backlight_sendCommand //char value in r0

    //wait_us(45);
    ldr	r1,=2880
Grove_LCD_RGB_BacklightinitWait45us:
	subs	r1,#1
	bne		Grove_LCD_RGB_BacklightinitWait45us

    // turn the display on
    //displayOn();
    call	Grove_LCD_RGB_Backlight_displayOn

    // clear the display
    //clear();
    call 	Grove_LCD_RGB_Backlightclear

    // Initialize backlight
    //setReg(0, 0);
    mov	r0,#0
    mov	r1,#0
    call	Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
    //setReg(1, 0);
    mov	r0,#1
    mov	r1,#0
    call	Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
    //setReg(0x08, 0xAA);
    mov	r0,#8
    mov	r1,#0xaa
    call	Grove_LCD_RGB_BacklightsetReg	//R0: char addr, R1: char val
    pop	{r0,r1,r2,r3}
    bx	lr

/*This function is used to write to the LCD screen.  It takes in a number writes it to the 0x40 register of the display.*/
Grove_LCD_RGB_Backlightdezaus:	//R0: nummer
	push	{r0,r1,r2,r3,r4}
	ldr		r3,=BCD
	ldr	r1,=1000000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=100000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#1]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=10000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#2]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=1000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#3]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=100000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#4]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=10000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#5]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=1000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#6]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=100
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#7]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=10
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#8]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=1
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#9]
	mul	r2,r1
	sub		r0,r2

	mov	r0,r3
	mov	r4,#0

dezausWdh:
	ldrb	r2,[r3]
	add		r2,#0x30
	strb	r2,[r3]
	add		r3,#1
	add		r4,#1
	cmp		r4,#10
	bne		dezausWdh

	mov	r1,#10
dezausWdh2:
	ldrb	r2,[r0]
	cmp		r2,#0x30
	bne		dezAnzeigen
	sub		r1,#1
	add		r0,#1
	cmp		r1,#1
	bne		dezausWdh2
dezAnzeigen:
	mov		r2,#0
	str		r2,[r3]
	call	Grove_LCD_RGB_Backlightprint	//R0: char *str

	pop		{r0,r1,r2,r3,r4}
	bx	lr

.ltorg
//MFS
.equ SerialData,D8
.equ SerialClock,D7
.equ LatchClock,D4

MFS_serial_init:
	//7segment-Anzeige
	setDir D8,Ausgang
	setDir D7,Ausgang
	setDir D4,Ausgang
	bx lr

sendBit:	//Bit im Carry
	movCBit	SerialData
	setb	SerialClock
	clr	    SerialClock
	bx	lr

MFS_sendWord:	//Daten in R0
	push	{r1,r2}
//	ldr	 r2,=EPort
//	ldr  r1,[r2]
	mov  r1,r0
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	lsrs r1,#1
	call sendBit
	setb	LatchClock
	clr		LatchClock
	pop	{r1,r2}
	bx lr

.ltorg

//LCD_Keyboard_Shield
.equ	RS,PA9
.equ	E,PC7
.equ 	DB4,D4
.equ	DB5,D5
.equ	DB6,D6
.equ	DB7,D7

.global	LCD_Keypad_init
.global LCD_Keypad_Text
.global LCD_Keypad_Clear
.global	LCD_Keypad_Cursor

.global LCD_Keypad_Dezaus

//This function is used to write to the LCD screen.  It takes in a number writes it to the 0x40 register of the display.
LCD_Keypad_Dezaus:	//R0: nummer

	push	{r0,r1,r2,r3,r4}
	ldr		r3,=BCD

	ldr	r1,=1000000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=100000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#1]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=10000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#2]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=1000000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#3]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=100000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#4]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=10000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#5]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=1000
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#6]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=100
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#7]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=10
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#8]
	mul	r2,r1
	sub		r0,r2

	ldr	r1,=1
	udiv	r2,r0,r1	//r2=r0/r1
	strb	r2,[r3,#9]
	mul	r2,r1
	sub		r0,r2

	mov	r0,r3
	mov	r4,#0

LCD_Keypad_dezausWdh:
	ldrb	r2,[r3]
	add		r2,#0x30
	strb	r2,[r3]
	add		r3,#1
	add		r4,#1
	cmp		r4,#10
	bne		LCD_Keypad_dezausWdh

	mov	r1,#10
LCD_Keypad_dezausWdh2:
	ldrb	r2,[r0]
	cmp		r2,#0x30
	bne		LCD_Keypad_dezAnzeigen
	sub		r1,#1
	add		r0,#1
	cmp		r1,#1
	bne		LCD_Keypad_dezausWdh2
LCD_Keypad_dezAnzeigen:
	//mov		r2,#0
	//str		r2,[r3]
	call	LCD_Keypad_Text	//R0: char *str

	pop		{r0,r1,r2,r3,r4}
	bx	lr

LCD_Keypad_Cursor:	//Cursorpos in R0
	push	{r0}
	orr		r0,#0x80
	call	LCD_Keypad_write_Control
	call	LCD_Keypad_Warte50us
	pop		{r0}
	bx	lr


LCD_Keypad_Clear:
	push	{r0}
	mov		r0,#0x01
	call	LCD_Keypad_write_Control
	mov		r0,#0
	call	LCD_Keypad_Cursor
	call	LCD_Keypad_Warte10ms
	pop		{r0}
	bx	lr

LCD_Keypad_Text:
/*This function is used to write to the LCD screen.  It takes in a string of
characters and writes them to the 0x40 register of the display.*/
	//R0: char *str)
	push	{r0,r1,r2,r3}
	mov		r1,r0
LCD_Keypad_Text_Wdh:
	ldrb	r0,[r1]
	cmp		r0,#0
	beq		LCD_Keypad_Text_fertig
	call	LCD_Keypad_write_Data
	add		r1,#1
	b		LCD_Keypad_Text_Wdh
LCD_Keypad_Text_fertig:
	call	LCD_Keypad_Warte50us
	pop		{r0,r1,r2,r3}
	bx	lr


LCD_Keypad_init:
	setDir	RS,Ausgang
	setDir	E,Ausgang
	clr		E
	setDir	DB4,Ausgang
	setDir	DB5,Ausgang
	setDir	DB6,Ausgang
	setDir	DB7,Ausgang
	call	LCD_Keypad_FunctionSet
	mov		r0,#0x28
	call	LCD_Keypad_write_Control
	mov		r0,#0x0E
	call	LCD_Keypad_write_Control
	mov		r0,#0x06
	call	LCD_Keypad_write_Control
	mov		r0,#0
	call	LCD_Keypad_Cursor
	call	LCD_Keypad_Warte50us
	bx lr

LCD_Keypad_wait:
	push	{r0}
	mov		r0,#16
LCD_Keypad_wait_Wdh:
	subs	r0,#1
	bne		LCD_Keypad_wait_Wdh
	pop		{r0}
	bx		lr

LCD_Keypad_write:	//Byte in R0
	push	{r0}
	setb	E
	lsrs	r0,#5
	movCBit DB4
	lsrs	r0,#1
	movCBit DB5
	lsrs	r0,#1
	movCBit DB6
	lsrs	r0,#1
	movCBit DB7
	call	LCD_Keypad_wait
	clr		E
	call	LCD_Keypad_wait
	pop		{r0}
	push	{r0}
	setb	E
	lsrs	r0,#1
	movCBit DB4
	lsrs	r0,#1
	movCBit DB5
	lsrs	r0,#1
	movCBit DB6
	lsrs	r0,#1
	movCBit DB7
	setb	E
	call	LCD_Keypad_wait
	clr		E
	call	LCD_Keypad_wait

	pop		{r0}
	bx		lr

LCD_Keypad_write_Control:	//Byte in R0
	clr		RS
	b		LCD_Keypad_write

LCD_Keypad_write_Data:		//Byte in R0
	setb	RS
	b		LCD_Keypad_write

LCD_Keypad_FunctionSet:	//4Bit Interface
	clr		RS
	clr		DB7
	clr		DB6
	setb	DB5
	clr		DB4
	setb	E
	call	LCD_Keypad_wait
	clr		E
	call	LCD_Keypad_wait
	bx		lr

LCD_Keypad_Warte50us:
	push	{r0}
	mov		r0,#300
LCD_Keypad_Warte50usWdh:
	subs	r0,#1
	bne		LCD_Keypad_Warte50usWdh
	pop		{r0}
	bx		lr

LCD_Keypad_Warte10ms:
	push	{r0}
	ldr		r0,=530000
LCD_Keypad_Warte10msWdh:
	subs	r0,#1
	bne		LCD_Keypad_Warte10msWdh
	pop		{r0}
	bx		lr
.ltorg

//Schrittmotorshield
.equ SM_EN12,D11
.equ SM_EN34,D3
.equ SM_SerialData,D8
.equ SM_SerialClock,D4
.equ SM_LatchClock,D12
.equ SM_OutputEnable,D7
.global	SM_init
.global SM_sendByte

SM_init:
	setDir D11,Ausgang
	setDir D3,Ausgang
	setDir D8,Ausgang
	setDir D4,Ausgang
	setDir D12,Ausgang
	setDir D7,Ausgang
	bx	lr

SM_sendBit:	//Bit im Carry
	//movc	SerialData
	movCBit	SM_SerialData
	setb	SM_SerialClock
	clr	    SM_SerialClock
	bx	lr

SM_sendByte:	//Schritt in R0
	push	{r0,r1}
	mov r1,r0
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	lsrs r1,#1
	call SM_sendBit
	setb	SM_LatchClock
	clr		SM_LatchClock
	pop		{r0,r1}
	bx lr

.ltorg
//Bitliste:	//Maske,ODR, IDR

.equ	ea,255
.equ	EA,255

//Bit-Operationen
.global	writeBit
writeBit:	//Bit in R0, Wert in R1
	push	{r0,r1,r2,r3,r4}
	cmp		r0,#EA
	bne		writeWeiter
	cmp		r1,#1
	beq		setEA
clearEA:
	mov	r0,#1
	msr faultmask,r0
	b		writeFertig
setEA:
	mov	r0,#0
	msr faultmask,r0
	b		writeFertig
writeWeiter:
	ldr		r2,=Bitliste
	mov		r3,#12
	mul		r0,r3
	add		r0,r2		//Adresse des Biteintrags in der Bitliste ist in R0
	cmp		r1,#1
	beq		setbit
clearbit:
	mov		r1,r0		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r4,[r1]		//Maske in R4
	bic		r3,r4
	str		r3,[r2]
	b		writeFertig
setbit:
	mov		r1,r0		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r4,[r1]		//Maske in R4
	orr		r3,r4
	str		r3,[r2]

writeFertig:
	pop 	{r0,r1,r2,r3,r4}
	bx		lr

writeBit2:	//Port Bit in R2, Wert in R3
	push	{r0,r1,r2,r3,r4}

	ldr		r0,=Bitliste
	mov		r1,#12
	mul		r2,r1
	add		r2,r0		//Adresse des Biteintrags in der Bitliste ist in R0
	cmp		r3,#1
	beq		setbit2
clearbit2:
	mov		r3,r2		//Tabellenadresse des Bits in der Bitliste
	ldr		r0,[r3,#4]	//Outputregister
	ldr 	r1,[r0]		//@Outputregister in r3
	ldr		r4,[r3]		//Maske in R4
	bic		r1,r4
	str		r1,[r0]
	b		writeFertig2
setbit2:
	mov		r1,r2		//Tabellenadresse des Bits in der Bitliste
	ldr		r0,[r1,#4]	//Outputregister
	ldr 	r3,[r0]		//@Outputregister in r3
	ldr		r4,[r1]		//Maske in R4
	orr		r3,r4
	str		r3,[r0]

writeFertig2:
	pop 	{r0,r1,r2,r3,r4}
	bx		lr




.global	readBit
readBit:	//Bit in R0, return in R0
	push	{r1,r2,r3,r4}
	cmp		r0,#EA
	bne		readWeiter
	mov		r0,#1
	mrs 	r0,faultmask
	and		r0,#1
	eor		r0,#1
	b		readFertig
readWeiter:
	ldr		r2,=Bitliste
	mov		r3,#12
	mul		r0,r3
	add		r0,r2		//Adresse des Biteintrags in der Bitliste ist in R0
	mov		r1,r0		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#8]	//Inputregister
	ldr 	r3,[r2]		//@Inputregister in r3
	ldr		r4,[r1]		//Maske in R4
	ands	r3,r4
	ite		eq
	moveq	r0,#0
	movne	r0,#1
readFertig:
	pop 	{r1,r2,r3,r4}
	bx		lr

readBit2:	//Bit in R0, return in R4
	push	{r0,r1,r2,r3}
	ldr		r2,=Bitliste
	mov		r3,#12
	mul		r0,r3
	add		r0,r2		//Adresse des Biteintrags in der Bitliste ist in R0
	mov		r1,r0		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#8]	//Inputregister
	ldr 	r3,[r2]		//@Inputregister in r3
	ldr		r4,[r1]		//Maske in R4
	ands	r3,r4
	ite		eq
	moveq	r0,#0
	movne	r0,#1
	mov		r4,r0
readFertig2:
	pop 	{r0,r1,r2,r3}
	bx		lr

.ltorg
.global setDirection
//.equ Eingang,0
//.equ Ausgang,1
//.equ Alternate,2
//.equ Analog,3
setDirection:	//R0: Portbit, R1: Direction
	push	{R0,R1,R2,R3,R4,r5}
	mov		r2,#16
	mov		r3,r0
	udiv	r3,r2	//0: PA, 1: PB 2: PC
	mov		r2,#0x400
	mul		r3,r2
	ldr		r2,=GPIOA
	add		r2,r3		//GPIO Basisadresse in r2
	mov		r3,#16
	mov		r4,r0
	mod		r5,r4,r3	//a=b%c	BitNr in r5
	add		r5,r5,r5
	lsl		r1,r1,r5		//Richtungswert in R1 bereit zum Schreiben
    mov r3,#3
    lsl r3,r3,r5
    ldr r4,=0xffffffff
    eor r3,r4
    ldr r4,[r2]
    and r4,r3
    orr	r4,r1
    str r4,[r2]	//ModeRegister
	pop {R0,R1,R2,R3,R4,r5}
	bx	lr
.ltorg

.global	PullUpDown
PullUpDown:
//Pullup/-down
//.equ	KeinPull,0
//.equ	Pullup,1
//.equ	PullDown,2
	push {R0,R1,R2,R3,R4,R5}
	mov		r2,#16
	mov		r3,r0
	udiv	r3,r2	//0: PA, 1: PB 2: PC
	mov		r2,#0x400
	mul		r3,r2
	ldr		r2,=GPIOA
	add		r2,r3		//GPIO Basisadresse in r2
	mov		r3,#16
	mov		r4,r0
	mod		r5,r4,r3	//a=b%c	BitNr in r5
	add		r5,r5,r5
	lsl		r1,r1,r5		//PUDRwert in R1 bereit zum Schreiben
    mov r3,#3
    lsl r3,r3,r5
    ldr r4,=0xffffffff
    eor r3,r4
    ldr r4,[r2,#GPIOx_PUPDR]
    and r4,r3
    orr	r4,r1
    str r4,[r2,#GPIOx_PUPDR]	//Pullup, -down Register
	pop {R0,R1,R2,R3,R4,R5}
	bx	lr
.ltorg
.global	cplBit
cplBit:		//Bit in R0
	push	{r0,r1,r2,r3,r4}
	mov		r1,#12
	mul		r0,r1
	ldr		r1,=Bitliste
	add		r1,r0		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r4,[r1]		//Maske in R4
	eor		r3,r4
	str		r3,[r2]
	pop 	{r0,r1,r2,r3,r4}
	bx		lr
.ltorg

.global	Ausgangstyp
Ausgangstyp: 	//Bit in R0, Typ in R1
//OutputType
//.equ PushPull,0
//.equ OpenDrain,1
	push {R0,R1,R2,R3,R4,R5}
	mov		r2,#16
	mov		r3,r0
	udiv	r3,r2	//0: PA, 1: PB 2: PC
	mov		r2,#0x400
	mul		r3,r2
	ldr		r2,=GPIOA
	add		r2,r3		//GPIO Basisadresse in r2
	mov		r3,#16
	mov		r4,r0
	mod		r5,r4,r3	//a=b%c	BitNr in r5
	lsl		r1,r1,r5	//ATRwert in R1 bereit zum Schreiben
    mov r3,#1
    lsl r3,r3,r5
    ldr r4,=0xffffffff
    eor r3,r4
    ldr r4,[r2,#GPIOx_OTYPER]
    and r4,r3
    orr	r4,r1
    str r4,[r2,#GPIOx_OTYPER]	//Pullup, -down Register
	pop {R0,R1,R2,R3,R4,R5}
	bx	lr

.global	writeArduinoPort
.equ	DL,0
.equ	DH,1
writeArduinoPort: 		// r0: Wert r1: DL oder DH 	kopiert untere(obere) 8 Bits von r0 auf D7..D0
	push	{r0,r1,r2,r3,r4}
	cmp		r1,#1
	beq		copyDH
	lsrs	R0,#1
	movCBit		D0
	lsrs	r0,#1
	movCBit		D1
	lsrs	r0,#1
	movCBit		D2
	lsrs	r0,#1
	movCBit		D3
	lsrs	r0,#1
	movCBit		D4
	lsrs	r0,#1
	movCBit		D5
	lsrs	r0,#1
	movCBit		D6
	lsrs	r0,#1
	movCBit		D7
	b	copyFertig
copyDH:
	lsrs	r0,#1
	movCBit		D8
	lsrs	r0,#1
	movCBit		D9
	lsrs	r0,#1
	movCBit		D10
	lsrs	r0,#1
	movCBit		D11
	lsrs	r0,#1
	movCBit		D12
	lsrs	r0,#1
	movCBit		D13
	lsrs	r0,#1
	movCBit		D14
	lsrs	r0,#1
	movCBit		D15
copyFertig:
	pop	{r0,r1,r2,r3,r4}

	bx	lr

.global	writeRegister
writeRegister:	//R0 Register, R1 Data
	strh	R1,[R0]
	bx	lr

.global	readRegister
readRegister:	//R0 Register	return R0
	ldrh	r0,[r0]
	bx	lr

.global	writeByteRegister
writeByteRegister:	//R0 Register, R1 Data
	strb	R1,[R0]
	bx	lr

.global	readByteRegister
readByteRegister:	//R0 Register	return R0
	ldrb	r0,[r0]
	bx	lr

.global wait_ms
wait_ms:	//Wartezeit in ms in R0
	push	{r0,r1}
	ldr		r1,=5333
	mul		r0,r1
wait_msWdh:
	subs	r0,#1
	bne		wait_msWdh
	pop		{r0,r1}
	bx	lr
.ltorg
//LED&KEY
.global	LuK_init
LuK_init:	//R0 = Pin Strobe, R1 = Pin CLK, R2 = Pin DIO
	push	{r0,r1,r2,r3,r4}
	ldr		r3,=LuK_Strobe
	strb	r0,[r3]
	strb	r1,[r3,#1]
	strb	r2,[r3,#2]
	mov		r4,r1
	mov		r1,#Ausgang		//Strobe Ausgang
	call	setDirection
	mov		r0,r4
	call	setDirection	//Clk Ausgang
	mov		r0,r2
	call	setDirection	//DIO Ausgang
	mov		r1,#OpenDrain
	call	Ausgangstyp		//DIO OpenDrain
	mov		r1,#1
	call	writeBit		//DIO = 1
	ldrb	r0,[r3]
	call	writeBit		//Strobe = 1
	ldrb	r0,[r3,#1]
	call	writeBit		//CLK = 1
	mov		r0,#0x8F
	call	LuK_sendCommand
	mov		r0,#0			//Display lschen
	mov		r1,#0
	mov		r2,#0
LuK_init_Wdh:
	call	LuK_send2Byte
	adds	r2,#1
	cmp		r2,#16
	bne		LuK_init_Wdh
	pop		{r0,r1,r2,r3,r4}
	bx	lr

//writeBit2:	//Port Bit in R2, Wert in R3
LuK_sendBit:	//Send Bit in r1, Pin DIO in R0, Pin CLK in R2 Wert CLK in R3
	mov		r3,#0
	call	writeBit2
	call	writeBit
	mov		r3,#1
	call	writeBit2
	bx		lr

.global		LuK_sendCommand
LuK_sendCommand: //Command in R0
	push	{r0,r1,r2,r3,r4,r5}
	mov		r4,r0			//Command in R4
	ldr		R5,=LuK_Strobe
	ldrb		R2,[R5,#1]		//Pin CLK in R2
	ldrb		R0,[r5]			//Pin Strobe in R0
	mov		R1,#0
	call	writeBit		//Strobe auf 0
	ldrb		r0,[r5,#2]		//Pin DIO	in r0
	mov		r5,#0			//Bit Zhler in r5
LuK_sendCommand_Wdh:
	lsrs	r4,#1
	ite		cc
	movcc	r1,#0
	movcs	r1,#1
	call	LuK_sendBit
	adds	r5,#1
	cmp		r5,#8
	bne		LuK_sendCommand_Wdh
	ldr		R5,=LuK_Strobe	//Strobe wieder auf 1
	ldrb	R0,[r5]			//Pin Strobe in R0
	mov		R1,#1
	call	writeBit		//Strobe auf 1
	pop		{r0,r1,r2,r3,r4,r5}
	bx 	lr

LuK_send2Byte: //Command in R0	Data in R1
	push	{r0,r1,r2,r3,r4,r5,r6}
	mov		r4,r0			//Command in R4
	mov		r6,r1
	ldr		R5,=LuK_Strobe
	ldrb		R2,[R5,#1]		//Pin CLK in R2
	ldrb		R0,[r5]			//Pin Strobe in R0
	mov		R1,#0
	call	writeBit		//Strobe auf 0
	ldrb		r0,[r5,#2]		//Pin DIO	in r0
	mov		r5,#0			//Bit Zhler in r5
LuK_send2Byte_Wdh:
	lsrs	r4,#1
	ite		cc
	movcc	r1,#0
	movcs	r1,#1
	call	LuK_sendBit
	adds	r5,#1
	cmp		r5,#8
	bne		LuK_send2Byte_Wdh
	mov		r1,#10			//2s
LuK_send2Byte_Warte:
	subs	r1,#1
	bne		LuK_send2Byte_Warte
	mov		r5,#0			//Bit Zhler in r5
LuK_send2Byte_Wdh2:
	lsrs	r6,#1
	ite		cc
	movcc	r1,#0
	movcs	r1,#1
	call	LuK_sendBit
	adds	r5,#1
	cmp		r5,#8
	bne		LuK_send2Byte_Wdh2
	ldr		R5,=LuK_Strobe
	ldrb	R0,[r5]			//Pin Strobe in R0
	mov		R1,#1
	call	writeBit		//Strobe auf 1
	pop		{r0,r1,r2,r3,r4,r5,r6}
	bx 	lr

.global	LuK_sendByte
LuK_sendByte:	//R0 Displayadresse, R1 Data
	push	{r0,r1,r2,r3,r4}
	ldr		r2,=LuK_busy
	ldrb	r3,[r2]
	cmp		r3,#0
	bne		LuK_sendBytefertig
	mov		r3,#1
	strb	r3,[r2]
	mov		r4,r0		//Displayadresse gespeichert in r4
	add		r4,#0xC0	//Alle displayadressen haben 0xC?
	mov		r0,#0x44	//setData Command
	call	LuK_sendCommand
	mov		r0,r4
	call	LuK_send2Byte
	ldr		r2,=LuK_busy
	mov		r3,#0
	strb	r3,[r2]
LuK_sendBytefertig:
	pop		{r0,r1,r2,r3,r4}
	bx		lr

LuK_sendCommand_ohneStrobe: //Command in R0
	mov		r4,r0			//Command in R4
	ldr		R5,=LuK_Strobe
	ldrb		R2,[R5,#1]		//Pin CLK in R2
	ldrb		R0,[r5]			//Pin Strobe in R0
	mov		R1,#0
	call	writeBit		//Strobe auf 0
	ldrb		r0,[r5,#2]		//Pin DIO	in r0
	mov		r5,#0			//Bit Zhler in r5
LuK_sendCommand_Wdh2:
	lsrs	r4,#1
	ite		cc
	movcc	r1,#0
	movcs	r1,#1
	call	LuK_sendBit
	adds	r5,#1
	cmp		r5,#8
	bne		LuK_sendCommand_Wdh2
	//ldr		R5,=LuK_Strobe	//Strobe wieder auf 1
	//ldrb	R0,[r5]			//Pin Strobe in R0
	//mov		R1,#1
	//call	writeBit		//Strobe auf 1

	bx 	lr

LuK_readBit:
	mov		r3,#0
	call	writeBit2
	nop
	nop
	nop
	nop		//Wartezeit auf Data
	call	readBit2
	mov		r3,#1
	call	writeBit2
	bx		lr



LuK_read:	//Rckgabe in R0, readBit2:	//Bit in R0, return in R4
	push	{r1,r2,r3,r4}
	ldr		r5,=LuK_Strobe
	ldrb	r0,[r5,#2]		//DIO in R0
	mov		r1,#1
	call 	writeBit
	ldrb	r2,[r5,#1]		//clk in R2
	mov		r5,#8
	mov		r6,#0
LuK_read_Wdh:
	call	LuK_readBit	//Bit in R4
	lsl		r6,#1
	add		r6,r4
	subs	r5,#1
	bne		LuK_read_Wdh
	mov		r0,r6
	mov		r1,#10			//2s
LuK_read_Warte1:
	subs	r1,#1
	bne		LuK_read_Warte1
	pop		{r1,r2,r3,r4}
	bx		lr


.global	LuK_readByte
LuK_readByte:	//Rckgabe in R0
	push	{r1,r2,r3,r4,r5,r6}
	ldr		r2,=LuK_busy
	ldrb	r3,[r2]
	cmp		r3,#0
	bne		LuK_readBytefertig
	mov		r3,#1
	strb	r3,[r2]
	mov		r0,#0x42
	call	LuK_sendCommand_ohneStrobe
	mov		r1,#10			//2s
LuK_readByte_Warte1:
	subs	r1,#1
	bne		LuK_readByte_Warte1
	ldr		r0,=LuK_DIO
	ldrb	r0,[r0]
	mov		r1,#0
	call	setDirection
	call	LuK_read
	mov		r1,r0
	call	LuK_read
	mov		r2,r0
	call	LuK_read
	mov		r3,r0
	call	LuK_read
	mov		r4,r0
	ldr		R5,=LuK_Strobe	//Strobe wieder auf 1
	ldrb	R0,[r5]			//Pin Strobe in R0
	push	{r1}
	mov		R1,#1
	call	writeBit		//Strobe auf 1
	pop		{r1}
	mov		r0,#0
	lsl		r0,#1
	lsrs	r4,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r3,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r2,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r1,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r4,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r3,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r2,#4
	adc	r0,#0
	lsl		r0,#1
	lsrs	r1,#4
	adc	r0,#0
	push	{r0}
	ldr		r0,=LuK_DIO
	ldrb	r0,[r0]
	mov		r1,#1
	call	setDirection
	pop		{r0}
	ldr		r2,=LuK_busy
	mov		r3,#0
	strb	r3,[r2]
LuK_readBytefertig:
	pop		{r1,r2,r3,r4,r5,r6}
	bx		lr
.ltorg
.global	LuK_setLEDs
LuK_setLEDs:	//LEDS in R0, Maske in R3
	push	{r0,r1,r2,r3}
	mov		r2,r0
	mov		r3,r1

	mov		r0,#1
LuK_setLEDs_Wdh:
	mov		r1,#0
	lsrs	r2,#1
	adc		r1,#0
	lsrs	r3,#1
	bcc		LuK_setLEDs_weiter
	call	LuK_sendByte	//R0 Displayadresse, R1 Data
LuK_setLEDs_weiter:
	adds	r0,#2
	cmp		r0,#17
	bne		LuK_setLEDs_Wdh

	pop		{r0,r1,r2,r3}
	bx		lr


.ltorg

.data 2
.balign 4
//LED&KEY Vatiablen
LuK_Strobe:
.byte	0
LuK_CLK:
.byte	0
LuK_DIO:
.byte 0
LuK_busy:
.byte 0



//Grove Variablen

_displayfunction:
.byte 0
_displaycontrol:
.byte 0
.byte 0,0
GroveBuffer:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
BCD:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

//USART Portmonitor Variablen
PortMonZustand:
.byte 0,0,0,0
PortMonCommand:
.byte 0,0,0,0
EPort:
.byte 0,0,0,0
.balign	4
ISRTabelle1:
.space 256,0x55
.global	Datenspeicher

Datenspeicher:
.space 0x8000,0xaa

