/**
  ******************************************************************************
  * @file    main.c
  * @author  Ac6
  * @version V1.0
  * @date    01-December-2013
  * @brief   Default main function.
  ******************************************************************************
*/
/**
 * Multifunctionshield
 * Ausgabe Poti auf Display und Schrittmotor (Minischrittmotorplatine IN1=PC0, IN2=PC1, IN3=PC2, IN3=PC4
 * wait_ms6(ms) mit Tim6
 * Schrittmotor im Interrupt von TIM7
 * TIM2 als Ereigniszhler wechselt LDE D3 (D11) alle 5 Ereignisse an A1 (Taste)
 * SysTicktimer blinkt LED D1 (D13)
 * Tasteninterrupt A1 wechselt LED D1 (D12)
 */

#include "stm32l1xx.h"
#include "startup.h"
char siebenseg[10]={0b00000011,0b10011111,0b00100101,0b00001101,0b10011001,0b01001001,0b01000001,0b00011111,0b00000001,0b00001001};
unsigned int Zaehler=0,Speed=10;
uint8	Schritte[4]={0b1010,0b1001,0b0101,0b0110};

void wait_ms6(int ms)
{
	int z=0;
	TIM6_ARR=1000;
	writeBit(CEN6,1);
	for (z=0;z<ms;z++)
	{
	writeBit(UIF6,0);
	while(readBit(UIF6)==0);
	}
	writeBit(CEN6,0);
}

void ZahlAusgeben(unsigned int Zahl)
{
	int ms=5;
	uint8 ziffer;
	ziffer =Zahl%10;
	Zahl=Zahl/10;
	MFS_sendWord (siebenseg[ziffer]+0x1000);
	wait_ms6(ms);
	ziffer =Zahl%10;
	Zahl=Zahl/10;
	MFS_sendWord (siebenseg[ziffer]+0x2000);
	wait_ms6(ms);
	ziffer =Zahl%10;
	Zahl=Zahl/10;
	MFS_sendWord (siebenseg[ziffer]+0x4000);
	wait_ms6(ms);
	ziffer =Zahl%10;
	Zahl=Zahl/10;
	MFS_sendWord (siebenseg[ziffer]+0x8000);
	wait_ms6(ms);
}

void SysTickISR(void)
{
	cplBit(D13);
}


void initSystickTimer(int ms)
{
	SysTick_ARR=2000*ms;

	writeBit(SysTickTimerEnable,1);

	writeBit(SysTickTimerCOUNTFLAG,0);		//Zero-Interrupt-Flag lschen
	setIntVector(SysTickISR,SysTickVector); 		//Adresse (Label) der ISR, Interrupt Vektor
	writeBit(SysTickIntEnable,1);			//SystemTimer Interrupt Enable setzen
	setDirection(D13,Ausgang);
}

uint8	Merker=0;

void TasteA1ISR(void)
{

		wait_ms(50);		//entprellen
		writeBit(PR1,1);	//Pending-Bit lschen
		cplBit(D12);
}

void initExtI_A1(void)
{

	setIntVector(TasteA1ISR,ex1Vector); //Adresse (Label) der ISR, Interrupt Vektor
		writeBit(FTSR1,0);		//fallende Flanke deaktivieren
		writeBit(RTSR1,1);		//steigende Flanke aktivieren
		writeBit(MR1,1);		//Externer Interrupt 1 freigeben
		writeBit(EA,1);			//Interruptsystem freigeben
		setDirection(D12,Ausgang);	//LED D2
}

void initTim2Counter()
{
	setDirection(D11,Ausgang);
	writeBit(D11,0);
	TIM2_CNT=0;
	writeBit(CEN2,1);
}

uint8 i=0;

void TIM7_ISR(void)
{
		unsigned long PortC;
		writeBit(UIF7,0);			//Pending lschen

		Zaehler=Zaehler+1;
		if	(Zaehler>=Speed)
		{
			Zaehler=0;
			PortC=GPIOC_ODR;	//Schrittmotor an PC: PC0=IN1, PC1=IN2, PC3=IN3, PC4=IN4
			PortC=PortC&0xfffffff0;
			PortC=PortC|Schritte[i];
			GPIOC_ODR=PortC;
			i++;
			if (i>=4) i=0;

		}


}

void initTim7(void)
{
	//TIM7 fr Interrupts alle 50ms konfigurieren

		TIM7_ARR=100;			//1ms
		writeBit(UIF7,0);			//Update-Interrupt-Flag lschen

		//Interrupt initialisieren
		setIntVector(TIM7_ISR,uie7Vector); //Adresse (Label) der ISR, Interrupt Vektor
		writeBit(UIE7,1);
		writeBit(CEN7,1);			//TIM6 starten

		//Ausgnge
		setDirection(PC0,Ausgang);
		setDirection(PC1,Ausgang);
		setDirection(PC2,Ausgang);
		setDirection(PC3,Ausgang);
		writeBit(PC0,1);
		writeBit(PC1,1);
		writeBit(PC2,1);
		writeBit(PC3,1);
}



int main(void)
{
	unsigned int Poti;
	startup();
	initSystickTimer(500);
	initExtI_A1();
	initTim2Counter();
	MFS_serial_init();
	initTim7();
	for(;;)
	{
		Poti = Ain0();
		Speed=Poti/10+50;
		ZahlAusgeben(Poti);
		if (TIM2_CNT>5)
		{
			cplBit(D11);
			TIM2_CNT=0;
		}

	}
}
