.syntax unified
.equ L152,1
.include "../Core/src/regs.s"
.global mainasm
mainasm:

.equ Motor,Bit1		//Alle GPIOC
.equ MotorFast,Bit0
.equ Pump,Bit2
.equ Heater,Bit3
.equ WaterIn,Bit4

.equ Temp,Bit0	//Alle GPIOB
.equ Temp60,Bit1
.equ Temp90,Bit2
.equ W1,Bit3
.equ W2,Bit4
.equ OnOff,Bit7


main:
	ldr		R2,=GPIOC
	ldr		R4,=GPIOB
	mov		R0,#0x0			//alles aus
	strb	R0,[R2,ODR]
schleife:
	ldr		R0,[R4,IDR]		//warten auf OnOff=1
	tst		R0,OnOff
	beq		schleife

	mov		R0,Pump			//8s Abpumpen
	strb	R0,[R2,BSR]
	bl		warte8s

	mov		R0,Pump			//Pumpe aus
	strb	R0,[R2,BRR]

	mov		R0,Motor		//Motor langsam
	strb	R0,[R2,BSR]

	mov 	R0,WaterIn		//Wasserzulauf=1
	strb	R0,[R2,BSR]

wartenAufVoll:				//warten auf voll
	ldr		R0,[R4,IDR]
	tst		R0,W2
	beq		wartenAufVoll

	mov		R0,WaterIn		//'Wasserzulauf aus
	strb	R0,[R2,BRR]

	mov		R0,Heater		//Heizung ein
	strb	R0,[R2,BSR]

	ldr		R0,[R4,IDR]		//Temperaturwahlschalter
	tst		R0,Temp
	bne		w90
w60:						//warten auf 60°V
	ldr		R0,[R4,IDR]
	tst		R0,Temp60
	beq		w60
	b		weiter
w90:						//warten auf 90°C
	ldr		R0,[R4,IDR]
	tst		R0,Temp90
	beq		w90
weiter:
	mov		R0,Heater		//Heater aus
	strb	R0,[R2,BRR]

	bl		warte8s			//8s waschen

	mov		R0,Pump			//abpumpen
	strb	R0,[R2,BSR]

wartenAufLeer:				//wartten auf leer
	ldr		R0,[R4,IDR]
	tst		R0,W1
	bne		wartenAufLeer

	mov		R0,MotorFast	//Schleudern
	strb	R0,[R2,BSR]

	bl		warte8s			//8s warten

	mov		R0,#0			//alles aus
	strb	R0,[R2,ODR]

wartenAufOnOff0:
	ldr		R0,[R4,IDR]
	tst		R0,OnOff
	bne		wartenAufOnOff0

	b		schleife

warte8s:
	ldr		R0,=32000000/5*8
	mov		R1,#1
w1:
	subs	R0,R1
	bne		w1
	bx		lr

.end
