.syntax unified
.equ L152,1
.include "../Core/src/regs.s"
.global mainasm
mainasm:


.equ Einerstelle,Bit14
.equ Zehnerstelle,Bit15

main:
	bl		startup		//Startupcode
	ldr 	R5,=GPIOC	//R5 verweist auf GPIOC
	mov 	R4,#0 		//Zähler in R4 mit 0 beginnen
	ldr 	R6,=seg7	//R6 verweist auf die Tabelle seg7
	ldr		R7,=TelNr
	mov		R0,Bit14	//Anzeige einschalten
	str 	R0,[R5,ODR] //Bit14 von GPIOC.ODR
schleife:	//Endlosschleife
	ldrb	R0,[R7,R4]	//Ziffer holen
	cmp		R0,#255
	beq		vonVorne
	ldrb 	R0,[R6,R0]	//R0=seg7[R1]
	strb	R0,[R5,ODR]	//R0 auf die Siebensegmentanzeige ausgeben
	mov		R0,#1000
	bl		HAL_Delay

	mov		R0,#0		//kurze Pause
	strb	R0,[R5,ODR]
	mov		R0,#100
	bl		HAL_Delay

	add		R4,#1		//nächste Ziffer

	b		schleife

vonVorne:
	mov		R0,0			//Aus
	strb	R0,[R5,ODR]
	mov		R0,#3000		//3s
	bl		HAL_Delay
	mov		R4,#0			//von vorne
	b		schleife


seg7:
.byte 0b00111111, 0b00000110, 0b01011011, 0b01001111, 0b01100110, 0b01101101, 0b01111101, 0b00000111, 0b01111111, 0b01101111

TelNr:
.byte 1,1,8,3,3,255
.end
