.syntax unified
.include "../src/regs.asm"
.global mainasm

.equ	snd,D3
.equ	LED0,D13
.equ 	LED1,D12
.equ	LED2,D11
.equ	LED3,D10

.equ	Zaehler,0

.equ SerialData,D8
.equ SerialClock,D7
.equ LatchClock,D4


mainasm:
	call startup

	call	I2C_init
	mov		r0,#0


	call	Grove_LCD_RGB_Backlightinit
	mov		r0,#0
	mov		r1,#0
	call	Grove_LCD_RGB_Backlightlocate	//R0: char col, R1: char row
	ldr		r0,=Text
	call  	Grove_LCD_RGB_Backlightprint	//R0: char *str)

	mov		r0,#0
	mov		r1,#1
	call	Grove_LCD_RGB_Backlightlocate	//R0: char col, R1: char row
	call	Grove_LCD_RGB_Backlightdezaus	//R0: nummer


//sound
	setDir 	snd,Ausgang	//snd = soundausgang
	setb	snd


InitTaste1ISR:	//Taste1 an Port A1
	setISR 	TasteA1ISR,ex1Vector		//AdresseDerISR, InterruptNr (Offset in der ISR-Tabelle)
	ldr		r1,=PRI7					//Priorittenregister auswhlen
	mov		r0,#0xF0					//Prioritt (hier hchste 15) auswhlen
	strb	r0,[r1]						//Prioritt einspeichern
	clr		FTSR1		//kein Interrupt bei fallender Flanke
	setb	RTSR1		//Interrupt bei steigender Flanke
	setb	MR1
	setb	EA
	setDIR	A1,Alternate
	setb	cen2

	//LEDs
	setDir	LED0,Ausgang
	setDir	LED1,Ausgang
	setDir	LED2,Ausgang
	setDir	LED3,Ausgang
	setb	LED0

	ldr		r7,=EPort
	call 	MFS_serial_init

	call	initTIM2

InitTIM6:  //LED3 (D10) soll mit 1s Ein- und Aus Blinken
//Zaehler im RAM mit 20 vorladen
	mov		r1,#20			//Startwert 20 des Zhlers in R1 (20*50ms=1s)
	str		r1,[dptr,Zaehler]
//TIM6 fr Interrupts alle 50ms konfigurieren
	ldr	r0,=TIM6	//Basisadresse von TIM6 laden
	mov	r1,#50000	//50000s = 50ms Reloadwert
	str	r1,[r0,#TIMx_ARR]	//Reloadwert im Reloadregister speichern
	clr	UIF6		//Update-Interrupt-Flag lschen
	//Interrupt initialisieren
	setISR 	TIM6ISR,uie6Vector //Adresse (Label) der ISR, Interrupt Vektor
	setb	UIE6
	setb	CEN6		//TIM6 starten

//Systimer mit 4MHz

	ldr	r1,=SysTickRR	//Reloadregister auswhlen
	ldr	r2,=2000000		//Reload fr 0,5s
	str	r2,[r1]			//Reload speichern

	setb	SysTickTimerEnable

	clr		SysTickTimerCOUNTFLAG		//Zero-Interrupt-Flag lschen
	setISR 	SysTickISR,SysTickVector //Adresse (Label) der ISR, Interrupt Vektor
	setb	SysTickIntEnable		//SystemTimer Interrupt Enable setzen

schleife:
	mov		r0,#0
	mov		r1,#1
	call	Grove_LCD_RGB_Backlightlocate	//R0: char col, R1: char row
	call	Ain0
	call	Grove_LCD_RGB_Backlightdezaus	//R0: nummer
	mov		r2,r0

	call 	ZahlAusgeben
	movc	A2
	movCBit	LED1
	jnb		A3,Taste3
	b	schleife

Warte5ms:
	push	{r0}
	mov		r0,#5
	call	wait_ms
	pop		{r0}
	bx	lr

Taste3:		//entprellt
	ldr	r0,=100000
Taste3Wdh1:
	subs	r0,#1
	bne		Taste3Wdh1
Taste3Wdh2:
	jnb		A3,Taste3Wdh2
	ldr	r0,=100000
Taste3Wdh3:
	subs	r0,#1
	bne		Taste3Wdh3
	cpl		LED2
	b	schleife

SysTickISR:
	clr		SysTickTimerCOUNTFLAG
	cpl		LED2
	reti

TasteA1ISR:
	mov	r0,#50
	call	wait_ms
	setb	PR1		//Pending lschen
	cpl	LED0
	reti

TIM6ISR:
	clr	UIF6		//Pending lschen
	push	{r0,r1}
	ldrb	r1,[dptr,Zaehler]
	subs	r1,#1
	bne		TIM6ISRfertig
	mov		r1,#20
	cpl		LED3
TIM6ISRfertig:
	strb	r1,[dptr,Zaehler]
	pop		{r0,r1}
	reti

ZahlAusgeben:	//Zahl in R2
	mov		r4,#10
	ldr		r5,=siebenseg
	mod		r0,r2,r4
	ldrb	r0,[r5,r0]
	add		r0,#0x1000

	call	MFS_sendWord	//Extensionport an MFC schicken

	udiv	r2,r4
	call	Warte5ms


	mod		r0,r2,r4
	ldrb	r0,[r5,r0]
	add		r0,#0x2000

	call	MFS_sendWord

	udiv	r2,r4
	call	Warte5ms

	mod		r0,r2,r4
	ldrb	r0,[r5,r0]
	add		r0,#0x4000

	call	MFS_sendWord

	udiv	r2,r4
	call	Warte5ms

	mod		r0,r2,r4
	ldrb	r0,[r5,r0]
	add		r0,#0x8000

	call	MFS_sendWord




	bx	lr

initTIM2:
	ldr	r0,=TIM2
	ldr	r1,=0
	str	r1,[r0,TIMx_CNT]	//Counter lschen
	setb	CEN2			//TIM2 freigeben
	bx	lr

Text:
.asciz "Hallo Welt "
//.byte	0

siebenseg:
.byte 0b00000011,0b10011111,0b00100101,0b00001101,0b10011001,0b01001001,0b01000001,0b00011111,0b00000001,0b00001001

.end
