.syntax unified
.equ L152,1
.include "../Core/src/regs.s"
.global mainasm
mainasm:




.equ Einerstelle,Bit12
.equ Zehnerstelle,Bit13
.equ Taster,Bit1

main:

	mov 	R5,#0 			//Zähler in R5 mit 0 beginnen
	ldr 	R4,=GPIOA		//R4 verweist auf GPIOA
	ldr 	R6,=seg7		//R6 verweist auf die Tabelle seg7
	ldr		R7,=TelNr
	bl		MFS_serial_init	//Initialisierung der Schnittstelle
schleife:	//Endlosschleife
	ldrb 	R0,[R7,R5]		//R0=TelNr[R5]
	cmp		R0,#255
	beq		vonVorne
	ldrb	R0,[R6,R0]		//R0=seg7[R0]
	add		R0,Einerstelle	//Einerstelle hinzufügen
	bl		MFS_sendWord
	mov		R0,#1000
	bl		HAL_Delay

	mov		R0,#0			//zwischen 2 Ziffern
	bl		MFS_sendWord
	mov		R0,#100
	bl		HAL_Delay


	add		R5,#1			//nächste Ziffer

	b		schleife
vonVorne:
	mov		R0,0xFF			//Aus
	bl		MFS_sendWord
	mov		R0,#3000		//3s
	bl		HAL_Delay
	mov		R5,#0			//von vorne
	b		schleife


seg7:
.byte 0b00000011,0b10011111,0b00100101,0b00001101,0b10011001,0b01001001,0b01000001,0b00011111,0b00000001,0b00001001

TelNr:
.byte 1,1,8,3,3,255
.end
