/* aufgabeL1-2.ino
 *  Handreichungen Wahlfach BPE 10 Robotik
*/ 

//  Übersicht über die Ansteuerung des L298n Moduls für die Fahrzeugbewegung
//  ENA   ENB   IN1   IN2   IN3   IN4   Pins
//  HIGH  HIGH  HIGH  LOW   LOW   HIGH  Auto fährt vorwärts
//  HIGH  HIGH  LOW   HIGH  HIGH  LOW   Auto fährt rückwärts
//  HIGH  HIGH  LOW   HIGH  LOW   HIGH  Auto dreht nach rechts
//  HIGH  HIGH  HIGH  LOW   HIGH  LOW   Auto dreht nach link
//  HIGH  HIGH  LOW   LOW   LOW   LOW   Auto hält an
//  HIGH  HIGH  HIGH  HIGH  HIGH  HIGH  Auto hält an
//  LOW   LOW   N/A   N/A   N/A   N/A   Auto hält an


// L298n Modul IO Pins für den gewählten Fahrroboter
#define ENA 5
#define ENB 6
#define IN1 7
#define IN2 8
#define IN3 9
#define IN4 11

void forward() {
  digitalWrite(ENA, HIGH); //aktiviere L298n A Kanal
  digitalWrite(ENB, HIGH); //aktiviere L298n B Kanal
  digitalWrite(IN1, HIGH); //setze IN1 auf High
  digitalWrite(IN2, LOW);  //setze IN2 auf Low
  digitalWrite(IN3, LOW);  //setze IN3 auf Low
  digitalWrite(IN4, HIGH); //setze IN4 auf Hight
  Serial.println("Forward");
}

void back() {
  digitalWrite(ENA, HIGH);
  digitalWrite(ENB, HIGH);
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  digitalWrite(IN3, HIGH);
  digitalWrite(IN4, LOW);
  Serial.println("Back");
}

void left() {
  digitalWrite(ENA, HIGH);
  digitalWrite(ENB, HIGH);
  digitalWrite(IN1, LOW);
  digitalWrite(IN2, HIGH);
  digitalWrite(IN3, LOW);
  digitalWrite(IN4, HIGH);
  Serial.println("Left");
}

void right() {
  digitalWrite(ENA, HIGH);
  digitalWrite(ENB, HIGH);
  digitalWrite(IN1, HIGH);
  digitalWrite(IN2, LOW);
  digitalWrite(IN3, HIGH);
  digitalWrite(IN4, LOW);
  Serial.println("Right");
}

void stop() {
  digitalWrite(ENA, LOW);
  digitalWrite(ENB, LOW);
  Serial.println("Stop");
}


// Initialisierung der Handware vor dem eigentlichen Start
// setup() wird zuerst und nur einmal ausgeführt
void setup() {
  Serial.begin(9600);   // Öffnen des seriellen Monitors und Setzen der Übertragungsrate
  pinMode(IN1, OUTPUT); // Definieren der IO Pins -> Pin Modus setzen
  pinMode(IN2, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);
  pinMode(ENA, OUTPUT);
  pinMode(ENB, OUTPUT);
  Serial.println("Init abgeschlossen");
}

// Wiederholte Ausführung des Codes im Block
void loop() {
  for (int i = 0; i < 3; i++) {
    forward();  //go forward
    delay(1000);//delay 1000 ms
    back();     //go back
    delay(1000);
    left();     //turning left
    delay(1000);
    right();    //turning right
    delay(1000);
  }
  stop();
  exit(0);
}
