/*
 * Copyright (c) Codiad & Thomas Perschke, distributed
 * as-is and without warranty under the MIT License.
 * See http://opensource.org/licenses/MIT for more information. 
 * This information must remain intact.
 */

(function(global, $){
    
    var codiad = global.codiad,
        scripts = document.getElementsByTagName('script'),
        path = scripts[scripts.length-1].src.split('?')[0],
        curpath = path.split('/').slice(0, -1).join('/')+'/';

    $(function() {
        codiad.Extract.init();
    });

    codiad.StudentImport = {
		
        controller: 'components/user/controller.php',
        
        path: curpath,
        file: "",
        
        init: function() {
            
        },
        
        //////////////////////////////////////////////////////////
        //
        //  Show dialog to import students
        //
        //  Parameter
        //
        //  path - {String} - File path
        //
        //////////////////////////////////////////////////////////
        showImportDialog: function(path) {
			var _this = this;
            this.file = path;
            codiad.modal.load(600, this.path+"dialog.php?d=i&path="+path);
            $('#modal-content form')
                .live('submit', function(e) {
                e.preventDefault();
				var cbs = $('#modal-content form input[type=checkbox]');
				for(i=0; i<cbs.length; i++) {
					var cb = cbs.eq(i);
					if(cb.attr('checked')) {
						var tds = cb.closest('tr').children();
						if(tds.length>= 3) {
							var name = tds.eq(0).text();
							var firstname = tds.eq(1).text();
							var schoolclass = tds.eq(2).text();
							$.post(_this.path+'controller.php?action=create', {'file': path, 'name' : name , 'firstname': firstname, 'schoolclass' : schoolclass}, function(data) {
								data = JSON.parse(data);
								if (data.status == 'error') {
									codiad.message.error(data.message, null)
								}
								if (data.status == 'success') {
									codiad.message.success("Schüler eingerichtet", null)
								}
							});
						}
					}
				}
				codiad.modal.unload();
            });
        },
		
        
        //////////////////////////////////////////////////////////
        //
        //  Show dialog to import students
        //
        //  Parameter
        //
        //  path - {String} - File path
        //
        //////////////////////////////////////////////////////////
        showManagementDialog: function() {
			var _this = this;
            this.file = path;
            codiad.modal.load(600, this.path+"dialog.php?d=m&path="+path);
            $('#modal-content form')
                .live('submit', function(e) {
                e.preventDefault();
				var cbs = $('#modal-content form input[type=checkbox]');
				for(i=0; i<cbs.length; i++) {
					var cb = cbs.eq(i);
					if(cb.attr('checked')) {
						var tds = cb.closest('tr').children();
						if(tds.length>= 1) {
							var name = tds.eq(0).text();
							$.post(_this.path+'controller.php?action=delete', {'name' : name}, function(data) {
								console.log(data);
								data = JSON.parse(data);
								if (data.status == 'error') {
									codiad.message.error(data.message, null)
								}
								if (data.status == 'success') {
									codiad.message.success("Schüler gelöscht", null)
								}
							});
						}
					}
				}
				codiad.modal.unload();
            });
        }
		
        
		
    };
})(this, jQuery);
