.syntax unified

acc .req r12
dptr .req r11

//LCD_i2c
.equ	LCD_Adresse,0x3F

.equ Bit0,0b1
.equ Bit1,0b10
.equ Bit2,0b100
.equ Bit3,0b1000
.equ Bit4,0b10000
.equ Bit5,0b100000
.equ Bit6,0b1000000
.equ Bit7,0b10000000
.equ Bit8,0b100000000
.equ Bit9,0b1000000000
.equ Bit10,0b10000000000
.equ Bit11,0b100000000000
.equ Bit12,0b1000000000000
.equ Bit13,0b10000000000000
.equ Bit14,0b100000000000000
.equ bit15,0b1000000000000000

.equ VectorTableOffsetRegister,0xE000ED08
.equ ISRTabelle,ISRTabelle1	//0x20013000
//.global	ISRTabelle
//Systick	24Bit Downcounter
.equ SysTickCSR,0xE000E010
.equ SysTickRR,0xE000E014
.equ SysTickCVR,0xE000E018
.equ SysTickCalVR,0xE000E01C

.equ rcc,0x40023800

.equ flash,0x40023C00

.equ exti,0x40010400
.equ EXTI,0x40010400
.equ exti_RTSR,0x08
.equ exti_FTSR,0x0c
.equ exti_EMR,0x04
.equ exti_IMR,0x00
.equ EXTI_IMR,0x00
.equ exti_SWIER,0x10
.equ exti_PR,0x14
.equ EXTI_PR,0x14

.equ RTSR,0x08
.equ FTSR,0x0c
.equ EMR,0x04
.equ IMR,0x00
.equ SWIER,0x10
.equ PR,0x14


.equ	ex0_nr,0
.equ	ex1_nr,1
.equ	ex2_nr,2
.equ	ex3_nr,3
.equ	ex4_nr,4
.equ	ex5_nr,5
.equ	ex6_nr,6
.equ	ex7_nr,7
.equ	ex8_nr,8
.equ	ex9_nr,9
.equ	ex10_nr,10
.equ	ex11_nr,11
.equ	ex12_nr,12
.equ	ex13_nr,13
.equ	ex14_nr,14
.equ	ex15_nr,15

.equ	uie6_nr,16
.equ	uie7_nr,17
.equ	usart2Int_nr,18
.equ	uie6_nr,19
.equ	uie7_nr,20
.equ	SysTick_nr,21


//vektorLocationTabelle:
.equ 	ex0Vector,0x58
.equ 	ex1Vector,0x5c
.equ 	ex2Vector,0x60
.equ 	ex3Vector,0x64
.equ 	ex4Vector,0x68
.equ 	ex5Vector,0x9c
.equ 	ex6Vector,0x9c
.equ 	ex7Vector,0x9c
.equ 	ex8Vector,0x9c
.equ 	ex9Vector,0x9c
.equ 	ex10Vector,0xe0
.equ 	ex11Vector,0xe0
.equ 	ex12Vector,0xe0
.equ 	ex13Vector,0xe0
.equ 	ex14Vector,0xe0
.equ 	ex15Vector,0xe0
.equ 	uie6Vector,0xec
.equ 	uie7Vector,0xf0
.equ 	uie2Vector,0xb0
.equ 	uie3Vector,0xb4
.equ 	usart2IntVector,0xD8
.equ	SysTickVector,0x3c

//Priorittenregister
.equ	PRI6,0xE000E406
.equ	PRI7,0xE000E407
.equ	PRI8,0xE000E408
.equ	PRI9,0xE000E409
.equ	PRI10,0xE000E40A
.equ	PRI23,0xE000E417
.equ	PRI28,0xE000E41C
.equ	PRI29,0xE000E41D
.equ	PRI40,0xE000E428
.equ	PRI43,0xE000E42B
.equ	PRI44,0xE000E42C
.equ	PRI_SysTick,0xE000ED23


.equ	exAnf0,0
.equ	exAnf1,1
.equ	exAnf2,2
.equ	exAnf3,3
.equ	exAnf4,4
.equ	exAnf5,5
.equ	exAnf6,6
.equ	exAnf7,7
.equ	exAnf8,8
.equ	exAnf9,9
.equ	exAnf10,10
.equ	exAnf11,11
.equ	exAnf12,12
.equ	exAnf13,13
.equ	exAnf14,14
.equ	exAnf15,15



.equ SysCFG,0x40010000
.equ SYSCFG_EXTICR1,0x08
.equ SYSCFG_EXTICR2,0x0c
.equ SYSCFG_EXTICR3,0x10
.equ SYSCFG_EXTICR4,0x14

.equ RI,0x40007C00
.equ RI_HYSCR1,0x14
.equ RI_HYSCR2,0x18

.equ RCC_AHBENR,0x1c
.equ nvic,0xe000e000
.equ isrEnableReg1,0x104
.equ isrEnableReg0,0x100
.equ isrClrReg,0x284

.equ GPIOA,0x40020000
.equ gpioa,0x40020000
.equ GPIOB,0x40020400
.equ GPIOC,0x40020800
.equ GPIOx_MODER,0x00
.equ GPIOx_ODR,0x14
.equ GPIOx_IDR,0x10
.equ GPIOx_AFRL,0x20
.equ GPIOx_AFRH,0x24
.equ GPIOx_PUPDR,0x0C
.equ GPIOx_OTYPER,0x04
.equ GPIOx_BSRR,0x18
.equ GPIOx_BRR,0x18
.equ MODER,0x00
.equ ODR,0x14
.equ IDR,0x10
.equ AFRL,0x20
.equ AFRH,0x24
.equ PUPDR,0x0C
.equ OTYPER,0x04
.equ BSR,0x18
.equ BRR,0x1A

.equ ADC,0x40012400
.equ tim2,0x40000000
.equ TIM2,0x40000000
.equ tim3,0x40000400
.equ TIM3,0x40000400
.equ tim4,0x40000800
.equ TIM4,0x40000800

.equ tim6,0x40001000
.equ TIM6,0x40001000
.equ TIM6,0x40001000
.equ tim7,0x40001400
.equ TIM7,0x40001400
.equ TIMx_CR1,0
.equ TIMx_CR2,4
.equ TIMx_SMCR,8
.equ TIMx_DIER,0x0c
.equ TIMx_SR,0x10
.equ TIMx_EGR,0x14
.equ TIMx_CCMR1,0x18
.equ TIMx_CCMR2,0x1c
.equ TIMx_CCER,0x20
.equ TIMx_CNT,0x24
.equ TIMx_PSC,0x28
.equ TIMx_ARR,0x2C
.equ TIMx_CCR1,0x34

.equ CR1,0
.equ CR2,4
.equ SMCR,8
.equ DIER,0x0c
.equ SR,0x10
.equ EGR,0x14
.equ CCMR1,0x18
.equ CCMR2,0x1c
.equ CCER,0x20
.equ CNT,0x24
.equ PSC,0x28
.equ ARR,0x2C
.equ CCR1,0x34

.equ RCC_APB2ENR,0x20
.equ RCC_APB1ENR,0x24
.equ RCC_CFGR,0x8



.equ ADC_CR1,0x04
.equ ADC_CR1_OVRIE,0
.equ ADC_CR1_RES,0b00	//12-bit (TCONV = 12 ADCCLK cycles)
.equ ADC_CR1_AWDEN,0	//Analog watchdog disabled on regular channels
.equ ADC_CR1_JAWDEN,0	// Analog watchdog disabled on injected channels
.equ ADC_CR1_PDI,0		//The ADC is powered up when waiting for a start event
.equ ADC_CR1_PDD,0		//The ADC is powered up during the delay
.equ ADC_CR1_DISCNUM,0b000	// 1 channel
.equ ADC_CR1_JDISCEN,0	//Discontinuous mode on injected channels disabled
.equ ADC_CR1_DISCEN,0	//Discontinuous mode on regular channels disabled
.equ ADC_CR1_JAUTO,0	// Automatic injected group conversion disabled
.equ ADC_CR1_AWDSGL,0	//Analog watchdog enabled on all channels
.equ ADC_CR1_SCAN,0		//Scan mode disabled
.equ ADC_CR1_JEOCIE,0	//JEOC interrupt disabled
.equ ADC_CR1_AWDIE,0	// Analog watchdog interrupt disabled
.equ ADC_CR1_EOCIE,0	//EOC interrupt disabled
.equ ADC_CR1_AWDCH,0b00000	//ADC analog input ADC_IN0


.equ ADC_SQR5,0x40
.equ ADC_A0,0
.equ ADC_A1,1
.equ ADC_A2,4
.equ ADC_A3,26	//WNDWE geschlossen PB4
.equ ADC_A4,11	//PC1
.equ ADC_A5,10	//PC0

.equ ADC_DR,0x58

.equ ADC_CR2,0x08
.equ ADC_CR2_SWSTART,0
.equ ADC_CR2_EXTEN,0b00
.equ ADC_CR2_EXTSEL,0b0000
.equ ADC_CR2_JSWSTART,0
.equ ADC_CR2_JEXTEN,0b00
.equ ADC_CR2_JEXTSEL,0b0000
.equ ADC_CR2_ALIGN,0
.equ ADC_CR2_EOCS,1		//EOC set at End of each conversion
.equ ADC_CR2_DDS,0		//No DMA  request
.equ ADC_CR2_DMA,0		//DMA disabled
.equ ADC_CR2_DELS,0b001	//Until the converted data have been read (DR read or EOC=0 for regular conversions)
.equ ADC_CR2_ADC_CFG,0	//Bank A selected for channels ADC_IN0..31
.equ ADC_CR2_CONT,0		// Single conversion mode
.equ ADC_CR2_ADON,1		// Enable ADC: conversions can start as soon as a start event (hardware or software) is received.

//I2C1
.equ I2C1,0x40005400
.equ I2C1_CR1,0
.equ I2C1_CR2,4
.equ I2C1_OAR1,8
.equ I2C1_OAR2,0x0C
.equ I2C1_DR,0x10
.equ I2C1_SR1,0x14
.equ I2C1_SR2,0x18
.equ I2C1_CCR,0x1C
.equ I2C1_TRISE,0x20
.equ I2C1_FREQ,0x20		//32MHz
.equ I2C1_CCRValue,1600	//32MHz * 50s =1600
.equ I2C1_TRISEValue,0x21	//32MHz * 1000ns +1

//USART2
.equ	USART2,0x40004400
.equ	USART2_SR,0x0
.equ	USART2_DR,0x04
.equ	USART2_BRR,0x08
.equ	USART2_CR1,0x0C
.equ	USART2_CR2,0x10
.equ	USART2_CR3,0x14
.equ	USART2_GTPR,0x18

//USART3
.equ	USART3,0x40004800
.equ	USART_SR,0x0
.equ	USART_DR,0x04
.equ	USART_BRR,0x08
.equ	USART_CR1,0x0C
.equ	USART_CR2,0x10
.equ	USART_CR3,0x14
.equ	USART_GTPR,0x18


//Groove-LCD RGB Backlight



//I2C addresses for LCD and RGB
.equ LCD_ADDRESS,0x7c
.equ RGB_ADDRESS,0xc4

.equ RED_REG,0x04
.equ GREEN_REG,0x03
.equ BLUE_REG,0x02

// commands
.equ LCD_CLEARDISPLAY,0x01
.equ LCD_DISPLAYCONTROL,0x08
.equ LCD_FUNCTIONSET,0x20

// flags for display on/off control
.equ LCD_DISPLAYON,0x04
.equ LCD_DISPLAYOFF,0x00

// flag for entry mode
.equ LCD_ENTRYLEFT,0x02

// flags for function set
.equ LCD_8BITMODE,0x10
.equ LCD_2LINE,0x08
.equ LCD_5x10DOTS,0x04

.macro loadImm32	reg,imm
		mov	\reg,#(\imm/0x10000)
		lsl	\reg,#16
		orr	\reg,#(\imm%0x10000)
.endm

//GPIO
//PinMode
.equ Eingang,0
.equ Ausgang,1
.equ Alternate,2
.equ Analog,3

//OutputType
.equ PushPull,0
.equ OpenDrain,1

//Pullup/-down
.equ	KeinPull,0
.equ	Keinpull,0
.equ	Pullup,1
.equ	PullDown,2
.equ	PullUp,1
.equ	Pulldown,2
.equ	keinPull,0
.equ	keinpull,0
.equ	pullup,1
.equ	pullDown,2
.equ	pullUp,1
.equ	pulldown,2

//Ports Nummerierung
//.equ	D0,0
//.equ	D13,13

.macro setAusgangstyp a,b
//OutputType
//.equ PushPull,0
//.equ OpenDrain,1
	call	setAusgangstyp\@
	b		setAusgangstypfertig\@
setAusgangstyp\@:
	push {R1,R2,R3}
	.if \a == D15 || \a==PB8
		ldr r1,=0x40020400	//D15=GPIOB Bit 8
        mov.w r2, #\b<<8
	.endif
	.if \a == D14 || \a==PB9
		ldr r1,=0x40020400	//D14=GPIOB Bit 9
        mov.w r2, #\b<<9
	.endif
	.if \a == D13 || \a==PA5 || \a==LED || \a==led
		ldr r1,=0x40020000	//D13=GPIOA Bit 5
        mov.w r2, #\b<<5
	.endif
	.if \a == D12 || \a==PA6
		ldr r1,=0x40020000	//D12=GPIOA Bit 6
        mov.w r2, #\b<<6
	.endif
	.if \a == D11 || \a==PA7
		ldr r1,=0x40020000	//D11=GPIOA Bit 7
        mov.w r2, #\b<<7
	.endif
	.if \a == D10 || \a==PB6
		ldr r1,=0x40020400	//D10=GPIOC Bit 6
        mov.w r2, #\b<<6
	.endif
	.if \a == D9 || \a==PC7
		ldr r1,=0x40020800	//D9=GPIOC Bit 7
        mov.w r2, #\b<<7
	.endif
	.if \a == D8 || \a==PA9
		ldr r1,=0x40020000	//D8=GPIOA Bit 9
        mov.w r2, #\b<<9
	.endif
	.if \a == D7 || \a==PA8
		ldr r1,=0x40020000	//D7=GPIOA Bit 8
        mov.w r2, #\b<<8
	.endif
	.if \a == D6 || \a==PB10
		ldr r1,=0x40020400	//D6=GPIOC Bit 10
        mov.w r2, #\b<<10
	.endif
	.if \a == D5 || \a==PB4
		ldr r1,=0x40020400	//D5=GPIOC Bit 4
        mov.w r2, #\b<<4
	.endif
	.if \a == D4 || \a==PB5
		ldr r1,=0x40020400	//D4=GPIOC Bit 5
        mov.w r2, #\b<<5
	.endif
	.if \a == D3 || \a==PB3
		ldr r1,=0x40020400	//D3=GPIOC Bit 3
        mov.w r2, #\b<<3
	.endif
	.if \a == D2 || \a==PA10
		ldr r1,=0x40020000	//D2=GPIOA Bit 10
        mov.w r2, #\b<<10
	.endif
	.if \a==PA11
		ldr r1,=0x40020000	//D2=GPIOA Bit 10
        mov.w r2, #\b<<11
	.endif
	.if \a==PA12
		ldr r1,=0x40020000	//D2=GPIOA Bit 10
        mov.w r2, #\b<<12
	.endif
	.if \a==PA13
		ldr r1,=0x40020000	//D2=GPIOA Bit 10
        mov.w r2, #\b<<13
	.endif
	.if \a==PA14
		ldr r1,=0x40020000	//D2=GPIOA Bit 10
        mov.w r2, #\b<<14
	.endif
	.if \a==PA15
		ldr r1,=0x40020000	//D2=GPIOA Bit 10
        mov.w r2, #\b<<15
	.endif
	.if \a == D1 || \a==PA2
		ldr r1,=0x40020000	//D1=GPIOA Bit 2
        mov.w r2, #\b<<2
	.endif
	.if \a == D0 || \a==PA3
		ldr r1,=0x40020000	//D0=GPIOA Bit 3
        mov.w r2, #\b<<3
	.endif
	.if \a == A0 || \a==PA0
		ldr r1,=0x40020000	//A0=GPIOA Bit 0
        mov.w r2, #\b<<0
	.endif
	.if \a == A1 || \a==PA1
		ldr r1,=0x40020000	//A1=GPIOA Bit 1
        mov.w r2, #\b<<1
	.endif
	.if \a == A2 || \a==PA4
		ldr r1,=0x40020000	//A2=GPIOA Bit 4
        mov.w r2, #\b<<4
	.endif
	.if \a == A3 || \a==PB0
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<0
	.endif
	.if \a==PB1
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<1
	.endif
	.if \a==PB2
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<2
	.endif
	.if \a==PB7
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<7
	.endif
	.if \a==PB11
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<11
	.endif
	.if \a==PB12
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<12
	.endif
	.if \a==PB13
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<13
	.endif
	.if \a==PB14
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<14
	.endif
	.if \a==PB15
		ldr r1,=0x40020400	//A3=GPIOC Bit 0
        mov.w r2, #\b<<15
	.endif

	.if \a == A4 || \a==PC1
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<1
	.endif
	.if \a == A5 || \a==PC0
		ldr r1,=0x40020800	//A5=GPIOC Bit 0
        mov.w r2, #\b<<0
	.endif
	.if \a==PC2
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<2
	.endif
	.if \a==PC3
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<3
	.endif
	.if \a==PC4
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<4
	.endif
	.if \a==PC5
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<5
	.endif
	.if \a==PC6
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<6
	.endif
	.if \a==PC8
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<8
	.endif
	.if \a==PC9
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<9
	.endif
	.if \a==PC10
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<10
	.endif
	.if \a==PC11
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<11
	.endif
	.if \a==PC12
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<12
	.endif
	.if \a==PC14
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<14
	.endif
	.if \a==PC15
		ldr r1,=0x40020800	//A4=GPIOC Bit 1
        mov.w r2, #\b<<15
	.endif

	.if \a==PC13
		ldr r1,=0x40020800
        mov.w r2, #\b<<13
	.endif
	ldr r3,[r1,#0x04]
	orr r2,r3
	str.w r2,[r1,#0x04]
	pop {R1,R2,R3}
	bx	lr
setAusgangstypfertig\@:
.endm

.macro setPullUpDown a,b
//Pullup/-down
//.equ	KeinPull,0
//.equ	Pullup,1
//.equ	PullDown,2
	call	setPullUpDown\@
	b		setPullUpDownfertig\@
setPullUpDown\@:
	push {R1,R2,R3,R4}
	.if \a==D15 || \a==PB8
	ldr r1,=0x40020400	//D15=GPIOB Bit 8
    mov.w r3,#16
    .endif
    .if \a==D14 || \a==PB9
	ldr r1,=0x40020400	//D14=GPIOB Bit 9
    mov.w r3,#18
    .endif
    .if \a==D13 || \a==PA5 || \a==LED || \a==led
	ldr r1,=0x40020000	//D13=GPIOA Bit 5
    mov.w r3,#10
    .endif
    .if \a==D12 || \a==PA6
	ldr r1,=0x40020000	//D12=GPIOA Bit 6
    mov.w r3,#12
    .endif
    .if \a==D11 || \a==PA7
	ldr r1,=0x40020000	//D11=GPIOA Bit 7
    mov.w r3,#14
    .endif
    .if \a==D10 || \a==PB6
	ldr r1,=0x40020400	//D10=GPIOC Bit 6
    mov.w r3,#12
    .endif
    .if \a==D9 || \a==PC7
	ldr r1,=0x40020800	//D9=GPIOC Bit 7
    mov.w r3,#14
    .endif
    .if \a==D8 || \a==PA9
	ldr r1,=0x40020000	//D8=GPIOA Bit 9
    mov.w r3,#18
    .endif
    .if \a==D7 || \a==PA8
	ldr r1,=0x40020000	//D7=GPIOA Bit 8
    mov.w r3,#16
    .endif
    .if \a==D6 || \a==PB10
	ldr r1,=0x40020400	//D6=GPIOC Bit 10
    mov.w r3,#20
    .endif
    .if \a==D5 || \a==PB4
	ldr r1,=0x40020400	//D5=GPIOC Bit 4
    mov.w r3,#8
    .endif
    .if \a==D4 || \a==PB5
	ldr r1,=0x40020400	//D4=GPIOC Bit 5
    mov.w r3,#10
    .endif
    .if \a==D3 || \a==PB3
	ldr r1,=0x40020400	//D3=GPIOC Bit 3
    mov.w r3,#6
    .endif
    .if \a==D2 || \a==PA10
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#20
    .endif
    .if \a==PA11
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#22
    .endif
    .if \a==PA12
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#24
    .endif
    .if \a==PA13
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#26
    .endif
    .if \a==PA14
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#28
    .endif
    .if \a==PA15
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#30
    .endif
    .if \a==D1 || \a==PA2
	ldr r1,=0x40020000	//D1=GPIOA Bit 2
    mov.w r3,#4
    .endif
    .if \a==D0 || \a==PA3
	ldr r1,=0x40020000	//D0=GPIOA Bit 3
    mov.w r3,#6
    .endif
    .if \a==A0 || \a==PA0
	ldr r1,=0x40020000	//A0=GPIOA Bit 0
    mov.w r3,#0
    .endif
    .if \a==A1 || \a==PA1
	ldr r1,=0x40020000	//A1=GPIOA Bit 1
    mov.w r3,#2
    .endif
    .if \a==A2 || \a==PA4
	ldr r1,=0x40020000	//A2=GPIOA Bit 4
    mov.w r3,#8
    .endif
    .if \a==A3 || \a==PB0
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#0
    .endif
    .if \a==PB1
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#2
    .endif
    .if \a==PB2
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#4
    .endif
     .if \a==PB7
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#14
    .endif
    .if \a==PB11
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#22
    .endif
    .if \a==PB12
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#24
    .endif
     .if \a==PB13
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#26
    .endif
    .if \a==PB14
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#28
    .endif
    .if \a==PB15
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#30
    .endif
    .if \a==A4 || \a==PC1
	ldr r1,=0x40020800	//A4=GPIOC Bit 1
    mov.w r3,#2
    .endif

    .if \a==A5 || \a==PC0
	ldr r1,=0x40020800	//A5=GPIOC Bit 0
    mov.w r3,#0
    .endif
    .if \a==PC2
	ldr r1,=0x40020800	//Taster
    mov.w r3,#4
    .endif
    .if \a==PC3
	ldr r1,=0x40020800	//Taster
    mov.w r3,#6
    .endif
    .if \a==PC4
	ldr r1,=0x40020800	//Taster
    mov.w r3,#8
    .endif
    .if \a==PC5
	ldr r1,=0x40020800	//Taster
    mov.w r3,#10
    .endif
    .if \a==PC6
	ldr r1,=0x40020800	//Taster
    mov.w r3,#12
    .endif
    .if \a==PC8
	ldr r1,=0x40020800	//Taster
    mov.w r3,#16
    .endif
    .if \a==PC9
	ldr r1,=0x40020800	//Taster
    mov.w r3,#18
    .endif
    .if \a==PC10
	ldr r1,=0x40020800	//Taster
    mov.w r3,#20
    .endif
    .if \a==PC11
	ldr r1,=0x40020800	//Taster
    mov.w r3,#22
    .endif
    .if \a==PC12
	ldr r1,=0x40020800	//Taster
    mov.w r3,#24
    .endif

    .if \a==PC13
	ldr r1,=0x40020800	//Taster
    mov.w r3,#26
    .endif
    .if \a==PC14
	ldr r1,=0x40020800	//Taster
    mov.w r3,#28
    .endif
    .if \a==PC15
	ldr r1,=0x40020800	//Taster
    mov.w r3,#30
    .endif

    mov r2,#3
    lsl r2,r2,r3
    ldr r4,=0xffffffff
    eor r2,r4
    ldr r4,[r1,#0x0C]
    and r2,r4
    mov.w r4,#\b
    lsl r4,r4,r3
    orr	r2,r4
    str r2,[r1,#0x0C]	//ModeRegister
	pop {R1,R2,R3,R4}
	bx	lr
.ltorg
setPullUpDownfertig\@:
.endm

.macro setDir a,b
//.equ Eingang,0
//.equ Ausgang,1
//.equ Alternate,2
//.equ Analog,3

	call	setDir\@
	b		setDirfertig\@
setDir\@:

	push	{R1,R2,R3,R4}
	.if \a==D15 || \a==PB8
	ldr r1,=0x40020400	//D15=GPIOC Bit 8
    mov.w r3,#16
    .endif
    .if \a==D14 || \a==PB9
	ldr r1,=0x40020400	//D14=GPIOC Bit 9
    mov.w r3,#18
    .endif
    .if \a==D13 || \a==PA5 || \a==LED || \a==led
	ldr r1,=0x40020000	//D13=GPIOA Bit 5
    mov.w r3,#10
    .endif
    .if \a==D12 || \a==PA6
	ldr r1,=0x40020000	//D12=GPIOA Bit 6
    mov.w r3,#12
    .endif
    .if \a==D11 || \a==PA7
	ldr r1,=0x40020000	//D11=GPIOA Bit 7
    mov.w r3,#14
    .endif
    .if \a==D10 || \a==PB6
	ldr r1,=0x40020400	//D10=GPIOC Bit 6
    mov.w r3,#12
    .endif
    .if \a==D9 || \a==PC7
	ldr r1,=0x40020800	//D9=GPIOC Bit 7
    mov.w r3,#14
    .endif
    .if \a==D8 || \a==PA9
	ldr r1,=0x40020000	//D8=GPIOA Bit 9
    mov.w r3,#18
    .endif
    .if \a==D7 || \a==PA8
	ldr r1,=0x40020000	//D7=GPIOA Bit 8
    mov.w r3,#16
    .endif
    .if \a==D6 || \a==PB10
	ldr r1,=0x40020400	//D6=GPIOC Bit 10
    mov.w r3,#20
    .endif
    .if \a==D5 || \a==PB4
	ldr r1,=0x40020400	//D5=GPIOC Bit 4
    mov.w r3,#8
    .endif
    .if \a==D4 || \a==PB5
	ldr r1,=0x40020400	//D4=GPIOC Bit 5
    mov.w r3,#10
    .endif
    .if \a==D3 || \a==PB3
	ldr r1,=0x40020400	//D3=GPIOC Bit 3
    mov.w r3,#6
    .endif
    .if \a==D2 || \a==PA10
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#20
    .endif
    .if \a==PA11
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#22
    .endif
    .if \a==PA12
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#24
    .endif
    .if \a==PA13
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#26
    .endif
    .if \a==PA14
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#28
    .endif
    .if \a==PA15
	ldr r1,=0x40020000	//D2=GPIOA Bit 10
    mov.w r3,#30
    .endif

    .if \a==D1 || \a==PA2
	ldr r1,=0x40020000	//D1=GPIOA Bit 2
    mov.w r3,#4
    .endif
    .if \a==D0 || \a==PA3
	ldr r1,=0x40020000	//D0=GPIOA Bit 3
    mov.w r3,#6
    .endif
    .if \a==A0 || \a==PA0
	ldr r1,=0x40020000	//A0=GPIOA Bit 0
    mov.w r3,#0
    .endif
    .if \a==A1 || \a==PA1
	ldr r1,=0x40020000	//A1=GPIOA Bit 1
    mov.w r3,#2
    .endif
    .if \a==A2 || \a==PA4
	ldr r1,=0x40020000	//A2=GPIOA Bit 4
    mov.w r3,#8
    .endif
    .if \a==A3 || \a==PB0
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#0
    .endif
    .if \a==PB1
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#2
    .endif
     .if \a==PB2
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#4
    .endif
    .if \a==PB7
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#14
    .endif
    .if \a==PB11
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#22
    .endif
    .if \a==PB12
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#24
    .endif
    .if \a==PB13
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#26
    .endif
    .if \a==PB14
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#28
    .endif
    .if \a==PB15
	ldr r1,=0x40020400	//A3=GPIOC Bit 0
    mov.w r3,#30
    .endif

    .if \a==A4 || \a==PC1
	ldr r1,=0x40020800	//A4=GPIOC Bit 1
    mov.w r3,#2
    .endif
    .if \a==A5 || \a==PC0
	ldr r1,=0x40020800	//A5=GPIOC Bit 0
    mov.w r3,#0
    .endif
    .if  \a==PC2
	ldr r1,=0x40020800	//GPIOC Bit 2
    mov.w r3,#4
    .endif
    .if  \a==PC3
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#6
    .endif
    .if  \a==PC4
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#8
    .endif
    .if  \a==PC5
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#10
    .endif
    .if  \a==PC6
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#12
    .endif
     .if  \a==PC8
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#16
    .endif
    .if  \a==PC9
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#18
    .endif
    .if  \a==PC10
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#20
    .endif
    .if  \a==PC11
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#22
    .endif
     .if  \a==PC12
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#24
    .endif

    .if \a==PC13
	ldr r1,=0x40020800	//Taster
    mov.w r3,#26
    .endif
    .if  \a==PC14
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#28
    .endif
    .if  \a==PC15
	ldr r1,=0x40020800	//GPIOC Bit 3
    mov.w r3,#30
    .endif

    mov r2,#3
    lsl r2,r2,r3
    ldr r4,=0xffffffff
    eor r2,r4
    ldr r4,[r1]
    and r2,r4
    mov.w r4,#\b
    lsl r4,r4,r3
    orr	r2,r4
    str r2,[r1]	//ModeRegister
	pop {R1,R2,R3,R4}
	bx	lr
.ltorg
setDirfertig\@:
.endm

.macro reti
	bx lr
.endm

.macro mod	a,b,c	//a=b%c
	udiv	\a,\b,\c
	mul		\a,\c
	sub		\a,\b,\a
.endm

.macro call1 a
	push	{lr}
	mov		lr,pc
	add		lr,#1
	b		\a
	pop		{lr}
.endm
.macro call a
	push {lr}
	bl \a
	pop {lr}
.endm


.macro setISR Adresse,VectorNr
	call	setISR\@
	b		setISRfertig\@
setISR\@:
	push	{R0,R1}
	ldr	R0,=ISRTabelle
	ldr	r1,=\Adresse+1
	str	r1,[r0,#\VectorNr]
	pop		{R0,R1}
	bx	lr
.ltorg
setISRfertig\@:
.endm



.macro setb Bit
	call	setb\@
	b		setbfertig\@
setb\@:
	push	{r0,r1,r2,r3}
	.if \Bit==EA || \Bit==ea
		mov	r0,#0
		msr faultmask,r0
	.else
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r0,[r1]		//Maske in R4
	orr		r3,r0
	str		r3,[r2]
	.endif
	pop 	{r0,r1,r2,r3}
	bx	lr
.ltorg
setbfertig\@:
.endm
.macro clr Bit
	call	clr\@
	b		clrfertig\@
clr\@:
	push	{r0,r1,r2,r3}
	.if \Bit==EA || \Bit==ea
		mov	r0,#1
		msr faultmask,r0
	.else
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r0,[r1]		//Maske in R4
	bic		r3,r0
	str		r3,[r2]
	.endif
	pop 	{r0,r1,r2,r3}
	bx	lr
.ltorg
clrfertig\@:
.endm

.macro cpl Bit
	call	cpl\@
	b		cplfertig\@
cpl\@:
	push	{r0,r1,r2,r3}
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r0,[r1]		//Maske in R4
	eor		r3,r0
	str		r3,[r2]
	pop 	{r0,r1,r2,r3}
	bx		lr
.ltorg
cplfertig\@:
.endm

.macro jb Bit,Ziel
	call	jb\@
	b		jbfertig\@
jb\@:
	push	{r0,r1,r2,r3}
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#8]	//Inputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r0,[r1]		//Maske in R4
	ands	r3,r0
	pop 	{r0,r1,r2,r3}
	bx		lr
.ltorg
jbfertig\@:
	bne	\Ziel
.endm

.macro jnb Bit,Ziel
	call	jnb\@
	b		jnbfertig\@
jnb\@:
	push	{r0,r1,r2,r3}
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#8]	//Inputregister
	ldr 	r3,[r2]		//@Inputregister in r3
	ldr		r0,[r1]		//Maske in R4
	ands	r3,r0
	pop 	{r0,r1,r2,r3}
	bx		lr
.ltorg
jnbfertig\@:
	beq	\Ziel
.endm

.macro movc Bit	//C <- bit
	call	movc\@
	b		movcfertig\@
movc\@:
	push	{r0,r1,r2,r3,r4}
	mrs		r0,APSR
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#8]	//Inputregister
	ldr 	r3,[r2]		//@Inputregister in r3
	ldr		r4,[r1]		//Maske in R4
	ands	r3,r4
	ldr		r2,=0x20000000
	ldr		r3,=0xDFFFFFFF
	ite		eq
	andeq	r0,r3
	orrne	r0,r2
	msr		APSR_nzcvq,r0
	pop 	{r0,r1,r2,r3,r4}
	bx	lr
.ltorg
movcfertig\@:
.endm
.macro movCBit Bit	//C -> bit
	call	movcBit\@
	b		movcBitfertig\@
movcBit\@:
	push	{r0,r1,r2,r3}
	ldr		r1,=\Bit		//Tabellenadresse des Bits in der Bitliste
	ldr		r2,[r1,#4]	//Outputregister
	ldr 	r3,[r2]		//@Outputregister in r3
	ldr		r0,[r1]		//Maske in R4
	ite		cc
	biccc	r3,r0
	orrcs	r3,r0
	str		r3,[r2]
	pop 	{r0,r1,r2,r3}
	bx	lr
.ltorg
movcBitfertig\@:
.endm

.macro outb a,b		//outb r1,DL(DH)	kopiert untere(obere) 8 Bits von r1 auf D7..D0
	call	outb\@
	b		outbfertig\@
outb\@:
	push	{\a}
	.if \a==DL
	lsrs	\a
	movCBit		D0
	lsrs	\a
	movCBit		D1
	lsrs	\a
	movCBit		D2
	lsrs	\a
	movCBit		D3
	lsrs	\a
	movCBit		D4
	lsrs	\a
	movCBit		D5
	lsrs	\a
	movCBit		D6
	lsrs	\a
	movCBit		D7
	.endif
	.if \a==DH
	lsrs	\a
	movCBit		D8
	lsrs	\a
	movCBit		D9
	lsrs	\a
	movCBit		D10
	lsrs	\a
	movCBit		D11
	lsrs	\a
	movCBit		D12
	lsrs	\a
	movCBit		D13
	lsrs	\a
	movCBit		D14
	lsrs	\a
	movCBit		D15
	.endif
	pop {\a}
	bx	lr
.ltorg
outbfertig\@:
.endm

Bitliste:	//Maske,ODR, IDR
A0:
PA0:
.word	0x00000001,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
A1:
PA1:
.word	0x00000002,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D1:
PA2:
.word	0x00000004,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D0:
PA3:
.word	0x00000008,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
A2:
PA4:
.word	0x00000010,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D13:
PA5:
LED:
.word	0x00000020,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D12:
PA6:
.word	0x00000040,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D11:
PA7:
.word	0x00000080,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D7:
PA8:
.word	0x00000100,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D8:
PA9:
.word	0x00000200,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
D2:
PA10:
.word	0x00000400,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
PA11:
.word	0x00000800,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
PA12:
.word	0x00001000,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
PA13:
.word	0x00002000,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
PA14:
.word	0x00004000,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR
PA15:
.word	0x00008000,GPIOA+GPIOx_ODR,GPIOA+GPIOx_IDR

A3:
PB0:
.word	0x00000001,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB1:
.word	0x00000002,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB2:
.word	0x00000004,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D3:
PB3:
.word	0x00000008,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D5:
PB4:
.word	0x00000010,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D4:
PB5:
.word	0x00000020,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D10:
PB6:
.word	0x00000040,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB7:
.word	0x00000080,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D15:
PB8:
.word	0x00000100,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D14:
PB9:
.word	0x00000200,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
D6:
PB10:
.word	0x00000400,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB11:
.word	0x00000800,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB12:
.word	0x00001000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB13:
.word	0x00002000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB14:
.word	0x00004000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR
PB15:
.word	0x00008000,GPIOB+GPIOx_ODR,GPIOB+GPIOx_IDR

A5:
PC0:
.word	0x00000001,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
A4:
PC1:
.word	0x00000002,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC2:
.word	0x00000004,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC3:
.word	0x00000008,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC4:
.word	0x00000010,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC5:
.word	0x00000020,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC6:
.word	0x00000040,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
D9:
PC7:
.word	0x00000080,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC8:
.word	0x00000100,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC9:
.word	0x00000200,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC10:
.word	0x00000400,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC11:
.word	0x00000800,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC12:
.word	0x00001000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC13:
USER:
Taste:
.word	0x00002000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC14:
.word	0x00004000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR
PC15:
.word	0x00008000,GPIOC+GPIOx_ODR,GPIOC+GPIOx_IDR

MR0:
ex0:
EX0:
.word 	0x00000001<<ex0_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR1:
ex1:
EX1:
.word 	0x00000001<<ex1_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR2:
ex2:
EX2:
.word 	0x00000001<<ex2_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR3:
ex3:
EX3:
.word 	0x00000001<<ex3_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR4:
ex4:
EX4:
.word 	0x00000001<<ex4_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR5:
ex5:
EX5:
.word 	0x00000001<<ex5_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR6:
ex6:
EX6:
.word 	0x00000001<<ex6_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR7:
ex7:
EX7:
.word 	0x00000001<<ex7_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR8:
ex8:
EX8:
.word 	0x00000001<<ex8_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR9:
ex9:
EX9:
.word 	0x00000001<<ex9_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR10:
ex10:
EX10:
.word 	0x00000001<<ex10_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR11:
ex11:
EX11:
.word 	0x00000001<<ex11_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR12:
ex12:
EX12:
.word 	0x00000001<<ex12_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR13:
ex13:
EX13:
.word 	0x00000001<<ex13_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR14:
ex14:
EX14:
.word 	0x00000001<<ex14_nr,exti+EXTI_IMR,exti+EXTI_IMR
MR15:
ex15:
EX15:
.word 	0x00000001<<ex15_nr,exti+EXTI_IMR,exti+EXTI_IMR

pr0:
PR0:
.word 	0x00000001<<ex0_nr,exti+EXTI_PR,exti+EXTI_PR
pr1:
PR1:
.word 	0x00000001<<ex1_nr,exti+EXTI_PR,exti+EXTI_PR
pr2:
PR2:
.word 	0x00000001<<ex2_nr,exti+EXTI_PR,exti+EXTI_PR
pr3:
PR3:
.word 	0x00000001<<ex3_nr,exti+EXTI_PR,exti+EXTI_PR
pr4:
PR4:
.word 	0x00000001<<ex4_nr,exti+EXTI_PR,exti+EXTI_PR
pr5:
PR5:
.word 	0x00000001<<ex5_nr,exti+EXTI_PR,exti+EXTI_PR
pr6:
PR6:
.word 	0x00000001<<ex6_nr,exti+EXTI_PR,exti+EXTI_PR
pr7:
PR7:
.word 	0x00000001<<ex7_nr,exti+EXTI_PR,exti+EXTI_PR
pr8:
PR8:
.word 	0x00000001<<ex8_nr,exti+EXTI_PR,exti+EXTI_PR
pr9:
PR9:
.word 	0x00000001<<ex9_nr,exti+EXTI_PR,exti+EXTI_PR
pr10:
PR10:
.word 	0x00000001<<ex10_nr,exti+EXTI_PR,exti+EXTI_PR
pr11:
PR11:
.word 	0x00000001<<ex11_nr,exti+EXTI_PR,exti+EXTI_PR
pr12:
PR12:
.word 	0x00000001<<ex12_nr,exti+EXTI_PR,exti+EXTI_PR
pr13:
PR13:
.word 	0x00000001<<ex13_nr,exti+EXTI_PR,exti+EXTI_PR
pr14:
PR14:
.word 	0x00000001<<ex14_nr,exti+EXTI_PR,exti+EXTI_PR
pr15:
PR15:
.word 	0x00000001<<ex15_nr,exti+EXTI_PR,exti+EXTI_PR



CEN2:
cen2:	//Tim2 enable
.word	0x00000001,TIM2+TIMx_CR1,TIM2+TIMx_CR1
CEN3:
cen3:	//Tim3 enable
.word	0x00000001,TIM3+TIMx_CR1,TIM3+TIMx_CR1
CEN6:
cen6:	//Tim6 enable
.word	0x00000001,TIM6+TIMx_CR1,TIM6+TIMx_CR1
CEN7:
cen7:	//Tim6 enable
.word	0x00000001,TIM7+TIMx_CR1,TIM7+TIMx_CR1

UIE6:
uie6:	//Tim6 Interrupt enable
.word	0x00000001,TIM6+TIMx_DIER,TIM6+TIMx_DIER
UIF6:
uif6:  //Tim6 interrupt flag
.word	0x00000001,TIM6+TIMx_SR,TIM6+TIMx_SR
UIE7:
uie7:	//Tim7 Interrupt enable
.word	0x00000001,TIM7+TIMx_DIER,TIM7+TIMx_DIER
UIF7:
uif7:  //Tim7 interrupt flag
.word	0x00000001,TIM7+TIMx_SR,TIM7+TIMx_SR
UIE2:
uie2:	//Tim6 Interrupt enable
.word	0x00000001,TIM2+TIMx_DIER,TIM2+TIMx_DIER
UIF2:
uif2:  //Tim6 interrupt flag
.word	0x00000001,TIM2+TIMx_SR,TIM2+TIMx_SR
UIE3:
uie3:	//Tim7 Interrupt enable
.word	0x00000001,TIM3+TIMx_DIER,TIM3+TIMx_DIER
UIF3:
uif3:  //Tim7 interrupt flag
.word	0x00000001,TIM3+TIMx_SR,TIM3+TIMx_SR
TIM2_SMS_0:
tim2_sms_0:
.word	0x00000001,TIM2+TIMx_SMCR,TIM2+TIMx_SMCR
TIM2_SMS_1:
tim2_sms_1:
.word	0x00000010,TIM2+TIMx_SMCR,TIM2+TIMx_SMCR
TIM2_SMS_2:
tim2_sms_2:
.word	0x00000100,TIM2+TIMx_SMCR,TIM2+TIMx_SMCR
TIM3_SMS_0:
tim3_sms_0:
.word	0x00000001,TIM3+TIMx_SMCR,TIM3+TIMx_SMCR
TIM3_SMS_1:
tim3_sms_1:
.word	0x00000010,TIM3+TIMx_SMCR,TIM3+TIMx_SMCR
TIM3_SMS_2:
tim3_sms_2:
.word	0x00000100,TIM3+TIMx_SMCR,TIM3+TIMx_SMCR

RXNEIE:
.word	0x00000020,USART2+USART2_CR1,USART2+USART2_CR1
EPort0:
.word 	0x0000001,EPort,EPort
EPort1:
.word 	0x0000002,EPort,EPort
EPort2:
.word 	0x0000004,EPort,EPort
EPort3:
.word 	0x0000008,EPort,EPort
EPort4:
.word 	0x0000010,EPort,EPort
EPort5:
.word 	0x0000020,EPort,EPort
EPort6:
.word 	0x0000040,EPort,EPort
EPort7:
.word 	0x0000080,EPort,EPort
EPort8:
.word 	0x0000100,EPort,EPort
EPort9:
.word 	0x0000200,EPort,EPort
EPort10:
.word 	0x0000400,EPort,EPort
EPort11:
.word 	0x0000800,EPort,EPort
EPort12:
.word 	0x0001000,EPort,EPort
EPort13:
.word 	0x0002000,EPort,EPort
EPort14:
.word 	0x0004000,EPort,EPort
EPort15:
.word 	0x0008000,EPort,EPort
//Systicktimer
SysTickIntEnable:
.word   0x0000002,SysTickCSR,SysTickCSR
SysTickTimerEnable:
.word   0x0000001,SysTickCSR,SysTickCSR
SysTickTimerCOUNTFLAG:
.word   1<<16,SysTickCSR,SysTickCSR
SysTickTimerClockSource:
.word   1<<2,SysTickCSR,SysTickCSR
RTSR0:
rtsr0:
.word   1<<0,exti+exti_RTSR,exti+exti_RTSR
RTSR1:
rtsr1:
.word   1<<1,exti+exti_RTSR,exti+exti_RTSR
RTSR2:
rtsr2:
.word   1<<2,exti+exti_RTSR,exti+exti_RTSR
RTSR3:
rtsr3:
.word   1<<3,exti+exti_RTSR,exti+exti_RTSR
RTSR4:
rtsr4:
.word   1<<4,exti+exti_RTSR,exti+exti_RTSR
RTSR5:
rtsr5:
.word   1<<5,exti+exti_RTSR,exti+exti_RTSR
RTSR6:
rtsr6:
.word   1<<6,exti+exti_RTSR,exti+exti_RTSR
RTSR7:
rtsr7:
.word   1<<7,exti+exti_RTSR,exti+exti_RTSR
RTSR8:
rtsr8:
.word   1<<8,exti+exti_RTSR,exti+exti_RTSR
RTSR9:
rtsr9:
.word   1<<9,exti+exti_RTSR,exti+exti_RTSR
RTSR10:
rtsr10:
.word   1<<10,exti+exti_RTSR,exti+exti_RTSR
RTSR11:
rtsr11:
.word   1<<11,exti+exti_RTSR,exti+exti_RTSR
RTSR12:
rtsr12:
.word   1<<12,exti+exti_RTSR,exti+exti_RTSR
RTSR13:
rtsr13:
.word   1<<13,exti+exti_RTSR,exti+exti_RTSR
RTSR14:
rtsr14:
.word   1<<14,exti+exti_RTSR,exti+exti_RTSR
RTSR15:
rtsr15:
.word   1<<15,exti+exti_RTSR,exti+exti_RTSR

FTSR0:
ftsr0:
.word   1<<0,exti+exti_FTSR,exti+exti_FTSR
FTSR1:
ftsr1:
.word   1<<1,exti+exti_FTSR,exti+exti_FTSR
FTSR2:
ftsr2:
.word   1<<2,exti+exti_FTSR,exti+exti_FTSR
FTSR3:
ftsr3:
.word   1<<3,exti+exti_FTSR,exti+exti_FTSR
FTSR4:
ftsr4:
.word   1<<4,exti+exti_FTSR,exti+exti_FTSR
FTSR5:
ftsr5:
.word   1<<5,exti+exti_FTSR,exti+exti_FTSR
FTSR6:
ftsr6:
.word   1<<6,exti+exti_FTSR,exti+exti_FTSR
FTSR7:
ftsr7:
.word   1<<7,exti+exti_FTSR,exti+exti_FTSR
FTSR8:
ftsr8:
.word   1<<8,exti+exti_FTSR,exti+exti_FTSR
FTSR9:
ftsr9:
.word   1<<9,exti+exti_FTSR,exti+exti_FTSR
FTSR10:
ftsr10:
.word   1<<10,exti+exti_FTSR,exti+exti_FTSR
FTSR11:
ftsr11:
.word   1<<11,exti+exti_FTSR,exti+exti_FTSR
FTSR12:
ftsr12:
.word   1<<12,exti+exti_FTSR,exti+exti_FTSR
FTSR13:
ftsr13:
.word   1<<13,exti+exti_FTSR,exti+exti_FTSR
FTSR14:
ftsr14:
.word   1<<14,exti+exti_FTSR,exti+exti_FTSR
FTSR15:
ftsr15:
.word   1<<15,exti+exti_FTSR,exti+exti_FTSR

/*
.data 1
.balign	4
ISRTabelle:
.rept 256
.byte 0x55
.endr
*/

