import { ModuleRenderInfo, ModuleUID } from "../types/types";
export declare class ModuleMapper {
    private projectRoot;
    private nodes;
    private nodeIds;
    constructor(projectRoot: string | RegExp);
    trimProjectRootId(moduleId: string): string;
    getModuleUid(moduleId: string): ModuleUID;
    getBundleModuleUid(bundleId: string, moduleId: string): ModuleUID;
    setValue(bundleId: string, moduleId: string, value: Omit<ModuleRenderInfo, "id">): ModuleUID;
    appendValue(bundleId: string, moduleId: string, value: Partial<Omit<ModuleRenderInfo, "id">>): ModuleUID;
    hasValue(bundleId: string, moduleId: string): boolean;
    getNodes(): ModuleMapper["nodes"];
    getNodeParts(): Record<ModuleUID, Record<string, ModuleUID>>;
}
