"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModuleMapper = void 0;
const non_secure_1 = require("nanoid/non-secure");
const nanoid = non_secure_1.customAlphabet("1234567890abcdef", 4);
const UNIQUE_PREFIX = nanoid();
let COUNTER = 0;
const uniqueId = () => `${UNIQUE_PREFIX}-${COUNTER++}`;
class ModuleMapper {
    constructor(projectRoot) {
        this.projectRoot = projectRoot;
        this.nodes = {};
        this.nodeIds = {};
    }
    trimProjectRootId(moduleId) {
        return moduleId.replace(this.projectRoot, "");
    }
    getModuleUid(moduleId) {
        if (!(moduleId in this.nodeIds)) {
            this.nodeIds[moduleId] = { bundles: {}, uid: uniqueId() };
        }
        return this.nodeIds[moduleId].uid;
    }
    getBundleModuleUid(bundleId, moduleId) {
        if (!(moduleId in this.nodeIds)) {
            this.nodeIds[moduleId] = { bundles: {}, uid: uniqueId() };
        }
        if (!(bundleId in this.nodeIds[moduleId].bundles)) {
            this.nodeIds[moduleId].bundles[bundleId] = uniqueId();
        }
        return this.nodeIds[moduleId].bundles[bundleId];
    }
    setValue(bundleId, moduleId, value) {
        const uid = this.getBundleModuleUid(bundleId, moduleId);
        if (uid in this.nodes) {
            throw new Error(`Override module: bundle id ${bundleId}, module id ${moduleId}, value ${JSON.stringify(value)}, existing value: ${JSON.stringify(this.nodes[uid])}`);
        }
        const id = this.trimProjectRootId(moduleId);
        this.nodes[uid] = { ...value, id };
        return uid;
    }
    appendValue(bundleId, moduleId, value) {
        const uid = this.getBundleModuleUid(bundleId, moduleId);
        if (!(uid in this.nodes)) {
            throw new Error(`Missing module: bundle id ${bundleId}, module id ${moduleId}, value ${JSON.stringify(value)}`);
        }
        const id = this.trimProjectRootId(moduleId);
        this.nodes[uid] = { ...this.nodes[uid], ...value, id };
        return uid;
    }
    hasValue(bundleId, moduleId) {
        var _a, _b, _c;
        return !!((_c = (_b = (_a = this.nodeIds) === null || _a === void 0 ? void 0 : _a[moduleId]) === null || _b === void 0 ? void 0 : _b.bundles) === null || _c === void 0 ? void 0 : _c[bundleId]);
    }
    getNodes() {
        return this.nodes;
    }
    getNodeParts() {
        const nodeParts = {};
        for (const nodeId of Object.values(this.nodeIds)) {
            nodeParts[nodeId.uid] = nodeId.bundles;
        }
        return nodeParts;
    }
}
exports.ModuleMapper = ModuleMapper;
