package com.example.flori.zahlenraten;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.TextView;

import org.w3c.dom.Text;

import java.util.Random;

public class MainActivity extends AppCompatActivity {

    int zahl;
    int wert;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Variablen erstellen
        final TextView anzeige1 = (TextView) findViewById(R.id.textView);
        final TextView anzeige2 = (TextView) findViewById(R.id.textView2);
        final SeekBar schieber = (SeekBar) findViewById(R.id.seekBar);
        Button okButton = (Button) findViewById(R.id.button);

        // Zufallszahl erzeugen
        Random zufall = new Random();
        zahl = zufall.nextInt(1000) + 1;
        schieber.setMax(1000);

        // Button mit Ereignis ausstatten
        okButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Zahl auswerten
                if (wert < zahl) anzeige1.setText(R.string.Zu_klein);
                if (wert > zahl) anzeige1.setText(R.string.Zu_gross);
                if (wert == zahl) anzeige1.setText(R.string.Richtig);

            }
        });

        schieber.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                wert = progress;
                anzeige2.setText(String.valueOf(progress));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
    }
}
