/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LCD_i2c_GSOE\LCD.h"
#include "mbed\drivers\RawSerial.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

lcd mylcd;
RawSerial pc(USBTX, USBRX,9600);

char buf[16];  
DigitalOut PC0(PC_0);


static void print2LCD()
{
   char z;
   int i=0;
   /*if (PC0==0) PC0=1; //Kontrolle
   else PC0=0;*/
   do
   {
        z=pc.getc();
        pc.putc(z);     //Echo
        if (z>=0x20)    //nur lesbare Zeichen
        { 
            buf[i]=z;
            i++;
        }
   }
   while (z!=10);       //LF
   buf[i]=0;
   pc.abort_read(); //!!!!!!!!
           
    mylcd.cursorpos(0x40);
    mylcd.printf("                ");
    mylcd.cursorpos(0x40);
    pc.printf("von MC %s",buf);     //Echo
    mylcd.printf("-> %s",buf);
}

int main()
{
    pc.attach(&print2LCD);
    pc.printf("Hello World !\n");
    mylcd.clear();
    mylcd.printf("Hallo Joerg");
    mylcd.cursorpos(0x40);
    DigitalOut led(LED1);
    // Initalise PortB als 8Bit-Input Port mit Pullup
    PortIn  eingabe(PortB,0xFF);
    eingabe.mode(PullDown);
    while (true) {
        if (eingabe==5) 
            {
                led = 1;
            }
        else 
            {
                led = !led;
                wait_ms(100);
            }
        /*
        if (neu==true)
        {
           pc.abort_read();
           
           mylcd.cursorpos(0x40);
           mylcd.printf("              ");

           mylcd.cursorpos(0x40);
           
           pc.printf("von MC %s",buf);
           mylcd.printf("-> %s",buf); 
           neu=false;   
        }
        */
        /*
        if (pc.readable()>0)
        {
           pc.scanf("%s", buf);
           mylcd.cursorpos(0x40);
           mylcd.printf("                ");
           mylcd.cursorpos(0x40);
           mylcd.printf("%s", buf);         
        }
        */
        
        
    }
}
