.syntax unified

.equ L152,1
.include "../Core/src/regs.s"

.global mainasm

mainasm:



main:
ldr R0,=rcc
ldr R1,[R0,RCC_AHBENR]
orr R1,Bit2+Bit1+Bit0
str R1,[R0,RCC_AHBENR]


ldr R0,=GPIOB
mov	R2,0
strh R2,[R0,MODER]
mov	R1,0b1010101010101010
strh R1,[R0,PUPDR]

ldr R1,=GPIOC
mov	R2,0b0101010101010101
strh R2,[R1,MODER]

//Mit PB0 steigende Flanke soll ein Interrupt ausgelöst werden
//1. NVIC alle Interrupts einschalten
//NVIC config enable Interrupt
ldr R4,=nvic

ldr R3,=0xFFFFFFFF

str R3,[R4,isrEnableReg0]
str R3,[R4,isrEnableReg1]

//2. Interruptquelle auswählen
ldr	R4,=SysCFG
ldr R3,=0b0001000100010001	//EXTI 3..0 GPIOB: PB3, PB2, Pb1, PB0
str	R3,[R4,SYSCFG_EXTICR1]

//3. Steigende Flanke
ldr R4,=EXTI		//external Interrupt Controller
mov R3,Bit0			//Bit0 = PB0 mit steigender Flanke
str	R3,[R4,RTSR]	//RTSR = rising Transitions Register

//4. Interrupt freigeben
ldr R4,=EXTI		//external Interrupt Controller
mov R3,Bit0			//Bit0 = PB0 INterrupt freigeben
str	R3,[R4,IMR]		//IMR = Interrupt Mask Register


schleife:				//Sprungmarke
ldrb	R3,[R0,IDR]		//GPIOB
tst		R3,Bit3			//Taste an Bit PB3 prüfen
beq		ruecksetzen		//0 = nicht gedrückt => PC1 rücksetzen
setzen:
mov		R2,Bit1			//setzen => 1 in Bit Set Register (BSR)
strb	R2,[R1,BSR]
b		schleife
ruecksetzen:
mov		R2,Bit1			//rücksetzen => 1 in Bit Reset Register (BRR)
strb	R2,[R1,BRR]

b	schleife		//bransh = Sprung = Fortsetzen bei Sprungmarke (label) schleife:

//5. ISR
.global meinInterrupt
meinInterrupt:
//6. Pendingbit zurücksetzen
ldr R4,=EXTI
mov R3,Bit0
str	R3,[R4,PR]

// Bit 0 von GPIOC umschalten
ldr	R3,[R1,ODR]
eor R3,Bit0
strb R3,[R1,ODR]



bx lr

//7. ISR in Vektortabelle in Startup\startup_stm32l152retx.s eintragen:
/*
g_pfnVectors:
  .word _estack
...
  .word RCC_IRQHandler
  .word meinInterrupt+1	//EXTI0_IRQHandler
  .word EXTI1_IRQHandler
...
*/
.end
