# Fachklasse
class Waehrung:
    def __init__(self):
        self.__name = ""
        self.__abkuerzung = ""
        self.__kurs = 1.0 # eine Einheit = ... EUR
        
    def get_name(self):
        """Lies den Namen der Währung aus"""
        return self.__name
    
    def set_name(self, p_name):
        """Setze den Namen der Währung"""
        self.__name = p_name
    
    def get_abkuerzung(self):
        """Lies die Abkürzung der Währung aus"""
        return self.__abkuerzung
    
    def set_abkuerzung(self, p_abkuerzung):
        """Setze den Namen der Währung"""
        self.__abkuerzung = p_abkuerzung
        
    def get_kurs(self):
        """Lies den Kurs der Währung aus"""
        return self.__kurs
    
    def set_kurs(self, p_kurs):
        """Setze den Kurs der Währung"""
        self.__kurs = p_kurs
        
    def umrechnen(self,p_betrag,p_ziel):
        """Berechne den neuen Geldbetrag"""
        ergebnis = round(p_betrag * self.__kurs / p_ziel,2)
        return ergebnis

# Hauptprogramm
w_start = Waehrung()
w_start.set_name("US-Dollar")
w_start.set_abkuerzung("USD")
w_start.set_kurs(0.91)

w_ziel = Waehrung()
w_ziel.set_name("Chinesischer Renminbi Yuan")
w_ziel.set_abkuerzung("CNY")
w_ziel.set_kurs(0.13)

print("Umrechnung von",w_start.get_name(),"in",w_ziel.get_name())
betrag = float(input("Wie viel möchten Sie umrechnen?"))
ergebnis = w_start.umrechnen(betrag,w_ziel.get_kurs())

print(betrag,w_start.get_abkuerzung(),"entsprechen",ergebnis,w_ziel.get_abkuerzung())


