import sys
from Konto import *
from PyQt5 import QtWidgets, uic

class MeinDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.ui = uic.loadUi("MeinDialog2.ui", self)
        # Objekt anlegen
        global k
        k = Konto(66124457, 450.00, "Peter Schmidt")
        self.ui.ta_ausgabe.setPlainText("Hallo " + k.inhaber + "!")
        self.ui.ta_ausgabe.appendPlainText("Ihre Kontonummer: " + str(k.kontonummer))
        self.ui.ta_ausgabe.appendPlainText("Aktueller Kontostand: " + str(k.kontostand) + " Euro")
        # Slot einrichten
        self.ui.bt_einzahlen.clicked.connect(self.on_einzahlen)
        self.ui.bt_auszahlen.clicked.connect(self.on_auszahlen)
        
    def on_einzahlen(self):
        # Daten einlesen
        betrag = float(self.ui.tf_betrag.text())
        # Methode aufrufen
        if self.ui.cb_spende.isChecked():
            spende = 2
            k.kontostand -= 2
            self.ui.ta_ausgabe.appendPlainText("Es wird eine Spende von 2,00 Euro durchgeführt.")
        else:
            spende = 0
        k.einzahlen(betrag)
        # Daten ausgeben
        self.ui.ta_ausgabe.appendPlainText("Es wurden " + str(betrag) + " Euro eingezahlt.")
        self.ui.ta_ausgabe.appendPlainText("Neuer Kontostand: "+ str(k.kontostand) + " Euro")

    def on_auszahlen(self):
        # Daten einlesen
        betrag = float(self.ui.tf_betrag.text())
        # Methode aufrufen
        if self.ui.cb_spende.isChecked():
            spende = 2
            k.kontostand -= 2
            self.ui.ta_ausgabe.appendPlainText("Es wird eine Spende von 2,00 Euro durchgeführt.")
        else:
            spende = 0
        k.auszahlen(betrag)
        # Daten ausgeben
        self.ui.ta_ausgabe.appendPlainText("Es wurden " + str(betrag) + " Euro ausgezahlt.")
        self.ui.ta_ausgabe.appendPlainText("Neuer Kontostand: "+ str(k.kontostand) + " Euro")
        
app = QtWidgets.QApplication(sys.argv)
dialog = MeinDialog()
dialog.show()
sys.exit(app.exec_())