import math

# Klasse wird definiert

class Ort():
    def __init__(self): # Konstruktor
        self.name = ""
        self.breite = 0.0
        self.laenge = 0.0

    def berechne_distanz(self, ziel):
        """Berechne die (grobe) Entfernung zwischen zwei Orten"""
        dx = 71.5 * (self.laenge - ziel.laenge)
        dy = 111.3 * (self.breite - ziel.breite)
        dist = (dx * dx + dy * dy)**0.5
        return dist
    
    def berechne_distanz_exakt(self, ziel):
        """Berechne die (exakte) Entfernung zwischen zwei Orten"""
        
        # Umwandlung der Koordinaten in Bogenmaß
        self.breite = math.pi/180 * self.breite
        self.laenge = math.pi/180 * self.laenge
        ziel.breite = math.pi/180 * ziel.breite
        ziel.laenge = math.pi/180 * ziel.laenge
        
        # Berechnung der Distanz
        dist = 6378.388 * math.acos(math.sin(self.breite) * math.sin(ziel.breite) \
                  + math.cos(self.breite) * math.cos(ziel.breite) * math.cos(ziel.laenge - self.laenge))
        return dist

# Test der Klasse

ort1 = Ort()
ort2 = Ort()

ort1.name = "Stuttgart"
ort1.breite = 48.778449
ort1.laenge = 9.180013

ort1.name = "München"
ort1.breite = 48.137108
ort1.laenge = 11.575382

print("Näherung:",ort1.berechne_distanz(ort2))
print("exakt:",ort1.berechne_distanz_exakt(ort2))

