import sys, math
from Flug import *
from PyQt5 import QtWidgets, uic

class MeinDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.ui = uic.loadUi("MeinDialog.ui", self)
        
        # Objekt anlegen
        global flug

        # Slot einrichten
        self.ui.bt_berechnen.clicked.connect(self.on_berechnen)
        
    def on_berechnen(self):
            
        # Daten einlesen
        flug = Flug()
        
        flug.start = self.ui.tf_start.text()
        flug.ziel = self.ui.tf_ziel.text()
        flug.x = float(self.ui.tf_entfernung.text())
        flug.co2 = self.ui.cb_emission.isChecked()
        
        # Methode aufrufen
        flug.berechne_flugpreis()
        
        # Daten ausgeben
        self.ui.ta_ausgabe.setPlainText("Flug von " + flug.start + " nach " + flug.ziel + ".")
        self.ui.ta_ausgabe.appendPlainText("Bei diesem Flug werden " + str(round(flug.emission,0)) + " kg CO2 pro Person freigesetzt.")
        self.ui.ta_ausgabe.appendPlainText("Preisanteil für die geflogenen Kilometer: " + str(round(flug.preis_km,2)) + " €")
        if flug.co2:
            self.ui.ta_ausgabe.appendPlainText("CO2-Anteil: " + str(round(flug.preis_emission,2)) + " €")
        else:
            self.ui.ta_ausgabe.appendPlainText("Sie zahlen keinen Ausgleich für Ihre CO2-Emissionen.")
        self.ui.ta_ausgabe.appendPlainText("Preis gesamt: " + str(round(flug.preis,2)) + " €")
        
app = QtWidgets.QApplication(sys.argv)
dialog = MeinDialog()
dialog.show()
sys.exit(app.exec_())

        