import tkinter as tk

class Rechteck:

    # Initialisiert ein Rechteck Objekt mit Standardwerten
    def __init__(self):
        self.breite = 0
        self.hoehe = 0
        self.pos_x = 0
        self.pos_y = 0
        self.farbe = "black"

    def __str__(self):
        return "Dies ist die Klasse 'Rechteck'"

    def berechne_inhalt(self):
        inhalt = round(self.breite * self.hoehe, 2)
        print("Der Inhalt des Rechtecks beträgt", inhalt)
        return inhalt

    def berechne_umfang(self):
        umfang = round(2 * self.breite * self.hoehe, 2)
        print("Der Umfang des Rechtecks beträgt", umfang)
        return umfang

    # Malt auf ein übergebenes "tk.Canvas" Objekt das Rechteck
    def zeichnen(self):
        # berechne Postion bis wohin gezeichnet werden muss, abhängig von Breite und Höhe
        x_ende = self.pos_x + self.breite
        y_ende = self.pos_y + self.hoehe
        canvas.create_rectangle(self.pos_x, self.pos_y, x_ende, y_ende, fill=self.farbe)

class Kreis:

    def __init__(self):
        self.pos_x = 0
        self.pos_y = 0
        self.radius = 0
        self.farbe = "black"

    def __str__(self):
        return "Dies ist die Klasse 'Kreis'"

    def berechne_inhalt(self):
        inhalt = round(self.radius * self.radius * 3.14159, 2)
        print("Der Inhalt des Kreises beträgt", inhalt)
        return inhalt

    def berechne_umfang(self):
        umfang = round(2 * self.radius * 3.14159, 2)
        print("Der Umfang des Kreises beträgt", umfang)
        return umfang

    # Malt auf ein übergebenes "tk.Canvas" Objekt den Kreis
    def zeichnen(self):
        # berechne Postion bis wohin gezeichnet werden muss, abhängig vom Radius
        x_start = self.pos_x - self.radius
        y_start = self.pos_y - self.radius
        x_ende = self.pos_x + self.radius
        y_ende = self.pos_y + self.radius
        canvas.create_oval(x_start, y_start, x_ende, y_ende, fill=self.farbe)
        
if __name__ == '__main__':
    # GUI Klasse initialisieren
    application = tk.Tk()

    # Hinzufügen einer Zeichenfläche
    canvas = tk.Canvas(application, width=600, height=400)
    canvas.pack()

    ############################################################################
    # HAUPTPROGRAMM                                                            #
    # Hier werden die Objekte erstellt und die Attributwerte werden festgelegt #
    ############################################################################

    k1 = Kreis()
    k1.pos_x = 150
    k1.pos_y = 100
    k1.radius = 100
    k1.farbe = "black"
    k1.berechne_umfang()
    k1.berechne_inhalt()
    k1.zeichnen()

    k2 = Kreis()
    k2.pos_x = 150
    k2.pos_y = 100
    k2.radius = 50
    k2.farbe = "yellow"
    k2.zeichnen()

    # Fokus auf die GUI legen und starten
    tk.mainloop()
    
