# Fachklasse
class Waehrung:
    def __init__(self):
        self.__name = ""
        self.__abkuerzung = ""
        self.__kurs = 1.0 # eine Einheit = ... EUR
        
    def get_name(self):
        """Lies den Namen der Währung aus"""
        return self.__name
    
    def set_name(self, p_name):
        """Setze den Namen der Währung"""
        self.__name = p_name
    
    def get_abkuerzung(self):
        """Lies die Abkürzung der Währung aus"""
        return self.__abkuerzung
    
    def set_abkuerzung(self, p_abkuerzung):
        """Setze den Namen der Währung"""
        self.__abkuerzung = p_abkuerzung
        
    def get_kurs(self):
        """Lies den Kurs der Währung aus"""
        return self.__kurs
    
    def set_kurs(self, p_kurs):
        """Setze den Kurs der Währung"""
        self.__kurs = p_kurs
        
    def umrechnen(self,p_betrag,p_ziel):
        """Berechne den neuen Geldbetrag"""
        ergebnis = round(p_betrag * self.__kurs / p_ziel,2)
        return ergebnis

# Hauptprogramm

# Währung 1 einlesen
w_start = Waehrung()
w_start.set_name(input("Bitte Namen der Startwährung eingeben"))
w_start.set_abkuerzung(input("Bitte Abkürzung der Startwährung eingeben"))
w_start.set_kurs(float(input("Bitte Kurs der Startwährung eingeben (1 Einheit = ... EUR)")))

# Währung 2 einlesen
w_ziel = Waehrung()
w_ziel.set_name(input("Bitte Namen der Zielwährung eingeben"))
w_ziel.set_abkuerzung(input("Bitte Abkürzung der Zielwährung eingeben"))
w_ziel.set_kurs(float(input("Bitte Kurs der Zielwährung eingeben (1 Einheit = ... EUR)")))

print("Umrechnung von",w_start.get_name(),"in",w_ziel.get_name())
betrag = float(input("Wie viel möchten Sie umrechnen?"))
ergebnis = w_start.umrechnen(betrag,w_ziel.get_kurs())

print(betrag,w_start.get_abkuerzung(),"entsprechen",ergebnis,w_ziel.get_abkuerzung())


