# Fachklasse
class Konto:
    def __init__(self):
        self.__inhaber = ""
        self.__kontonummer = 0
        self.__kontostand = 0
    
    def get_inhaber(self):
        """Lies den Inhaber des Kontos aus"""
        return self.__inhaber
    
    def set_inhaber(self, p_inhaber):
        """Setze den Inhaber des Kontos"""
        self.__inhaber = p_inhaber
        
    def get_kontonummer(self):
        """Lies die Kontonummer des Kontos aus"""
        return self.__kontonummer
    
    def set_kontonummer(self, p_kontonummer):
        """Setze die Kontonummer des Kontos"""
        self.__kontonummer = p_kontonummer
        
    def get_kontostand(self):
        """Lies den Kontostand des Kontos aus"""
        return self.__kontostand
    
    def set_kontostand(self, p_kontostand):
        """Setze den Kontostand des Kontos"""
        self.__Kontostand = p_kontostand
    
    def einzahlen(self, p_betrag):
        """Zahle einen Betrag auf das Konto ein"""
        self.__kontostand = self.__kontostand + p_betrag
        
    def abheben(self, p_betrag):
        """Hebe einen Betrag vom Konto ab"""
        self.__kontostand = self.__kontostand - p_betrag
        
    def berechne_zinsen(self, p_zinssatz):
        """Berechne die Zinsen für ein Konto
        Der Zinssatz ist in % anzugeben"""
        zinsen = self.__kontostand * p_zinssatz / 100
        return zinsen
    
    def anzeigen(self):
        """Zeige den aktuellen Kontostatus an"""
        print("Inhaber:", self.__inhaber)
        print("Kontonummer:",self.__kontonummer)
        print("Kontostand:",self.__kontostand,"€")

# Hauptprogramm
k = Konto()
k.set_inhaber("Peter Schmidt")
k.set_kontonummer(66124457)
k.set_kontostand(450.0)
k.anzeigen()
print("Wir zahlen 800€ auf das Konto ein.")
k.einzahlen(800)
k.anzeigen()
print("Wir heben 120€ vom Konto ab.")
k.abheben(120)
k.anzeigen()
print("Wir berechnen die Zinsen mit einem Zinssatz von 2%.")
print("Die Zinsen betragen",k.berechne_zinsen(2),"€")

