import math

# Klasse wird definiert

class Flug:
    def __init__(self): # Konstruktor
        self.x = 0.0
        self.emission = 0.0
        self.co2 = False
        self.preis_km = 0.0
        self.preis_emission = 0.0
        self.preis = 0.0

    def berechne_emission(self):
        """Berechne die (grobe) Emission eines Fluges für eine Person"""

        if self.x < 2500:
            S = 153.51
            PLF = 0.82
            DC = 95
            CF = 0.07
            CW = 0.96
            EF = 3.15
            P = 0.54
            M = 2
            AF = 0.00038
            A = 11.68
            a = 0
            b = 2.714
            c = 1166.52
        
        else:
            S = 280.21
            PLF = 0.82
            DC = 95
            CF = 0.26
            CW = 0.80
            EF = 3.15
            P = 0.54
            M = 2
            AF = 0.00038
            A = 11.68
            a = 0
            b = 7.104
            c = 5044.93
            
        self.x = self.x + DC
        emission = (a*(self.x**2) + b*self.x + c) / (S * PLF) * (1 - CF) * CW * (EF * M + P) + AF * self.x + A
        return emission